/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java;

import com.oracle.tools.Option;
import com.oracle.tools.Options;
import com.oracle.tools.deferred.AbstractDeferred;
import com.oracle.tools.deferred.Deferred;
import com.oracle.tools.deferred.DeferredHelper;
import com.oracle.tools.deferred.PermanentlyUnavailableException;
import com.oracle.tools.deferred.TemporarilyUnavailableException;
import com.oracle.tools.deferred.TimeoutConstraint;
import com.oracle.tools.io.NetworkHelper;
import com.oracle.tools.lang.StringHelper;
import com.oracle.tools.options.Timeout;
import com.oracle.tools.predicate.Predicate;
import com.oracle.tools.predicate.Predicates;
import com.oracle.tools.runtime.Application;
import com.oracle.tools.runtime.ApplicationConsole;
import com.oracle.tools.runtime.ApplicationSchema;
import com.oracle.tools.runtime.LocalApplicationProcess;
import com.oracle.tools.runtime.LocalPlatform;
import com.oracle.tools.runtime.Platform;
import com.oracle.tools.runtime.concurrent.ControllableRemoteExecutor;
import com.oracle.tools.runtime.concurrent.RemoteCallable;
import com.oracle.tools.runtime.concurrent.RemoteRunnable;
import com.oracle.tools.runtime.concurrent.socket.RemoteExecutorServer;
import com.oracle.tools.runtime.java.AbstractJavaApplicationBuilder;
import com.oracle.tools.runtime.java.ClassPath;
import com.oracle.tools.runtime.java.JavaApplication;
import com.oracle.tools.runtime.java.JavaApplicationLauncher;
import com.oracle.tools.runtime.java.JavaApplicationProcess;
import com.oracle.tools.runtime.java.JavaApplicationSchema;
import com.oracle.tools.runtime.java.options.JavaHome;
import com.oracle.tools.runtime.java.options.JvmOption;
import com.oracle.tools.runtime.java.options.RemoteDebugging;
import com.oracle.tools.runtime.options.EnvironmentVariables;
import com.oracle.tools.runtime.options.ErrorStreamRedirection;
import com.oracle.tools.runtime.options.Orphanable;
import com.oracle.tools.util.CompletionListener;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalJavaApplicationBuilder<A extends JavaApplication>
extends AbstractJavaApplicationBuilder<A> {
    private static Logger LOGGER = Logger.getLogger(LocalJavaApplicationBuilder.class.getName());

    @Override
    public <T extends A, S extends ApplicationSchema<T>> T realize(S applicationSchema, String applicationName, ApplicationConsole console, Platform platform, Option ... applicationOptions) {
        Process process;
        ClassPath classPath;
        Options options = applicationSchema.getPlatformSpecificOptions(platform);
        options.addAll(applicationOptions);
        JavaApplicationSchema schema = (JavaApplicationSchema)applicationSchema;
        ProcessBuilder processBuilder = new ProcessBuilder(schema.getExecutableName());
        File directory = schema.getWorkingDirectory();
        if (directory != null) {
            processBuilder.directory(schema.getWorkingDirectory());
        }
        EnvironmentVariables environmentVariables = (EnvironmentVariables)options.get(EnvironmentVariables.class, (Option)EnvironmentVariables.inherited());
        switch (environmentVariables.getSource()) {
            case Custom: {
                processBuilder.environment().clear();
                break;
            }
            case ThisApplication: {
                processBuilder.environment().clear();
                processBuilder.environment().putAll(System.getenv());
                break;
            }
        }
        Properties variables = environmentVariables.getBuilder().realize();
        for (String variableName : variables.stringPropertyNames()) {
            processBuilder.environment().put(variableName, variables.getProperty(variableName));
        }
        JavaHome javaHome = (JavaHome)options.get(JavaHome.class);
        if (javaHome == null) {
            javaHome = JavaHome.at(System.getProperty("java.home", null));
        }
        if (javaHome != null) {
            processBuilder.environment().put("JAVA_HOME", javaHome.get());
        }
        try {
            classPath = new ClassPath(schema.getClassPath(), ClassPath.ofClass(JavaApplicationLauncher.class));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to locate required classes for the class path", e);
        }
        processBuilder.environment().put("CLASSPATH", classPath.toString());
        if (javaHome == null) {
            processBuilder.command(schema.getExecutableName());
        } else {
            String javaHomePath = javaHome.get();
            if (!(javaHomePath = javaHomePath.trim()).endsWith(File.separator)) {
                javaHomePath = javaHomePath + File.separator;
            }
            processBuilder.command(javaHomePath + "bin" + File.separator + schema.getExecutableName());
        }
        Properties systemProperties = schema.getSystemProperties(platform);
        for (String propertyName : systemProperties.stringPropertyNames()) {
            String propertyValue = systemProperties.getProperty(propertyName);
            if (propertyName.startsWith("oracletools")) continue;
            processBuilder.command().add("-D" + propertyName + (propertyValue.isEmpty() ? "" : "=" + StringHelper.doubleQuoteIfNecessary((String)propertyValue)));
        }
        final RemoteExecutorServer server = new RemoteExecutorServer();
        try {
            server.open();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create remote execution server for the application", e);
        }
        Predicate preferred = schema.isIPv4Preferred() ? Predicates.allOf((Predicate[])new Predicate[]{NetworkHelper.IPv4_ADDRESS, NetworkHelper.NON_LOOPBACK_ADDRESS}) : NetworkHelper.DEFAULT_ADDRESS;
        processBuilder.command().add("-Doracletools.runtime.parent.address=" + server.getInetAddress((Predicate<InetAddress>)preferred).getHostAddress());
        processBuilder.command().add("-Doracletools.runtime.parent.port=" + server.getPort());
        Orphanable orphanable = (Orphanable)options.get(Orphanable.class, (Option)Orphanable.disabled());
        processBuilder.command().add("-Doracletools.runtime.orphanable=" + orphanable.isOrphanable());
        for (JvmOption option : options.getAll(JvmOption.class)) {
            processBuilder.command().add(option.get());
        }
        RemoteDebugging remoteDebugging = (RemoteDebugging)options.get(RemoteDebugging.class, (Option)RemoteDebugging.autoDetect());
        int debugPort = -1;
        if (remoteDebugging.isEnabled()) {
            int n = debugPort = remoteDebugging.getBehavior() == RemoteDebugging.Behavior.LISTEN_FOR_DEBUGGER ? remoteDebugging.getListenPort() : remoteDebugging.getAttachPort();
            if (debugPort <= 0) {
                debugPort = LocalPlatform.getInstance().getAvailablePorts().next();
            }
            boolean isDebugServer = remoteDebugging.getBehavior() == RemoteDebugging.Behavior.LISTEN_FOR_DEBUGGER;
            String option = String.format("-agentlib:jdwp=transport=dt_socket,server=%s,suspend=%s,address=%s:%d", isDebugServer ? "y" : "n", remoteDebugging.isStartSuspended() ? "y" : "n", LocalPlatform.getInstance().getHostName(), debugPort);
            processBuilder.command().add(option);
        }
        processBuilder.command().add("com.oracle.tools.runtime.java.JavaApplicationLauncher");
        processBuilder.command().add(schema.getApplicationClassName());
        for (String argument : schema.getArguments()) {
            processBuilder.command().add(argument);
        }
        ErrorStreamRedirection redirection = (ErrorStreamRedirection)options.get(ErrorStreamRedirection.class, (Option)ErrorStreamRedirection.disabled());
        processBuilder.redirectErrorStream(redirection.isEnabled());
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder commandBuilder = new StringBuilder();
            for (String command : processBuilder.command()) {
                commandBuilder.append(command);
                commandBuilder.append(" ");
            }
            LOGGER.log(Level.INFO, "Starting Local Process: " + commandBuilder.toString());
        }
        try {
            process = processBuilder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to build the underlying native process for the application", e);
        }
        LocalJavaApplicationProcess localJavaProcess = new LocalJavaApplicationProcess(process, server);
        Object application = schema.createJavaApplication(localJavaProcess, applicationName, platform, options, console, variables, systemProperties, debugPort);
        if (!remoteDebugging.isEnabled() || !remoteDebugging.isStartSuspended()) {
            Timeout timeout = (Timeout)options.get(Timeout.class, (Option)Timeout.autoDetect());
            DeferredHelper.ensure((Deferred)new AbstractDeferred<Boolean>(){

                public Boolean get() throws TemporarilyUnavailableException, PermanentlyUnavailableException {
                    if (!server.getRemoteExecutors().iterator().hasNext()) {
                        throw new TemporarilyUnavailableException((Deferred)this);
                    }
                    return true;
                }
            }, (TimeoutConstraint)DeferredHelper.within((Timeout)timeout));
        }
        this.raiseApplicationLifecycleEvent(application, Application.EventKind.REALIZED);
        return (T)application;
    }

    public static class LocalJavaApplicationProcess
    extends LocalApplicationProcess
    implements JavaApplicationProcess {
        private ControllableRemoteExecutor remoteExecutor;

        public LocalJavaApplicationProcess(Process process, ControllableRemoteExecutor remoteExecutor) {
            super(process);
            this.remoteExecutor = remoteExecutor;
        }

        @Override
        public <T> void submit(RemoteCallable<T> callable, CompletionListener<T> listener) {
            this.remoteExecutor.submit(callable, listener);
        }

        @Override
        public void submit(RemoteRunnable runnable) throws IllegalStateException {
            this.remoteExecutor.submit(runnable);
        }

        @Override
        public void close() {
            super.close();
            this.remoteExecutor.close();
        }
    }
}

