/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.container;

import com.oracle.tools.runtime.LocalPlatform;
import com.oracle.tools.runtime.java.container.ContainerScope;
import com.oracle.tools.runtime.java.container.ContainerScopeClassLoader;
import com.oracle.tools.runtime.java.container.DefaultScope;
import com.oracle.tools.runtime.java.container.DelegatingMBeanServerBuilder;
import com.oracle.tools.runtime.java.container.DelegatingProperties;
import com.oracle.tools.runtime.java.container.DelegatingStdErrOutputStream;
import com.oracle.tools.runtime.java.container.DelegatingStdInInputStream;
import com.oracle.tools.runtime.java.container.DelegatingStdOutOutputStream;
import com.oracle.tools.runtime.java.container.PlatformScope;
import com.oracle.tools.runtime.java.container.Scope;
import com.oracle.tools.runtime.network.AvailablePortIterator;
import java.io.PrintStream;
import java.util.HashSet;

public class Container {
    private static PlatformScope platformScope;
    private static DefaultScope defaultScope;
    private static InheritableThreadLocal<ContainerScope> threadScope;
    private static HashSet<ContainerScope> scopes;
    public static final int PIPE_BUFFER_SIZE_BYTES = 16384;

    public static synchronized void start() {
        if (!(System.getProperties() instanceof DelegatingProperties)) {
            defaultScope = new DefaultScope(platformScope);
            defaultScope.getProperties().setProperty("javax.management.builder.initial", DelegatingMBeanServerBuilder.class.getCanonicalName());
            System.setProperties(new DelegatingProperties(defaultScope.getProperties()));
            System.setOut(new PrintStream(new DelegatingStdOutOutputStream(platformScope.getStandardOutput()), true));
            System.setErr(new PrintStream(new DelegatingStdErrOutputStream(platformScope.getStandardError()), true));
            System.setIn(new DelegatingStdInInputStream(platformScope.getStandardInput()));
            scopes = new HashSet();
        }
    }

    public static synchronized void stop() {
        if (System.getProperties() instanceof DelegatingProperties) {
            System.setProperties(platformScope.getProperties());
            System.setOut(platformScope.getStandardOutput());
            System.setErr(platformScope.getStandardError());
            defaultScope.close();
            defaultScope = null;
        }
    }

    public static synchronized void manage(ContainerScope scope) {
        if (scopes.add(scope)) {
            Container.start();
        }
    }

    public static synchronized void unmanage(ContainerScope scope) {
        if (scopes.remove(scope)) {
            Container.stop();
        }
    }

    public static ContainerScope getContainerScope() {
        ContainerScope scope = (ContainerScope)threadScope.get();
        if (scope == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            while (scope == null && classLoader != null) {
                if (classLoader instanceof ContainerScopeClassLoader) {
                    scope = ((ContainerScopeClassLoader)classLoader).getContainerScope();
                    continue;
                }
                classLoader = classLoader.getParent();
            }
        }
        return scope;
    }

    public static PlatformScope getPlatformScope() {
        return platformScope;
    }

    public static DefaultScope getDefaultScope() {
        return defaultScope;
    }

    public static void associateThreadWith(ContainerScope scope) {
        if (scope != null) {
            Scope existingScope = (Scope)threadScope.get();
            if (existingScope == null) {
                threadScope.set(scope);
            } else {
                throw new IllegalStateException(String.format("Attempted to associateThreadWith(%s) on Thread [%s] when it is already associated with ContainerScope(%s)", scope.getName(), Thread.currentThread(), existingScope.getName()));
            }
        }
    }

    public static void dissociateThread() {
        if (threadScope.get() != null) {
            threadScope.remove();
        }
    }

    public static AvailablePortIterator getAvailablePorts() {
        return LocalPlatform.getInstance().getAvailablePorts();
    }

    static {
        threadScope = new InheritableThreadLocal();
        platformScope = new PlatformScope(Container.getAvailablePorts());
        scopes = new HashSet();
    }
}

