/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.container;

import com.oracle.tools.runtime.LocalPlatform;
import com.oracle.tools.runtime.PropertiesBuilder;
import com.oracle.tools.runtime.java.ClassPath;
import com.oracle.tools.runtime.java.container.Container;
import com.oracle.tools.runtime.java.container.ContainerMBeanServerBuilder;
import com.oracle.tools.runtime.java.container.ContainerScope;
import com.oracle.tools.runtime.java.container.ContainerScopeClassLoader;
import com.oracle.tools.runtime.java.container.DelegatingMBeanServerBuilder;
import com.oracle.tools.runtime.java.container.PlatformScope;
import com.oracle.tools.runtime.network.AvailablePortIterator;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ContainerClassLoader
extends ContainerScopeClassLoader {
    public static final String PROPERTY_JAVA_CLASS_PATH = "java.class.path";
    public static final String PROPERTY_EXCLUDED_PACKAGES = "container.exclude.packages";
    private Set<String> packagesToLoadFromParent = new HashSet<String>();
    private Set<String> packagesToLoadInContainer = new HashSet<String>();
    private Map<String, Class<?>> loadedClasses = new HashMap();
    private Map<String, URL> loadedResources = new HashMap<String, URL>();
    private ClassLoader rootClassLoader;
    private ClassLoader parentClassLoader;
    private ClassPath classPath;

    private ContainerClassLoader(ClassPath classPath, ClassLoader parent, ContainerScope scope) {
        super(classPath, null, scope);
        this.parentClassLoader = parent;
        this.classPath = classPath;
        while (parent.getParent() != null) {
            this.rootClassLoader = parent.getParent();
            parent = parent.getParent();
        }
    }

    public static ContainerClassLoader newInstance(String applicationName) throws Exception {
        PropertiesBuilder builder = PropertiesBuilder.fromCurrentNonStandardSystemProperties();
        return ContainerClassLoader.newInstance(applicationName, ClassPath.ofSystem(), builder.realize(), System.getProperties(), LocalPlatform.getInstance().getAvailablePorts(), false, 16384);
    }

    public static ContainerClassLoader newInstance(String applicationName, ClassPath classPath, Properties localProperties) throws Exception {
        return ContainerClassLoader.newInstance(applicationName, classPath, localProperties, System.getProperties(), LocalPlatform.getInstance().getAvailablePorts(), false, 16384);
    }

    protected static ContainerClassLoader newInstance(String applicationName, ClassPath classPath, Properties localProperties, Properties systemProperties, AvailablePortIterator availablePorts, boolean redirectErrorStream, int pipeBufferSizeBytes) throws Exception {
        if ((classPath == null || classPath.isEmpty()) && (classPath = new ClassPath(systemProperties.getProperty(PROPERTY_JAVA_CLASS_PATH))) == null) {
            System.out.println("Classpath should not be null!");
        }
        PlatformScope platformScope = Container.getPlatformScope();
        ContainerMBeanServerBuilder mBeanServerBuilder = new ContainerMBeanServerBuilder(LocalPlatform.getInstance().getAvailablePorts());
        ContainerScope scope = new ContainerScope(applicationName, platformScope.getProperties(), availablePorts, mBeanServerBuilder, redirectErrorStream, pipeBufferSizeBytes);
        localProperties.put("javax.management.builder.initial", DelegatingMBeanServerBuilder.class.getCanonicalName());
        scope.getProperties().putAll((Map<?, ?>)localProperties);
        ClassLoader parentLoader = ContainerClassLoader.class.getClassLoader();
        ContainerClassLoader loader = new ContainerClassLoader(classPath, parentLoader, scope);
        String excludedPackageList = localProperties.getProperty(PROPERTY_EXCLUDED_PACKAGES);
        if (excludedPackageList != null && excludedPackageList.trim().length() > 0) {
            String[] packages;
            for (String pack : packages = excludedPackageList.split(",")) {
                if (pack.trim().length() <= 0) continue;
                loader.addPackageToLoadFromParent(pack.trim());
            }
        }
        loader.addPackageToLoadFromParent("com.oracle.tools.runtime.java.container");
        loader.addPackageToLoadFromParent("com.oracle.tools.runtime.java");
        loader.addPackageToLoadInContainer("com.oracle.tools.runtime.java.concurrent");
        loader.addPackageToLoadInContainer("com.oracle.tools.runtime.java.util");
        return loader;
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public void addPackageToLoadFromParent(String packagePrefix) {
        this.packagesToLoadFromParent.add(packagePrefix);
    }

    public void addPackageToLoadInContainer(String packagePrefix) {
        this.packagesToLoadInContainer.add(packagePrefix);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.shouldLoadFromParent(name) && this.parentClassLoader != null) {
            return this.parentClassLoader.loadClass(name);
        }
        Class<?> c = this.loadedClasses.get(name);
        if (c == null) {
            try {
                c = super.loadClass(name);
            }
            catch (Throwable t) {
                c = this.rootClassLoader.loadClass(name);
            }
            this.loadedClasses.put(name, c);
        }
        return c;
    }

    private boolean shouldLoadFromParent(String className) {
        if (ContainerClassLoader.class.getCanonicalName().equals(className)) {
            return true;
        }
        for (String prefix : this.packagesToLoadInContainer) {
            if (!className.startsWith(prefix)) continue;
            return false;
        }
        for (String prefix : this.packagesToLoadFromParent) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }

    @Override
    public URL getResource(String name) {
        URL c = this.loadedResources.get(name);
        if (c == null) {
            c = this.findResource(name);
            this.loadedResources.put(name, c);
        }
        if (c == null) {
            c = super.getResource(name);
        }
        return c;
    }
}

