/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.container;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LineNumberingOutputStream
extends FilterOutputStream {
    private int m_lineNumber = 1;
    private String m_prefix;
    private boolean m_lastOutputWasEOL = true;

    public LineNumberingOutputStream(OutputStream outputStream, String prefix) {
        super(outputStream);
        this.m_prefix = prefix == null ? "" : prefix.trim();
        this.m_prefix = this.m_prefix.isEmpty() ? this.m_prefix : this.m_prefix + ":";
    }

    @Override
    public void write(int value) throws IOException {
        if (this.m_lastOutputWasEOL && value != 10 && value != 13) {
            byte[] bytes;
            for (byte c : bytes = String.format("[%-10s%4d]: ", this.m_prefix, this.m_lineNumber++).getBytes()) {
                super.write(c);
            }
            this.m_lastOutputWasEOL = false;
        }
        super.write(value);
        if (value == 10 || value == 13) {
            this.m_lastOutputWasEOL = true;
        }
    }
}

