/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public class ClassLoaderAwareObjectInputStream
extends ObjectInputStream {
    protected ClassLoader classLoader;

    public ClassLoaderAwareObjectInputStream(ClassLoader classLoader, InputStream inputStream) throws IOException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return this.classLoader.loadClass(objectStreamClass.getName());
        }
        catch (Exception e) {
            return super.resolveClass(objectStreamClass);
        }
    }
}

