/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.options;

import com.oracle.tools.Option;
import com.oracle.tools.runtime.java.options.JvmOption;

public class HeapSize
implements Option,
JvmOption {
    private int initial;
    private Units initialUnits;
    private int maximum;
    private Units maximumUnits;

    private HeapSize() {
        this.initial = -1;
        this.initialUnits = Units.KB;
        this.maximum = -1;
        this.maximumUnits = Units.KB;
    }

    private HeapSize(HeapSize heapSize) {
        this.initial = heapSize.initial;
        this.initialUnits = heapSize.initialUnits;
        this.maximum = heapSize.maximum;
        this.maximumUnits = heapSize.maximumUnits;
    }

    public static HeapSize useDefaults() {
        return new HeapSize();
    }

    public static HeapSize initial(int amount, Units units) {
        HeapSize heapSize = new HeapSize();
        heapSize.initial = amount;
        heapSize.initialUnits = units;
        return heapSize;
    }

    public static HeapSize maximum(int amount, Units units) {
        HeapSize heapSize = new HeapSize();
        heapSize.maximum = amount;
        heapSize.maximumUnits = units;
        return heapSize;
    }

    public static HeapSize of(int initial, Units initialUnits, int maximum, Units maximumUnits) {
        HeapSize heapSize = new HeapSize();
        heapSize.initial = initial;
        heapSize.initialUnits = initialUnits;
        heapSize.maximum = maximum;
        heapSize.maximumUnits = maximumUnits;
        return heapSize;
    }

    @Override
    public String get() {
        StringBuilder builder = new StringBuilder();
        if (this.initial >= 0) {
            builder.append("-Xms");
            builder.append(this.initial);
            builder.append(this.initialUnits.toString().charAt(0));
        }
        if (this.maximum >= 0) {
            if (this.initial >= 0) {
                builder.append(" ");
            }
            builder.append("-Xmx");
            builder.append(this.maximum);
            builder.append(this.maximumUnits.toString().charAt(0));
        }
        return builder.toString();
    }

    public static enum Units {
        KB,
        MB;

    }
}

