/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.options;

import com.oracle.tools.ComposableOption;
import com.oracle.tools.runtime.java.options.JvmOption;
import java.util.LinkedHashSet;

public class JvmOptions
implements JvmOption,
ComposableOption<JvmOptions> {
    private LinkedHashSet<String> options = new LinkedHashSet();

    private JvmOptions(String ... options) {
        if (options != null) {
            for (String option : options) {
                this.options.add(option);
            }
        }
    }

    public JvmOptions compose(JvmOptions other) {
        JvmOptions set = new JvmOptions(new String[0]);
        set.options.addAll(this.options);
        set.options.addAll(other.options);
        return set;
    }

    @Override
    public String get() {
        StringBuilder builder = new StringBuilder();
        for (String option : this.options) {
            if (builder.length() > 0) {
                builder.append(" ");
            }
            builder.append(option);
        }
        return builder.toString();
    }

    public JvmOptions addAll(String ... options) {
        JvmOptions set = new JvmOptions(new String[0]);
        set.options.addAll(this.options);
        if (options != null) {
            for (String option : options) {
                set.options.add(option);
            }
        }
        return set;
    }

    public static JvmOptions include(String ... options) {
        return new JvmOptions(options);
    }
}

