/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.java.options;

import com.oracle.tools.Option;
import com.oracle.tools.runtime.LocalPlatform;
import com.oracle.tools.runtime.java.JavaVirtualMachine;
import com.oracle.tools.runtime.network.AvailablePortIterator;

public class RemoteDebugging
implements Option {
    private boolean enabled;
    private boolean startSuspended;
    private Behavior behavior;
    private AvailablePortIterator remoteDebuggingPorts;
    private int remoteDebuggerPort;

    private RemoteDebugging(boolean enabled, boolean startSuspended, Behavior behavior, AvailablePortIterator remoteDebuggingPorts) {
        this.enabled = enabled;
        this.startSuspended = startSuspended;
        this.behavior = behavior;
        this.remoteDebuggingPorts = remoteDebuggingPorts;
        this.remoteDebuggerPort = -1;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isStartSuspended() {
        return this.startSuspended;
    }

    public Behavior getBehavior() {
        return this.behavior;
    }

    public int getListenPort() {
        return this.remoteDebuggingPorts != null && this.remoteDebuggingPorts.hasNext() ? this.remoteDebuggingPorts.next() : 0;
    }

    public int getAttachPort() {
        return this.remoteDebuggerPort;
    }

    public RemoteDebugging attachToDebugger(int remoteDebuggerPort) {
        this.behavior = Behavior.ATTACH_TO_DEBUGGER;
        this.remoteDebuggerPort = remoteDebuggerPort;
        return this;
    }

    public RemoteDebugging listenForDebugger() {
        this.behavior = Behavior.LISTEN_FOR_DEBUGGER;
        this.remoteDebuggerPort = -1;
        return this;
    }

    public RemoteDebugging startSuspended(boolean startSuspended) {
        this.startSuspended = startSuspended;
        return this;
    }

    public static RemoteDebugging enabled() {
        return new RemoteDebugging(true, false, Behavior.LISTEN_FOR_DEBUGGER, LocalPlatform.getInstance().getAvailablePorts());
    }

    public static RemoteDebugging disabled() {
        return new RemoteDebugging(false, false, Behavior.LISTEN_FOR_DEBUGGER, LocalPlatform.getInstance().getAvailablePorts());
    }

    public static RemoteDebugging autoDetect() {
        return new RemoteDebugging(JavaVirtualMachine.getInstance().shouldEnableRemoteDebugging(), false, Behavior.LISTEN_FOR_DEBUGGER, LocalPlatform.getInstance().getAvailablePorts());
    }

    public static enum Behavior {
        LISTEN_FOR_DEBUGGER,
        ATTACH_TO_DEBUGGER;

    }
}

