/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.network;

import com.oracle.tools.runtime.network.Constants;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AvailablePortIterator
implements Iterator<Integer>,
Iterable<Integer> {
    private static final int MINIMUM_PORT = 1;
    public static final int MAXIMUM_PORT = 65535;
    private static final int LOW_PORT_THRESHOLD = 5;
    private static final int IDEAL_AVAILABLE_PORTS = 10;
    private InetAddress m_inetAddress;
    private int m_portRangeStart;
    private int m_portRangeEnd;
    private Queue<ServerSocket> m_availableSockets;
    private int m_lastCheckedPort;

    public AvailablePortIterator() throws UnknownHostException {
        this(InetAddress.getByName(Constants.getLocalHost()), 1, 65535);
    }

    public AvailablePortIterator(int portRangeStart) throws UnknownHostException {
        this(InetAddress.getByName(Constants.getLocalHost()), portRangeStart, 65535);
    }

    public AvailablePortIterator(int portRangeStart, int portRangeEnd) throws UnknownHostException {
        this(InetAddress.getByName(Constants.getLocalHost()), portRangeStart, portRangeEnd);
    }

    public AvailablePortIterator(InetAddress inetAddress, int portRangeStart, int portRangeEnd) {
        this.m_inetAddress = inetAddress;
        this.m_portRangeStart = portRangeStart;
        this.m_portRangeEnd = portRangeEnd;
        this.m_availableSockets = new ConcurrentLinkedQueue<ServerSocket>();
        this.m_lastCheckedPort = portRangeStart - 1;
        this.acquireAvailablePorts(5, 10);
    }

    public AvailablePortIterator(String host, int portRangeStart, int portRangeEnd) throws UnknownHostException {
        this(InetAddress.getByName(host), portRangeStart, portRangeEnd);
    }

    public InetAddress getInetAddress() {
        return this.m_inetAddress;
    }

    private boolean isPortAvailable(int port) {
        if (port < this.m_portRangeStart || port > this.m_portRangeEnd) {
            return false;
        }
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(this.m_inetAddress, port));
            this.m_availableSockets.add(serverSocket);
            return true;
        }
        catch (IOException ioException) {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private synchronized int acquireAvailablePorts(int minimumThreshold, int idealQueueSize) {
        int count;
        int n = count = this.m_availableSockets.size() < minimumThreshold ? this.m_availableSockets.size() + idealQueueSize : this.m_availableSockets.size();
        while (this.m_availableSockets.size() < count && this.m_lastCheckedPort < this.m_portRangeEnd) {
            this.isPortAvailable(++this.m_lastCheckedPort);
        }
        return this.m_availableSockets.size();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.acquireAvailablePorts(5, 10) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer next() {
        if (this.hasNext()) {
            int port;
            boolean reacquire;
            do {
                ServerSocket socket;
                AvailablePortIterator availablePortIterator = this;
                synchronized (availablePortIterator) {
                    if (this.acquireAvailablePorts(5, 10) == 0) {
                        throw new UnsupportedOperationException("Exhausted all available ports");
                    }
                    socket = this.m_availableSockets.remove();
                }
                port = socket.getLocalPort();
                reacquire = false;
                try {
                    socket.close();
                }
                catch (Exception e) {
                    reacquire = true;
                }
            } while (reacquire);
            return port;
        }
        throw new NoSuchElementException("Attempted to iterate outside of the range of available ports");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("It's illegal to attempt to remove() a port from an AvailablePortIterator");
    }

    public String toString() {
        ArrayList<ServerSocket> list = new ArrayList<ServerSocket>(this.m_availableSockets);
        StringBuilder builder = new StringBuilder("");
        for (ServerSocket socket : list) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(socket.getLocalPort());
        }
        return "AvailablePortIterator{" + builder.toString() + "}";
    }
}

