/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.runtime.options;

import com.oracle.tools.ComposableOption;
import com.oracle.tools.Option;
import com.oracle.tools.runtime.PropertiesBuilder;
import java.util.Iterator;

public class EnvironmentVariables
implements Option,
ComposableOption<EnvironmentVariables> {
    private Source source;
    private PropertiesBuilder variables;

    private EnvironmentVariables(Source source, PropertiesBuilder variables) {
        this.source = source;
        this.variables = variables;
    }

    public Source getSource() {
        return this.source;
    }

    public PropertiesBuilder getBuilder() {
        return this.variables;
    }

    public static EnvironmentVariables of(Source source) {
        return new EnvironmentVariables(source, new PropertiesBuilder());
    }

    public static EnvironmentVariables custom() {
        return new EnvironmentVariables(Source.Custom, new PropertiesBuilder());
    }

    public static EnvironmentVariables inherited() {
        return new EnvironmentVariables(Source.ThisApplication, new PropertiesBuilder());
    }

    public EnvironmentVariables set(String name, Object value) {
        this.variables.setProperty(name, value);
        return this;
    }

    public EnvironmentVariables setIfAbsent(String name, Object value) {
        this.variables.setPropertyIfAbsent(name, value);
        return this;
    }

    public EnvironmentVariables set(String name, Iterator<?> iterator) {
        this.variables.setProperty(name, iterator);
        return this;
    }

    public EnvironmentVariables setIfAbsent(String name, Iterator<?> iterator) {
        this.variables.setPropertyIfAbsent(name, iterator);
        return this;
    }

    public EnvironmentVariables compose(EnvironmentVariables other) {
        EnvironmentVariables environmentVariables = new EnvironmentVariables(this.source, new PropertiesBuilder(this.variables));
        environmentVariables.getBuilder().addProperties(other.getBuilder());
        return environmentVariables;
    }

    public static enum Source {
        ThisApplication,
        TargetPlatform,
        Custom;

    }
}

