/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.Debugger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

final class BreakpointsPropertyChangeEvent
extends PropertyChangeEvent {
    private static final long serialVersionUID = 1L;

    static void firePropertyChange(Debugger source, Breakpoint oldBreakpoint, Breakpoint newBreakpoint) {
        if (source.propSupport.isEmpty()) {
            return;
        }
        BreakpointsPropertyChangeEvent ev = new BreakpointsPropertyChangeEvent(source, oldBreakpoint, newBreakpoint);
        for (PropertyChangeListener l : source.propSupport.toArray(new PropertyChangeListener[0])) {
            l.propertyChange(ev);
        }
    }

    private BreakpointsPropertyChangeEvent(Object source, Breakpoint oldBreakpoint, Breakpoint newBreakpoint) {
        super(source, "breakpoints", oldBreakpoint, newBreakpoint);
    }

    @Override
    public Object getOldValue() {
        Breakpoint breakpoint = (Breakpoint)super.getOldValue();
        if (breakpoint != null) {
            breakpoint = breakpoint.getROWrapper();
        }
        return breakpoint;
    }

    @Override
    public Object getNewValue() {
        Breakpoint breakpoint = (Breakpoint)super.getNewValue();
        if (breakpoint != null) {
            breakpoint = breakpoint.getROWrapper();
        }
        return breakpoint;
    }
}

