/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.debug.ObjectStructures;
import com.oracle.truffle.api.debug.SuspendedEvent;
import com.oracle.truffle.api.debug.ValueInteropList;
import com.oracle.truffle.api.debug.ValuePropertiesCollection;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.List;

public final class DebugScope {
    private final Scope scope;
    private final Iterator<Scope> iterator;
    private final Debugger debugger;
    private final SuspendedEvent event;
    private final MaterializedFrame frame;
    private final RootNode root;
    private final LanguageInfo language;
    private DebugScope parent;
    private ValuePropertiesCollection variables;

    DebugScope(Scope scope, Iterator<Scope> iterator, Debugger debugger, SuspendedEvent event, MaterializedFrame frame, RootNode root) {
        this(scope, iterator, debugger, event, frame, root, null);
    }

    DebugScope(Scope scope, Iterator<Scope> iterator, Debugger debugger, LanguageInfo language) {
        this(scope, iterator, debugger, null, null, null, language);
    }

    private DebugScope(Scope scope, Iterator<Scope> iterator, Debugger debugger, SuspendedEvent event, MaterializedFrame frame, RootNode root, LanguageInfo language) {
        this.scope = scope;
        this.iterator = iterator;
        this.debugger = debugger;
        this.event = event;
        this.frame = frame;
        this.root = root;
        this.language = language;
    }

    public String getName() {
        return this.scope.getName();
    }

    public DebugScope getParent() throws DebugException {
        this.verifyValidState();
        try {
            if (this.parent == null && this.iterator.hasNext()) {
                this.parent = new DebugScope(this.iterator.next(), this.iterator, this.debugger, this.event, this.frame, this.root, this.language);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.debugger, ex, this.language, null, true, null);
        }
        return this.parent;
    }

    public boolean isFunctionScope() {
        return this.root != null && this.root.equals(this.scope.getNode());
    }

    public SourceSection getSourceSection() throws DebugException {
        try {
            Node node = this.scope.getNode();
            if (node != null) {
                return node.getEncapsulatingSourceSection();
            }
            return null;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.debugger, ex, this.language, null, true, null);
        }
    }

    public Iterable<DebugValue> getArguments() throws DebugException {
        this.verifyValidState();
        AbstractCollection arguments = null;
        try {
            Object argumentsObj = this.scope.getArguments();
            if (argumentsObj != null && argumentsObj instanceof TruffleObject) {
                TruffleObject argsTO = (TruffleObject)argumentsObj;
                arguments = DebugValue.getProperties(argumentsObj, this.debugger, this.getLanguage(), this);
                if (arguments == null && ObjectStructures.isArray(this.debugger.getMessageNodes(), argsTO)) {
                    List<Object> array = ObjectStructures.asList(this.debugger.getMessageNodes(), argsTO);
                    arguments = new ValueInteropList(this.debugger, this.getLanguage(), array);
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.debugger, ex, this.language, null, true, null);
        }
        return arguments;
    }

    public Iterable<DebugValue> getDeclaredValues() throws DebugException {
        return this.getVariables();
    }

    public DebugValue getDeclaredValue(String name) throws DebugException {
        return this.getVariables().get(name);
    }

    private ValuePropertiesCollection getVariables() {
        this.verifyValidState();
        try {
            if (this.variables == null) {
                Object variablesObj = this.scope.getVariables();
                this.variables = DebugValue.getProperties(variablesObj, this.debugger, this.getLanguage(), this);
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable ex) {
            throw new DebugException(this.debugger, ex, this.language, null, true, null);
        }
        return this.variables;
    }

    LanguageInfo getLanguage() {
        if (this.root != null) {
            return this.root.getLanguageInfo();
        }
        return this.language;
    }

    void verifyValidState() {
        if (this.event != null) {
            this.event.verifyValidState(false);
        }
    }
}

