/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugException;
import com.oracle.truffle.api.debug.DebugScope;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.LanguageInfo;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

final class ValuePropertiesCollection
extends AbstractCollection<DebugValue> {
    private final Debugger debugger;
    private final LanguageInfo language;
    private final TruffleObject object;
    private final Map<Object, Object> map;
    private final Set<Map.Entry<Object, Object>> entrySet;
    private final DebugScope scope;

    ValuePropertiesCollection(Debugger debugger, LanguageInfo language, TruffleObject object, Map<Object, Object> map, Set<Map.Entry<Object, Object>> entrySet, DebugScope scope) {
        this.debugger = debugger;
        this.language = language;
        this.object = object;
        this.map = map;
        this.entrySet = entrySet;
        this.scope = scope;
    }

    @Override
    public Iterator<DebugValue> iterator() {
        return new PropertiesIterator(this.object, this.entrySet.iterator());
    }

    @Override
    public int size() {
        return this.entrySet.size();
    }

    DebugValue get(String name) {
        Object value = this.map.get(name);
        if (value == null) {
            return null;
        }
        return new DebugValue.PropertyNamedValue(this.debugger, this.language, this.object, this.map, name, this.scope);
    }

    private final class PropertiesIterator
    implements Iterator<DebugValue> {
        private final TruffleObject object;
        private final Iterator<Map.Entry<Object, Object>> entries;

        PropertiesIterator(TruffleObject object, Iterator<Map.Entry<Object, Object>> entries) {
            this.object = object;
            this.entries = entries;
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasNext();
        }

        @Override
        public DebugValue next() {
            try {
                return new DebugValue.PropertyValue(ValuePropertiesCollection.this.debugger, ValuePropertiesCollection.this.language, this.object, this.entries.next(), ValuePropertiesCollection.this.scope);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable ex) {
                throw new DebugException(ValuePropertiesCollection.this.debugger, ex, ValuePropertiesCollection.this.language, null, true, null);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported.");
        }
    }
}

