/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import java.nio.file.Path;
import java.util.Map;

public abstract class HomeFinder {
    private static HomeFinder nativeImageHomeFinder;

    public abstract Path getHomeFolder();

    public abstract String getVersion();

    public abstract Map<String, Path> getLanguageHomes();

    public abstract Map<String, Path> getToolHomes();

    public static HomeFinder getInstance() {
        if (TruffleOptions.AOT) {
            return nativeImageHomeFinder;
        }
        return Truffle.getRuntime().getCapability(HomeFinder.class);
    }

    private static void initializeNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageHomeFinder = Truffle.getRuntime().getCapability(HomeFinder.class);
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageHomeFinder = null;
    }
}

