/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.instrumentation.ExecutionEventNodeFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableFactory;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.instrumentation.UnwindException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public final class EventContext {
    private final ProbeNode probeNode;
    private final SourceSection sourceSection;
    @CompilerDirectives.CompilationFinal
    private volatile Object nodeObject;

    EventContext(ProbeNode probeNode, SourceSection sourceSection) {
        this.sourceSection = sourceSection;
        this.probeNode = probeNode;
    }

    boolean validEventContext() {
        RootNode root;
        Node node = this.getInstrumentedNode();
        if (node instanceof RootNode) {
            throw new IllegalStateException("Instrumentable node must not be a root node.");
        }
        Object object = null;
        if (!(node instanceof InstrumentableNode)) {
            return true;
        }
        object = ((InstrumentableNode)((Object)node)).getNodeObject();
        if (object != null) assert (InstrumentationHandler.AccessorInstrumentHandler.interopAccess().isValidNodeObject(object));
        boolean foundStandardTag = false;
        for (Class clazz : StandardTags.ALL_TAGS) {
            if (!this.hasTag(clazz)) continue;
            foundStandardTag = true;
        }
        if (foundStandardTag && (root = this.probeNode.getRootNode()) != null && root.getSourceSection() != null) assert (this.sourceSection != null) : "All nodes tagged with a standard tag and with a root node that has a source section must also have a source section.";
        return true;
    }

    ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == null) {
            CompilerDirectives.transferToInterpreter();
            throw new NullPointerException();
        }
        Node node = this.getInstrumentedNode();
        if (node instanceof InstrumentableNode) {
            return ((InstrumentableNode)((Object)node)).hasTag(tag);
        }
        return InstrumentationHandler.AccessorInstrumentHandler.nodesAccess().isTaggedWith(node, tag);
    }

    public Object getNodeObject() {
        Object object = this.nodeObject;
        if (object == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Node node = this.getInstrumentedNode();
            if (!(node instanceof InstrumentableNode)) {
                return null;
            }
            object = ((InstrumentableNode)((Object)node)).getNodeObject();
            if (object == null) {
                object = InstrumentationHandler.AccessorInstrumentHandler.interopAccess().createDefaultNodeObject(node);
            } else assert (InstrumentationHandler.AccessorInstrumentHandler.interopAccess().isValidNodeObject(object));
            this.nodeObject = object;
        }
        return object;
    }

    public SourceSection getInstrumentedSourceSection() {
        return this.sourceSection;
    }

    public Node getInstrumentedNode() {
        InstrumentableFactory.WrapperNode wrapper = this.probeNode.findWrapper();
        return wrapper != null ? wrapper.getDelegateNode() : null;
    }

    public boolean isLanguageContextInitialized() {
        CompilerAsserts.neverPartOfCompilation();
        Node node = this.getInstrumentedNode();
        if (node == null) {
            return true;
        }
        RootNode root = node.getRootNode();
        if (root == null) {
            return true;
        }
        LanguageInfo languageInfo = root.getLanguageInfo();
        TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(languageInfo);
        return InstrumentationHandler.AccessorInstrumentHandler.langAccess().isContextInitialized(env);
    }

    @Deprecated
    public CallTarget parseInContext(Source source, String ... argumentNames) throws IOException {
        Node instrumentedNode = this.getInstrumentedNode();
        LanguageInfo languageInfo = instrumentedNode.getRootNode().getLanguageInfo();
        if (languageInfo == null) {
            throw new IllegalArgumentException("No language available for given node.");
        }
        TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(languageInfo);
        return InstrumentationHandler.AccessorInstrumentHandler.langAccess().parse(env, source, instrumentedNode, argumentNames);
    }

    public ExecutionEventNode lookupExecutionEventNode(EventBinding<? extends ExecutionEventNodeFactory> binding) {
        if (!(binding.getElement() instanceof ExecutionEventNodeFactory)) {
            throw new IllegalArgumentException(String.format("Binding is not a subtype of %s.", ExecutionEventNodeFactory.class.getSimpleName()));
        }
        return this.probeNode.lookupExecutionEventNode(binding);
    }

    public Iterator<ExecutionEventNode> lookupExecutionEventNodes(Collection<EventBinding<? extends ExecutionEventNodeFactory>> bindings) {
        return this.probeNode.lookupExecutionEventNodes(bindings);
    }

    public ThreadDeath createUnwind(Object info) {
        return this.createUnwind(info, null);
    }

    public ThreadDeath createUnwind(Object info, EventBinding<?> unwindBinding) {
        CompilerAsserts.neverPartOfCompilation();
        return new UnwindException(info, unwindBinding);
    }

    public String toString() {
        return "EventContext[source=" + this.getInstrumentedSourceSection() + "]";
    }
}

