/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrumentation;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentationHandler;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

public abstract class TruffleInstrument {
    protected TruffleInstrument() {
    }

    protected abstract void onCreate(Env var1);

    protected void onFinalize(Env env) {
    }

    protected void onDispose(Env env) {
    }

    protected OptionDescriptors getOptionDescriptors() {
        return OptionDescriptors.EMPTY;
    }

    static {
        try {
            Class.forName(InstrumentationHandler.class.getName(), true, InstrumentationHandler.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String id() default "";

        public String name() default "";

        public String version() default "inherit";

        public boolean internal() default false;

        public Class<?>[] services() default {};
    }

    public static final class Env {
        private final Object vmObject;
        private final InputStream in;
        private final OutputStream err;
        private final OutputStream out;
        OptionValues options;
        InstrumentationHandler.InstrumentClientInstrumenter instrumenter;
        private List<Object> services;

        Env(Object vm, OutputStream out, OutputStream err, InputStream in) {
            this.vmObject = vm;
            this.in = in;
            this.err = err;
            this.out = out;
        }

        Object getVMObject() {
            return this.vmObject;
        }

        public Instrumenter getInstrumenter() {
            return this.instrumenter;
        }

        public InputStream in() {
            return this.in;
        }

        public OutputStream out() {
            return this.out;
        }

        public OutputStream err() {
            return this.err;
        }

        public void registerService(Object service) {
            if (this.services == null) {
                throw new IllegalStateException();
            }
            this.services.add(service);
        }

        public <S> S lookup(LanguageInfo language, Class<S> type) {
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().lookup(language, type);
        }

        public <S> S lookup(InstrumentInfo instrument, Class<S> type) {
            Object vm = InstrumentationHandler.AccessorInstrumentHandler.langAccess().getVMObject(instrument);
            if (vm == this.vmObject) {
                throw new IllegalArgumentException("Not allowed to lookup services from the currrent instrument.");
            }
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().lookup(instrument, type);
        }

        public Map<String, LanguageInfo> getLanguages() {
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getLanguages(this.vmObject);
        }

        public Map<String, InstrumentInfo> getInstruments() {
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getInstruments(this.vmObject);
        }

        Object[] onCreate(TruffleInstrument instrument) {
            ArrayList<Object> arr = new ArrayList<Object>();
            this.services = arr;
            try {
                instrument.onCreate(this);
            }
            finally {
                this.services = null;
            }
            return arr.toArray();
        }

        public OptionValues getOptions() {
            return this.options;
        }

        public CallTarget parse(Source source, String ... argumentNames) throws IOException {
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(this.vmObject, source.getLanguage(), source.getMimeType());
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().parse(env, source, null, argumentNames);
        }

        public ExecutableNode parseInline(Source source, Node node, MaterializedFrame frame) {
            if (node == null) {
                throw new IllegalArgumentException("Node must not be null.");
            }
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(this.vmObject, source.getLanguage(), source.getMimeType());
            assert (InstrumentationHandler.AccessorInstrumentHandler.langAccess().getLanguageInfo(env) == node.getRootNode().getLanguageInfo());
            ExecutableNode fragment = InstrumentationHandler.AccessorInstrumentHandler.langAccess().parseInline(env, source, node, frame);
            if (fragment != null) {
                TruffleLanguage<?> languageSPI = InstrumentationHandler.AccessorInstrumentHandler.langAccess().getSPI(env);
                fragment = new GuardedExecutableNode(languageSPI, fragment, frame);
            }
            return fragment;
        }

        private static boolean checkNullOrInterop(Object obj) {
            if (obj == null) {
                return true;
            }
            InstrumentationHandler.AccessorInstrumentHandler.interopAccess().checkInteropType(obj);
            return true;
        }

        public boolean isEngineRoot(RootNode root) {
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().isEvalRoot(root);
        }

        @Deprecated
        public String toString(Node node, Object value) {
            TruffleLanguage.Env env = Env.getLangEnv(node);
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().toStringIfVisible(env, value, false);
        }

        public String toString(LanguageInfo language, Object value) {
            InstrumentationHandler.AccessorInstrumentHandler.interopAccess().checkInteropType(value);
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(language);
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().toStringIfVisible(env, value, false);
        }

        @Deprecated
        public Object findMetaObject(Node node, Object value) {
            TruffleLanguage.Env env = Env.getLangEnv(node);
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().findMetaObject(env, value);
        }

        public Object findMetaObject(LanguageInfo language, Object value) {
            InstrumentationHandler.AccessorInstrumentHandler.interopAccess().checkInteropType(value);
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(language);
            Object metaObject = InstrumentationHandler.AccessorInstrumentHandler.langAccess().findMetaObject(env, value);
            assert (Env.checkNullOrInterop(metaObject));
            return metaObject;
        }

        @Deprecated
        public SourceSection findSourceLocation(Node node, Object value) {
            TruffleLanguage.Env env = Env.getLangEnv(node);
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().findSourceLocation(env, value);
        }

        public SourceSection findSourceLocation(LanguageInfo language, Object value) {
            InstrumentationHandler.AccessorInstrumentHandler.interopAccess().checkInteropType(value);
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(language);
            return InstrumentationHandler.AccessorInstrumentHandler.langAccess().findSourceLocation(env, value);
        }

        public LanguageInfo findLanguage(Object value) {
            if (value == null || value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String) {
                return null;
            }
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getObjectLanguage(value, this.vmObject);
        }

        private static TruffleLanguage.Env getLangEnv(Node node) {
            LanguageInfo languageInfo = node.getRootNode().getLanguageInfo();
            if (languageInfo == null) {
                throw new IllegalArgumentException("No language available for given node.");
            }
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(languageInfo);
        }

        public Map<String, ? extends Object> getExportedSymbols() {
            return InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getExportedSymbols(this.vmObject);
        }

        public Iterable<Scope> findLocalScopes(Node node, Frame frame) {
            RootNode rootNode = node.getRootNode();
            if (rootNode == null) {
                throw new IllegalArgumentException("The node " + node + " does not have a RootNode.");
            }
            LanguageInfo languageInfo = rootNode.getLanguageInfo();
            if (languageInfo == null) {
                throw new IllegalArgumentException("The root node " + rootNode + " does not have a language associated.");
            }
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(languageInfo);
            Iterable<Scope> langScopes = InstrumentationHandler.AccessorInstrumentHandler.langAccess().findLocalScopes(env, node, frame);
            assert (langScopes != null) : languageInfo.getId();
            return langScopes;
        }

        public Iterable<Scope> findTopScopes(String languageId) {
            LanguageInfo languageInfo = this.getLanguages().get(languageId);
            if (languageInfo == null) {
                throw new IllegalArgumentException("Unknown language: " + languageId + ". Known languages are: " + this.getLanguages().keySet());
            }
            TruffleLanguage.Env env = InstrumentationHandler.AccessorInstrumentHandler.engineAccess().getEnvForInstrument(languageInfo);
            return Env.findTopScopes(env);
        }

        static Iterable<Scope> findTopScopes(TruffleLanguage.Env env) {
            Iterable<Scope> langScopes = InstrumentationHandler.AccessorInstrumentHandler.langAccess().findTopScopes(env);
            assert (langScopes != null) : InstrumentationHandler.AccessorInstrumentHandler.langAccess().getLanguageInfo(env).getId();
            return langScopes;
        }

        private static class GuardedExecutableNode
        extends ExecutableNode {
            private final FrameDescriptor frameDescriptor;
            @Node.Child
            private ExecutableNode fragment;

            GuardedExecutableNode(TruffleLanguage<?> languageSPI, ExecutableNode fragment, MaterializedFrame frameLocation) {
                super(languageSPI);
                this.frameDescriptor = frameLocation != null ? frameLocation.getFrameDescriptor() : null;
                this.fragment = fragment;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                assert (this.frameDescriptor == null || this.frameDescriptor == frame.getFrameDescriptor());
                this.assureAdopted();
                Object ret = this.fragment.execute(frame);
                assert (Env.checkNullOrInterop(ret));
                return ret;
            }

            private void assureAdopted() {
                if (this.getParent() == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new IllegalStateException("Needs to be inserted into the AST before execution.");
                }
            }
        }
    }
}

