/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.Source;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import org.graalvm.polyglot.io.ByteSequence;

final class SourceImpl
extends Source {
    private final Key key;
    private final Object sourceId;

    private SourceImpl(Key key) {
        this.key = key;
        this.sourceId = new SourceId(key.hashCode());
    }

    private SourceImpl(Key key, Object sourceId) {
        this.key = key;
        this.sourceId = sourceId;
    }

    @Override
    protected Object getSourceId() {
        return this.sourceId;
    }

    @Override
    public CharSequence getCharacters() {
        if (this.hasCharacters()) {
            return (CharSequence)this.key.content;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteSequence getBytes() {
        if (this.hasBytes()) {
            return (ByteSequence)this.key.content;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasBytes() {
        return this.key.content instanceof ByteSequence;
    }

    @Override
    public boolean hasCharacters() {
        return this.key.content instanceof CharSequence;
    }

    @Override
    Source copy() {
        return new SourceImpl(this.key, this.sourceId);
    }

    @Override
    public boolean isCached() {
        return this.key.cached;
    }

    @Override
    public String getName() {
        return this.key.name;
    }

    @Override
    public String getPath() {
        return this.key.path;
    }

    @Override
    public boolean isInternal() {
        return this.key.internal;
    }

    @Override
    boolean isLegacy() {
        return this.key.legacy;
    }

    @Override
    public boolean isInteractive() {
        return this.key.interactive;
    }

    @Override
    public URL getURL() {
        return this.key.url;
    }

    @Override
    public URI getOriginalURI() {
        return this.key.uri;
    }

    @Override
    public String getMimeType() {
        return this.key.mimeType;
    }

    @Override
    public String getLanguage() {
        return this.key.language;
    }

    Key toKey() {
        return this.key;
    }

    static final class Key {
        final Object content;
        final URI uri;
        final URL url;
        final String name;
        final String mimeType;
        final String language;
        final String path;
        final boolean internal;
        final boolean interactive;
        final boolean cached;
        final boolean legacy;

        Key(Object content, String mimeType, String languageId, URL url, URI uri, String name, String path, boolean internal, boolean interactive, boolean cached, boolean legacy) {
            this.content = content;
            this.mimeType = mimeType;
            this.language = languageId;
            this.name = name;
            this.path = path;
            this.internal = internal;
            this.interactive = interactive;
            this.cached = cached;
            this.url = url;
            this.uri = uri;
            this.legacy = legacy;
        }

        public int hashCode() {
            int result = 31 + (this.content == null ? 0 : this.content.hashCode());
            result = 31 * result + (this.interactive ? 1231 : 1237);
            result = 31 * result + (this.internal ? 1231 : 1237);
            result = 31 * result + (this.cached ? 1231 : 1237);
            result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
            result = 31 * result + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            assert (this.content != null);
            Key other = (Key)obj;
            return Objects.equals(this.language, other.language) && Objects.equals(this.mimeType, other.mimeType) && Objects.equals(this.name, other.name) && Objects.equals(this.path, other.path) && Objects.equals(this.uri, other.uri) && Objects.equals(this.url, other.url) && this.interactive == other.interactive && this.internal == other.internal && this.cached == other.cached && this.compareContent(other);
        }

        private boolean compareContent(Key other) {
            Object otherContent = other.content;
            if (this.content instanceof CharSequence && otherContent instanceof CharSequence) {
                return Key.compareCharacters((CharSequence)this.content, (CharSequence)otherContent);
            }
            if (this.content instanceof ByteSequence && otherContent instanceof ByteSequence) {
                return Key.compareBytes((ByteSequence)this.content, (ByteSequence)otherContent);
            }
            return false;
        }

        private static boolean compareBytes(ByteSequence bytes, ByteSequence other) {
            if (bytes == other) {
                return true;
            }
            if (bytes == null) {
                return false;
            }
            if (bytes.length() != other.length()) {
                return false;
            }
            return bytes.equals(other);
        }

        private static boolean compareCharacters(CharSequence characters, CharSequence other) {
            if (characters == other) {
                return true;
            }
            if (characters == null) {
                return false;
            }
            if (characters.length() != other.length()) {
                return false;
            }
            assert (other != null);
            return Objects.equals(characters.toString(), other.toString());
        }

        SourceImpl toSourceInterned() {
            assert (this.cached);
            return new SourceImpl(this);
        }

        SourceImpl toSourceNotInterned() {
            assert (!this.cached);
            return new SourceImpl(this, this);
        }
    }

    private static final class SourceId {
        final int hash;

        SourceId(int hash) {
            this.hash = hash;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

