/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.LanguageCache;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.polyglot.io.FileSystem;

final class FileSystems {
    static final String FILE_SCHEME = "file";
    private static final AtomicReference<FileSystem> DEFAULT_FILE_SYSTEM = new AtomicReference();

    private FileSystems() {
        throw new IllegalStateException("No instance allowed");
    }

    static FileSystem getDefaultFileSystem() {
        FileSystem fs = DEFAULT_FILE_SYSTEM.get();
        if (fs == null && !DEFAULT_FILE_SYSTEM.compareAndSet(null, fs = FileSystems.newFileSystem(FileSystems.findDefaultFileSystemProvider()))) {
            fs = DEFAULT_FILE_SYSTEM.get();
        }
        return fs;
    }

    static FileSystem newNoIOFileSystem() {
        return new DeniedIOFileSystem();
    }

    static FileSystem newNoIOFileSystem(Path userDir) {
        return new DeniedIOFileSystem(userDir);
    }

    static FileSystem newFullIOFileSystem(Path userDir) {
        return FileSystems.newFileSystem(FileSystems.findDefaultFileSystemProvider(), userDir);
    }

    static FileSystem newFileSystem(FileSystemProvider fileSystemProvider) {
        return new NIOFileSystem(fileSystemProvider);
    }

    static FileSystem newFileSystem(FileSystemProvider fileSystemProvider, Path userDir) {
        return new NIOFileSystem(fileSystemProvider, userDir);
    }

    private static FileSystemProvider findDefaultFileSystemProvider() {
        for (FileSystemProvider fsp : FileSystemProvider.installedProviders()) {
            if (!FILE_SCHEME.equals(fsp.getScheme())) continue;
            return fsp;
        }
        throw new IllegalStateException("No FileSystemProvider for scheme 'file'.");
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (lo != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    private static final class DeniedIOFileSystem
    implements FileSystem {
        private final Path userDir;
        private final boolean explicitUserDir;
        private final FileSystem fullIO;
        private volatile Set<Path> languageHomes;

        DeniedIOFileSystem() {
            this(null, false);
        }

        DeniedIOFileSystem(Path userDir) {
            this(userDir, true);
        }

        private DeniedIOFileSystem(Path userDir, boolean explicitUserDir) {
            this.userDir = userDir;
            this.explicitUserDir = explicitUserDir;
            this.fullIO = FileSystems.getDefaultFileSystem();
        }

        public Path parsePath(URI uri) {
            return Paths.get(uri);
        }

        public Path parsePath(String path) {
            return Paths.get(path, new String[0]);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                this.fullIO.checkAccess(absolutePath, modes, linkOptions);
                return;
            }
            throw DeniedIOFileSystem.forbidden(absolutePath);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            throw DeniedIOFileSystem.forbidden(dir);
        }

        public void delete(Path path) throws IOException {
            throw DeniedIOFileSystem.forbidden(path);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            throw DeniedIOFileSystem.forbidden(source);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            throw DeniedIOFileSystem.forbidden(source);
        }

        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            boolean write;
            boolean read = options.contains(StandardOpenOption.READ);
            boolean bl = write = options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.DELETE_ON_CLOSE);
            if (!read && !write) {
                if (options.contains(StandardOpenOption.APPEND)) {
                    write = true;
                } else {
                    read = true;
                }
            }
            if (write) {
                throw DeniedIOFileSystem.forbidden(inPath);
            }
            assert (read);
            Path absolutePath = this.toAbsolutePath(inPath);
            if (this.inLanguageHome(absolutePath)) {
                return this.fullIO.newByteChannel(absolutePath, options, (FileAttribute[])attrs);
            }
            throw DeniedIOFileSystem.forbidden(absolutePath);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            Path absoluteDir = this.toAbsolutePath(dir);
            if (this.inLanguageHome(absoluteDir)) {
                return this.fullIO.newDirectoryStream(absoluteDir, filter);
            }
            throw DeniedIOFileSystem.forbidden(absoluteDir);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            Path absolutePath = this.toAbsolutePath(path);
            if (this.inLanguageHome(absolutePath)) {
                return this.fullIO.readAttributes(absolutePath, attributes, options);
            }
            throw DeniedIOFileSystem.forbidden(absolutePath);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            throw DeniedIOFileSystem.forbidden(path);
        }

        public Path toAbsolutePath(Path path) {
            if (path.isAbsolute()) {
                return path;
            }
            if (this.explicitUserDir) {
                if (this.userDir == null) {
                    throw new SecurityException("Access to 'user.dir' is not allowed.");
                }
                return this.userDir.resolve(path);
            }
            return path.toAbsolutePath();
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Path absoluetPath = this.toAbsolutePath(path);
            if (this.inLanguageHome(absoluetPath)) {
                return this.fullIO.toRealPath(absoluetPath, linkOptions);
            }
            throw DeniedIOFileSystem.forbidden(absoluetPath);
        }

        private boolean inLanguageHome(Path path) {
            for (Path home : this.getLanguageHomes()) {
                if (!path.startsWith(home)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Path> getLanguageHomes() {
            Set<Path> res = this.languageHomes;
            if (res == null) {
                DeniedIOFileSystem deniedIOFileSystem = this;
                synchronized (deniedIOFileSystem) {
                    res = this.languageHomes;
                    if (res == null) {
                        res = new HashSet<Path>();
                        for (LanguageCache cache : LanguageCache.languages().values()) {
                            String languageHome = cache.getLanguageHome();
                            if (languageHome == null) continue;
                            res.add(Paths.get(languageHome, new String[0]));
                        }
                        this.languageHomes = res;
                    }
                }
            }
            return res;
        }

        private static SecurityException forbidden(Path path) {
            throw new SecurityException("Operation is not allowed for: " + path);
        }
    }

    private static final class NIOFileSystem
    implements FileSystem {
        private final FileSystemProvider delegate;
        private final boolean explicitUserDir;
        private final Path userDir;

        NIOFileSystem(FileSystemProvider fileSystemProvider) {
            this(fileSystemProvider, false, null);
        }

        NIOFileSystem(FileSystemProvider fileSystemProvider, Path userDir) {
            this(fileSystemProvider, true, userDir);
        }

        private NIOFileSystem(FileSystemProvider fileSystemProvider, boolean explicitUserDir, Path userDir) {
            Objects.requireNonNull(fileSystemProvider, "FileSystemProvider must be non null.");
            this.delegate = fileSystemProvider;
            this.explicitUserDir = explicitUserDir;
            this.userDir = userDir;
        }

        public Path parsePath(URI uri) {
            return this.delegate.getPath(uri);
        }

        public Path parsePath(String path) {
            if (!FileSystems.FILE_SCHEME.equals(this.delegate.getScheme())) {
                throw new IllegalStateException("The ParsePath(String path) should be called only for file scheme.");
            }
            return Paths.get(path, new String[0]);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            if (FileSystems.isFollowLinks(linkOptions)) {
                this.delegate.checkAccess(this.resolveRelative(path), modes.toArray(new AccessMode[modes.size()]));
            } else if (modes.isEmpty()) {
                this.delegate.readAttributes(path, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
            } else {
                throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
            }
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(this.resolveRelative(dir), attrs);
        }

        public void delete(Path path) throws IOException {
            this.delegate.delete(this.resolveRelative(path));
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Path resolved = this.resolveRelative(path);
            try {
                return this.delegate.newFileChannel(resolved, options, attrs);
            }
            catch (UnsupportedOperationException uoe) {
                return this.delegate.newByteChannel(resolved, options, attrs);
            }
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            return this.delegate.newDirectoryStream(this.resolveRelative(dir), filter);
        }

        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(this.resolveRelative(link), this.resolveRelative(existing));
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(this.resolveRelative(link), this.resolveRelative(target), attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegate.readSymbolicLink(this.resolveRelative(link));
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(this.resolveRelative(path), attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(this.resolveRelative(path), attribute, value, options);
        }

        public Path toAbsolutePath(Path path) {
            if (path.isAbsolute()) {
                return path;
            }
            if (this.explicitUserDir) {
                if (this.userDir == null) {
                    throw new SecurityException("Access to user.dir is not allowed.");
                }
                return this.userDir.resolve(path);
            }
            return path.toAbsolutePath();
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            Path resolvedPath = this.resolveRelative(path);
            return resolvedPath.toRealPath(linkOptions);
        }

        private Path resolveRelative(Path path) {
            return this.explicitUserDir ? this.toAbsolutePath(path) : path;
        }
    }

    static final class PreInitializeContextFileSystem
    implements FileSystem {
        private FileSystem delegate = FileSystems.newFullIOFileSystem(null);

        PreInitializeContextFileSystem() {
        }

        void patchDelegate(FileSystem newDelegate) {
            Objects.requireNonNull(newDelegate, "NewDelegate must be non null.");
            this.delegate = newDelegate;
        }

        public Path parsePath(URI path) {
            return this.delegate.parsePath(path);
        }

        public Path parsePath(String path) {
            return this.delegate.parsePath(path);
        }

        public void checkAccess(Path path, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            this.delegate.checkAccess(path, modes, linkOptions);
        }

        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(dir, (FileAttribute[])attrs);
        }

        public void delete(Path path) throws IOException {
            this.delegate.delete(path);
        }

        public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return this.delegate.newByteChannel(path, options, (FileAttribute[])attrs);
        }

        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
            return this.delegate.newDirectoryStream(dir, filter);
        }

        public Path toAbsolutePath(Path path) {
            return this.delegate.toAbsolutePath(path);
        }

        public Path toRealPath(Path path, LinkOption ... linkOptions) throws IOException {
            return this.delegate.toRealPath(path, linkOptions);
        }

        public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(path, attributes, options);
        }

        public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(path, attribute, value, options);
        }

        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(source, target, options);
        }

        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(source, target, options);
        }

        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(link, existing);
        }

        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(link, target, (FileAttribute[])attrs);
        }

        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegate.readSymbolicLink(link);
        }
    }
}

