/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostMethodDesc;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

final class HostClassDesc {
    private static final ClassValue<HostClassDesc> CACHED_DESCS = new ClassValue<HostClassDesc>(){

        @Override
        protected HostClassDesc computeValue(Class<?> type) {
            return new HostClassDesc(type);
        }
    };
    private final Class<?> type;
    private volatile Members members;
    private volatile JNIMembers jniMembers;

    @CompilerDirectives.TruffleBoundary
    static HostClassDesc forClass(Class<?> clazz) {
        return CACHED_DESCS.get(clazz);
    }

    HostClassDesc(Class<?> type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    static boolean isObjectMethodOverride(Method m) {
        return m.getParameterCount() == 0 && (m.getName().equals("hashCode") || m.getName().equals("toString")) || m.getParameterCount() == 1 && m.getName().equals("equals") && m.getParameterTypes()[0] == Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Members getMembers() {
        Members m = this.members;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m = this.members;
                if (m == null) {
                    this.members = m = new Members(this.type);
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIMembers getJNIMembers() {
        JNIMembers m = this.jniMembers;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m = this.jniMembers;
                if (m == null) {
                    this.jniMembers = m = new JNIMembers(this.getMembers());
                }
            }
        }
        return m;
    }

    public HostMethodDesc lookupMethod(String name) {
        return this.getMembers().methods.get(name);
    }

    public HostMethodDesc lookupStaticMethod(String name) {
        return this.getMembers().staticMethods.get(name);
    }

    public HostMethodDesc lookupMethod(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticMethod(name) : this.lookupMethod(name);
    }

    public HostMethodDesc lookupMethodByJNIName(String jniName, boolean onlyStatic) {
        return onlyStatic ? this.getJNIMembers().staticMethods.get(jniName) : this.getJNIMembers().methods.get(jniName);
    }

    public Collection<String> getMethodNames(boolean onlyStatic, boolean includeInternal) {
        Map<String, HostMethodDesc> methods;
        Map<String, HostMethodDesc> map = methods = onlyStatic ? this.getMembers().staticMethods : this.getMembers().methods;
        if (includeInternal || onlyStatic) {
            return Collections.unmodifiableCollection(methods.keySet());
        }
        ArrayList<String> methodNames = new ArrayList<String>(methods.size());
        for (Map.Entry<String, HostMethodDesc> entry : methods.entrySet()) {
            if (entry.getValue().isInternal()) continue;
            methodNames.add(entry.getKey());
        }
        return methodNames;
    }

    public HostMethodDesc lookupConstructor() {
        return this.getMembers().constructor;
    }

    public HostFieldDesc lookupField(String name) {
        return this.getMembers().fields.get(name);
    }

    public HostFieldDesc lookupStaticField(String name) {
        return this.getMembers().staticFields.get(name);
    }

    public HostFieldDesc lookupField(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticField(name) : this.lookupField(name);
    }

    public Collection<String> getFieldNames(boolean onlyStatic) {
        return Collections.unmodifiableCollection((onlyStatic ? this.getMembers().staticFields : this.getMembers().fields).keySet());
    }

    public HostMethodDesc getFunctionalMethod() {
        return this.getMembers().functionalMethod;
    }

    public String toString() {
        return "JavaClass[" + this.type.getCanonicalName() + "]";
    }

    private static class JNIMembers {
        final Map<String, HostMethodDesc> methods;
        final Map<String, HostMethodDesc> staticMethods;

        JNIMembers(Members members) {
            this.methods = JNIMembers.collectJNINamedMethods(members.methods);
            this.staticMethods = JNIMembers.collectJNINamedMethods(members.staticMethods);
        }

        private static Map<String, HostMethodDesc> collectJNINamedMethods(Map<String, HostMethodDesc> methods) {
            LinkedHashMap<String, HostMethodDesc> jniMethods = new LinkedHashMap<String, HostMethodDesc>();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc m : method.getOverloads()) {
                    assert (m.isMethod());
                    jniMethods.put(HostInteropReflect.jniName((Method)((HostMethodDesc.SingleMethod)m).getReflectionMethod()), m);
                }
            }
            return jniMethods;
        }
    }

    private static class Members {
        final Map<String, HostMethodDesc> methods;
        final Map<String, HostMethodDesc> staticMethods;
        final HostMethodDesc constructor;
        final Map<String, HostFieldDesc> fields;
        final Map<String, HostFieldDesc> staticFields;
        final HostMethodDesc functionalMethod;
        private static final BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc> MERGE = new BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc>(){

            @Override
            public HostMethodDesc apply(HostMethodDesc m1, HostMethodDesc m2) {
                return Members.merge(m1, m2);
            }
        };

        Members(Class<?> type) {
            String functionalInterfaceMethodName;
            LinkedHashMap<String, HostMethodDesc> methodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostMethodDesc> staticMethodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostFieldDesc> fieldMap = new LinkedHashMap<String, HostFieldDesc>();
            LinkedHashMap<String, HostFieldDesc> staticFieldMap = new LinkedHashMap<String, HostFieldDesc>();
            HostMethodDesc.SingleMethod ctor = null;
            HostMethodDesc functionalInterfaceMethod = null;
            Members.collectPublicMethods(type, methodMap, staticMethodMap);
            if (Modifier.isPublic(type.getModifiers())) {
                boolean inheritedPublicInstanceFields = false;
                boolean inheritedPublicInaccessibleFields = false;
                for (Field f : type.getFields()) {
                    if (!Modifier.isStatic(f.getModifiers())) {
                        if (f.getDeclaringClass() == type) {
                            assert (!fieldMap.containsKey(f.getName()));
                            fieldMap.put(f.getName(), HostFieldDesc.unreflect(f));
                            continue;
                        }
                        if (Modifier.isPublic(f.getDeclaringClass().getModifiers())) {
                            inheritedPublicInstanceFields = true;
                            continue;
                        }
                        inheritedPublicInaccessibleFields = true;
                        continue;
                    }
                    if (f.getDeclaringClass() != type) continue;
                    staticFieldMap.put(f.getName(), HostFieldDesc.unreflect(f));
                }
                if (inheritedPublicInstanceFields) {
                    Members.collectPublicInstanceFields(type, fieldMap, inheritedPublicInaccessibleFields);
                }
            } else if (!Modifier.isInterface(type.getModifiers())) {
                Members.collectPublicInstanceFields(type, fieldMap, true);
            }
            if (Modifier.isPublic(type.getModifiers())) {
                for (Constructor<?> c : type.getConstructors()) {
                    HostMethodDesc.SingleMethod overload = HostMethodDesc.SingleMethod.unreflect(c);
                    ctor = ctor == null ? overload : Members.merge(ctor, overload);
                }
            }
            if (!Modifier.isInterface(type.getModifiers()) && !Modifier.isAbstract(type.getModifiers()) && (functionalInterfaceMethodName = Members.findFunctionalInterfaceMethodName(type)) != null) {
                functionalInterfaceMethod = (HostMethodDesc)methodMap.get(functionalInterfaceMethodName);
                assert (functionalInterfaceMethod != null);
            }
            this.methods = methodMap;
            this.staticMethods = staticMethodMap;
            this.constructor = ctor;
            this.fields = fieldMap;
            this.staticFields = staticFieldMap;
            this.functionalMethod = functionalInterfaceMethod;
        }

        private static void collectPublicMethods(Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            Members.collectPublicMethods(type, methodMap, staticMethodMap, new HashSet<Object>(), type);
        }

        private static void collectPublicMethods(Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap, Set<Object> visited, Class<?> startType) {
            boolean isPublicType = Modifier.isPublic(type.getModifiers()) && !Proxy.isProxyClass(type);
            boolean allMethodsPublic = true;
            if (isPublicType) {
                for (GenericDeclaration genericDeclaration : type.getMethods()) {
                    if (!Modifier.isPublic(((Method)genericDeclaration).getDeclaringClass().getModifiers())) {
                        allMethodsPublic = false;
                        continue;
                    }
                    if (Modifier.isStatic(((Method)genericDeclaration).getModifiers()) && ((Method)genericDeclaration).getDeclaringClass() != startType && Modifier.isInterface(((Method)genericDeclaration).getDeclaringClass().getModifiers()) || !visited.add(Members.methodInfo((Method)genericDeclaration))) continue;
                    Members.putMethod((Method)genericDeclaration, methodMap, staticMethodMap);
                }
            }
            if (!isPublicType || !allMethodsPublic) {
                if (type.getSuperclass() != null) {
                    Members.collectPublicMethods(type.getSuperclass(), methodMap, staticMethodMap, visited, startType);
                }
                for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
                    if (!visited.add(genericDeclaration)) continue;
                    Members.collectPublicMethods(genericDeclaration, methodMap, staticMethodMap, visited, startType);
                }
            }
        }

        private static Object methodInfo(Method m) {
            class MethodInfo {
                private final String name;
                private final Class<?>[] parameterTypes;
                final /* synthetic */ Method val$m;

                MethodInfo(Method method) {
                    this.val$m = method;
                    this.name = this.val$m.getName();
                    this.parameterTypes = this.val$m.getParameterTypes();
                }

                public boolean equals(Object obj) {
                    return obj instanceof MethodInfo && this.name.equals(((MethodInfo)obj).name) && Arrays.equals(this.parameterTypes, ((MethodInfo)obj).parameterTypes);
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + this.name.hashCode();
                    result = 31 * result + Arrays.hashCode(this.parameterTypes);
                    return result;
                }
            }
            return new MethodInfo(m);
        }

        private static void putMethod(Method m, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            HostMethodDesc.SingleMethod method = HostMethodDesc.SingleMethod.unreflect(m);
            Map<String, HostMethodDesc> map = Modifier.isStatic(m.getModifiers()) ? staticMethodMap : methodMap;
            map.merge(m.getName(), method, MERGE);
        }

        static HostMethodDesc merge(HostMethodDesc existing, HostMethodDesc other) {
            assert (other instanceof HostMethodDesc.SingleMethod);
            if (existing instanceof HostMethodDesc.SingleMethod) {
                return new HostMethodDesc.OverloadedMethod(new HostMethodDesc.SingleMethod[]{(HostMethodDesc.SingleMethod)existing, (HostMethodDesc.SingleMethod)other});
            }
            HostMethodDesc.SingleMethod[] oldOverloads = ((HostMethodDesc.OverloadedMethod)existing).getOverloads();
            HostMethodDesc.SingleMethod[] newOverloads = Arrays.copyOf(oldOverloads, oldOverloads.length + 1);
            newOverloads[oldOverloads.length] = (HostMethodDesc.SingleMethod)other;
            return new HostMethodDesc.OverloadedMethod(newOverloads);
        }

        private static void collectPublicInstanceFields(Class<?> type, Map<String, HostFieldDesc> fieldMap, boolean mayHaveInaccessibleFields) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (Class<?> superclass = type; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                boolean inheritedPublicInstanceFields = false;
                for (Field f : superclass.getFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    if (f.getDeclaringClass() != superclass) {
                        if (!Modifier.isPublic(f.getDeclaringClass().getModifiers())) continue;
                        inheritedPublicInstanceFields = true;
                        continue;
                    }
                    if (mayHaveInaccessibleFields && !fieldNames.add(f.getName())) continue;
                    if (Modifier.isPublic(f.getDeclaringClass().getModifiers())) {
                        fieldMap.putIfAbsent(f.getName(), HostFieldDesc.unreflect(f));
                        continue;
                    }
                    assert (mayHaveInaccessibleFields);
                }
                if (!inheritedPublicInstanceFields) break;
            }
        }

        private static String findFunctionalInterfaceMethodName(Class<?> clazz) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!Modifier.isPublic(iface.getModifiers()) || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
                for (Method m : iface.getMethods()) {
                    if (!Modifier.isAbstract(m.getModifiers()) || HostClassDesc.isObjectMethodOverride(m)) continue;
                    return m.getName();
                }
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return Members.findFunctionalInterfaceMethodName(superclass);
            }
            return null;
        }
    }
}

