/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;

abstract class HostEntryRootNode<T>
extends RootNode {
    private static final Object UNINITIALIZED_CONTEXT = new Object();
    @CompilerDirectives.CompilationFinal
    private boolean seenEnter;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonEnter;
    @CompilerDirectives.CompilationFinal
    private Object constantContext = UNINITIALIZED_CONTEXT;

    HostEntryRootNode() {
        super(null);
    }

    protected abstract Class<? extends T> getReceiverType();

    @Override
    public final Object execute(VirtualFrame frame) {
        Object prev;
        boolean needsEnter;
        Object[] args = frame.getArguments();
        PolyglotLanguageContext languageContext = this.profileContext(args[0]);
        assert (languageContext != null);
        PolyglotContextImpl context = languageContext.context;
        boolean bl = needsEnter = languageContext != null && context.needsEnter();
        if (needsEnter) {
            if (!this.seenEnter) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenEnter = true;
            }
            prev = context.enter();
        } else {
            if (!this.seenNonEnter) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenNonEnter = true;
            }
            prev = null;
        }
        try {
            Object[] arguments = frame.getArguments();
            T receiver = this.getReceiverType().cast(arguments[1]);
            Object result = this.executeImpl(languageContext, receiver, arguments, 2);
            assert (!(result instanceof TruffleObject));
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            CompilerDirectives.transferToInterpreter();
            throw PolyglotImpl.wrapGuestException(languageContext, e);
        }
        finally {
            if (needsEnter) {
                context.leave(prev);
            }
        }
    }

    private PolyglotLanguageContext profileContext(Object languageContext) {
        if (this.constantContext != null) {
            if (this.constantContext == languageContext) {
                return (PolyglotLanguageContext)this.constantContext;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.constantContext = this.constantContext == UNINITIALIZED_CONTEXT ? languageContext : null;
        }
        return (PolyglotLanguageContext)languageContext;
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, T var2, Object[] var3, int var4);

    protected static CallTarget createTarget(HostEntryRootNode<?> node) {
        return Truffle.getRuntime().createCallTarget(node);
    }

    static <T> T installHostCodeCache(PolyglotLanguageContext languageContext, Object key, T value, Class<T> expectedType) {
        T result = expectedType.cast(languageContext.context.engine.javaInteropCodeCache.putIfAbsent(key, value));
        if (result != null) {
            return result;
        }
        return value;
    }

    static <T> T lookupHostCodeCache(PolyglotLanguageContext languageContext, Object key, Class<T> expectedType) {
        return expectedType.cast(languageContext.context.engine.javaInteropCodeCache.get(key));
    }
}

