/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.HostFunctionMRForeign;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;

final class HostFunction
implements TruffleObject {
    final HostMethodDesc method;
    final Object obj;
    final PolyglotLanguageContext languageContext;

    HostFunction(HostMethodDesc method, Object obj, PolyglotLanguageContext languageContext) {
        this.method = method;
        this.obj = obj;
        this.languageContext = languageContext;
    }

    public static boolean isInstance(TruffleObject obj) {
        return obj instanceof HostFunction;
    }

    public static boolean isInstance(Object obj) {
        return obj instanceof HostFunction;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return HostFunctionMRForeign.ACCESS;
    }

    public boolean equals(Object o) {
        if (o instanceof HostFunction) {
            HostFunction other = (HostFunction)o;
            return this.method == other.method && this.obj == other.obj && this.languageContext == other.languageContext;
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    String getDescription() {
        if (this.obj == null) {
            return "null";
        }
        String typeName = this.obj.getClass().getTypeName();
        return typeName + "." + this.method.getName();
    }
}

