/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.FunctionProxyHandler;
import com.oracle.truffle.polyglot.HostClassDesc;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.ObjectProxyHandler;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import org.graalvm.collections.EconomicSet;

final class HostInteropReflect {
    static final Object[] EMPTY = new Object[0];

    private HostInteropReflect() {
    }

    @CompilerDirectives.TruffleBoundary
    static Class<?> findInnerClass(Class<?> clazz, String name) {
        if (Modifier.isPublic(clazz.getModifiers())) {
            for (Class<?> t : clazz.getClasses()) {
                if (!HostInteropReflect.isStaticTypeOrInterface(t) || !t.getSimpleName().equals(name)) continue;
                return t;
            }
        }
        return null;
    }

    static boolean isJNIName(String name) {
        return name.contains("__");
    }

    @CompilerDirectives.TruffleBoundary
    static HostMethodDesc findMethod(Class<?> clazz, String name, boolean onlyStatic) {
        if (TruffleOptions.AOT) {
            return null;
        }
        HostClassDesc classDesc = HostClassDesc.forClass(clazz);
        HostMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod == null && HostInteropReflect.isJNIName(name)) {
            foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic);
        }
        return foundMethod;
    }

    @CompilerDirectives.TruffleBoundary
    static HostFieldDesc findField(Class<?> clazz, String name, boolean onlyStatic) {
        HostClassDesc classDesc = HostClassDesc.forClass(clazz);
        return classDesc.lookupField(name, onlyStatic);
    }

    @CompilerDirectives.TruffleBoundary
    static int findKeyInfo(Class<?> clazz, String name, boolean onlyStatic) {
        HostFieldDesc foundField;
        if (TruffleOptions.AOT) {
            return 0;
        }
        boolean readable = false;
        boolean writable = false;
        boolean invocable = false;
        boolean internal = false;
        HostClassDesc classDesc = HostClassDesc.forClass(clazz);
        HostMethodDesc foundMethod = classDesc.lookupMethod(name, onlyStatic);
        if (foundMethod != null) {
            readable = true;
            invocable = true;
        } else if (HostInteropReflect.isJNIName(name) && (foundMethod = classDesc.lookupMethodByJNIName(name, onlyStatic)) != null) {
            readable = true;
            invocable = true;
            internal = true;
        }
        if (!readable && (foundField = classDesc.lookupField(name, onlyStatic)) != null) {
            readable = true;
            writable = true;
        }
        if (onlyStatic) {
            Class<?> innerClass;
            if (!readable && "class".equals(name)) {
                readable = true;
            }
            if (!readable && (innerClass = HostInteropReflect.findInnerClass(clazz, name)) != null) {
                readable = true;
            }
        }
        if (readable) {
            return 2 | (writable ? 4 : 0) | (invocable ? 8 : 0) | (internal ? 16 : 0);
        }
        return 0;
    }

    @CompilerDirectives.TruffleBoundary
    static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function, PolyglotLanguageContext languageContext) {
        assert (HostInteropReflect.isFunctionalInterface(functionalType));
        Method functionalInterfaceMethod = HostInteropReflect.functionalInterfaceMethod(functionalType);
        FunctionProxyHandler handler = new FunctionProxyHandler(function, functionalInterfaceMethod, languageContext);
        Object obj = Proxy.newProxyInstance(functionalType.getClassLoader(), new Class[]{functionalType}, (InvocationHandler)handler);
        return functionalType.cast(obj);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isFunctionalInterface(Class<?> type) {
        if (!type.isInterface() || type == TruffleObject.class) {
            return false;
        }
        if (type.getAnnotation(FunctionalInterface.class) != null) {
            return true;
        }
        return HostInteropReflect.functionalInterfaceMethod(type) != null;
    }

    static Method functionalInterfaceMethod(Class<?> functionalInterface) {
        if (!functionalInterface.isInterface()) {
            return null;
        }
        Method found = null;
        for (Method m : functionalInterface.getMethods()) {
            if (!Modifier.isAbstract(m.getModifiers()) || HostClassDesc.isObjectMethodOverride(m)) continue;
            if (found != null) {
                return null;
            }
            found = m;
        }
        return found;
    }

    static TruffleObject asTruffleViaReflection(Object obj, PolyglotLanguageContext languageContext) {
        if (obj instanceof Proxy) {
            return HostInteropReflect.asTruffleObjectProxy(obj, languageContext);
        }
        return HostObject.forObject(obj, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleObject asTruffleObjectProxy(Object obj, PolyglotLanguageContext languageContext) {
        if (Proxy.isProxyClass(obj.getClass())) {
            InvocationHandler h = Proxy.getInvocationHandler(obj);
            if (h instanceof FunctionProxyHandler) {
                return ((FunctionProxyHandler)h).functionObj;
            }
            if (h instanceof ObjectProxyHandler) {
                return ((ObjectProxyHandler)h).obj;
            }
        }
        return HostObject.forObject(obj, languageContext);
    }

    static Object newProxyInstance(Class<?> clazz, TruffleObject obj, PolyglotLanguageContext languageContext) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ObjectProxyHandler(obj, languageContext, clazz));
    }

    static boolean isStaticTypeOrInterface(Class<?> t) {
        return Modifier.isPublic(t.getModifiers()) && (t.isInterface() || t.isEnum() || Modifier.isStatic(t.getModifiers()));
    }

    @CompilerDirectives.TruffleBoundary
    static String[] findUniquePublicMemberNames(Class<?> clazz, boolean onlyStatic, boolean includeInternal) throws SecurityException {
        HostClassDesc classDesc = HostClassDesc.forClass(clazz);
        EconomicSet names = EconomicSet.create();
        names.addAll(classDesc.getFieldNames(onlyStatic));
        names.addAll(classDesc.getMethodNames(onlyStatic, includeInternal));
        if (onlyStatic) {
            names.add((Object)"class");
            if (Modifier.isPublic(clazz.getModifiers())) {
                for (Class<?> t : clazz.getClasses()) {
                    if (!HostInteropReflect.isStaticTypeOrInterface(t)) continue;
                    names.add((Object)t.getSimpleName());
                }
            }
        }
        return (String[])names.toArray((Object[])new String[names.size()]);
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    public static Class<?> getMethodReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return Object.class;
        }
        return method.getReturnType();
    }

    public static Type getMethodGenericReturnType(Method method) {
        if (method == null || method.getReturnType() == Void.TYPE) {
            return Object.class;
        }
        return method.getGenericReturnType();
    }

    static String jniName(Method m) {
        StringBuilder sb = new StringBuilder();
        HostInteropReflect.noUnderscore(sb, m.getName()).append("__");
        HostInteropReflect.appendType(sb, m.getReturnType());
        Class<?>[] arr = m.getParameterTypes();
        for (int i = 0; i < arr.length; ++i) {
            HostInteropReflect.appendType(sb, arr[i]);
        }
        return sb.toString();
    }

    private static StringBuilder noUnderscore(StringBuilder sb, String name) {
        return sb.append(name.replace("_", "_1").replace('.', '_'));
    }

    private static void appendType(StringBuilder sb, Class<?> type) {
        if (type == Integer.TYPE) {
            sb.append('I');
            return;
        }
        if (type == Long.TYPE) {
            sb.append('J');
            return;
        }
        if (type == Double.TYPE) {
            sb.append('D');
            return;
        }
        if (type == Float.TYPE) {
            sb.append('F');
            return;
        }
        if (type == Byte.TYPE) {
            sb.append('B');
            return;
        }
        if (type == Boolean.TYPE) {
            sb.append('Z');
            return;
        }
        if (type == Short.TYPE) {
            sb.append('S');
            return;
        }
        if (type == Void.TYPE) {
            sb.append('V');
            return;
        }
        if (type == Character.TYPE) {
            sb.append('C');
            return;
        }
        if (type.isArray()) {
            sb.append("_3");
            HostInteropReflect.appendType(sb, type.getComponentType());
            return;
        }
        HostInteropReflect.noUnderscore(sb.append('L'), type.getName());
        sb.append("_2");
    }
}

