/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.HostObjectMRForeign;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;

final class HostObject
implements TruffleObject {
    static final HostObject NULL = new HostObject(null, null, false);
    final Object obj;
    final PolyglotLanguageContext languageContext;
    private final boolean staticClass;

    private HostObject(Object obj, PolyglotLanguageContext languageContext, boolean staticClass) {
        this.obj = obj;
        this.languageContext = languageContext;
        this.staticClass = staticClass;
    }

    static HostObject forClass(Class<?> clazz, PolyglotLanguageContext languageContext) {
        assert (clazz != null);
        return new HostObject(clazz, languageContext, false);
    }

    static HostObject forStaticClass(Class<?> clazz, PolyglotLanguageContext languageContext) {
        assert (clazz != null);
        return new HostObject(clazz, languageContext, true);
    }

    static HostObject forObject(Object object, PolyglotLanguageContext languageContext) {
        assert (object != null && !(object instanceof Class));
        return new HostObject(object, languageContext, false);
    }

    static boolean isInstance(Object obj) {
        return obj instanceof HostObject;
    }

    static boolean isInstance(TruffleObject obj) {
        return obj instanceof HostObject;
    }

    static boolean isStaticClass(Object object) {
        return object instanceof HostObject && ((HostObject)object).isStaticClass();
    }

    static boolean isJavaInstance(Class<?> targetType, Object javaObject) {
        if (javaObject instanceof HostObject) {
            Object value = HostObject.valueOf((HostObject)javaObject);
            return targetType.isInstance(value);
        }
        return false;
    }

    boolean isPrimitive() {
        return PolyglotImpl.isGuestPrimitive(this.obj);
    }

    static Object valueOf(TruffleObject value) {
        HostObject obj = (HostObject)value;
        return obj.obj;
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return HostObjectMRForeign.ACCESS;
    }

    public int hashCode() {
        return System.identityHashCode(this.obj);
    }

    boolean isClass() {
        return this.obj instanceof Class;
    }

    boolean isArray() {
        return this.obj != null && this.obj.getClass().isArray();
    }

    boolean isNull() {
        return this.obj == null;
    }

    boolean isStaticClass() {
        return this.staticClass;
    }

    Class<?> getObjectClass() {
        return this.obj == null ? null : this.obj.getClass();
    }

    Class<?> asStaticClass() {
        assert (this.isStaticClass());
        return (Class)this.obj;
    }

    Class<?> asClass() {
        assert (this.isClass());
        return (Class)this.obj;
    }

    Class<?> getLookupClass() {
        if (this.obj == null) {
            return null;
        }
        if (this.isStaticClass()) {
            return this.asStaticClass();
        }
        return this.obj.getClass();
    }

    public boolean equals(Object o) {
        if (o instanceof HostObject) {
            HostObject other = (HostObject)o;
            return this.obj == other.obj && this.languageContext == other.languageContext;
        }
        return false;
    }

    public String toString() {
        if (this.obj == null) {
            return "null";
        }
        if (this.isClass()) {
            return "JavaClass[" + this.asClass().getTypeName() + "]";
        }
        return "JavaObject[" + this.obj + " (" + this.getObjectClass().getTypeName() + ")]";
    }
}

