/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.HostClassDesc;
import com.oracle.truffle.polyglot.HostExecuteNode;
import com.oracle.truffle.polyglot.HostFieldDesc;
import com.oracle.truffle.polyglot.HostFunction;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostMethodDesc;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.HostObjectMRFactory;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.ToHostPrimitiveNode;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;

class HostObjectMR {
    HostObjectMR() {
    }

    static abstract class WriteFieldNode
    extends Node {
        static final int LIMIT = 3;
        @Node.Child
        private ToHostNode toHost = ToHostNode.create();

        WriteFieldNode() {
        }

        public abstract void execute(HostFieldDesc var1, HostObject var2, Object var3);

        @Specialization(guards={"field == cachedField"}, limit="LIMIT")
        void doCached(HostFieldDesc field, HostObject object, Object rawValue, @Cached(value="field") HostFieldDesc cachedField) {
            Object val = this.toHost.execute(rawValue, cachedField.getType(), cachedField.getGenericType(), object.languageContext);
            cachedField.set(object.obj, val);
        }

        @Specialization(replaces={"doCached"})
        void doUncached(HostFieldDesc field, HostObject object, Object rawValue) {
            Object val = this.toHost.execute(rawValue, field.getType(), field.getGenericType(), object.languageContext);
            field.set(object.obj, val);
        }
    }

    static abstract class ReadFieldNode
    extends Node {
        static final int LIMIT = 3;

        ReadFieldNode() {
        }

        public abstract Object execute(HostFieldDesc var1, HostObject var2);

        @Specialization(guards={"field == cachedField"}, limit="LIMIT")
        static Object doCached(HostFieldDesc field, HostObject object, @Cached(value="field") HostFieldDesc cachedField, @Cached(value="create()") PolyglotLanguageContext.ToGuestValueNode toGuest) {
            Object val = cachedField.get(object.obj);
            return toGuest.apply(object.languageContext, val);
        }

        @Specialization(replaces={"doCached"})
        static Object doUncached(HostFieldDesc field, HostObject object, @Cached(value="create()") PolyglotLanguageContext.ToGuestValueNode toGuest) {
            Object val = field.get(object.obj);
            return toGuest.apply(object.languageContext, val);
        }
    }

    static abstract class LookupMethodNode
    extends Node {
        static final int LIMIT = 3;

        LookupMethodNode() {
        }

        public abstract HostMethodDesc execute(Class<?> var1, String var2, boolean var3);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static HostMethodDesc doCached(Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name, onlyStatic)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == HostInteropReflect.findMethod(clazz, name, onlyStatic));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        static HostMethodDesc doUncached(Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findMethod(clazz, name, onlyStatic);
        }
    }

    static abstract class LookupInnerClassNode
    extends Node {
        static final int LIMIT = 3;

        LookupInnerClassNode() {
        }

        public abstract Class<?> execute(Class<?> var1, String var2);

        @Specialization(guards={"clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static Class<?> doCached(Class<?> clazz, String name, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name)") Class<?> cachedInnerClass) {
            assert (cachedInnerClass == HostInteropReflect.findInnerClass(clazz, name));
            return cachedInnerClass;
        }

        @Specialization(replaces={"doCached"})
        static Class<?> doUncached(Class<?> clazz, String name) {
            return HostInteropReflect.findInnerClass(clazz, name);
        }
    }

    static abstract class LookupFunctionalMethodNode
    extends Node {
        static final int LIMIT = 3;

        LookupFunctionalMethodNode() {
        }

        public abstract HostMethodDesc execute(Class<?> var1);

        @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
        static HostMethodDesc doCached(Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(clazz)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == LookupFunctionalMethodNode.doUncached(clazz));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        static HostMethodDesc doUncached(Class<?> clazz) {
            return HostClassDesc.forClass(clazz).getFunctionalMethod();
        }
    }

    static abstract class LookupFieldNode
    extends Node {
        static final int LIMIT = 3;

        LookupFieldNode() {
        }

        public abstract HostFieldDesc execute(Class<?> var1, String var2, boolean var3);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static HostFieldDesc doCached(Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name, onlyStatic)") HostFieldDesc cachedField) {
            assert (cachedField == HostInteropReflect.findField(clazz, name, onlyStatic));
            return cachedField;
        }

        @Specialization(replaces={"doCached"})
        static HostFieldDesc doUncached(Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findField(clazz, name, onlyStatic);
        }
    }

    static abstract class LookupConstructorNode
    extends Node {
        static final int LIMIT = 3;

        LookupConstructorNode() {
        }

        public abstract HostMethodDesc execute(Class<?> var1);

        @Specialization(guards={"clazz == cachedClazz"}, limit="LIMIT")
        static HostMethodDesc doCached(Class<?> clazz, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="doUncached(clazz)") HostMethodDesc cachedMethod) {
            assert (cachedMethod == LookupConstructorNode.doUncached(clazz));
            return cachedMethod;
        }

        @Specialization(replaces={"doCached"})
        static HostMethodDesc doUncached(Class<?> clazz) {
            return HostClassDesc.forClass(clazz).lookupConstructor();
        }
    }

    static abstract class ExecuteObjectNode
    extends Node {
        private static final Message EXECUTE = Message.EXECUTE;
        @Node.Child
        private LookupFunctionalMethodNode lookupMethod;
        @Node.Child
        private HostExecuteNode doExecute;

        ExecuteObjectNode() {
        }

        public Object access(HostObject receiver, Object[] args) {
            HostMethodDesc method;
            if (TruffleOptions.AOT) {
                throw UnsupportedMessageException.raise(EXECUTE);
            }
            if (receiver.obj != null && !receiver.isClass() && (method = this.lookupFunctionalInterfaceMethod(receiver)) != null) {
                if (this.doExecute == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.doExecute = this.insert(HostExecuteNode.create());
                }
                return this.doExecute.execute(method, receiver.obj, args, receiver.languageContext);
            }
            throw UnsupportedMessageException.raise(EXECUTE);
        }

        private HostMethodDesc lookupFunctionalInterfaceMethod(HostObject receiver) {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(HostObjectMRFactory.LookupFunctionalMethodNodeGen.create());
            }
            return this.lookupMethod.execute(receiver.getLookupClass());
        }
    }

    static abstract class IsExecutableObjectNode
    extends Node {
        @Node.Child
        private LookupFunctionalMethodNode lookupMethod;

        IsExecutableObjectNode() {
        }

        public Object access(HostObject receiver) {
            if (TruffleOptions.AOT) {
                return false;
            }
            return receiver.obj != null && !receiver.isClass() && this.lookupFunctionalInterfaceMethod(receiver) != null;
        }

        private HostMethodDesc lookupFunctionalInterfaceMethod(HostObject receiver) {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(HostObjectMRFactory.LookupFunctionalMethodNodeGen.create());
            }
            return this.lookupMethod.execute(receiver.getLookupClass());
        }
    }

    static abstract class KeyInfoNode
    extends Node {
        @Node.Child
        private KeyInfoCacheNode keyInfoCache;

        KeyInfoNode() {
        }

        public int access(HostObject receiver, int index) {
            if (index < 0) {
                return 0;
            }
            if (receiver.isArray()) {
                int length = Array.getLength(receiver.obj);
                if (index < length) {
                    return 6;
                }
            } else if (receiver.obj instanceof List) {
                int length = KeyInfoNode.listSize((List)receiver.obj);
                if (index < length) {
                    return 38;
                }
                if (index == length) {
                    return 64;
                }
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        public int access(HostObject receiver, Number index) {
            int i = index.intValue();
            if ((double)i != index.doubleValue()) {
                return 0;
            }
            return this.access(receiver, i);
        }

        @CompilerDirectives.TruffleBoundary
        private static int listSize(List<?> list) {
            return list.size();
        }

        public int access(HostObject receiver, String name) {
            if (receiver.isNull()) {
                throw UnsupportedMessageException.raise(Message.KEY_INFO);
            }
            if (TruffleOptions.AOT) {
                return 0;
            }
            return this.keyInfoCache().execute(receiver.getLookupClass(), name, receiver.isStaticClass());
        }

        private KeyInfoCacheNode keyInfoCache() {
            if (this.keyInfoCache == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.keyInfoCache = this.insert(HostObjectMRFactory.KeyInfoCacheNodeGen.create());
            }
            return this.keyInfoCache;
        }
    }

    static abstract class KeyInfoCacheNode
    extends Node {
        static final int LIMIT = 3;

        KeyInfoCacheNode() {
        }

        public abstract int execute(Class<?> var1, String var2, boolean var3);

        @Specialization(guards={"onlyStatic == cachedStatic", "clazz == cachedClazz", "cachedName.equals(name)"}, limit="LIMIT")
        static int doCached(Class<?> clazz, String name, boolean onlyStatic, @Cached(value="onlyStatic") boolean cachedStatic, @Cached(value="clazz") Class<?> cachedClazz, @Cached(value="name") String cachedName, @Cached(value="doUncached(clazz, name, onlyStatic)") int cachedKeyInfo) {
            assert (cachedKeyInfo == KeyInfoCacheNode.doUncached(clazz, name, onlyStatic));
            return cachedKeyInfo;
        }

        @Specialization(replaces={"doCached"})
        static int doUncached(Class<?> clazz, String name, boolean onlyStatic) {
            return HostInteropReflect.findKeyInfo(clazz, name, onlyStatic);
        }
    }

    static abstract class KeysNode
    extends Node {
        KeysNode() {
        }

        @CompilerDirectives.TruffleBoundary
        public Object access(HostObject receiver, boolean includeInternal) {
            if (receiver.isNull()) {
                throw UnsupportedMessageException.raise(Message.KEYS);
            }
            String[] fields = TruffleOptions.AOT ? new String[]{} : HostInteropReflect.findUniquePublicMemberNames(receiver.getLookupClass(), receiver.isStaticClass(), includeInternal);
            return HostObject.forObject(fields, receiver.languageContext);
        }
    }

    static abstract class HasKeysNode
    extends Node {
        HasKeysNode() {
        }

        public Object access(HostObject receiver) {
            return !receiver.isNull();
        }
    }

    static abstract class ArrayRemoveNode
    extends Node {
        ArrayRemoveNode() {
        }

        protected abstract boolean executeWithTarget(HostObject var1, Object var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList(receiver)"})
        protected boolean doListIntIndex(HostObject receiver, int index) {
            try {
                ((List)receiver.obj).remove(index);
            }
            catch (IndexOutOfBoundsException outOfBounds) {
                throw UnknownIdentifierException.raise(String.valueOf(index));
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList(receiver)"}, replaces={"doListIntIndex"})
        protected boolean doListGeneric(HostObject receiver, Number index) {
            return this.doListIntIndex(receiver, index.intValue());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isList(receiver)"})
        protected static boolean notArray(HostObject receiver, Number index) {
            throw UnsupportedMessageException.raise(Message.REMOVE);
        }

        static boolean isList(HostObject receiver) {
            return receiver.obj instanceof List;
        }
    }

    static abstract class RemoveNode
    extends Node {
        @Node.Child
        private ArrayRemoveNode arrayRemove;
        @Node.Child
        private MapRemoveNode mapRemove;

        RemoveNode() {
        }

        public Object access(HostObject receiver, Number index) {
            if (this.arrayRemove == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayRemove = this.insert(HostObjectMRFactory.ArrayRemoveNodeGen.create());
            }
            return this.arrayRemove.executeWithTarget(receiver, index);
        }

        public Object access(HostObject receiver, String name) {
            if (this.mapRemove == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.mapRemove = this.insert(HostObjectMRFactory.MapRemoveNodeGen.create());
            }
            return this.mapRemove.executeWithTarget(receiver, name);
        }
    }

    static abstract class MapRemoveNode
    extends Node {
        MapRemoveNode() {
        }

        protected abstract Object executeWithTarget(HostObject var1, String var2);

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isMap(receiver)"})
        protected Object doMapGeneric(HostObject receiver, String name) {
            Map map = (Map)receiver.obj;
            if (!map.containsKey(name)) {
                throw UnknownIdentifierException.raise(name);
            }
            map.remove(name);
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isMap(receiver)"})
        protected static Object notMap(HostObject receiver, String name) {
            throw UnsupportedMessageException.raise(Message.REMOVE);
        }

        static boolean isMap(HostObject receiver) {
            return receiver.obj instanceof Map;
        }
    }

    static abstract class ArrayWriteNode
    extends Node {
        @Node.Child
        private ToHostNode toJavaNode = ToHostNode.create();
        @Node.Child
        private ArraySet arraySet = HostObjectMRFactory.ArrayWriteNodeGen.ArraySetNodeGen.create();

        ArrayWriteNode() {
        }

        protected abstract Object executeWithTarget(HostObject var1, Object var2, Object var3);

        @Specialization(guards={"receiver.isArray()"})
        protected final Object doArrayIntIndex(HostObject receiver, int index, Object value) {
            return this.doArrayAccess(receiver, index, value);
        }

        @Specialization(guards={"receiver.isArray()", "index.getClass() == clazz"})
        protected final Object doArrayCached(HostObject receiver, Number index, Object value, @Cached(value="index.getClass()") Class<? extends Number> clazz) {
            return this.doArrayAccess(receiver, clazz.cast(index).intValue(), value);
        }

        @Specialization(guards={"receiver.isArray()"}, replaces={"doArrayCached"})
        protected final Object doArrayGeneric(HostObject receiver, Number index, Object value) {
            return this.doArrayAccess(receiver, index.intValue(), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList(receiver)"})
        protected Object doListIntIndex(HostObject receiver, int index, Object value) {
            Object javaValue = this.toJavaNode.execute(value, Object.class, null, receiver.languageContext);
            try {
                List list = (List)receiver.obj;
                if (index == list.size()) {
                    list.add(javaValue);
                } else {
                    list.set(index, javaValue);
                }
                return value;
            }
            catch (IndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(index));
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList(receiver)"}, replaces={"doListIntIndex"})
        protected Object doListGeneric(HostObject receiver, Number index, Object value) {
            return this.doListIntIndex(receiver, index.intValue(), value);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!receiver.isArray()", "!isList(receiver)"})
        protected static Object notArray(HostObject receiver, Number index, Object value) {
            throw UnsupportedMessageException.raise(Message.WRITE);
        }

        private Object doArrayAccess(HostObject receiver, int index, Object value) {
            Object obj = receiver.obj;
            assert (receiver.isArray());
            Object javaValue = this.toJavaNode.execute(value, obj.getClass().getComponentType(), null, receiver.languageContext);
            try {
                this.arraySet.execute(obj, index, javaValue);
            }
            catch (ArrayIndexOutOfBoundsException outOfBounds) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(index));
            }
            return HostObject.NULL;
        }

        static boolean isList(HostObject receiver) {
            return receiver.obj instanceof List;
        }

        static ArrayWriteNode create() {
            return HostObjectMRFactory.ArrayWriteNodeGen.create();
        }

        static abstract class ArraySet
        extends Node {
            ArraySet() {
            }

            protected abstract void execute(Object var1, int var2, Object var3);

            @Specialization
            void doBoolean(boolean[] array, int index, boolean value) {
                array[index] = value;
            }

            @Specialization
            void doByte(byte[] array, int index, byte value) {
                array[index] = value;
            }

            @Specialization
            void doShort(short[] array, int index, short value) {
                array[index] = value;
            }

            @Specialization
            void doChar(char[] array, int index, char value) {
                array[index] = value;
            }

            @Specialization
            void doInt(int[] array, int index, int value) {
                array[index] = value;
            }

            @Specialization
            void doLong(long[] array, int index, long value) {
                array[index] = value;
            }

            @Specialization
            void doFloat(float[] array, int index, float value) {
                array[index] = value;
            }

            @Specialization
            void doDouble(double[] array, int index, double value) {
                array[index] = value;
            }

            @Specialization
            void doObject(Object[] array, int index, Object value) {
                array[index] = value;
            }
        }
    }

    static abstract class WriteNode
    extends Node {
        @Node.Child
        private ArrayWriteNode arrayWrite;
        @Node.Child
        private LookupFieldNode lookupField;
        @Node.Child
        private WriteFieldNode writeField;

        WriteNode() {
        }

        public Object access(HostObject receiver, Number index, Object value) {
            if (this.arrayWrite == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayWrite = this.insert(ArrayWriteNode.create());
            }
            try {
                return this.arrayWrite.executeWithTarget(receiver, index, value);
            }
            catch (ClassCastException | NullPointerException e) {
                throw UnsupportedTypeException.raise(e, new Object[]{value});
            }
        }

        public Object access(HostObject receiver, String name, Object value) {
            if (TruffleOptions.AOT || receiver.isNull()) {
                throw UnsupportedMessageException.raise(Message.WRITE);
            }
            HostFieldDesc f = this.lookupField().execute(receiver.getLookupClass(), name, receiver.isStaticClass());
            if (f == null) {
                throw UnknownIdentifierException.raise(name);
            }
            try {
                this.writeField().execute(f, receiver, value);
            }
            catch (ClassCastException | NullPointerException e) {
                throw UnsupportedTypeException.raise(e, new Object[]{value});
            }
            return HostObject.NULL;
        }

        private LookupFieldNode lookupField() {
            if (this.lookupField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupField = this.insert(HostObjectMRFactory.LookupFieldNodeGen.create());
            }
            return this.lookupField;
        }

        private WriteFieldNode writeField() {
            if (this.writeField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeField = this.insert(HostObjectMRFactory.WriteFieldNodeGen.create());
            }
            return this.writeField;
        }
    }

    static abstract class ArrayReadNode
    extends Node {
        @Node.Child
        private ArrayGet arrayGet = HostObjectMRFactory.ArrayReadNodeGen.ArrayGetNodeGen.create();
        private final PolyglotLanguageContext.ToGuestValueNode toGuest = PolyglotLanguageContext.ToGuestValueNode.create();

        ArrayReadNode() {
        }

        protected abstract Object executeWithTarget(HostObject var1, Object var2);

        @Specialization(guards={"receiver.isArray()"})
        protected Object doArrayIntIndex(HostObject receiver, int index) {
            return this.doArrayAccess(receiver, index);
        }

        @Specialization(guards={"receiver.isArray()", "index.getClass() == clazz"}, replaces={"doArrayIntIndex"})
        protected Object doArrayCached(HostObject receiver, Number index, @Cached(value="index.getClass()") Class<? extends Number> clazz) {
            return this.doArrayAccess(receiver, clazz.cast(index).intValue());
        }

        @Specialization(guards={"receiver.isArray()"}, replaces={"doArrayCached"})
        protected Object doArrayGeneric(HostObject receiver, Number index) {
            return this.doArrayAccess(receiver, index.intValue());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList(receiver)"})
        protected Object doListIntIndex(HostObject receiver, int index) {
            try {
                return this.toGuest.apply(receiver.languageContext, ((List)receiver.obj).get(index));
            }
            catch (IndexOutOfBoundsException e) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(index));
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isList(receiver)"}, replaces={"doListIntIndex"})
        protected Object doListGeneric(HostObject receiver, Number index) {
            return this.doListIntIndex(receiver, index.intValue());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!receiver.isArray()", "!isList(receiver)"})
        protected static Object notArray(HostObject receiver, Number index) {
            throw UnsupportedMessageException.raise(Message.READ);
        }

        private Object doArrayAccess(HostObject object, int index) {
            Object obj = object.obj;
            assert (object.isArray());
            Object val = null;
            try {
                val = this.arrayGet.execute(obj, index);
            }
            catch (ArrayIndexOutOfBoundsException outOfBounds) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(index));
            }
            return this.toGuest.apply(object.languageContext, val);
        }

        static boolean isList(HostObject receiver) {
            return receiver.obj instanceof List;
        }

        static abstract class ArrayGet
        extends Node {
            ArrayGet() {
            }

            protected abstract Object execute(Object var1, int var2);

            @Specialization
            boolean doBoolean(boolean[] array, int index) {
                return array[index];
            }

            @Specialization
            byte doByte(byte[] array, int index) {
                return array[index];
            }

            @Specialization
            short doShort(short[] array, int index) {
                return array[index];
            }

            @Specialization
            char doChar(char[] array, int index) {
                return array[index];
            }

            @Specialization
            int doInt(int[] array, int index) {
                return array[index];
            }

            @Specialization
            long doLong(long[] array, int index) {
                return array[index];
            }

            @Specialization
            float doFloat(float[] array, int index) {
                return array[index];
            }

            @Specialization
            double doDouble(double[] array, int index) {
                return array[index];
            }

            @Specialization
            Object doObject(Object[] array, int index) {
                return array[index];
            }
        }
    }

    static abstract class ReadNode
    extends Node {
        @Node.Child
        private ArrayReadNode arrayRead;
        @Node.Child
        private LookupFieldNode lookupField;
        @Node.Child
        private ReadFieldNode readField;
        @Node.Child
        private LookupMethodNode lookupMethod;
        @Node.Child
        private LookupInnerClassNode lookupInnerClass;

        ReadNode() {
        }

        public Object access(HostObject object, Number index) {
            if (this.arrayRead == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.arrayRead = this.insert(HostObjectMRFactory.ArrayReadNodeGen.create());
            }
            return this.arrayRead.executeWithTarget(object, index);
        }

        public Object access(HostObject object, String name) {
            if (TruffleOptions.AOT || object.isNull()) {
                throw UnsupportedMessageException.raise(Message.READ);
            }
            boolean isStatic = object.isStaticClass();
            Class<?> lookupClass = object.getLookupClass();
            HostFieldDesc foundField = this.lookupField().execute(lookupClass, name, isStatic);
            if (foundField != null) {
                return this.readField().execute(foundField, object);
            }
            HostMethodDesc foundMethod = this.lookupMethod().execute(lookupClass, name, isStatic);
            if (foundMethod != null) {
                return new HostFunction(foundMethod, object.obj, object.languageContext);
            }
            if (isStatic) {
                LookupInnerClassNode lookupInnerClassNode = this.lookupInnerClass();
                if ("class".equals(name)) {
                    return HostObject.forClass(lookupClass, object.languageContext);
                }
                Class<?> innerclass = lookupInnerClassNode.execute(lookupClass, name);
                if (innerclass != null) {
                    return HostObject.forStaticClass(innerclass, object.languageContext);
                }
            }
            throw UnknownIdentifierException.raise(name);
        }

        private ReadFieldNode readField() {
            if (this.readField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readField = this.insert(HostObjectMRFactory.ReadFieldNodeGen.create());
            }
            return this.readField;
        }

        private LookupFieldNode lookupField() {
            if (this.lookupField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupField = this.insert(HostObjectMRFactory.LookupFieldNodeGen.create());
            }
            return this.lookupField;
        }

        private LookupMethodNode lookupMethod() {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(HostObjectMRFactory.LookupMethodNodeGen.create());
            }
            return this.lookupMethod;
        }

        private LookupInnerClassNode lookupInnerClass() {
            if (this.lookupInnerClass == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupInnerClass = this.insert(HostObjectMRFactory.LookupInnerClassNodeGen.create());
            }
            return this.lookupInnerClass;
        }
    }

    static abstract class UnboxNode
    extends Node {
        @Node.Child
        private ToHostPrimitiveNode primitive = ToHostPrimitiveNode.create();

        UnboxNode() {
        }

        public Object access(HostObject object) {
            if (object.isPrimitive()) {
                return object.obj;
            }
            return UnsupportedMessageException.raise(Message.UNBOX);
        }
    }

    static abstract class BoxedCheckNode
    extends Node {
        @Node.Child
        private ToHostPrimitiveNode primitive = ToHostPrimitiveNode.create();

        BoxedCheckNode() {
        }

        public Object access(HostObject object) {
            return object.isPrimitive();
        }
    }

    static abstract class NullCheckNode
    extends Node {
        NullCheckNode() {
        }

        public Object access(HostObject object) {
            return object.isNull();
        }
    }

    static abstract class NewNode
    extends Node {
        private static final Message NEW = Message.NEW;
        @Node.Child
        private LookupConstructorNode lookupConstructor;
        @Node.Child
        private HostExecuteNode executeMethod;
        @Node.Child
        private ToHostNode toJava;

        NewNode() {
        }

        public Object access(HostObject receiver, Object[] args) {
            if (TruffleOptions.AOT) {
                throw UnsupportedMessageException.raise(NEW);
            }
            if (receiver.isClass()) {
                Class<?> javaClass = receiver.asClass();
                if (javaClass.isArray()) {
                    return this.newArray(receiver, args);
                }
                HostMethodDesc constructor = this.lookupConstructor().execute(javaClass);
                if (constructor != null) {
                    return this.executeMethod().execute(constructor, null, args, receiver.languageContext);
                }
            }
            throw UnsupportedMessageException.raise(NEW);
        }

        private Object newArray(HostObject receiver, Object[] args) {
            int length;
            if (args.length != 1) {
                throw ArityException.raise(1, args.length);
            }
            if (this.toJava == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toJava = this.insert(ToHostNode.create());
            }
            try {
                length = (Integer)this.toJava.execute(args[0], Integer.TYPE, null, receiver.languageContext);
            }
            catch (ClassCastException | NullPointerException e) {
                throw UnsupportedTypeException.raise(e, args);
            }
            Object array = Array.newInstance(receiver.asClass().getComponentType(), length);
            return HostObject.forObject(array, receiver.languageContext);
        }

        private LookupConstructorNode lookupConstructor() {
            if (this.lookupConstructor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupConstructor = this.insert(HostObjectMRFactory.LookupConstructorNodeGen.create());
            }
            return this.lookupConstructor;
        }

        private HostExecuteNode executeMethod() {
            if (this.executeMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeMethod = this.insert(HostExecuteNode.create());
            }
            return this.executeMethod;
        }
    }

    static abstract class IsInstantiableObjectNode
    extends Node {
        @Node.Child
        private LookupConstructorNode lookupConstructor;

        IsInstantiableObjectNode() {
        }

        public Object access(HostObject receiver) {
            if (TruffleOptions.AOT) {
                return false;
            }
            return receiver.isClass() && this.lookupConstructor().execute(receiver.asClass()) != null;
        }

        private LookupConstructorNode lookupConstructor() {
            if (this.lookupConstructor == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupConstructor = this.insert(HostObjectMRFactory.LookupConstructorNodeGen.create());
            }
            return this.lookupConstructor;
        }
    }

    static abstract class InvokeNode
    extends Node {
        private static final Message INVOKE = Message.INVOKE;
        @Node.Child
        private LookupMethodNode lookupMethod;
        @Node.Child
        private HostExecuteNode executeMethod;
        @Node.Child
        private LookupFieldNode lookupField;
        @Node.Child
        private ReadFieldNode readField;
        @Node.Child
        private Node sendIsExecutableNode;
        @Node.Child
        private Node sendExecuteNode;

        InvokeNode() {
        }

        public Object access(HostObject object, String name, Object[] args) {
            Object fieldValue;
            if (TruffleOptions.AOT || object.isNull()) {
                throw UnsupportedMessageException.raise(INVOKE);
            }
            boolean isStatic = object.isStaticClass();
            Class<?> lookupClass = object.getLookupClass();
            HostMethodDesc foundMethod = this.lookupMethod().execute(lookupClass, name, isStatic);
            if (foundMethod != null) {
                return this.executeMethod().execute(foundMethod, object.obj, args, object.languageContext);
            }
            HostFieldDesc foundField = this.lookupField().execute(lookupClass, name, isStatic);
            if (foundField != null && (fieldValue = this.readField().execute(foundField, object)) instanceof TruffleObject) {
                boolean isExecutable;
                TruffleObject fieldObject = (TruffleObject)fieldValue;
                if (this.sendIsExecutableNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.sendIsExecutableNode = this.insert(Message.IS_EXECUTABLE.createNode());
                }
                if (isExecutable = ForeignAccess.sendIsExecutable(this.sendIsExecutableNode, fieldObject)) {
                    if (this.sendExecuteNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.sendExecuteNode = this.insert(Message.EXECUTE.createNode());
                    }
                    try {
                        return ForeignAccess.sendExecute(this.sendExecuteNode, fieldObject, args);
                    }
                    catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                        throw e.raise();
                    }
                }
            }
            throw UnknownIdentifierException.raise(name);
        }

        private LookupMethodNode lookupMethod() {
            if (this.lookupMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupMethod = this.insert(HostObjectMRFactory.LookupMethodNodeGen.create());
            }
            return this.lookupMethod;
        }

        private HostExecuteNode executeMethod() {
            if (this.executeMethod == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeMethod = this.insert(HostExecuteNode.create());
            }
            return this.executeMethod;
        }

        private LookupFieldNode lookupField() {
            if (this.lookupField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lookupField = this.insert(HostObjectMRFactory.LookupFieldNodeGen.create());
            }
            return this.lookupField;
        }

        private ReadFieldNode readField() {
            if (this.readField == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.readField = this.insert(HostObjectMRFactory.ReadFieldNodeGen.create());
            }
            return this.readField;
        }
    }

    static abstract class ArrayHasSizeNode
    extends Node {
        ArrayHasSizeNode() {
        }

        public Object access(HostObject receiver) {
            Object obj = receiver.obj;
            if (obj == null) {
                return false;
            }
            return obj.getClass().isArray() || obj instanceof List;
        }
    }

    static abstract class ArrayGetSizeNode
    extends Node {
        ArrayGetSizeNode() {
        }

        public Object access(HostObject receiver) {
            Object obj = receiver.obj;
            if (obj != null) {
                if (obj.getClass().isArray()) {
                    return Array.getLength(obj);
                }
                if (obj instanceof List) {
                    return ((List)obj).size();
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw UnsupportedMessageException.raise(Message.GET_SIZE);
        }
    }
}

