/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

final class LanguageCache
implements Comparable<LanguageCache> {
    private static final Map<String, LanguageCache> nativeImageCache = TruffleOptions.AOT ? new HashMap() : null;
    private static final Map<String, LanguageCache> nativeImageMimes = TruffleOptions.AOT ? new HashMap() : null;
    private static volatile Map<String, LanguageCache> runtimeCache;
    private static volatile Map<String, LanguageCache> runtimeMimes;
    private final String className;
    private final Set<String> mimeTypes;
    private final Set<String> characterMimeTypes;
    private final Set<String> byteMimeTypes;
    private final String defaultMimeType;
    private final Set<String> dependentLanguages;
    private final String id;
    private final String name;
    private final String implementationName;
    private final String version;
    private final boolean interactive;
    private final boolean internal;
    private final ClassLoader loader;
    private final TruffleLanguage<?> globalInstance;
    private String languageHome;
    private volatile TruffleLanguage.ContextPolicy policy;
    private volatile Class<? extends TruffleLanguage<?>> languageClass;

    private LanguageCache(String id, String prefix, Properties info, ClassLoader loader, String url) {
        this.loader = loader;
        this.className = info.getProperty(prefix + "className");
        this.name = info.getProperty(prefix + "name");
        this.implementationName = info.getProperty(prefix + "implementationName");
        this.version = info.getProperty(prefix + "version");
        TreeSet<String> characterMimes = LanguageCache.parseList(info, prefix + "characterMimeType");
        if (characterMimes.isEmpty()) {
            characterMimes = LanguageCache.parseList(info, prefix + "mimeType");
        }
        this.characterMimeTypes = characterMimes;
        this.byteMimeTypes = LanguageCache.parseList(info, prefix + "byteMimeType");
        this.mimeTypes = new TreeSet<String>();
        this.mimeTypes.addAll(characterMimes);
        this.mimeTypes.addAll(this.byteMimeTypes);
        String defaultMime = info.getProperty(prefix + "defaultMimeType");
        this.defaultMimeType = this.mimeTypes.size() == 1 && defaultMime == null ? this.mimeTypes.iterator().next() : defaultMime;
        this.dependentLanguages = LanguageCache.parseList(info, prefix + "dependentLanguage");
        this.id = id;
        this.interactive = Boolean.valueOf(info.getProperty(prefix + "interactive"));
        this.internal = Boolean.valueOf(info.getProperty(prefix + "internal"));
        this.languageHome = url;
        if (TruffleOptions.AOT) {
            this.initializeLanguageClass();
            assert (this.languageClass != null);
            assert (this.policy != null);
        }
        this.globalInstance = null;
    }

    private static TreeSet<String> parseList(Properties info, String prefix) {
        String mt;
        TreeSet<String> mimeTypesSet = new TreeSet<String>();
        int i = 0;
        while ((mt = info.getProperty(prefix + "." + i)) != null) {
            mimeTypesSet.add(mt);
            ++i;
        }
        return mimeTypesSet;
    }

    LanguageCache(String id, String name, String implementationName, String version, boolean interactive, boolean internal, TruffleLanguage<?> instance) {
        this.id = id;
        this.className = instance.getClass().getName();
        this.mimeTypes = Collections.emptySet();
        this.characterMimeTypes = Collections.emptySet();
        this.byteMimeTypes = Collections.emptySet();
        this.defaultMimeType = null;
        this.implementationName = implementationName;
        this.name = name;
        this.version = version;
        this.interactive = interactive;
        this.internal = internal;
        this.dependentLanguages = Collections.emptySet();
        this.loader = instance.getClass().getClassLoader();
        this.languageClass = instance.getClass();
        this.languageHome = null;
        this.policy = TruffleLanguage.ContextPolicy.SHARED;
        this.globalInstance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, LanguageCache> languageMimes() {
        if (TruffleOptions.AOT) {
            return nativeImageMimes;
        }
        Map<String, LanguageCache> cache = runtimeMimes;
        if (cache != null) return cache;
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            cache = runtimeMimes;
            if (cache != null) return cache;
            runtimeMimes = cache = LanguageCache.createMimes();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, LanguageCache> createMimes() {
        LinkedHashMap<String, LanguageCache> mimes = new LinkedHashMap<String, LanguageCache>();
        for (LanguageCache cache : LanguageCache.languages().values()) {
            for (String mime : cache.getMimeTypes()) {
                mimes.put(mime, cache);
            }
        }
        return mimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Map<String, LanguageCache> languages() {
        if (TruffleOptions.AOT) {
            return nativeImageCache;
        }
        Map<String, LanguageCache> cache = runtimeCache;
        if (cache != null) return cache;
        Class<LanguageCache> clazz = LanguageCache.class;
        synchronized (LanguageCache.class) {
            cache = runtimeCache;
            if (cache != null) return cache;
            runtimeCache = cache = LanguageCache.createLanguages(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    private static Map<String, LanguageCache> createLanguages(ClassLoader additionalLoader) {
        ArrayList<LanguageCache> caches = new ArrayList<LanguageCache>();
        for (ClassLoader loader : VMAccessor.allLoaders()) {
            LanguageCache.collectLanguages(loader, caches);
        }
        if (additionalLoader != null) {
            LanguageCache.collectLanguages(additionalLoader, caches);
        }
        HashMap<String, LanguageCache> cacheToId = new HashMap<String, LanguageCache>();
        for (LanguageCache languageCache : caches) {
            cacheToId.put(languageCache.getId(), languageCache);
        }
        return cacheToId;
    }

    private static void collectLanguages(ClassLoader loader, List<LanguageCache> list) {
        Enumeration<URL> en;
        if (loader == null) {
            return;
        }
        try {
            en = loader.getResources("META-INF/truffle/language");
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot read list of Truffle languages", ex);
        }
        while (en.hasMoreElements()) {
            String prefix;
            String name;
            URLConnection connection;
            Properties p;
            URL u = en.nextElement();
            try {
                p = new Properties();
                connection = u.openConnection();
                try (InputStream is = connection.getInputStream();){
                    p.load(is);
                }
            }
            catch (IOException ex) {
                PrintStream out = System.err;
                out.println("Cannot process " + u + " as language definition");
                ex.printStackTrace();
                continue;
            }
            int cnt = 1;
            while ((name = p.getProperty((prefix = "language" + cnt + ".") + "name")) != null) {
                String languageHome;
                String id;
                block24: {
                    id = p.getProperty(prefix + "id");
                    if (id == null) {
                        id = LanguageCache.defaultId(name, p.getProperty(prefix + "className"));
                    }
                    if ((languageHome = System.getProperty(id + ".home")) == null && connection instanceof JarURLConnection) {
                        try {
                            Path path = Paths.get(((JarURLConnection)connection).getJarFileURL().toURI());
                            languageHome = path.getParent().toString();
                        }
                        catch (URISyntaxException e) {
                            if ($assertionsDisabled) break block24;
                            throw new AssertionError((Object)"Could not resolve path.");
                        }
                    }
                }
                list.add(new LanguageCache(id, prefix, p, loader, languageHome));
                ++cnt;
            }
        }
    }

    private static String defaultId(String name, String className) {
        String resolvedId;
        if (name.isEmpty()) {
            int lastIndex = className.lastIndexOf(36);
            if (lastIndex == -1) {
                lastIndex = className.lastIndexOf(46);
            }
            resolvedId = className.substring(lastIndex + 1, className.length());
        } else {
            resolvedId = name.length() == 1 ? name : name.toLowerCase();
        }
        return resolvedId;
    }

    @Override
    public int compareTo(LanguageCache o) {
        return this.id.compareTo(o.id);
    }

    String getId() {
        return this.id;
    }

    Set<String> getMimeTypes() {
        return this.mimeTypes;
    }

    String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    boolean isCharacterMimeType(String mimeType) {
        return this.characterMimeTypes.contains(mimeType);
    }

    boolean isByteMimeType(String mimeType) {
        return this.characterMimeTypes.contains(mimeType);
    }

    String getName() {
        return this.name;
    }

    String getImplementationName() {
        return this.implementationName;
    }

    Set<String> getDependentLanguages() {
        return this.dependentLanguages;
    }

    String getVersion() {
        return this.version;
    }

    String getClassName() {
        return this.className;
    }

    boolean isInternal() {
        return this.internal;
    }

    boolean isInteractive() {
        return this.interactive;
    }

    String getLanguageHome() {
        if (this.languageHome == null) {
            this.languageHome = System.getProperty(this.id + ".home");
        }
        return this.languageHome;
    }

    TruffleLanguage<?> loadLanguage() {
        TruffleLanguage<?> instance;
        if (this.globalInstance != null) {
            return this.globalInstance;
        }
        try {
            instance = this.getLanguageClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create instance of " + this.name + " language implementation. Public default constructor expected in " + this.className + ".", e);
        }
        return instance;
    }

    Class<? extends TruffleLanguage<?>> getLanguageClass() {
        if (!TruffleOptions.AOT) {
            this.initializeLanguageClass();
        }
        return this.languageClass;
    }

    TruffleLanguage.ContextPolicy getPolicy() {
        this.initializeLanguageClass();
        return this.policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLanguageClass() {
        if (this.languageClass == null) {
            LanguageCache languageCache = this;
            synchronized (languageCache) {
                if (this.languageClass == null) {
                    try {
                        Class<?> loadedClass = Class.forName(this.className, true, this.loader);
                        TruffleLanguage.Registration reg = loadedClass.getAnnotation(TruffleLanguage.Registration.class);
                        this.policy = reg == null ? TruffleLanguage.ContextPolicy.EXCLUSIVE : loadedClass.getAnnotation(TruffleLanguage.Registration.class).contextPolicy();
                        this.languageClass = loadedClass;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot load language " + this.name + ". Language implementation class " + this.className + " failed to load.", e);
                    }
                }
            }
        }
    }

    public String toString() {
        return "LanguageCache [id=" + this.id + ", name=" + this.name + ", implementationName=" + this.implementationName + ", version=" + this.version + ", className=" + this.className + "]";
    }

    static void resetNativeImageCacheLanguageHomes() {
        for (LanguageCache languageCache : LanguageCache.languages().values()) {
            languageCache.languageHome = null;
        }
    }

    private static void initializeNativeImageState(ClassLoader imageClassLoader) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.putAll(LanguageCache.createLanguages(imageClassLoader));
        nativeImageMimes.putAll(LanguageCache.createMimes());
    }

    private static void resetNativeImageState() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        nativeImageCache.clear();
        nativeImageMimes.clear();
    }

    private static void removeLanguageFromNativeImage(String languageId) {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        assert (nativeImageCache.containsKey(languageId));
        LanguageCache cache = nativeImageCache.remove(languageId);
        if (cache != null) {
            for (String mime : cache.getMimeTypes()) {
                if (nativeImageCache.get(mime) != cache) continue;
                nativeImageMimes.remove(mime);
            }
        }
    }

    private static Collection<Class<?>> getLanguageClasses() {
        assert (TruffleOptions.AOT) : "Only supported during image generation";
        ArrayList list = new ArrayList();
        for (LanguageCache cache : nativeImageCache.values()) {
            assert (cache.languageClass != null);
            list.add(cache.languageClass);
        }
        return list;
    }
}

