/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.HostEntryRootNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ProxyInvokeNode;
import com.oracle.truffle.polyglot.ProxyInvokeNodeGen;
import java.lang.reflect.Method;
import java.util.Objects;

class ObjectProxyNode
extends HostEntryRootNode<TruffleObject> {
    final Class<?> receiverClass;
    final Class<?> interfaceType;
    @Node.Child
    private ProxyInvokeNode proxyInvoke = ProxyInvokeNodeGen.create();
    @CompilerDirectives.CompilationFinal
    private PolyglotLanguageContext.ToGuestValuesNode toGuests;

    ObjectProxyNode(Class<?> receiverType, Class<?> interfaceType) {
        this.receiverClass = receiverType;
        this.interfaceType = interfaceType;
    }

    @Override
    protected Class<? extends TruffleObject> getReceiverType() {
        return this.receiverClass;
    }

    @Override
    public final String getName() {
        return "InterfaceProxy<" + this.receiverClass + ">";
    }

    @Override
    protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
        if (this.proxyInvoke == null || this.toGuests == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.toGuests = PolyglotLanguageContext.ToGuestValuesNode.create();
            this.proxyInvoke = ProxyInvokeNodeGen.create();
        }
        Method method = (Method)args[offset];
        Object[] arguments = this.toGuests.apply(languageContext, (Object[])args[offset + 1]);
        return this.proxyInvoke.execute(languageContext, receiver, method, arguments);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.receiverClass);
        result = 31 * result + Objects.hashCode(this.interfaceType);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectProxyNode)) {
            return false;
        }
        ObjectProxyNode other = (ObjectProxyNode)obj;
        return this.receiverClass == other.receiverClass && this.interfaceType == other.interfaceType;
    }

    static CallTarget lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> interfaceClass) {
        ObjectProxyNode node = new ObjectProxyNode(receiverClass, interfaceClass);
        CallTarget target = ObjectProxyNode.lookupHostCodeCache(languageContext, node, CallTarget.class);
        if (target == null) {
            target = ObjectProxyNode.installHostCodeCache(languageContext, node, ObjectProxyNode.createTarget(node), CallTarget.class);
        }
        return target;
    }
}

