/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.polyglot.io.FileSystem;

final class PolyglotContextConfig {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    final OutputStream out;
    final OutputStream err;
    final InputStream in;
    final boolean hostAccessAllowed;
    final boolean nativeAccessAllowed;
    final boolean createThreadAllowed;
    final boolean hostClassLoadingAllowed;
    final Predicate<String> classFilter;
    private final Map<String, String[]> applicationArguments;
    final Set<String> allowedPublicLanguages;
    private final Map<String, OptionValuesImpl> optionsByLanguage;
    @CompilerDirectives.CompilationFinal
    FileSystem fileSystem;
    final Map<String, Level> logLevels;
    final Handler logHandler;

    PolyglotContextConfig(PolyglotEngineImpl engine, OutputStream out, OutputStream err, InputStream in, boolean hostAccessAllowed, boolean nativeAccessAllowed, boolean createThreadAllowed, boolean hostClassLoadingAllowed, Predicate<String> classFilter, Map<String, String[]> applicationArguments, Set<String> allowedPublicLanguages, Map<String, String> options, FileSystem fileSystem, Handler logHandler) {
        assert (out != null);
        assert (err != null);
        assert (in != null);
        this.out = out;
        this.err = err;
        this.in = in;
        this.hostAccessAllowed = hostAccessAllowed;
        this.nativeAccessAllowed = nativeAccessAllowed;
        this.createThreadAllowed = createThreadAllowed;
        this.hostClassLoadingAllowed = hostClassLoadingAllowed;
        this.classFilter = classFilter;
        this.applicationArguments = applicationArguments;
        this.allowedPublicLanguages = allowedPublicLanguages;
        this.fileSystem = fileSystem;
        this.optionsByLanguage = new HashMap<String, OptionValuesImpl>();
        this.logHandler = logHandler;
        this.logLevels = new HashMap<String, Level>(engine.logLevels);
        for (String optionKey : options.keySet()) {
            String group = PolyglotEngineImpl.parseOptionGroup(optionKey);
            if (group.equals("log")) {
                this.logLevels.put(PolyglotEngineImpl.parseLoggerName(optionKey), Level.parse(options.get(optionKey)));
                continue;
            }
            PolyglotLanguage language = PolyglotContextConfig.findLanguageForOption(engine, optionKey, group);
            OptionValuesImpl languageOptions = this.optionsByLanguage.get(language.getId());
            if (languageOptions == null) {
                languageOptions = language.getOptionValues().copy();
                this.optionsByLanguage.put(language.getId(), languageOptions);
            }
            languageOptions.put(optionKey, options.get(optionKey));
        }
    }

    String[] getApplicationArguments(PolyglotLanguage lang) {
        String[] args = this.applicationArguments.get(lang.getId());
        if (args == null) {
            args = EMPTY_STRING_ARRAY;
        }
        return args;
    }

    OptionValuesImpl getOptionValues(PolyglotLanguage lang) {
        OptionValuesImpl values = this.optionsByLanguage.get(lang.getId());
        if (values == null) {
            values = lang.getOptionValues();
        }
        return values.copy();
    }

    private static PolyglotLanguage findLanguageForOption(PolyglotEngineImpl engine, String optionKey, String group) {
        PolyglotLanguage language = engine.idToLanguage.get(group);
        if (language == null) {
            if (engine.isEngineGroup(group) && engine.getAllOptions().get(optionKey) != null) {
                throw new IllegalArgumentException("Option " + optionKey + " is an engine option. Engine level options can only be configured for contexts without a shared engine set. To resolve this, configure the option when creating the Engine or create a context without a shared engine.");
            }
            throw OptionValuesImpl.failNotFound(engine.getAllOptions(), optionKey);
        }
        assert (!engine.isEngineGroup(group));
        return language;
    }
}

