/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.ContextThreadLocal;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.FinalIntMap;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.PolyglotBindingsValue;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotFunction;
import com.oracle.truffle.polyglot.PolyglotIllegalStateException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMap;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotContextImpl
extends AbstractPolyglotImpl.AbstractContextImpl
implements PolyglotImpl.VMObject {
    @CompilerDirectives.CompilationFinal
    private static SingleContextState singleContextState = new SingleContextState();
    private static final Object NO_ENTER = new Object();
    private final Assumption singleThreaded = Truffle.getRuntime().createAssumption("Single threaded");
    private final Assumption singleThreadedConstant = Truffle.getRuntime().createAssumption("Single threaded constant thread");
    private final Map<Thread, PolyglotThreadInfo> threads = new HashMap<Thread, PolyglotThreadInfo>();
    private volatile PolyglotThreadInfo currentThreadInfo = PolyglotThreadInfo.NULL;
    @CompilerDirectives.CompilationFinal
    private volatile PolyglotThreadInfo constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
    volatile boolean cancelling;
    private volatile Thread closingThread;
    volatile boolean closed;
    final PolyglotEngineImpl engine;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    final PolyglotLanguageContext[] contexts;
    Context creatorApi;
    Context currentApi;
    final TruffleContext truffleContext;
    final PolyglotContextImpl parent;
    final Map<String, Value> polyglotBindings;
    final Value polyglotHostBindings;
    final PolyglotLanguage creator;
    final Map<String, Object> creatorArguments;
    @CompilerDirectives.CompilationFinal
    PolyglotContextConfig config;
    @CompilerDirectives.CompilationFinal
    private FinalIntMap languageIndexMap;
    private final List<PolyglotContextImpl> childContexts = new ArrayList<PolyglotContextImpl>();
    boolean inContextPreInitialization;

    static void resetSingleContextState() {
        singleContextState = new SingleContextState();
    }

    private PolyglotContextImpl() {
        super(null);
        this.engine = null;
        this.contexts = null;
        this.truffleContext = null;
        this.parent = null;
        this.polyglotHostBindings = null;
        this.polyglotBindings = null;
        this.creator = null;
        this.creatorArguments = null;
    }

    PolyglotContextImpl(PolyglotEngineImpl engine, PolyglotContextConfig config) {
        super((AbstractPolyglotImpl)engine.impl);
        this.parent = null;
        this.engine = engine;
        this.config = config;
        this.creator = null;
        this.creatorArguments = Collections.emptyMap();
        this.truffleContext = VMAccessor.LANGUAGE.createTruffleContext(this);
        this.polyglotBindings = new ConcurrentHashMap<String, Value>();
        this.contexts = this.createContextArray();
        if (!config.logLevels.isEmpty()) {
            VMAccessor.LANGUAGE.configureLoggers(this, config.logLevels);
        }
        PolyglotLanguageContext hostContext = this.getContextInitialized(engine.hostLanguage, null);
        this.polyglotHostBindings = this.getAPIAccess().newValue(this.polyglotBindings, (AbstractPolyglotImpl.AbstractValueImpl)new PolyglotBindingsValue(hostContext));
        this.notifyContextCreated();
        PolyglotContextImpl.initializeStaticContext(this);
    }

    PolyglotContextImpl(PolyglotLanguageContext creator, Map<String, Object> langConfig, TruffleContext spiContext) {
        super((AbstractPolyglotImpl)creator.getEngine().impl);
        PolyglotContextImpl parent;
        this.parent = parent = creator.context;
        this.config = parent.config;
        this.engine = parent.engine;
        this.creator = creator.language;
        this.creatorArguments = langConfig;
        this.parent.addChildContext(this);
        this.truffleContext = spiContext;
        this.polyglotBindings = new ConcurrentHashMap<String, Value>();
        if (!parent.config.logLevels.isEmpty()) {
            VMAccessor.LANGUAGE.configureLoggers(this, parent.config.logLevels);
        }
        this.contexts = this.createContextArray();
        this.polyglotHostBindings = this.getAPIAccess().newValue(this.polyglotBindings, (AbstractPolyglotImpl.AbstractValueImpl)new PolyglotBindingsValue(this.getHostContext()));
        PolyglotContextImpl.initializeStaticContext(this);
    }

    private PolyglotLanguageContext[] createContextArray() {
        PolyglotLanguageContext hostContext;
        Collection<PolyglotLanguage> languages = this.engine.idToLanguage.values();
        PolyglotLanguageContext[] newContexts = new PolyglotLanguageContext[languages.size() + 1];
        Iterator<PolyglotLanguage> languageIterator = languages.iterator();
        newContexts[0] = hostContext = new PolyglotLanguageContext(this, this.engine.hostLanguage);
        for (int i = 1; i < languages.size() + 1; ++i) {
            PolyglotLanguage language = languageIterator.next();
            newContexts[i] = new PolyglotLanguageContext(this, language);
        }
        hostContext.ensureInitialized(null);
        ((HostLanguage.HostContext)hostContext.getContextImpl()).internalContext = hostContext;
        return newContexts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initializeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    if (state.singleContext != null) {
                        state.singleContextAssumption.invalidate();
                        state.singleContext = null;
                    } else {
                        state.singleContext = context;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeStaticContext(PolyglotContextImpl context) {
        SingleContextState state = singleContextState;
        if (state.singleContextAssumption.isValid()) {
            SingleContextState singleContextState = state;
            synchronized (singleContextState) {
                if (state.singleContextAssumption.isValid()) {
                    assert (state.singleContext == context);
                    state.singleContext = null;
                }
            }
        }
    }

    PolyglotLanguageContext getContext(PolyglotLanguage language) {
        return this.contexts[language.index];
    }

    PolyglotLanguageContext getContextInitialized(PolyglotLanguage language, PolyglotLanguage accessingLanguage) {
        PolyglotLanguageContext context = this.getContext(language);
        context.ensureInitialized(accessingLanguage);
        return context;
    }

    void notifyContextCreated() {
        VMAccessor.INSTRUMENT.notifyContextCreated(this.engine, this.truffleContext);
    }

    private synchronized void addChildContext(PolyglotContextImpl child) {
        if (this.closingThread != null) {
            throw new IllegalStateException("Adding child context into a closing context.");
        }
        this.childContexts.add(child);
    }

    static PolyglotContextImpl current() {
        if (singleContextState.singleContextAssumption.isValid()) {
            if (singleContextState.contextThreadLocal.isSet()) {
                return singleContextState.singleContext;
            }
            CompilerDirectives.transferToInterpreter();
            return null;
        }
        return (PolyglotContextImpl)singleContextState.contextThreadLocal.get();
    }

    static PolyglotContextImpl requireContext() {
        PolyglotContextImpl context = PolyglotContextImpl.current();
        if (context == null) {
            CompilerDirectives.transferToInterpreter();
            context = PolyglotContextImpl.current();
            if (context == null) {
                throw new AssertionError((Object)"No current context available.");
            }
        }
        return context;
    }

    public synchronized void explicitEnter(Context sourceContext) {
        this.checkCreatorAccess(sourceContext, "entered");
        Object prev = this.enter();
        PolyglotThreadInfo current = this.getCurrentThreadInfo();
        assert (current.thread == Thread.currentThread());
        current.explicitContextStack.addLast(prev);
    }

    public synchronized void explicitLeave(Context sourceContext) {
        this.checkCreatorAccess(sourceContext, "left");
        PolyglotThreadInfo current = this.getCurrentThreadInfo();
        LinkedList<Object> stack = current.explicitContextStack;
        if (stack.isEmpty() || current.thread == null) {
            throw new IllegalStateException("The context is not entered explicity. A context can only be left if it was previously entered.");
        }
        this.leave(stack.removeLast());
    }

    private void checkCreatorAccess(Context context, String operation) {
        if (context != this.creatorApi) {
            throw new IllegalStateException(String.format("Context instances that were received using Context.get() cannot be %s.", operation));
        }
    }

    boolean needsEnter() {
        if (singleContextState.singleContextAssumption.isValid()) {
            return !singleContextState.contextThreadLocal.isSet();
        }
        return PolyglotContextImpl.current() != this;
    }

    PolyglotThreadInfo getCachedThreadInfo() {
        return this.singleThreadedConstant.isValid() ? this.constantCurrentThreadInfo : this.currentThreadInfo;
    }

    Object enterIfNeeded() {
        if (this.needsEnter()) {
            return this.enter();
        }
        return NO_ENTER;
    }

    void leaveIfNeeded(Object prev) {
        if (prev != NO_ENTER) {
            this.leave(prev);
        }
    }

    Object enter() {
        Object context;
        PolyglotThreadInfo info = this.getCachedThreadInfo();
        if (CompilerDirectives.injectBranchProbability(0.75, info.thread == (TruffleOptions.AOT ? ContextThreadLocal.currentThread() : Thread.currentThread()))) {
            context = singleContextState.contextThreadLocal.setReturnParent(this);
            info.enter();
        } else {
            if (this.singleThreaded.isValid()) {
                CompilerDirectives.transferToInterpreter();
            }
            context = this.enterThreadChanged();
        }
        assert (this == PolyglotContextImpl.current());
        return context;
    }

    void leave(Object prev) {
        assert (PolyglotContextImpl.current() == this) : "Cannot leave context that is currently not entered. Forgot to enter or leave a context?";
        PolyglotThreadInfo info = this.getCachedThreadInfo();
        if (CompilerDirectives.injectBranchProbability(0.75, info.thread == (TruffleOptions.AOT ? ContextThreadLocal.currentThread() : Thread.currentThread()))) {
            info.leave();
        } else {
            if (this.singleThreaded.isValid()) {
                CompilerDirectives.transferToInterpreter();
            }
            this.leaveThreadChanged();
        }
        singleContextState.contextThreadLocal.set(prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    PolyglotContextImpl enterThreadChanged() {
        PolyglotContextImpl prev;
        Thread current = Thread.currentThread();
        boolean needsInitialization = false;
        PolyglotContextImpl polyglotContextImpl = this;
        synchronized (polyglotContextImpl) {
            boolean transitionToMultiThreading;
            this.engine.checkState();
            this.checkClosed();
            PolyglotThreadInfo threadInfo = this.getCurrentThreadInfo();
            assert (threadInfo != null);
            threadInfo = this.threads.get(current);
            if (threadInfo == null) {
                threadInfo = this.createThreadInfo(current);
                needsInitialization = !this.inContextPreInitialization;
            }
            boolean bl = transitionToMultiThreading = this.singleThreaded.isValid() && this.hasActiveOtherThread(true);
            if (transitionToMultiThreading) {
                this.checkAllThreadAccesses();
            }
            Thread closing = this.closingThread;
            if (needsInitialization) {
                if (closing != null && closing != current) {
                    throw new PolyglotIllegalStateException("Can not create new threads in closing context.");
                }
                this.threads.put(current, threadInfo);
            }
            prev = (PolyglotContextImpl)singleContextState.contextThreadLocal.setReturnParent(this);
            threadInfo.enter();
            if (transitionToMultiThreading) {
                this.transitionToMultiThreaded();
            }
            if (needsInitialization) {
                this.initializeNewThread(current);
            }
            if (!this.closed && closing == null) {
                this.setCachedThreadInfo(threadInfo);
            }
        }
        if (needsInitialization) {
            VMAccessor.INSTRUMENT.notifyThreadStarted(this.engine, this.truffleContext, current);
        }
        return prev;
    }

    private void setCachedThreadInfo(PolyglotThreadInfo info) {
        assert (Thread.holdsLock(this));
        if (this.constantCurrentThreadInfo != info) {
            if (this.constantCurrentThreadInfo.thread == null) {
                this.constantCurrentThreadInfo = info;
            } else {
                this.constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
                if (info != PolyglotThreadInfo.NULL) {
                    this.singleThreadedConstant.invalidate();
                }
            }
        }
        this.currentThreadInfo = info;
    }

    private void checkAllThreadAccesses() {
        assert (Thread.holdsLock(this));
        Thread current = Thread.currentThread();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            boolean accessAllowed = true;
            if (!VMAccessor.LANGUAGE.isThreadAccessAllowed(context.env, current, false)) {
                accessAllowed = false;
            }
            if (accessAllowed) {
                for (PolyglotThreadInfo seenThread : this.threads.values()) {
                    if (VMAccessor.LANGUAGE.isThreadAccessAllowed(context.env, seenThread.thread, false)) continue;
                    accessAllowed = false;
                    break;
                }
            }
            if (accessAllowed) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, false, deniedLanguages);
        }
    }

    @CompilerDirectives.TruffleBoundary
    synchronized PolyglotThreadInfo leaveThreadChanged() {
        Thread current = Thread.currentThread();
        this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
        PolyglotThreadInfo threadInfo = this.threads.get(current);
        assert (threadInfo != null);
        PolyglotThreadInfo info = threadInfo;
        if (this.cancelling && info.isLastActive()) {
            this.notifyThreadClosed();
        }
        info.leave();
        if (!this.closed && !this.cancelling) {
            this.setCachedThreadInfo(threadInfo);
        }
        return info;
    }

    private void initializeNewThread(Thread thread) {
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            VMAccessor.LANGUAGE.initializeThread(context.env, thread);
        }
    }

    private void transitionToMultiThreaded() {
        assert (this.singleThreaded.isValid());
        assert (Thread.holdsLock(this));
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized()) continue;
            VMAccessor.LANGUAGE.initializeMultiThreading(context.env);
        }
        this.singleThreaded.invalidate();
        this.singleThreadedConstant.invalidate();
    }

    private PolyglotThreadInfo createThreadInfo(Thread current) {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo threadInfo = new PolyglotThreadInfo(current);
        boolean singleThread = this.isSingleThreaded();
        ArrayList<PolyglotLanguage> deniedLanguages = null;
        for (PolyglotLanguageContext context : this.contexts) {
            if (!context.isInitialized() || VMAccessor.LANGUAGE.isThreadAccessAllowed(context.env, current, singleThread)) continue;
            if (deniedLanguages == null) {
                deniedLanguages = new ArrayList<PolyglotLanguage>();
            }
            deniedLanguages.add(context.language);
        }
        if (deniedLanguages != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(current, singleThread, deniedLanguages);
        }
        return threadInfo;
    }

    static RuntimeException throwDeniedThreadAccess(Thread current, boolean accessSingleThreaded, List<PolyglotLanguage> deniedLanguages) {
        StringBuilder languagesString = new StringBuilder("");
        for (PolyglotLanguage language : deniedLanguages) {
            if (languagesString.length() != 0) {
                languagesString.append(", ");
            }
            languagesString.append(language.getId());
        }
        String message = accessSingleThreaded ? String.format("Single threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString) : String.format("Multi threaded access requested by thread %s but is not allowed for language(s) %s.", current, languagesString);
        throw new PolyglotIllegalStateException(message);
    }

    Value findLegacyExportedSymbol(String symbolName) {
        Value legacySymbol = this.findLegacyExportedSymbol(symbolName, true);
        if (legacySymbol != null) {
            return legacySymbol;
        }
        return this.findLegacyExportedSymbol(symbolName, false);
    }

    private Value findLegacyExportedSymbol(String name, boolean onlyExplicit) {
        for (PolyglotLanguageContext languageContext : this.contexts) {
            Object s;
            if (!languageContext.isInitialized() || (s = VMAccessor.LANGUAGE.findExportedSymbol(languageContext.env, name, onlyExplicit)) == null) continue;
            return languageContext.asValue(s);
        }
        return null;
    }

    public Value getBindings(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        if (!languageContext.isInitialized()) {
            Object prev = this.enterIfNeeded();
            try {
                languageContext.ensureInitialized(null);
            }
            catch (Throwable e) {
                throw PolyglotImpl.wrapGuestException(languageContext, e);
            }
            finally {
                this.leaveIfNeeded(prev);
            }
        }
        return languageContext.getHostBindings();
    }

    public Value getPolyglotBindings() {
        this.checkClosed();
        return this.polyglotHostBindings;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new PolyglotIllegalStateException("The Context is already closed.");
        }
    }

    PolyglotLanguageContext getHostContext() {
        return this.contexts[0];
    }

    HostLanguage.HostContext getHostContextImpl() {
        return (HostLanguage.HostContext)this.getHostContext().getContextImpl();
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    PolyglotLanguageContext getLanguageContext(Class<? extends TruffleLanguage<?>> languageClass) {
        if (CompilerDirectives.isPartialEvaluationConstant(this)) {
            return this.getLanguageContextImpl(languageClass);
        }
        return this.getLanguageContextBoundary(languageClass);
    }

    @CompilerDirectives.TruffleBoundary
    private PolyglotLanguageContext getLanguageContextBoundary(Class<? extends TruffleLanguage<?>> languageClass) {
        return this.getLanguageContextImpl(languageClass);
    }

    PolyglotLanguageContext findLanguageContext(Class<? extends TruffleLanguage> languageClazz, boolean failIfNotFound) {
        for (PolyglotLanguageContext lang : this.contexts) {
            if (!lang.isInitialized()) continue;
            TruffleLanguage<?> language = VMAccessor.LANGUAGE.getLanguage(lang.env);
            if (languageClazz == TruffleLanguage.class || !languageClazz.isInstance(language)) continue;
            return lang;
        }
        if (failIfNotFound) {
            HashSet<String> languageNames = new HashSet<String>();
            for (PolyglotLanguageContext lang : this.contexts) {
                if (!lang.isInitialized()) continue;
                languageNames.add(lang.language.cache.getClassName());
            }
            throw new IllegalStateException("Cannot find language " + languageClazz + " among " + languageNames);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageContext getLanguageContextImpl(Class<? extends TruffleLanguage<?>> languageClass) {
        int indexValue;
        FinalIntMap map = this.languageIndexMap;
        int n = indexValue = map != null ? map.get(languageClass) : -1;
        if (indexValue == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            PolyglotContextImpl polyglotContextImpl = this;
            synchronized (polyglotContextImpl) {
                if (this.languageIndexMap == null) {
                    this.languageIndexMap = new FinalIntMap();
                }
                if ((indexValue = this.languageIndexMap.get(languageClass)) == -1) {
                    PolyglotLanguageContext context = this.findLanguageContext(languageClass, true);
                    indexValue = context.language.index;
                    this.languageIndexMap.put(languageClass, indexValue);
                }
            }
        }
        PolyglotLanguageContext context = this.contexts[indexValue];
        return context;
    }

    public boolean initializeLanguage(String languageId) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        PolyglotLanguageContext languageContext = this.getContext(language);
        languageContext.checkAccess(null);
        if (!languageContext.isInitialized()) {
            Object prev = this.enterIfNeeded();
            try {
                boolean bl = languageContext.ensureInitialized(null);
                return bl;
            }
            catch (Throwable t) {
                throw PolyglotImpl.wrapGuestException(languageContext, t);
            }
            finally {
                this.leaveIfNeeded(prev);
            }
        }
        return false;
    }

    public Value eval(String languageId, Object sourceImpl) {
        PolyglotLanguage language = this.requirePublicLanguage(languageId);
        Object prev = this.enterIfNeeded();
        PolyglotLanguageContext languageContext = this.getContext(language);
        try {
            Value hostValue;
            languageContext.checkAccess(null);
            languageContext.ensureInitialized(null);
            Source source = (Source)sourceImpl;
            CallTarget target = languageContext.parseCached(null, source, null);
            Object result = target.call(PolyglotImpl.EMPTY_ARGS);
            try {
                hostValue = languageContext.asValue(result);
            }
            catch (ClassCastException | NullPointerException e) {
                throw new AssertionError(String.format("Language %s returned an invalid return value %s. Must be an interop value.", languageId, result), e);
            }
            if (source.isInteractive()) {
                PolyglotContextImpl.printResult(languageContext, result);
            }
            Value value = hostValue;
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.wrapGuestException(languageContext, e);
        }
        finally {
            this.leaveIfNeeded(prev);
        }
    }

    private PolyglotLanguage requirePublicLanguage(String languageId) {
        PolyglotLanguage language = this.engine.idToLanguage.get(languageId);
        if (language == null || language.cache.isInternal()) {
            this.engine.requirePublicLanguage(languageId);
            assert (false);
            return null;
        }
        return language;
    }

    @CompilerDirectives.TruffleBoundary
    private static void printResult(PolyglotLanguageContext languageContext, Object result) {
        String stringResult = VMAccessor.LANGUAGE.toStringIfVisible(languageContext.env, result, true);
        if (stringResult != null) {
            try {
                OutputStream out = languageContext.context.config.out;
                out.write(stringResult.getBytes(StandardCharsets.UTF_8));
                out.write(System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ioex) {
                throw new IllegalStateException(ioex);
            }
        }
    }

    public Engine getEngineImpl(Context sourceContext) {
        return sourceContext == this.creatorApi ? this.engine.creatorApi : this.engine.currentApi;
    }

    public void close(Context sourceContext, boolean cancelIfExecuting) {
        this.checkCreatorAccess(sourceContext, "closed");
        boolean closeCompleted = this.closeImpl(cancelIfExecuting, cancelIfExecuting);
        if (cancelIfExecuting) {
            this.engine.getCancelHandler().waitForClosing(this);
        } else if (!closeCompleted) {
            throw new PolyglotIllegalStateException(String.format("The context is currently executing on another thread. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
        }
        if (this.engine.boundEngine && this.parent == null) {
            try {
                this.engine.ensureClosed(cancelIfExecuting, false);
            }
            catch (Throwable t) {
                throw PolyglotImpl.wrapGuestException(this.engine, t);
            }
        }
    }

    public Value asValue(Object hostValue) {
        if (hostValue instanceof Value) {
            return (Value)hostValue;
        }
        PolyglotLanguageContext context = null;
        TruffleObject guestValue = null;
        if (hostValue instanceof PolyglotList) {
            context = ((PolyglotList)hostValue).languageContext;
            guestValue = ((PolyglotList)hostValue).guestObject;
        } else if (hostValue instanceof PolyglotMap) {
            context = ((PolyglotMap)hostValue).languageContext;
            guestValue = ((PolyglotMap)hostValue).guestObject;
        } else if (hostValue instanceof PolyglotFunction) {
            context = ((PolyglotFunction)hostValue).languageContext;
            guestValue = ((PolyglotFunction)hostValue).guestObject;
        }
        if (context == null) {
            context = this.getHostContext();
            return context.asValue(context.toGuestValue(hostValue));
        }
        return context.asValue(guestValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForClose() {
        while (!this.closeImpl(false, true)) {
            try {
                PolyglotContextImpl polyglotContextImpl = this;
                synchronized (polyglotContextImpl) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    boolean isSingleThreaded() {
        return this.singleThreaded.isValid();
    }

    Map<Thread, PolyglotThreadInfo> getSeenThreads() {
        assert (Thread.holdsLock(this));
        return this.threads;
    }

    synchronized boolean isActive() {
        for (PolyglotThreadInfo seenTinfo : this.threads.values()) {
            if (!seenTinfo.isActive()) continue;
            return true;
        }
        return false;
    }

    PolyglotThreadInfo getFirstActiveOtherThread(boolean includePolyglotThread) {
        assert (Thread.holdsLock(this));
        for (PolyglotThreadInfo otherInfo : this.threads.values()) {
            if (!includePolyglotThread && otherInfo.isPolyglotThread(this) || otherInfo.isCurrent() || !otherInfo.isActive()) continue;
            return otherInfo;
        }
        return null;
    }

    boolean hasActiveOtherThread(boolean includePolyglotThreads) {
        return this.getFirstActiveOtherThread(includePolyglotThreads) != null;
    }

    synchronized void notifyThreadClosed() {
        PolyglotThreadInfo currentTInfo = this.getCurrentThreadInfo();
        if (currentTInfo != PolyglotThreadInfo.NULL) {
            currentTInfo.cancelled = true;
            Thread.interrupted();
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    boolean closeImpl(boolean cancelIfExecuting, boolean waitForPolyglotThreads) {
        Thread[] remainingThreads;
        boolean success;
        block53: {
            success = false;
            remainingThreads = null;
            PolyglotContextImpl[] childrenToClose = null;
            try {
                block55: {
                    block56: {
                        PolyglotContextImpl polyglotContextImpl;
                        PolyglotThreadInfo threadInfo;
                        block57: {
                            PolyglotContextImpl polyglotContextImpl2 = this;
                            synchronized (polyglotContextImpl2) {
                                block52: {
                                    if (this.closed) break block57;
                                    threadInfo = this.getCurrentThreadInfo();
                                    this.setCachedThreadInfo(PolyglotThreadInfo.NULL);
                                    if (!threadInfo.explicitContextStack.isEmpty()) {
                                        throw new IllegalStateException("The context is explicitely entered on the current thread. Call leave() before closing the context to resolve this.");
                                    }
                                    childrenToClose = this.childContexts.toArray(new PolyglotContextImpl[this.childContexts.size()]);
                                    if (cancelIfExecuting) {
                                        this.cancelling = true;
                                        if (threadInfo != PolyglotThreadInfo.NULL) {
                                            threadInfo.cancelled = true;
                                            Thread.interrupted();
                                        }
                                    }
                                    if (!this.hasActiveOtherThread(waitForPolyglotThreads)) break block52;
                                    boolean bl = false;
                                    return bl;
                                }
                                this.closingThread = Thread.currentThread();
                            }
                        }
                        if (childrenToClose == null) break block53;
                        Object prev = this.enter();
                        try {
                            boolean finalizationPerformed;
                            void var9_18;
                            threadInfo = childrenToClose;
                            int n = ((PolyglotThreadInfo)threadInfo).length;
                            boolean bl = false;
                            while (var9_18 < n) {
                                PolyglotThreadInfo polyglotThreadInfo = threadInfo[var9_18];
                                ((PolyglotContextImpl)((Object)polyglotThreadInfo)).closeImpl(cancelIfExecuting, waitForPolyglotThreads);
                                ++var9_18;
                            }
                            do {
                                finalizationPerformed = false;
                                for (int i = this.contexts.length - 1; i >= 0; --i) {
                                    PolyglotLanguageContext polyglotLanguageContext = this.contexts[i];
                                    if (!polyglotLanguageContext.isInitialized()) continue;
                                    try {
                                        finalizationPerformed |= polyglotLanguageContext.finalizeContext();
                                        continue;
                                    }
                                    catch (Error | Exception throwable) {
                                        throw PolyglotImpl.wrapGuestException(polyglotLanguageContext, throwable);
                                    }
                                }
                            } while (finalizationPerformed);
                            this.closed = true;
                            ArrayList<PolyglotLanguageContext> disposedContexts = new ArrayList<PolyglotLanguageContext>(this.contexts.length);
                            try {
                                PolyglotContextImpl polyglotContextImpl2 = this;
                                synchronized (polyglotContextImpl2) {
                                    void var10_27;
                                    int n2 = this.contexts.length - 1;
                                    while (var10_27 >= 0) {
                                        PolyglotLanguageContext context2 = this.contexts[var10_27];
                                        try {
                                            boolean disposed = context2.dispose();
                                            if (disposed) {
                                                disposedContexts.add(context2);
                                            }
                                        }
                                        catch (Error | Exception ex) {
                                            throw PolyglotImpl.wrapGuestException(context2, ex);
                                        }
                                        --var10_27;
                                    }
                                }
                            }
                            finally {
                                for (PolyglotLanguageContext polyglotLanguageContext : disposedContexts) {
                                    polyglotLanguageContext.notifyDisposed();
                                }
                            }
                            assert (this.childContexts.isEmpty());
                            success = true;
                            this.leave(prev);
                            if (!success) break block55;
                            if (this.parent == null) break block56;
                            polyglotContextImpl = this.parent;
                        }
                        catch (Throwable throwable) {
                            this.leave(prev);
                            if (success) {
                                PolyglotContextImpl polyglotContextImpl3;
                                if (this.parent != null) {
                                    polyglotContextImpl3 = this.parent;
                                    synchronized (polyglotContextImpl3) {
                                        this.parent.childContexts.remove(this);
                                    }
                                } else {
                                    this.engine.removeContext(this);
                                }
                                polyglotContextImpl3 = this;
                                synchronized (polyglotContextImpl3) {
                                    remainingThreads = this.threads.keySet().toArray(new Thread[0]);
                                }
                            }
                            this.closed = success;
                            if (success && this.engine.boundEngine) {
                                PolyglotContextImpl.disposeStaticContext(this);
                            }
                            this.cancelling = false;
                            throw throwable;
                        }
                        synchronized (polyglotContextImpl) {
                            this.parent.childContexts.remove(this);
                        }
                    }
                    this.engine.removeContext(this);
                    PolyglotContextImpl polyglotContextImpl = this;
                    synchronized (polyglotContextImpl) {
                        remainingThreads = this.threads.keySet().toArray(new Thread[0]);
                    }
                }
                this.closed = success;
                if (success && this.engine.boundEngine) {
                    PolyglotContextImpl.disposeStaticContext(this);
                }
                this.cancelling = false;
            }
            finally {
                this.closingThread = null;
            }
        }
        if (success) {
            for (PolyglotContextImpl polyglotContextImpl : remainingThreads) {
                VMAccessor.INSTRUMENT.notifyThreadFinished(this.engine, this.truffleContext, (Thread)((Object)polyglotContextImpl));
            }
            VMAccessor.INSTRUMENT.notifyContextClosed(this.engine, this.truffleContext);
            if (this.parent == null) {
                if (!this.config.logLevels.isEmpty()) {
                    VMAccessor.LANGUAGE.configureLoggers(this, null);
                }
                if (this.config.logHandler != null) {
                    this.config.logHandler.close();
                }
            }
        }
        return true;
    }

    synchronized void sendInterrupt() {
        if (!this.cancelling) {
            return;
        }
        for (PolyglotThreadInfo threadInfo : this.threads.values()) {
            if (threadInfo.isCurrent() || !threadInfo.isActive()) continue;
            threadInfo.thread.interrupt();
        }
    }

    PolyglotThreadInfo getCurrentThreadInfo() {
        assert (Thread.holdsLock(this));
        PolyglotThreadInfo currentTInfo = this.currentThreadInfo;
        if (currentTInfo.thread != Thread.currentThread() && (currentTInfo = this.threads.get(Thread.currentThread())) == null) {
            currentTInfo = PolyglotThreadInfo.NULL;
        }
        assert (currentTInfo.thread == null || currentTInfo.thread == Thread.currentThread());
        return currentTInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean patch(PolyglotContextConfig newConfig) {
        CompilerAsserts.neverPartOfCompilation();
        this.config = newConfig;
        PolyglotContextImpl.initializeStaticContext(this);
        if (!newConfig.logLevels.isEmpty()) {
            VMAccessor.LANGUAGE.configureLoggers(this, newConfig.logLevels);
        }
        Object prev = this.enter();
        try {
            for (int i = 1; i < this.contexts.length; ++i) {
                PolyglotLanguageContext context = this.contexts[i];
                if (context.patch(newConfig)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.leave(prev);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PolyglotContextImpl preInitialize(PolyglotEngineImpl engine) {
        FileSystems.PreInitializeContextFileSystem fs = new FileSystems.PreInitializeContextFileSystem();
        PolyglotContextConfig config = new PolyglotContextConfig(engine, engine.out, engine.err, engine.in, false, false, false, false, null, Collections.emptyMap(), engine.getLanguages().keySet(), Collections.emptyMap(), fs, engine.logHandler);
        PolyglotContextImpl context = new PolyglotContextImpl(engine, config);
        String optionValue = engine.engineOptionValues.get(PolyglotEngineOptions.PreinitializeContexts);
        if (optionValue != null && !optionValue.isEmpty()) {
            HashSet languagesToPreinitialize = new HashSet();
            Collections.addAll(languagesToPreinitialize, optionValue.split(","));
            context.inContextPreInitialization = true;
            try {
                Object prev = context.enter();
                try {
                    for (String languageId : engine.getLanguages().keySet()) {
                        PolyglotLanguage language;
                        if (languagesToPreinitialize.contains(languageId) && (language = engine.findLanguage(languageId, null, false)) != null) {
                            PolyglotLanguageContext languageContext = context.getContextInitialized(language, null);
                            languageContext.preInitialize();
                        }
                        language = engine.idToLanguage.get(languageId);
                        language.clearOptionValues();
                    }
                }
                finally {
                    context.leave(prev);
                }
            }
            finally {
                context.inContextPreInitialization = false;
                fs.patchDelegate(FileSystems.newNoIOFileSystem(null));
                if (!config.logLevels.isEmpty()) {
                    VMAccessor.LANGUAGE.configureLoggers(context, null);
                }
            }
        }
        context.currentThreadInfo = PolyglotThreadInfo.NULL;
        context.constantCurrentThreadInfo = PolyglotThreadInfo.NULL;
        PolyglotContextImpl.disposeStaticContext(context);
        return context;
    }

    static final class SingleContextState {
        private final ContextThreadLocal contextThreadLocal = new ContextThreadLocal();
        private final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("Single Context");
        @CompilerDirectives.CompilationFinal
        private volatile PolyglotContextImpl singleContext;

        SingleContextState() {
        }
    }
}

