/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventListener;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.SourceSectionFilter;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptionsOptionDescriptors;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotIllegalStateException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLogHandler;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;

class PolyglotEngineImpl
extends AbstractPolyglotImpl.AbstractEngineImpl
implements PolyglotImpl.VMObject {
    static final int HOST_LANGUAGE_INDEX = 0;
    static final String HOST_LANGUAGE_ID = "host";
    private static final Set<String> RESERVED_IDS = new HashSet<String>(Arrays.asList("host", "graal", "truffle", "engine", "language", "instrument", "graalvm", "context", "polyglot", "compiler", "vm", "log"));
    private static final Map<PolyglotEngineImpl, Void> ENGINES = Collections.synchronizedMap(new WeakHashMap());
    private static volatile boolean shutdownHookInitialized = false;
    private static final boolean DEBUG_MISSING_CLOSE = Boolean.getBoolean("polyglotimpl.DebugMissingClose");
    Engine creatorApi;
    Engine currentApi;
    final Object instrumentationHandler;
    final PolyglotImpl impl;
    DispatchOutputStream out;
    DispatchOutputStream err;
    InputStream in;
    final Map<String, PolyglotLanguage> idToLanguage;
    final Map<String, Language> idToPublicLanguage;
    final Map<String, LanguageInfo> idToInternalLanguageInfo;
    final Map<String, PolyglotInstrument> idToInstrument;
    final Map<String, Instrument> idToPublicInstrument;
    final Map<String, InstrumentInfo> idToInternalInstrumentInfo;
    final OptionDescriptors engineOptions;
    final OptionDescriptors compilerOptions;
    final OptionDescriptors allEngineOptions;
    final OptionValuesImpl engineOptionValues;
    final OptionValuesImpl compilerOptionValues;
    ClassLoader contextClassLoader;
    boolean boundEngine;
    Handler logHandler;
    final Exception createdLocation = DEBUG_MISSING_CLOSE ? new Exception() : null;
    private final Set<PolyglotContextImpl> contexts = new LinkedHashSet<PolyglotContextImpl>();
    private PolyglotContextImpl preInitializedContext;
    PolyglotLanguage hostLanguage;
    final Assumption singleContext = Truffle.getRuntime().createAssumption();
    volatile OptionDescriptors allOptions;
    volatile boolean closed;
    private volatile CancelHandler cancelHandler;
    volatile Object runtimeData;
    final Map<Object, Object> javaInteropCodeCache = new ConcurrentHashMap<Object, Object>();
    Map<String, Level> logLevels;

    PolyglotEngineImpl(PolyglotImpl impl, DispatchOutputStream out, DispatchOutputStream err, InputStream in, Map<String, String> options, boolean useSystemProperties, ClassLoader contextClassLoader, boolean boundEngine, Handler logHandler) {
        this(impl, out, err, in, options, useSystemProperties, contextClassLoader, boundEngine, false, logHandler);
    }

    private PolyglotEngineImpl(PolyglotImpl impl, DispatchOutputStream out, DispatchOutputStream err, InputStream in, Map<String, String> options, boolean useSystemProperties, ClassLoader contextClassLoader, boolean boundEngine, boolean preInitialization, Handler logHandler) {
        super((AbstractPolyglotImpl)impl);
        this.instrumentationHandler = VMAccessor.INSTRUMENT.createInstrumentationHandler(this, out, err, in);
        this.impl = impl;
        this.out = out;
        this.err = err;
        this.in = in;
        this.contextClassLoader = contextClassLoader;
        this.boundEngine = boundEngine;
        this.logHandler = logHandler;
        LinkedHashMap<String, LanguageInfo> languageInfos = new LinkedHashMap<String, LanguageInfo>();
        this.idToLanguage = Collections.unmodifiableMap(this.initializeLanguages(languageInfos));
        this.idToInternalLanguageInfo = Collections.unmodifiableMap(languageInfos);
        LinkedHashMap<String, InstrumentInfo> instrumentInfos = new LinkedHashMap<String, InstrumentInfo>();
        this.idToInstrument = Collections.unmodifiableMap(this.initializeInstruments(instrumentInfos));
        this.idToInternalInstrumentInfo = Collections.unmodifiableMap(instrumentInfos);
        for (String string : this.idToLanguage.keySet()) {
            if (!this.idToInstrument.containsKey(string)) continue;
            throw PolyglotEngineImpl.failDuplicateId(string, this.idToLanguage.get((Object)string).cache.getClassName(), this.idToInstrument.get((Object)string).cache.getClassName());
        }
        this.engineOptions = new PolyglotEngineOptionsOptionDescriptors();
        this.compilerOptions = VMAccessor.SPI.getCompilerOptions();
        this.allEngineOptions = OptionDescriptors.createUnion((OptionDescriptors[])new OptionDescriptors[]{this.engineOptions, this.compilerOptions});
        this.engineOptionValues = new OptionValuesImpl(this, this.engineOptions);
        this.compilerOptionValues = new OptionValuesImpl(this, this.compilerOptions);
        LinkedHashMap<String, Language> publicLanguages = new LinkedHashMap<String, Language>();
        for (String string : this.idToLanguage.keySet()) {
            PolyglotLanguage languageImpl = this.idToLanguage.get(string);
            if (languageImpl.cache.isInternal()) continue;
            publicLanguages.put(string, languageImpl.api);
        }
        this.idToPublicLanguage = Collections.unmodifiableMap(publicLanguages);
        LinkedHashMap<String, Instrument> linkedHashMap = new LinkedHashMap<String, Instrument>();
        for (String key : this.idToInstrument.keySet()) {
            PolyglotInstrument instrumentImpl = this.idToInstrument.get(key);
            if (instrumentImpl.cache.isInternal()) continue;
            linkedHashMap.put(key, instrumentImpl.api);
        }
        this.idToPublicInstrument = Collections.unmodifiableMap(linkedHashMap);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> originalCompilerOptions = new HashMap<String, String>();
        this.logLevels = new HashMap<String, Level>();
        HashMap<PolyglotLanguage, Map<String, String>> languagesOptions = new HashMap<PolyglotLanguage, Map<String, String>>();
        HashMap<PolyglotInstrument, Map<String, String>> instrumentsOptions = new HashMap<PolyglotInstrument, Map<String, String>>();
        this.parseOptions(options, useSystemProperties, hashMap, originalCompilerOptions, languagesOptions, instrumentsOptions, this.logLevels, preInitialization);
        this.engineOptionValues.putAll(hashMap);
        this.compilerOptionValues.putAll(originalCompilerOptions);
        for (PolyglotLanguage language : languagesOptions.keySet()) {
            language.getOptionValues().putAll((Map)languagesOptions.get(language));
        }
        if (!boundEngine) {
            this.initializeMultiContext(null);
        }
        ENGINES.put(this, null);
        if (!preInitialization) {
            this.createInstruments(instrumentsOptions);
            PolyglotEngineImpl.registerShutDownHook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Collection<Engine> findActiveEngines() {
        Map<PolyglotEngineImpl, Void> map = ENGINES;
        synchronized (map) {
            ArrayList<Engine> engines = new ArrayList<Engine>(ENGINES.size());
            for (PolyglotEngineImpl engine : ENGINES.keySet()) {
                engines.add(engine.creatorApi);
            }
            return engines;
        }
    }

    boolean patch(DispatchOutputStream newOut, DispatchOutputStream newErr, InputStream newIn, Map<String, String> newOptions, boolean newUseSystemProperties, ClassLoader newContextClassLoader, boolean newBoundEngine, Handler newLogHandler) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.boundEngine != newBoundEngine) {
            return false;
        }
        this.out = newOut;
        this.err = newErr;
        this.in = newIn;
        this.contextClassLoader = newContextClassLoader;
        this.boundEngine = newBoundEngine;
        this.logHandler = newLogHandler;
        VMAccessor.INSTRUMENT.patchInstrumentationHandler(this.instrumentationHandler, newOut, newErr, newIn);
        HashMap<String, String> originalEngineOptions = new HashMap<String, String>();
        HashMap<String, String> originalCompilerOptions = new HashMap<String, String>();
        HashMap<PolyglotLanguage, Map<String, String>> languagesOptions = new HashMap<PolyglotLanguage, Map<String, String>>();
        HashMap<PolyglotInstrument, Map<String, String>> instrumentsOptions = new HashMap<PolyglotInstrument, Map<String, String>>();
        assert (this.logLevels.isEmpty());
        this.parseOptions(newOptions, newUseSystemProperties, originalEngineOptions, originalCompilerOptions, languagesOptions, instrumentsOptions, this.logLevels, false);
        this.engineOptionValues.putAll(originalEngineOptions);
        this.compilerOptionValues.putAll(originalCompilerOptions);
        for (PolyglotLanguage language : languagesOptions.keySet()) {
            language.getOptionValues().putAll((Map)languagesOptions.get(language));
        }
        this.createInstruments(instrumentsOptions);
        PolyglotEngineImpl.registerShutDownHook();
        return true;
    }

    private void createInstruments(Map<PolyglotInstrument, Map<String, String>> instrumentsOptions) {
        for (PolyglotInstrument instrument : instrumentsOptions.keySet()) {
            instrument.getOptionValues().putAll(instrumentsOptions.get(instrument));
        }
        try {
            for (PolyglotInstrument instrument : instrumentsOptions.keySet()) {
                instrument.ensureCreated();
            }
        }
        catch (Throwable e) {
            throw PolyglotImpl.wrapGuestException(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerShutDownHook() {
        if (!shutdownHookInitialized) {
            Map<PolyglotEngineImpl, Void> map = ENGINES;
            synchronized (map) {
                if (!shutdownHookInitialized) {
                    shutdownHookInitialized = true;
                    Runtime.getRuntime().addShutdownHook(new Thread(new PolyglotShutDownHook()));
                }
            }
        }
    }

    synchronized void initializeMultiContext(PolyglotContextImpl existingContext) {
        if (this.singleContext.isValid()) {
            this.singleContext.invalidate("More than one context introduced.");
            if (existingContext != null) {
                for (PolyglotLanguageContext context : existingContext.contexts) {
                    if (!context.isInitialized()) continue;
                    context.getLanguageInstance().initializeMultiContext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseOptions(Map<String, String> options, boolean useSystemProperties, Map<String, String> originalEngineOptions, Map<String, String> originalCompilerOptions, Map<PolyglotLanguage, Map<String, String>> languagesOptions, Map<PolyglotInstrument, Map<String, String>> instrumentsOptions, Map<String, Level> logOptions, boolean preInitialization) {
        if (useSystemProperties) {
            Properties properties;
            Properties properties2 = properties = System.getProperties();
            synchronized (properties2) {
                for (Object systemKey : properties.keySet()) {
                    String key = (String)systemKey;
                    if (!key.startsWith("polyglot.")) continue;
                    String engineKey = key.substring("polyglot.".length(), key.length());
                    String optionGroup = PolyglotEngineImpl.parseOptionGroup(engineKey);
                    if (options.containsKey(engineKey) || preInitialization && !this.idToPublicLanguage.containsKey(optionGroup) && !engineKey.equals("engine.PreinitializeContexts") && !"log".equals(optionGroup)) continue;
                    options.put(engineKey, System.getProperty(key));
                }
            }
        }
        for (String key : options.keySet()) {
            String group = PolyglotEngineImpl.parseOptionGroup(key);
            String value = options.get(key);
            PolyglotLanguage language = this.idToLanguage.get(group);
            if (language != null && !language.cache.isInternal()) {
                Map<String, String> languageOptions = languagesOptions.get(language);
                if (languageOptions == null) {
                    languageOptions = new HashMap<String, String>();
                    languagesOptions.put(language, languageOptions);
                }
                languageOptions.put(key, value);
                continue;
            }
            PolyglotInstrument instrument = this.idToInstrument.get(group);
            if (instrument != null && !instrument.cache.isInternal()) {
                Map<String, String> instrumentOptions = instrumentsOptions.get(instrument);
                if (instrumentOptions == null) {
                    instrumentOptions = new HashMap<String, String>();
                    instrumentsOptions.put(instrument, instrumentOptions);
                }
                instrumentOptions.put(key, value);
                continue;
            }
            if (group.equals("engine")) {
                originalEngineOptions.put(key, value);
                continue;
            }
            if (group.equals("compiler")) {
                originalCompilerOptions.put(key, value);
                continue;
            }
            if (group.equals("log")) {
                logOptions.put(PolyglotEngineImpl.parseLoggerName(key), Level.parse(value));
                continue;
            }
            throw OptionValuesImpl.failNotFound(this.getAllOptions(), key);
        }
    }

    boolean isEngineGroup(String group) {
        return this.idToPublicInstrument.containsKey(group) || group.equals("engine") || group.equals("compiler");
    }

    static String parseOptionGroup(String key) {
        int groupIndex = key.indexOf(46);
        String group = groupIndex != -1 ? key.substring(0, groupIndex) : key;
        return group;
    }

    static String parseLoggerName(String optionKey) {
        int end;
        String prefix = "log.";
        String suffix = ".level";
        if (!optionKey.startsWith("log.") || !optionKey.endsWith(".level")) {
            throw new IllegalArgumentException(optionKey);
        }
        int start = "log.".length();
        return start < (end = optionKey.length() - ".level".length()) ? optionKey.substring(start, end) : "";
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this;
    }

    PolyglotLanguage findLanguage(String languageId, String mimeType, boolean failIfNotFound) {
        PolyglotLanguage language;
        assert (languageId != null || mimeType != null) : Objects.toString(languageId) + ", " + Objects.toString(mimeType);
        if (languageId != null && (language = this.idToLanguage.get(languageId)) != null) {
            return language;
        }
        if (mimeType != null) {
            language = this.idToLanguage.get(mimeType);
            if (language != null) {
                return language;
            }
            for (PolyglotLanguage searchLanguage : this.idToLanguage.values()) {
                if (!searchLanguage.cache.getMimeTypes().contains(mimeType)) continue;
                return searchLanguage;
            }
        }
        if (failIfNotFound) {
            if (languageId != null) {
                LinkedHashSet<String> ids = new LinkedHashSet<String>();
                for (PolyglotLanguage language2 : this.idToLanguage.values()) {
                    ids.add(language2.cache.getId());
                }
                throw new IllegalStateException("No language for id " + languageId + " found. Supported languages are: " + ids);
            }
            LinkedHashSet<String> mimeTypes = new LinkedHashSet<String>();
            for (PolyglotLanguage language2 : this.idToLanguage.values()) {
                mimeTypes.addAll(language2.cache.getMimeTypes());
            }
            throw new IllegalStateException("No language for MIME type " + mimeType + " found. Supported languages are: " + mimeTypes);
        }
        return null;
    }

    private Map<String, PolyglotInstrument> initializeInstruments(Map<String, InstrumentInfo> infos) {
        LinkedHashMap<String, PolyglotInstrument> instruments = new LinkedHashMap<String, PolyglotInstrument>();
        List<InstrumentCache> cachedInstruments = InstrumentCache.load(VMAccessor.allLoaders());
        for (InstrumentCache instrumentCache : cachedInstruments) {
            Instrument instrument;
            PolyglotInstrument instrumentImpl = new PolyglotInstrument(this, instrumentCache);
            instrumentImpl.info = VMAccessor.LANGUAGE.createInstrument(instrumentImpl, instrumentCache.getId(), instrumentCache.getName(), instrumentCache.getVersion());
            instrumentImpl.api = instrument = this.impl.getAPIAccess().newInstrument((AbstractPolyglotImpl.AbstractInstrumentImpl)instrumentImpl);
            String id = instrumentImpl.cache.getId();
            PolyglotEngineImpl.verifyId(id, instrumentCache.getClassName());
            if (instruments.containsKey(id)) {
                throw PolyglotEngineImpl.failDuplicateId(id, instrumentImpl.cache.getClassName(), ((PolyglotInstrument)instruments.get((Object)id)).cache.getClassName());
            }
            instruments.put(id, instrumentImpl);
            infos.put(id, instrumentImpl.info);
        }
        return instruments;
    }

    private Map<String, PolyglotLanguage> initializeLanguages(Map<String, LanguageInfo> infos) {
        LinkedHashMap<String, PolyglotLanguage> polyglotLanguages = new LinkedHashMap<String, PolyglotLanguage>();
        HashMap<String, LanguageCache> cachedLanguages = new HashMap<String, LanguageCache>();
        ArrayList<LanguageCache> sortedLanguages = new ArrayList<LanguageCache>();
        for (LanguageCache lang : LanguageCache.languages().values()) {
            String id = lang.getId();
            if (cachedLanguages.containsKey(id)) continue;
            sortedLanguages.add(lang);
            cachedLanguages.put(id, lang);
        }
        Collections.sort(sortedLanguages);
        LinkedHashSet<LanguageCache> serializedLanguages = new LinkedHashSet<LanguageCache>();
        HashSet<String> languageReferences = new HashSet<String>();
        HashMap<String, RuntimeException> initErrors = new HashMap<String, RuntimeException>();
        for (LanguageCache language : sortedLanguages) {
            languageReferences.addAll(language.getDependentLanguages());
        }
        for (LanguageCache language : sortedLanguages) {
            if (!language.isInternal() || languageReferences.contains(language.getId())) continue;
            this.visitLanguage(initErrors, cachedLanguages, serializedLanguages, language);
        }
        for (LanguageCache language : sortedLanguages) {
            if (language.isInternal() || languageReferences.contains(language.getId())) continue;
            this.visitLanguage(initErrors, cachedLanguages, serializedLanguages, language);
        }
        this.hostLanguage = this.createLanguage(PolyglotEngineImpl.createHostLanguageCache(), 0, null);
        int index = 1;
        for (LanguageCache cache : serializedLanguages) {
            PolyglotLanguage languageImpl = this.createLanguage(cache, index, (RuntimeException)initErrors.get(cache.getId()));
            String id = languageImpl.cache.getId();
            PolyglotEngineImpl.verifyId(id, cache.getClassName());
            if (polyglotLanguages.containsKey(id)) {
                throw PolyglotEngineImpl.failDuplicateId(id, languageImpl.cache.getClassName(), ((PolyglotLanguage)polyglotLanguages.get((Object)id)).cache.getClassName());
            }
            polyglotLanguages.put(id, languageImpl);
            infos.put(id, languageImpl.info);
            ++index;
        }
        return polyglotLanguages;
    }

    private void visitLanguage(Map<String, RuntimeException> initErrors, Map<String, LanguageCache> cachedLanguages, LinkedHashSet<LanguageCache> serializedLanguages, LanguageCache language) {
        this.visitLanguageImpl(new HashSet<String>(), initErrors, cachedLanguages, serializedLanguages, language);
    }

    private void visitLanguageImpl(Set<String> visitedIds, Map<String, RuntimeException> initErrors, Map<String, LanguageCache> cachedLanguages, LinkedHashSet<LanguageCache> serializedLanguages, LanguageCache language) {
        Set<String> dependencies = language.getDependentLanguages();
        for (String dependency : dependencies) {
            LanguageCache dependentLanguage = cachedLanguages.get(dependency);
            if (dependentLanguage == null) continue;
            if (visitedIds.contains(dependency)) {
                initErrors.put(language.getId(), new PolyglotIllegalStateException("Illegal cyclic language dependency found:" + language.getId() + " -> " + dependency));
                continue;
            }
            visitedIds.add(dependency);
            this.visitLanguageImpl(visitedIds, initErrors, cachedLanguages, serializedLanguages, dependentLanguage);
            visitedIds.remove(dependency);
        }
        serializedLanguages.add(language);
    }

    private PolyglotLanguage createLanguage(LanguageCache cache, int index, RuntimeException initError) {
        Language language;
        PolyglotLanguage languageImpl = new PolyglotLanguage(this, cache, index, index == 0, initError);
        languageImpl.api = language = this.impl.getAPIAccess().newLanguage((AbstractPolyglotImpl.AbstractLanguageImpl)languageImpl);
        return languageImpl;
    }

    private static LanguageCache createHostLanguageCache() {
        return new LanguageCache(HOST_LANGUAGE_ID, "Host", "Host", System.getProperty("java.version"), false, false, new HostLanguage());
    }

    private static void verifyId(String id, String className) {
        if (RESERVED_IDS.contains(id)) {
            throw new IllegalStateException(String.format("The language or instrument with class '%s' uses a reserved id '%s'. Resolve this by using a not reserved id for the language or instrument. The following ids are reserved %s for internal use.", className, id, RESERVED_IDS));
        }
        if (id.contains(".")) {
            throw new IllegalStateException(String.format("The language '%s' must not contain a period in its id '%s'. Remove all periods from the id to resolve this issue. ", className, id));
        }
    }

    private static RuntimeException failDuplicateId(String duplicateId, String className1, String className2) {
        return new IllegalStateException(String.format("Duplicate id '%s' specified by language or instrument with class '%s' and '%s'. Resolve this by specifying a unique id for each language or instrument.", duplicateId, className1, className2));
    }

    final void checkState() {
        if (this.closed) {
            throw new IllegalStateException("Engine is already closed.");
        }
    }

    void addContext(PolyglotContextImpl context) {
        assert (Thread.holdsLock(this));
        this.contexts.add(context);
    }

    synchronized void removeContext(PolyglotContextImpl context) {
        this.contexts.remove(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportAllLanguageContexts(ContextsListener listener) {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        synchronized (this) {
            if (this.contexts.isEmpty()) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            PolyglotContextImpl[] allContexts = this.contexts.toArray(new PolyglotContextImpl[this.contexts.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (PolyglotContextImpl context : allContexts) {
                listener.onContextCreated(context.truffleContext);
                for (PolyglotLanguageContext lc : context.contexts) {
                    LanguageInfo language = lc.language.info;
                    if (!lc.eventsEnabled || lc.env == null) continue;
                    listener.onLanguageContextCreated(context.truffleContext, language);
                    if (!lc.isInitialized()) continue;
                    listener.onLanguageContextInitialized(context.truffleContext, language);
                    if (!lc.finalized) continue;
                    listener.onLanguageContextFinalized(context.truffleContext, language);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void reportAllContextThreads(ThreadsListener listener) {
        PolyglotContextImpl[] polyglotContextImplArray = this;
        // MONITORENTER : this
        if (this.contexts.isEmpty()) {
            // MONITOREXIT : polyglotContextImplArray
            return;
        }
        PolyglotContextImpl[] allContexts = this.contexts.toArray(new PolyglotContextImpl[this.contexts.size()]);
        // MONITOREXIT : polyglotContextImplArray
        polyglotContextImplArray = allContexts;
        int n = polyglotContextImplArray.length;
        int n2 = 0;
        while (n2 < n) {
            Thread[] context;
            Thread[] threadArray = context = polyglotContextImplArray[n2];
            // MONITORENTER : context
            Thread[] threads = context.getSeenThreads().keySet().toArray(new Thread[0]);
            // MONITOREXIT : threadArray
            for (Thread thread : threads) {
                listener.onThreadInitialized(context.truffleContext, thread);
            }
            ++n2;
        }
    }

    public Language requirePublicLanguage(String id) {
        this.checkState();
        Language language = this.idToPublicLanguage.get(id);
        if (language == null) {
            String misspelledGuess = PolyglotEngineImpl.matchSpellingError(this.idToPublicLanguage.keySet(), id);
            String didYouMean = "";
            if (misspelledGuess != null) {
                didYouMean = String.format("Did you mean '%s'? ", misspelledGuess);
            }
            throw new PolyglotIllegalArgumentException(String.format("A language with id '%s' is not installed. %sInstalled languages are: %s.", id, didYouMean, this.getLanguages().keySet()));
        }
        return language;
    }

    private static String matchSpellingError(Set<String> allIds, String enteredId) {
        String lowerCaseEnteredId = enteredId.toLowerCase();
        for (String id : allIds) {
            if (!id.toLowerCase().equals(lowerCaseEnteredId)) continue;
            return id;
        }
        return null;
    }

    public Instrument requirePublicInstrument(String id) {
        this.checkState();
        Instrument instrument = this.idToPublicInstrument.get(id);
        if (instrument == null) {
            String misspelledGuess = PolyglotEngineImpl.matchSpellingError(this.idToPublicInstrument.keySet(), id);
            String didYouMean = "";
            if (misspelledGuess != null) {
                didYouMean = String.format("Did you mean '%s'? ", misspelledGuess);
            }
            throw new PolyglotIllegalStateException(String.format("An instrument with id '%s' is not installed. %sInstalled instruments are: %s.", id, didYouMean, this.getInstruments().keySet()));
        }
        return instrument;
    }

    public void close(Engine sourceEngine, boolean cancelIfExecuting) {
        if (sourceEngine != this.creatorApi) {
            throw new IllegalStateException("Engine instances that were indirectly received using Context.get() cannot be closed.");
        }
        this.ensureClosed(cancelIfExecuting, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void ensureClosed(boolean cancelIfExecuting, boolean ignoreCloseFailure) {
        if (!this.closed) {
            block22: {
                Object object;
                block21: {
                    PolyglotContextImpl[] localContexts = this.contexts.toArray(new PolyglotContextImpl[0]);
                    if (!cancelIfExecuting && !ignoreCloseFailure) {
                        object = localContexts;
                        int n = ((PolyglotContextImpl[])object).length;
                        for (int i = 0; i < n; ++i) {
                            PolyglotContextImpl polyglotContextImpl;
                            PolyglotContextImpl polyglotContextImpl2 = polyglotContextImpl = object[i];
                            synchronized (polyglotContextImpl2) {
                                if (polyglotContextImpl.hasActiveOtherThread(false)) {
                                    throw new IllegalStateException(String.format("One of the context instances is currently executing. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
                                }
                                continue;
                            }
                        }
                    }
                    for (PolyglotContextImpl polyglotContextImpl : localContexts) {
                        try {
                            boolean closeCompleted = polyglotContextImpl.closeImpl(cancelIfExecuting, cancelIfExecuting);
                            if (closeCompleted || cancelIfExecuting || ignoreCloseFailure) continue;
                            throw new IllegalStateException(String.format("One of the context instances is currently executing. Set cancelIfExecuting to true to stop the execution on this thread.", new Object[0]));
                        }
                        catch (Throwable e) {
                            if (ignoreCloseFailure) continue;
                            throw e;
                        }
                    }
                    if (cancelIfExecuting) {
                        this.getCancelHandler().waitForClosing(localContexts);
                    }
                    if (!this.boundEngine) {
                        for (PolyglotContextImpl polyglotContextImpl : localContexts) {
                            PolyglotContextImpl.disposeStaticContext(polyglotContextImpl);
                        }
                    }
                    this.contexts.clear();
                    object = this.idToInstrument.values().iterator();
                    while (true) {
                        PolyglotInstrument instrumentImpl = (PolyglotInstrument)object.next();
                        instrumentImpl.notifyClosing();
                        continue;
                        break;
                    }
                    finally {
                        if (!object.hasNext()) break block21;
                    }
                }
                object = this.idToInstrument.values().iterator();
                while (true) {
                    PolyglotInstrument instrumentImpl = (PolyglotInstrument)object.next();
                    instrumentImpl.ensureClosed();
                    continue;
                    break;
                }
                finally {
                    if (!object.hasNext()) break block22;
                }
            }
            ENGINES.remove(this);
            this.closed = true;
        }
    }

    public Map<String, Instrument> getInstruments() {
        this.checkState();
        return this.idToPublicInstrument;
    }

    public Map<String, Language> getLanguages() {
        this.checkState();
        return this.idToPublicLanguage;
    }

    public OptionDescriptors getOptions() {
        this.checkState();
        return this.allEngineOptions;
    }

    public String getVersion() {
        String version = System.getProperty("org.graalvm.version");
        if (version == null) {
            version = System.getProperty("graalvm.version");
        }
        if (version == null) {
            return "Development Build";
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionDescriptors getAllOptions() {
        this.checkState();
        if (this.allOptions == null) {
            PolyglotEngineImpl polyglotEngineImpl = this;
            synchronized (polyglotEngineImpl) {
                if (this.allOptions == null) {
                    ArrayList<OptionDescriptors> allDescriptors = new ArrayList<OptionDescriptors>();
                    allDescriptors.add(this.engineOptions);
                    allDescriptors.add(this.compilerOptions);
                    for (PolyglotLanguage language : this.idToLanguage.values()) {
                        allDescriptors.add(language.getOptions());
                    }
                    for (PolyglotInstrument instrument : this.idToInstrument.values()) {
                        allDescriptors.add(instrument.getOptions());
                    }
                    this.allOptions = OptionDescriptors.createUnion((OptionDescriptors[])allDescriptors.toArray(new OptionDescriptors[0]));
                }
            }
        }
        return this.allOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PolyglotEngineImpl preInitialize(PolyglotImpl impl, DispatchOutputStream out, DispatchOutputStream err, InputStream in, ClassLoader contextClassLoader, Handler logHandler) {
        PolyglotEngineImpl engine;
        PolyglotEngineImpl polyglotEngineImpl = engine = new PolyglotEngineImpl(impl, out, err, in, new HashMap<String, String>(), true, contextClassLoader, true, true, logHandler);
        synchronized (polyglotEngineImpl) {
            try {
                engine.preInitializedContext = PolyglotContextImpl.preInitialize(engine);
                engine.addContext(engine.preInitializedContext);
            }
            finally {
                LanguageCache.resetNativeImageCacheLanguageHomes();
                engine.logLevels.clear();
                engine.logHandler = null;
            }
        }
        return engine;
    }

    static void resetPreInitializedEngine() {
        ENGINES.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CancelHandler getCancelHandler() {
        if (this.cancelHandler == null) {
            PolyglotEngineImpl polyglotEngineImpl = this;
            synchronized (polyglotEngineImpl) {
                if (this.cancelHandler == null) {
                    this.cancelHandler = new CancelHandler();
                }
            }
        }
        return this.cancelHandler;
    }

    public String getImplementationName() {
        return Truffle.getRuntime().getName();
    }

    public synchronized Context createContext(OutputStream configOut, OutputStream configErr, InputStream configIn, boolean allowHostAccess, boolean allowNativeAccess, boolean allowCreateThread, boolean allowHostIO, boolean allowHostClassLoading, Predicate<String> classFilter, Map<String, String> options, Map<String, String[]> arguments, String[] onlyLanguages, FileSystem fileSystem, Handler logHandler) {
        Context api;
        this.checkState();
        if (this.boundEngine && this.preInitializedContext == null && !this.contexts.isEmpty()) {
            throw new IllegalArgumentException("Automatically created engines cannot be used to create more than one context. Use Engine.newBuilder().build() to construct a new engine and pass it using Context.newBuilder().engine(engine).build().");
        }
        Set<String> allowedLanguages = onlyLanguages.length == 0 ? this.getLanguages().keySet() : new HashSet<String>(Arrays.asList(onlyLanguages));
        FileSystem fs = allowHostIO ? (fileSystem != null ? fileSystem : FileSystems.getDefaultFileSystem()) : FileSystems.newNoIOFileSystem();
        OutputStream useOut = configOut == null || configOut == VMAccessor.INSTRUMENT.getOut(this.out) ? this.out : VMAccessor.INSTRUMENT.createDelegatingOutput(configOut, this.out);
        OutputStream useErr = configErr == null || configErr == VMAccessor.INSTRUMENT.getOut(this.err) ? this.err : VMAccessor.INSTRUMENT.createDelegatingOutput(configErr, this.err);
        Handler useHandler = logHandler != null ? logHandler : this.logHandler;
        InputStream useIn = configIn == null ? this.in : configIn;
        PolyglotContextConfig config = new PolyglotContextConfig(this, useOut, useErr, useIn, allowHostAccess, allowNativeAccess, allowCreateThread, allowHostClassLoading, classFilter, arguments, allowedLanguages, options, fs, useHandler = useHandler != null ? useHandler : PolyglotLogHandler.createStreamHandler(useErr, false, true));
        PolyglotContextImpl context = this.loadPreinitializedContext(config);
        if (context == null) {
            context = new PolyglotContextImpl(this, config);
            this.addContext(context);
        } else {
            assert (Thread.holdsLock(this));
            assert (this.contexts.contains(context));
        }
        context.creatorApi = api = this.impl.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextImpl)context);
        context.currentApi = this.impl.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextImpl)context);
        return api;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotContextImpl loadPreinitializedContext(PolyglotContextConfig config) {
        PolyglotContextImpl context = this.preInitializedContext;
        this.preInitializedContext = null;
        if (context != null) {
            FileSystems.PreInitializeContextFileSystem preInitFs = (FileSystems.PreInitializeContextFileSystem)context.config.fileSystem;
            preInitFs.patchDelegate(config.fileSystem);
            FileSystem oldFileSystem = config.fileSystem;
            config.fileSystem = preInitFs;
            boolean patchResult = false;
            try {
                patchResult = context.patch(config);
            }
            finally {
                if (!patchResult) {
                    context.closeImpl(false, false);
                    context = null;
                    PolyglotContextImpl.disposeStaticContext(context);
                    config.fileSystem = oldFileSystem;
                }
            }
        }
        return context;
    }

    private static final class CancelExecution
    extends ThreadDeath
    implements TruffleException {
        private final Node node;

        CancelExecution(EventContext context) {
            this.node = context.getInstrumentedNode();
        }

        @Override
        public Node getLocation() {
            return this.node;
        }

        @Override
        public String getMessage() {
            return "Execution got cancelled.";
        }

        @Override
        public boolean isCancelled() {
            return true;
        }
    }

    final class CancelHandler {
        private final Instrumenter instrumenter;
        private volatile EventBinding<?> cancellationBinding;
        private int cancellationUsers;

        CancelHandler() {
            this.instrumenter = (Instrumenter)VMAccessor.INSTRUMENT.getEngineInstrumenter(PolyglotEngineImpl.this.instrumentationHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForClosing(PolyglotContextImpl ... localContexts) {
            boolean cancelling = false;
            for (PolyglotContextImpl context : localContexts) {
                if (!context.cancelling) continue;
                cancelling = true;
                break;
            }
            if (cancelling) {
                this.enableCancel();
                try {
                    for (PolyglotContextImpl context : localContexts) {
                        context.sendInterrupt();
                    }
                    for (PolyglotContextImpl context : localContexts) {
                        context.waitForClose();
                    }
                }
                finally {
                    this.disableCancel();
                }
            }
        }

        private synchronized void enableCancel() {
            if (this.cancellationBinding == null) {
                this.cancellationBinding = this.instrumenter.attachExecutionEventListener(SourceSectionFilter.ANY, new ExecutionEventListener(){

                    @Override
                    public void onReturnValue(EventContext context, VirtualFrame frame, Object result) {
                        this.cancelExecution(context);
                    }

                    @Override
                    public void onReturnExceptional(EventContext context, VirtualFrame frame, Throwable exception) {
                        this.cancelExecution(context);
                    }

                    @Override
                    public void onEnter(EventContext context, VirtualFrame frame) {
                        this.cancelExecution(context);
                    }

                    @CompilerDirectives.TruffleBoundary
                    private void cancelExecution(EventContext eventContext) {
                        PolyglotContextImpl context = PolyglotContextImpl.requireContext();
                        if (context.cancelling) {
                            throw new CancelExecution(eventContext);
                        }
                    }
                });
            }
            ++this.cancellationUsers;
        }

        private synchronized void disableCancel() {
            int usersLeft;
            if ((usersLeft = --this.cancellationUsers) <= 0) {
                EventBinding<?> b = this.cancellationBinding;
                if (b != null) {
                    b.dispose();
                }
                this.cancellationBinding = null;
            }
        }
    }

    private static final class PolyglotShutDownHook
    implements Runnable {
        private PolyglotShutDownHook() {
        }

        @Override
        public void run() {
            PolyglotEngineImpl[] engines;
            for (PolyglotEngineImpl engine : engines = ENGINES.keySet().toArray(new PolyglotEngineImpl[0])) {
                if (DEBUG_MISSING_CLOSE) {
                    PrintStream out = System.out;
                    out.println("Missing close on vm shutdown: ");
                    out.print(" InitializedLanguages:");
                    for (PolyglotContextImpl context : engine.contexts) {
                        for (PolyglotLanguageContext langContext : context.contexts) {
                            if (langContext.env == null) continue;
                            out.print(langContext.language.getId());
                            out.print(", ");
                        }
                    }
                    out.println();
                    engine.createdLocation.printStackTrace();
                }
                if (engine == null) continue;
                engine.ensureClosed(false, true);
            }
            ENGINES.keySet().removeAll(Arrays.asList(engines));
        }
    }
}

