/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotExceptionFrame
extends AbstractPolyglotImpl.AbstractStackFrameImpl {
    private final PolyglotLanguage language;
    private final SourceSection sourceLocation;
    private final String rootName;
    private final boolean host;
    private StackTraceElement stackTrace;

    private PolyglotExceptionFrame(PolyglotImpl.VMObject source, PolyglotLanguage language, SourceSection sourceLocation, String rootName, boolean isHost, StackTraceElement stackTrace) {
        super((AbstractPolyglotImpl)source.getImpl());
        this.language = language;
        this.sourceLocation = sourceLocation;
        this.rootName = rootName;
        this.host = isHost;
        this.stackTrace = stackTrace;
    }

    public SourceSection getSourceLocation() {
        return this.sourceLocation;
    }

    public Language getLanguage() {
        return this.language.api;
    }

    public String getRootName() {
        return this.rootName;
    }

    public boolean isHostFrame() {
        return this.host;
    }

    public StackTraceElement toHostFrame() {
        if (this.stackTrace == null) {
            String declaringClass = "<" + this.language.getId() + ">";
            String methodName = this.rootName == null ? "" : this.rootName;
            String fileName = this.sourceLocation != null ? this.sourceLocation.getSource().getName() : "Unknown";
            int startLine = this.sourceLocation != null ? this.sourceLocation.getStartLine() : -1;
            this.stackTrace = new StackTraceElement(declaringClass, methodName, fileName, startLine);
        }
        return this.stackTrace;
    }

    public String toStringImpl(int langColumn) {
        StringBuilder b = new StringBuilder();
        if (this.isHostFrame()) {
            String languageId = "";
        } else {
            String languageId = this.language.getId();
            b.append(PolyglotExceptionFrame.spaces(Math.max(langColumn, languageId.length()) - languageId.length())).append("<").append(languageId).append("> ");
        }
        if (this.isHostFrame()) {
            b.append(this.stackTrace.toString());
        } else {
            b.append(this.rootName);
            b.append("(");
            b.append(PolyglotExceptionFrame.formatSource(this.sourceLocation));
            b.append(")");
        }
        return b.toString();
    }

    static PolyglotExceptionFrame createGuest(PolyglotExceptionImpl exception, TruffleStackTraceElement frame, boolean first) {
        SourceSection location;
        if (frame == null) {
            return null;
        }
        RootNode targetRoot = frame.getTarget().getRootNode();
        if (targetRoot.isInternal()) {
            return null;
        }
        LanguageInfo info = targetRoot.getLanguageInfo();
        if (info == null) {
            return null;
        }
        PolyglotEngineImpl engine = exception.getEngine();
        PolyglotLanguage language = engine.idToLanguage.get(info.getId());
        String rootName = targetRoot.getName();
        Node callNode = frame.getLocation();
        if (callNode != null) {
            com.oracle.truffle.api.source.SourceSection section = callNode.getEncapsulatingSourceSection();
            if (section != null) {
                Source source = engine.getAPIAccess().newSource(language.getId(), (Object)section.getSource());
                location = engine.getAPIAccess().newSourceSection(source, (Object)section);
            } else {
                location = null;
            }
        } else {
            location = first ? exception.getSourceLocation() : null;
        }
        return new PolyglotExceptionFrame(exception, language, location, rootName, false, null);
    }

    static PolyglotExceptionFrame createHost(PolyglotExceptionImpl exception, StackTraceElement hostStack) {
        PolyglotLanguage language = exception.getEngine().hostLanguage;
        SourceSection location = null;
        String rootname = hostStack.getClassName() + "." + hostStack.getMethodName();
        return new PolyglotExceptionFrame(exception, language, location, rootname, true, hostStack);
    }

    private static String spaces(int length) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    private static String formatSource(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "Unknown";
        }
        Source source = sourceSection.getSource();
        if (source == null) {
            return "Unknown";
        }
        StringBuilder b = new StringBuilder();
        String path = source.getPath();
        if (path == null) {
            b.append(source.getName());
        } else {
            Path pathAbsolute = Paths.get(path, new String[0]);
            Path pathBase = new File("").getAbsoluteFile().toPath();
            try {
                Path pathRelative = pathBase.relativize(pathAbsolute);
                b.append(pathRelative.toFile());
            }
            catch (IllegalArgumentException e) {
                b.append(source.getName());
            }
        }
        b.append(":").append(PolyglotExceptionFrame.formatIndices(sourceSection, true));
        return b.toString();
    }

    private static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b.append(sourceSection.getStartLine());
        } else {
            b.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b.append(sourceSection.getCharIndex());
            } else {
                b.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b.toString();
    }
}

