/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleException;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotExceptionFrame;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotUnsupportedException;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

final class PolyglotExceptionImpl
extends AbstractPolyglotImpl.AbstractExceptionImpl
implements PolyglotImpl.VMObject {
    private static final String CAUSE_CAPTION = "Caused by host exception: ";
    private static final boolean TRACE_STACK_TRACE_WALKING = false;
    private PolyglotException api;
    final PolyglotContextImpl context;
    private final PolyglotEngineImpl engine;
    final Throwable exception;
    private final List<TruffleStackTraceElement> guestFrames;
    private StackTraceElement[] javaStackTrace;
    private List<PolyglotException.StackFrame> materializedFrames;
    private final SourceSection sourceLocation;
    private final boolean internal;
    private final boolean cancelled;
    private final boolean exit;
    private final boolean incompleteSource;
    private final boolean syntaxError;
    private final int exitStatus;
    private final Value guestObject;
    private final String message;

    PolyglotExceptionImpl(PolyglotLanguageContext languageContext, Throwable original) {
        this(languageContext.getImpl(), languageContext.getEngine(), languageContext, original);
    }

    PolyglotExceptionImpl(PolyglotEngineImpl engine, Throwable original) {
        this(engine.impl, engine, null, original);
    }

    private PolyglotExceptionImpl(AbstractPolyglotImpl impl, PolyglotEngineImpl engine, PolyglotLanguageContext languageContext, Throwable original) {
        super(impl);
        Objects.requireNonNull(engine);
        this.engine = engine;
        this.context = languageContext != null ? languageContext.context : null;
        this.exception = original;
        this.guestFrames = TruffleStackTraceElement.getStackTrace(original);
        if (this.exception instanceof TruffleException) {
            TruffleException truffleException = (TruffleException)((Object)this.exception);
            this.internal = truffleException.isInternalError();
            this.cancelled = truffleException.isCancelled();
            this.syntaxError = truffleException.isSyntaxError();
            this.incompleteSource = truffleException.isIncompleteSource();
            this.exit = truffleException.isExit();
            this.exitStatus = this.exit ? truffleException.getExitStatus() : 0;
            com.oracle.truffle.api.source.SourceSection section = truffleException.getSourceLocation();
            if (section != null) {
                PolyglotLanguage foundLanguage;
                Objects.requireNonNull(languageContext, "Source location can not be accepted without language context.");
                Source truffleSource = section.getSource();
                String language = truffleSource.getLanguage();
                if (language == null && (foundLanguage = languageContext.getEngine().findLanguage(language, truffleSource.getMimeType(), false)) != null) {
                    language = foundLanguage.getId();
                }
                org.graalvm.polyglot.Source source = this.getAPIAccess().newSource(language, (Object)truffleSource);
                this.sourceLocation = this.getAPIAccess().newSourceSection(source, (Object)section);
            } else {
                this.sourceLocation = null;
            }
            Object exceptionObject = ((TruffleException)((Object)this.exception)).getExceptionObject();
            if (exceptionObject != null && languageContext != null) {
                Object receiver = exceptionObject;
                if (receiver instanceof Proxy) {
                    receiver = languageContext.toGuestValue(receiver);
                }
                this.guestObject = languageContext.asValue(receiver);
            } else {
                this.guestObject = null;
            }
        } else {
            this.cancelled = false;
            this.internal = true;
            this.syntaxError = false;
            this.incompleteSource = false;
            this.exit = false;
            this.exitStatus = 0;
            this.sourceLocation = null;
            this.guestObject = null;
        }
        this.message = this.isHostException() ? this.asHostException().getMessage() : (this.internal ? this.exception.toString() : this.exception.getMessage());
        VMAccessor.LANGUAGE.materializeHostFrames(original);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolyglotExceptionImpl) {
            return this.exception == ((PolyglotExceptionImpl)obj).exception;
        }
        return false;
    }

    public int hashCode() {
        return this.exception.hashCode();
    }

    public SourceSection getSourceLocation() {
        return this.sourceLocation;
    }

    public void onCreate(PolyglotException instance) {
        this.api = instance;
    }

    public boolean isHostException() {
        return this.exception instanceof HostException;
    }

    public Throwable asHostException() {
        if (!(this.exception instanceof HostException)) {
            throw new PolyglotUnsupportedException(String.format("Unsupported operation %s.%s. You can ensure that the operation is supported using %s.%s.", PolyglotException.class.getSimpleName(), "asHostException()", PolyglotException.class.getSimpleName(), "isHostException()"));
        }
        return ((HostException)this.exception).getOriginal();
    }

    public void printStackTrace(PrintWriter s) {
        this.printStackTrace(new WrappedPrintWriter(s));
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new WrappedPrintStream(s));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printStackTrace(PrintStreamOrWriter s) {
        Object object = s.lock();
        synchronized (object) {
            if (this.isInternalError() || this.getMessage() == null || this.getMessage().isEmpty()) {
                s.println(this.api);
            } else {
                s.println(this.getMessage());
            }
            this.materialize();
            int languageIdLength = 0;
            for (PolyglotException.StackFrame traceElement : this.getPolyglotStackTrace()) {
                if (traceElement.isHostFrame()) continue;
                languageIdLength = Math.max(languageIdLength, this.getAPIAccess().getImpl(traceElement).getLanguage().getId().length());
            }
            for (PolyglotException.StackFrame traceElement : this.getPolyglotStackTrace()) {
                s.println("\tat " + this.getAPIAccess().getImpl(traceElement).toStringImpl(languageIdLength));
            }
            if (this.isHostException()) {
                s.println(CAUSE_CAPTION + this.asHostException());
            }
            if (this.isInternalError()) {
                s.println("Original Internal Error: ");
                s.printStackTrace(this.exception);
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getJavaStackTrace() {
        if (this.javaStackTrace == null) {
            this.materialize();
            this.javaStackTrace = new StackTraceElement[this.materializedFrames.size()];
            for (int i = 0; i < this.javaStackTrace.length; ++i) {
                this.javaStackTrace[i] = this.materializedFrames.get(i).toHostFrame();
            }
        }
        return this.javaStackTrace;
    }

    private void materialize() {
        if (this.materializedFrames == null) {
            ArrayList<PolyglotException.StackFrame> frames = new ArrayList<PolyglotException.StackFrame>();
            for (PolyglotException.StackFrame frame : this.getPolyglotStackTrace()) {
                frames.add(frame);
            }
            this.materializedFrames = Collections.unmodifiableList(frames);
        }
    }

    public StackTraceElement[] getStackTrace() {
        return (StackTraceElement[])this.getJavaStackTrace().clone();
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    public boolean isInternalError() {
        return this.internal;
    }

    public Iterable<PolyglotException.StackFrame> getPolyglotStackTrace() {
        if (this.materializedFrames != null) {
            return this.materializedFrames;
        }
        return new Iterable<PolyglotException.StackFrame>(){

            @Override
            public Iterator<PolyglotException.StackFrame> iterator() {
                return new StackFrameIterator(PolyglotExceptionImpl.this);
            }
        };
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isExit() {
        return this.exit;
    }

    public boolean isIncompleteSource() {
        return this.incompleteSource;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public boolean isSyntaxError() {
        return this.syntaxError;
    }

    public Value getGuestObject() {
        return this.guestObject;
    }

    private static class StackFrameIterator
    implements Iterator<PolyglotException.StackFrame> {
        private static final String POLYGLOT_PACKAGE = Engine.class.getName().substring(0, Engine.class.getName().lastIndexOf(46) + 1);
        private static final String PROXY_PACKAGE = PolyglotProxy.class.getName();
        private static final String HOST_INTEROP_PACKAGE = "com.oracle.truffle.polyglot.";
        private static final String[] JAVA_INTEROP_HOST_TO_GUEST = new String[]{"com.oracle.truffle.polyglot.PolyglotMap", "com.oracle.truffle.polyglot.PolyglotList", "com.oracle.truffle.polyglot.PolyglotFunction", "com.oracle.truffle.polyglot.FunctionProxyHandler", "com.oracle.truffle.polyglot.ObjectProxyHandler"};
        final PolyglotExceptionImpl impl;
        final Iterator<TruffleStackTraceElement> guestFrames;
        final ListIterator<StackTraceElement> hostFrames;
        final AbstractPolyglotImpl.APIAccess apiAccess;
        boolean inHostLanguage;
        boolean firstGuestFrame = true;
        PolyglotExceptionFrame fetchedNext;

        StackFrameIterator(PolyglotExceptionImpl impl) {
            this.impl = impl;
            this.apiAccess = impl.getAPIAccess();
            Throwable cause = impl.exception;
            while (cause.getCause() != null && cause.getStackTrace().length == 0) {
                cause = cause.getCause();
            }
            StackTraceElement[] hostStack = VMAccessor.LANGUAGE.isTruffleStackTrace(cause) ? VMAccessor.LANGUAGE.getInternalStackTraceElements(cause) : (cause.getStackTrace().length == 0 ? impl.exception.getStackTrace() : cause.getStackTrace());
            this.guestFrames = impl.guestFrames == null ? Collections.emptyList().iterator() : impl.guestFrames.iterator();
            this.hostFrames = Arrays.asList(hostStack).listIterator();
            this.inHostLanguage = impl.isHostException() || impl.isInternalError();
        }

        @Override
        public boolean hasNext() {
            return this.fetchNext() != null;
        }

        @Override
        public PolyglotException.StackFrame next() {
            PolyglotExceptionFrame next = this.fetchNext();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.fetchedNext = null;
            return this.apiAccess.newPolyglotStackTraceElement(this.impl.api, (AbstractPolyglotImpl.AbstractStackFrameImpl)next);
        }

        PolyglotExceptionFrame fetchNext() {
            if (this.fetchedNext != null) {
                return this.fetchedNext;
            }
            while (this.hostFrames.hasNext()) {
                StackTraceElement element;
                block11: {
                    block10: {
                        element = this.hostFrames.next();
                        if (!this.inHostLanguage) break block10;
                        if (!StackFrameIterator.isGuestToHost(element)) break block11;
                        assert (!StackFrameIterator.isHostToGuest(element));
                        this.inHostLanguage = false;
                        break block11;
                    }
                    if (StackFrameIterator.isHostToGuest(element)) {
                        this.inHostLanguage = true;
                        while (this.hostFrames.hasNext()) {
                            StackTraceElement next = this.hostFrames.next();
                            if (StackFrameIterator.isHostToGuest(next)) {
                                this.traceStackTraceElement(element);
                                element = next;
                                continue;
                            }
                            this.hostFrames.previous();
                            break;
                        }
                    }
                }
                this.traceStackTraceElement(element);
                if (StackFrameIterator.isGuestCall(element)) {
                    this.inHostLanguage = false;
                    TruffleStackTraceElement guestFrame = null;
                    if (this.guestFrames.hasNext()) {
                        guestFrame = this.guestFrames.next();
                    }
                    PolyglotExceptionFrame frame = PolyglotExceptionFrame.createGuest(this.impl, guestFrame, this.firstGuestFrame);
                    this.firstGuestFrame = false;
                    if (frame == null) continue;
                    this.fetchedNext = frame;
                    return this.fetchedNext;
                }
                if (!this.inHostLanguage) continue;
                this.fetchedNext = PolyglotExceptionFrame.createHost(this.impl, element);
                return this.fetchedNext;
            }
            if (this.guestFrames.hasNext()) {
                TruffleStackTraceElement guestFrame = this.guestFrames.next();
                PolyglotExceptionFrame frame = PolyglotExceptionFrame.createGuest(this.impl, guestFrame, this.firstGuestFrame);
                this.firstGuestFrame = false;
                if (frame != null) {
                    this.fetchedNext = frame;
                    return this.fetchedNext;
                }
            }
            return null;
        }

        static boolean isLazyStackTraceElement(StackTraceElement element) {
            return element == null;
        }

        static boolean isGuestCall(StackTraceElement element) {
            return StackFrameIterator.isLazyStackTraceElement(element) || VMAccessor.SPI.isGuestCallStackElement(element);
        }

        static boolean isHostToGuest(StackTraceElement element) {
            if (StackFrameIterator.isLazyStackTraceElement(element)) {
                return false;
            }
            if (element.getClassName().startsWith(POLYGLOT_PACKAGE) && element.getClassName().indexOf(46, POLYGLOT_PACKAGE.length()) < 0) {
                return true;
            }
            if (element.getClassName().startsWith(HOST_INTEROP_PACKAGE)) {
                for (String hostToGuestClassName : JAVA_INTEROP_HOST_TO_GUEST) {
                    if (!element.getClassName().equals(hostToGuestClassName)) continue;
                    return true;
                }
            }
            return false;
        }

        static boolean isGuestToHost(StackTraceElement element) {
            if (StackFrameIterator.isLazyStackTraceElement(element)) {
                return false;
            }
            return element.getClassName().startsWith(PROXY_PACKAGE) || element.getClassName().startsWith(HOST_INTEROP_PACKAGE);
        }

        private void traceStackTraceElement(StackTraceElement element) {
        }
    }

    private static class WrappedPrintWriter
    extends PrintStreamOrWriter {
        private final PrintWriter printWriter;

        WrappedPrintWriter(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        @Override
        Object lock() {
            return this.printWriter;
        }

        @Override
        void println(Object o) {
            this.printWriter.println(o);
        }

        @Override
        void printStackTrace(Throwable t) {
            t.printStackTrace(this.printWriter);
        }
    }

    private static class WrappedPrintStream
    extends PrintStreamOrWriter {
        private final PrintStream printStream;

        WrappedPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        Object lock() {
            return this.printStream;
        }

        @Override
        void println(Object o) {
            this.printStream.println(o);
        }

        @Override
        void printStackTrace(Throwable t) {
            t.printStackTrace(this.printStream);
        }
    }

    private static abstract class PrintStreamOrWriter {
        private PrintStreamOrWriter() {
        }

        abstract Object lock();

        abstract void println(Object var1);

        abstract void printStackTrace(Throwable var1);
    }
}

