/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;

final class PolyglotExecuteNode
extends Node {
    private static final Object[] EMPTY = new Object[0];
    @Node.Child
    private Node isExecutable = Message.IS_EXECUTABLE.createNode();
    @Node.Child
    private Node isInstantiable = Message.IS_INSTANTIABLE.createNode();
    @Node.Child
    private Node execute = Message.EXECUTE.createNode();
    @Node.Child
    private Node instantiate = Message.NEW.createNode();
    private final PolyglotLanguageContext.ToGuestValuesNode toGuests = PolyglotLanguageContext.ToGuestValuesNode.create();
    private final ConditionProfile condition = ConditionProfile.createBinaryProfile();
    @Node.Child
    private ToHostNode toHost = ToHostNode.create();

    PolyglotExecuteNode() {
    }

    public Object execute(PolyglotLanguageContext languageContext, TruffleObject function, Object functionArgsObject, Class<?> resultClass, Type resultType) {
        Object result;
        block8: {
            Object[] argsArray = functionArgsObject instanceof Object[] ? (Object[])functionArgsObject : (functionArgsObject == null ? EMPTY : new Object[]{functionArgsObject});
            Object[] functionArgs = this.toGuests.apply(languageContext, argsArray);
            boolean executable = this.condition.profile(ForeignAccess.sendIsExecutable(this.isExecutable, function));
            try {
                if (executable) {
                    result = ForeignAccess.sendExecute(this.execute, function, functionArgs);
                    break block8;
                }
                if (ForeignAccess.sendIsInstantiable(this.isInstantiable, function)) {
                    result = ForeignAccess.sendNew(this.instantiate, function, functionArgs);
                    break block8;
                }
                CompilerDirectives.transferToInterpreter();
                throw HostInteropErrors.executeUnsupported(languageContext, function);
            }
            catch (UnsupportedTypeException e) {
                CompilerDirectives.transferToInterpreter();
                if (executable) {
                    throw HostInteropErrors.invalidExecuteArgumentType(languageContext, function, functionArgs);
                }
                throw HostInteropErrors.invalidInstantiateArgumentType(languageContext, function, functionArgs);
            }
            catch (ArityException e) {
                CompilerDirectives.transferToInterpreter();
                if (executable) {
                    throw HostInteropErrors.invalidExecuteArity(languageContext, function, functionArgs, e.getExpectedArity(), e.getActualArity());
                }
                throw HostInteropErrors.invalidInstantiateArity(languageContext, function, functionArgs, e.getExpectedArity(), e.getActualArity());
            }
            catch (UnsupportedMessageException e) {
                CompilerDirectives.transferToInterpreter();
                throw HostInteropErrors.executeUnsupported(languageContext, function);
            }
        }
        return this.toHost.execute(result, resultClass, resultType, languageContext);
    }
}

