/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.impl.HomeFinder;
import com.oracle.truffle.api.impl.TruffleLocator;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.DefaultScope;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostException;
import com.oracle.truffle.polyglot.HostFunction;
import com.oracle.truffle.polyglot.HostLanguage;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotArrayIndexOutOfBoundsException;
import com.oracle.truffle.polyglot.PolyglotClassCastException;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotExecutionListener;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotIllegalStateException;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLogHandler;
import com.oracle.truffle.polyglot.PolyglotNullPointerException;
import com.oracle.truffle.polyglot.PolyglotSource;
import com.oracle.truffle.polyglot.PolyglotSourceSection;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.PolyglotUnsupportedException;
import com.oracle.truffle.polyglot.PolyglotValue;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object[] EMPTY_ARGS = new Object[0];
    static final String OPTION_GROUP_COMPILER = "compiler";
    static final String OPTION_GROUP_ENGINE = "engine";
    private final PolyglotSource sourceImpl = new PolyglotSource(this);
    private final PolyglotSourceSection sourceSectionImpl = new PolyglotSourceSection(this);
    private final PolyglotExecutionListener executionListenerImpl = new PolyglotExecutionListener(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();

    public AbstractPolyglotImpl.AbstractSourceImpl getSourceImpl() {
        return this.sourceImpl;
    }

    public AbstractPolyglotImpl.AbstractSourceSectionImpl getSourceSectionImpl() {
        return this.sourceSectionImpl;
    }

    public AbstractPolyglotImpl.AbstractExecutionListenerImpl getExecutionListenerImpl() {
        return this.executionListenerImpl;
    }

    public Context getCurrentContext() {
        PolyglotContextImpl context = PolyglotContextImpl.current();
        if (context == null) {
            return super.getCurrentContext();
        }
        return context.currentApi;
    }

    public Engine buildEngine(OutputStream out, OutputStream err, InputStream in, Map<String, String> arguments, long timeout, TimeUnit timeoutUnit, boolean sandbox, long maximumAllowedAllocationBytes, boolean useSystemProperties, boolean boundEngine, Handler logHandler) {
        Engine engine;
        PolyglotEngineImpl impl;
        if (TruffleOptions.AOT) {
            VMAccessor.SPI.initializeNativeImageTruffleLocator();
        }
        OutputStream resolvedOut = out == null ? System.out : out;
        OutputStream resolvedErr = err == null ? System.err : err;
        InputStream resolvedIn = in == null ? System.in : in;
        DispatchOutputStream dispatchOut = VMAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
        DispatchOutputStream dispatchErr = VMAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
        ClassLoader contextClassLoader = TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader();
        PolyglotEngineImpl polyglotEngineImpl = impl = boundEngine ? (PolyglotEngineImpl)this.preInitializedEngineRef.getAndSet(null) : null;
        if (impl != null && !impl.patch(dispatchOut, dispatchErr, resolvedIn, arguments, useSystemProperties, contextClassLoader, boundEngine, logHandler)) {
            impl.ensureClosed(false, true);
            impl = null;
        }
        if (impl == null) {
            impl = new PolyglotEngineImpl(this, dispatchOut, dispatchErr, resolvedIn, arguments, useSystemProperties, contextClassLoader, boundEngine, logHandler);
        }
        impl.creatorApi = engine = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)impl);
        impl.currentApi = this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineImpl)impl);
        return engine;
    }

    public void preInitializeEngine() {
        Handler logHandler = PolyglotLogHandler.createStreamHandler(System.err, false, true);
        try {
            PolyglotEngineImpl preInitializedEngine = PolyglotEngineImpl.preInitialize(this, VMAccessor.INSTRUMENT.createDispatchOutput(System.out), VMAccessor.INSTRUMENT.createDispatchOutput(System.err), System.in, TruffleOptions.AOT ? null : Thread.currentThread().getContextClassLoader(), logHandler);
            this.preInitializedEngineRef.set(preInitializedEngine);
        }
        finally {
            logHandler.flush();
        }
    }

    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
        PolyglotEngineImpl.resetPreInitializedEngine();
    }

    public Class<?> loadLanguageClass(String className) {
        for (ClassLoader loader : TruffleLocator.loaders()) {
            try {
                return loader.loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public Collection<Engine> findActiveEngines() {
        return PolyglotEngineImpl.findActiveEngines();
    }

    public Path findHome() {
        HomeFinder homeFinder = HomeFinder.getInstance();
        return homeFinder == null ? null : homeFinder.getHomeFolder();
    }

    Source getPolyglotSource(com.oracle.truffle.api.source.Source source) {
        Source polyglotSource = VMAccessor.SOURCE.getPolyglotSource(source);
        if (polyglotSource == null) {
            polyglotSource = this.getAPIAccess().newSource(source.getLanguage(), (Object)source);
            VMAccessor.SOURCE.setPolyglotSource(source, polyglotSource);
        }
        return polyglotSource;
    }

    org.graalvm.polyglot.SourceSection getPolyglotSourceSection(SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        Source polyglotSource = this.getPolyglotSource(sourceSection.getSource());
        return this.getAPIAccess().newSourceSection(polyglotSource, (Object)sourceSection);
    }

    static RuntimeException engineError(RuntimeException e) {
        throw new EngineException(e);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException wrapHostException(PolyglotLanguageContext languageContext, T e) {
        throw PolyglotImpl.wrapHostException(languageContext.context, e);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException wrapHostException(PolyglotContextImpl context, T e) {
        if (e instanceof ThreadDeath) {
            throw (ThreadDeath)e;
        }
        if (e instanceof PolyglotException) {
            PolyglotException polyglot = (PolyglotException)e;
            if (context != null) {
                PolyglotExceptionImpl exceptionImpl = (PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl(polyglot);
                if (exceptionImpl.context == context || exceptionImpl.context == null || exceptionImpl.isHostException()) {
                    Throwable original = ((PolyglotExceptionImpl)context.getImpl().getAPIAccess().getImpl((PolyglotException)polyglot)).exception;
                    if (original instanceof RuntimeException) {
                        throw (RuntimeException)original;
                    }
                    if (original instanceof Error) {
                        throw (Error)original;
                    }
                }
            }
        } else {
            if (e instanceof EngineException) {
                return ((EngineException)e).e;
            }
            if (e instanceof HostException) {
                return (HostException)e;
            }
            if (e instanceof InteropException) {
                throw ((InteropException)e).raise();
            }
        }
        return new HostException(e);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException wrapGuestException(PolyglotLanguageContext context, T e) {
        if (e instanceof PolyglotException) {
            return (PolyglotException)e;
        }
        PolyglotImpl.doRethrowPolyglotVariants(e);
        AbstractPolyglotImpl.APIAccess access = context.getEngine().impl.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(context, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> PolyglotException wrapGuestException(PolyglotEngineImpl engine, T e) {
        if (e instanceof PolyglotException) {
            return (PolyglotException)e;
        }
        PolyglotImpl.doRethrowPolyglotVariants(e);
        AbstractPolyglotImpl.APIAccess access = engine.impl.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionImpl)exceptionImpl);
    }

    private static void doRethrowPolyglotVariants(Throwable e) {
        if (e instanceof EngineException) {
            throw ((EngineException)e).e;
        }
        if (e instanceof PolyglotUnsupportedException) {
            throw (PolyglotUnsupportedException)e;
        }
        if (e instanceof PolyglotClassCastException) {
            throw (PolyglotClassCastException)e;
        }
        if (e instanceof PolyglotIllegalStateException) {
            throw (PolyglotIllegalStateException)e;
        }
        if (e instanceof PolyglotNullPointerException) {
            throw (PolyglotNullPointerException)e;
        }
        if (e instanceof PolyglotIllegalArgumentException) {
            throw (PolyglotIllegalArgumentException)e;
        }
        if (e instanceof PolyglotArrayIndexOutOfBoundsException) {
            throw (PolyglotArrayIndexOutOfBoundsException)e;
        }
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String;
    }

    static final class EngineImpl
    extends Accessor.EngineSupport {
        EngineImpl() {
        }

        @Override
        public boolean isDisposed(Object vmObject) {
            return EngineImpl.getEngine((Object)vmObject).closed;
        }

        @Override
        public Object getCurrentContext(Object vmObject) {
            return ((PolyglotLanguage)vmObject).profile.get();
        }

        @Override
        public OptionValues getCompilerOptionValues(RootNode rootNode) {
            Object vm = VMAccessor.NODES.getSourceVM(rootNode);
            if (vm instanceof PolyglotEngineImpl) {
                return ((PolyglotEngineImpl)vm).compilerOptionValues;
            }
            return null;
        }

        @Override
        public Object getVMFromLanguageObject(Object engineObject) {
            return EngineImpl.getEngine(engineObject);
        }

        @Override
        public CallTarget parseForLanguage(Object vmObject, com.oracle.truffle.api.source.Source source, String[] argumentNames) {
            PolyglotLanguageContext sourceContext = (PolyglotLanguageContext)vmObject;
            PolyglotLanguage targetLanguage = sourceContext.context.engine.findLanguage(source.getLanguage(), source.getMimeType(), true);
            PolyglotLanguageContext targetContext = sourceContext.context.getContextInitialized(targetLanguage, sourceContext.language);
            return targetContext.parseCached(sourceContext.language, source, argumentNames);
        }

        @Override
        public TruffleLanguage.Env getEnvForInstrument(Object vmObject, String languageId, String mimeType) {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            PolyglotLanguage foundLanguage = context.engine.findLanguage(languageId, mimeType, true);
            return context.getContextInitialized((PolyglotLanguage)foundLanguage, null).env;
        }

        @Override
        public org.graalvm.polyglot.SourceSection createSourceSection(Object vmObject, Source source, SourceSection sectionImpl) {
            Source polyglotSource = source;
            if (polyglotSource == null) {
                com.oracle.truffle.api.source.Source sourceImpl = sectionImpl.getSource();
                polyglotSource = ((VMObject)vmObject).getAPIAccess().newSource(sourceImpl.getLanguage(), (Object)sourceImpl);
            }
            return ((VMObject)vmObject).getAPIAccess().newSourceSection(polyglotSource, (Object)sectionImpl);
        }

        @Override
        public <T> T lookup(InstrumentInfo info, Class<T> serviceClass) {
            PolyglotInstrument instrument = (PolyglotInstrument)VMAccessor.LANGUAGE.getVMObject(info);
            return instrument.lookup(serviceClass, false);
        }

        @Override
        public <S> S lookup(LanguageInfo info, Class<S> serviceClass) {
            PolyglotLanguage language = (PolyglotLanguage)VMAccessor.NODES.getEngineObject(info);
            PolyglotLanguageContext languageContext = PolyglotContextImpl.requireContext().getContextInitialized(language, language);
            return VMAccessor.LANGUAGE.lookup(VMAccessor.LANGUAGE.getLanguage(languageContext.env), serviceClass);
        }

        @Override
        public <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
            CompilerAsserts.partialEvaluationConstant(languageClass);
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            TruffleLanguage.Env env = context.getLanguageContext(languageClass).env;
            if (env == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("Current context is not yet initialized or already disposed.");
            }
            return (C)VMAccessor.LANGUAGE.getContext(env);
        }

        @Override
        public TruffleContext getPolyglotContext(Object vmObject) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)vmObject;
            return languageContext.context.truffleContext;
        }

        @Override
        public <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> languageClass) {
            CompilerAsserts.partialEvaluationConstant(languageClass);
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            TruffleLanguage.Env env = context.getLanguageContext(languageClass).env;
            if (env == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("Current context is not yet initialized or already disposed.");
            }
            return (T)VMAccessor.LANGUAGE.getLanguage(env);
        }

        @Override
        public Map<String, LanguageInfo> getLanguages(Object vmObject) {
            return EngineImpl.getEngine((Object)vmObject).idToInternalLanguageInfo;
        }

        @Override
        public Map<String, InstrumentInfo> getInstruments(Object vmObject) {
            return EngineImpl.getEngine((Object)vmObject).idToInternalInstrumentInfo;
        }

        private static PolyglotEngineImpl getEngine(Object vmObject) throws AssertionError {
            if (!(vmObject instanceof VMObject)) {
                throw new AssertionError();
            }
            return ((VMObject)vmObject).getEngine();
        }

        @Override
        public TruffleLanguage.Env getEnvForInstrument(LanguageInfo info) {
            PolyglotLanguage language = (PolyglotLanguage)VMAccessor.NODES.getEngineObject(info);
            return PolyglotContextImpl.requireContext().getContextInitialized((PolyglotLanguage)language, null).env;
        }

        @Override
        public TruffleLanguage.Env getExistingEnvForInstrument(LanguageInfo info) {
            PolyglotLanguage language = (PolyglotLanguage)VMAccessor.NODES.getEngineObject(info);
            PolyglotLanguageContext languageContext = PolyglotContextImpl.requireContext().contexts[language.index];
            return languageContext.isInitialized() ? languageContext.env : null;
        }

        static PolyglotLanguage findObjectLanguage(PolyglotContextImpl context, PolyglotLanguageContext currentlanguageContext, Object value) {
            PolyglotLanguage foundLanguage = null;
            PolyglotLanguageContext hostLanguageContext = context.getHostContext();
            if (currentlanguageContext != null && EngineImpl.isPrimitive(value)) {
                return currentlanguageContext.language;
            }
            if (VMAccessor.LANGUAGE.isObjectOfLanguage(hostLanguageContext.env, value)) {
                foundLanguage = hostLanguageContext.language;
            } else if (currentlanguageContext != null && VMAccessor.LANGUAGE.isObjectOfLanguage(currentlanguageContext.env, value)) {
                foundLanguage = currentlanguageContext.language;
            } else {
                for (PolyglotLanguageContext searchContext : context.contexts) {
                    TruffleLanguage.Env searchEnv;
                    if (!searchContext.isInitialized() || searchContext == currentlanguageContext || !VMAccessor.LANGUAGE.isObjectOfLanguage(searchEnv = searchContext.env, value)) continue;
                    foundLanguage = searchContext.language;
                    break;
                }
            }
            return foundLanguage;
        }

        static boolean isPrimitive(Object value) {
            Class<?> valueClass = value.getClass();
            return valueClass == Boolean.class || valueClass == Byte.class || valueClass == Short.class || valueClass == Integer.class || valueClass == Long.class || valueClass == Float.class || valueClass == Double.class || valueClass == Character.class || valueClass == String.class;
        }

        @Override
        public LanguageInfo getObjectLanguage(Object obj, Object vmObject) {
            PolyglotLanguage language = EngineImpl.findObjectLanguage(PolyglotContextImpl.requireContext(), null, obj);
            if (language != null) {
                return language.info;
            }
            return null;
        }

        @Override
        public Object getCurrentVM() {
            PolyglotContextImpl context = PolyglotContextImpl.current();
            if (context == null) {
                return null;
            }
            return context.engine;
        }

        @Override
        public boolean isEvalRoot(RootNode target) {
            return false;
        }

        @Override
        public boolean isMimeTypeSupported(Object vmObject, String mimeType) {
            PolyglotEngineImpl engine = EngineImpl.getEngine(vmObject);
            for (PolyglotLanguage language : engine.idToLanguage.values()) {
                if (!language.cache.getMimeTypes().contains(mimeType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public TruffleLanguage.Env findEnv(Object vmObject, Class<? extends TruffleLanguage> languageClass, boolean failIfNotFound) {
            PolyglotLanguageContext findLanguageContext = PolyglotContextImpl.requireContext().findLanguageContext(languageClass, failIfNotFound);
            if (findLanguageContext != null) {
                return findLanguageContext.env;
            }
            return null;
        }

        @Override
        public Object getInstrumentationHandler(Object vmObject) {
            return EngineImpl.getEngine((Object)vmObject).instrumentationHandler;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object importSymbol(Object vmObject, TruffleLanguage.Env env, String symbolName) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)vmObject;
            Value value = context.context.polyglotBindings.get(symbolName);
            if (value != null) {
                return context.getAPIAccess().getReceiver(value);
            }
            value = context.context.findLegacyExportedSymbol(symbolName);
            if (value != null) {
                return context.getAPIAccess().getReceiver(value);
            }
            return null;
        }

        @Override
        public Object lookupHostSymbol(Object vmObject, TruffleLanguage.Env env, String symbolName) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)vmObject;
            HostLanguage.HostContext hostContext = ((PolyglotLanguageContext)vmObject).context.getHostContextImpl();
            Class<?> clazz = hostContext.findClass(symbolName);
            if (clazz == null) {
                return null;
            }
            return HostObject.forStaticClass(clazz, context);
        }

        @Override
        public Object asHostSymbol(Object vmObject, Class<?> symbolClass) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)vmObject;
            return HostObject.forStaticClass(symbolClass, context);
        }

        @Override
        public boolean isHostAccessAllowed(Object vmObject, TruffleLanguage.Env env) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)vmObject;
            return context.context.config.hostAccessAllowed;
        }

        @Override
        public boolean isNativeAccessAllowed(Object vmObject, TruffleLanguage.Env env) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)vmObject;
            return context.context.config.nativeAccessAllowed;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void exportSymbol(Object vmObject, String symbolName, Object value) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)vmObject;
            if (value == null) {
                context.context.polyglotBindings.remove(symbolName);
            } else {
                context.context.polyglotBindings.put(symbolName, context.asValue(value));
            }
        }

        @Override
        public Map<String, ? extends Object> getExportedSymbols(Object vmObject) {
            PolyglotContextImpl currentContext = PolyglotContextImpl.current();
            return (Map)currentContext.polyglotHostBindings.as(Map.class);
        }

        @Override
        public void registerDebugger(Object vm, Object debugger) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T installJavaInteropCodeCache(Object languageContext, Object key, T value, Class<T> expectedType) {
            if (languageContext == null) {
                return value;
            }
            T result = expectedType.cast(((PolyglotLanguageContext)languageContext).context.engine.javaInteropCodeCache.putIfAbsent(key, value));
            if (result != null) {
                return result;
            }
            return value;
        }

        @Override
        public <T> T lookupJavaInteropCodeCache(Object languageContext, Object key, Class<T> expectedType) {
            if (languageContext == null) {
                return null;
            }
            return expectedType.cast(((PolyglotLanguageContext)languageContext).context.engine.javaInteropCodeCache.get(key));
        }

        @Override
        public Object toGuestValue(Object obj, Object context) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)context;
            if (obj instanceof Value) {
                PolyglotValue valueImpl = (PolyglotValue)languageContext.getImpl().getAPIAccess().getImpl((Value)obj);
                languageContext = valueImpl.languageContext;
            }
            return languageContext.toGuestValue(obj);
        }

        @Override
        public Object asBoxedGuestValue(Object guestObject, Object vmObject) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)vmObject;
            if (PolyglotImpl.isGuestPrimitive(guestObject)) {
                return HostObject.forObject(guestObject, languageContext);
            }
            if (guestObject instanceof TruffleObject) {
                return guestObject;
            }
            CompilerDirectives.transferToInterpreter();
            throw new IllegalArgumentException("Provided value not an interop value.");
        }

        @Override
        public Iterable<Scope> createDefaultLexicalScope(Node node, Frame frame) {
            return DefaultScope.lexicalScope(node, frame);
        }

        @Override
        public Iterable<Scope> createDefaultTopScope(Object global) {
            return DefaultScope.topScope(global);
        }

        @Override
        public void reportAllLanguageContexts(Object vmObject, Object contextsListener) {
            ((PolyglotEngineImpl)vmObject).reportAllLanguageContexts((ContextsListener)contextsListener);
        }

        @Override
        public void reportAllContextThreads(Object vmObject, Object threadsListener) {
            ((PolyglotEngineImpl)vmObject).reportAllContextThreads((ThreadsListener)threadsListener);
        }

        @Override
        public TruffleContext getParentContext(Object impl) {
            PolyglotContextImpl parent = ((PolyglotContextImpl)impl).parent;
            if (parent != null) {
                return parent.truffleContext;
            }
            return null;
        }

        @Override
        public Object enterInternalContext(Object impl) {
            return ((PolyglotContextImpl)impl).enter();
        }

        @Override
        public void leaveInternalContext(Object impl, Object prev) {
            ((PolyglotContextImpl)impl).leave(prev);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void closeInternalContext(Object impl) {
            PolyglotContextImpl context = (PolyglotContextImpl)impl;
            if (context.isActive()) {
                throw new IllegalStateException("The context is currently entered and cannot be closed.");
            }
            context.closeImpl(false, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object createInternalContext(Object vmObject, Map<String, Object> config, TruffleContext spiContext) {
            PolyglotContextImpl impl;
            PolyglotLanguageContext creator = (PolyglotLanguageContext)vmObject;
            PolyglotContextImpl polyglotContextImpl = creator.context;
            synchronized (polyglotContextImpl) {
                impl = new PolyglotContextImpl(creator, config, spiContext);
                impl.creatorApi = impl.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextImpl)impl);
                impl.currentApi = impl.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextImpl)impl);
            }
            return impl;
        }

        @Override
        public void initializeInternalContext(Object vmObject, Object contextImpl) {
            PolyglotLanguageContext creator = (PolyglotLanguageContext)vmObject;
            PolyglotContextImpl impl = (PolyglotContextImpl)contextImpl;
            impl.engine.initializeMultiContext(creator.context);
            impl.notifyContextCreated();
            impl.initializeLanguage(creator.language.getId());
        }

        @Override
        public boolean isCreateThreadAllowed(Object vmObject) {
            return ((PolyglotLanguageContext)vmObject).context.config.createThreadAllowed;
        }

        @Override
        public Thread createThread(Object vmObject, Runnable runnable, Object innerContextImpl) {
            if (!this.isCreateThreadAllowed(vmObject)) {
                throw new IllegalStateException("Creating threads is not allowed.");
            }
            PolyglotLanguageContext threadContext = (PolyglotLanguageContext)vmObject;
            if (innerContextImpl != null) {
                PolyglotContextImpl innerContext = (PolyglotContextImpl)innerContextImpl;
                threadContext = innerContext.getContext(threadContext.language);
            }
            return new PolyglotThread(threadContext, runnable);
        }

        @Override
        public RuntimeException wrapHostException(Object languageContext, Throwable exception) {
            return PolyglotImpl.wrapHostException((PolyglotLanguageContext)languageContext, exception);
        }

        @Override
        public boolean isHostException(Throwable exception) {
            return exception instanceof HostException;
        }

        @Override
        public Throwable asHostException(Throwable exception) {
            return ((HostException)exception).getOriginal();
        }

        @Override
        public Object getCurrentHostContext() {
            PolyglotContextImpl polyglotContext = PolyglotContextImpl.current();
            return polyglotContext == null ? null : polyglotContext.getHostContext();
        }

        @Override
        public Object getPolyglotBindingsForLanguage(Object languageVMObject) {
            return ((PolyglotLanguageContext)languageVMObject).getPolyglotGuestBindings();
        }

        @Override
        public Object findMetaObjectForLanguage(Object languageVMObject, Object value) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)languageVMObject;
            TruffleLanguage.Env currentLanguage = languageContext.env;
            assert (currentLanguage != null) : "current language is initialized";
            TruffleLanguage.Env foundLanguage = null;
            TruffleLanguage.Env hostLanguage = languageContext.context.getHostContext().env;
            if (VMAccessor.LANGUAGE.isObjectOfLanguage(hostLanguage, value)) {
                foundLanguage = hostLanguage;
            } else if (VMAccessor.LANGUAGE.isObjectOfLanguage(currentLanguage, value)) {
                foundLanguage = currentLanguage;
            } else {
                for (PolyglotLanguageContext searchContext : languageContext.context.contexts) {
                    TruffleLanguage.Env searchEnv;
                    if (!searchContext.isInitialized() || searchContext == languageContext || !VMAccessor.LANGUAGE.isObjectOfLanguage(searchEnv = searchContext.env, value)) continue;
                    foundLanguage = searchEnv;
                    break;
                }
            }
            if (foundLanguage != null) {
                return VMAccessor.LANGUAGE.findMetaObject(foundLanguage, value);
            }
            return null;
        }

        @Override
        public PolyglotException wrapGuestException(String languageId, Throwable e) {
            PolyglotContextImpl pc = PolyglotContextImpl.current();
            if (pc == null) {
                return null;
            }
            PolyglotLanguage language = pc.engine.findLanguage(languageId, null, true);
            PolyglotLanguageContext languageContext = pc.getContextInitialized(language, null);
            return PolyglotImpl.wrapGuestException(languageContext, e);
        }

        @Override
        public Class<? extends TruffleLanguage<?>> getLanguageClass(LanguageInfo language) {
            return ((PolyglotLanguage)VMAccessor.NODES.getEngineObject((LanguageInfo)language)).cache.getLanguageClass();
        }

        @Override
        public TruffleLanguage.Env getLanguageEnv(Object languageVMObject, LanguageInfo language) {
            PolyglotLanguage lang = (PolyglotLanguage)VMAccessor.NODES.getEngineObject(language);
            PolyglotLanguageContext context = (PolyglotLanguageContext)languageVMObject;
            return context.context.getContext((PolyglotLanguage)lang).env;
        }

        @Override
        public Object legacyTckEnter(Object vm) {
            throw new AssertionError((Object)"Should not reach here.");
        }

        @Override
        public void legacyTckLeave(Object vm, Object prev) {
            throw new AssertionError((Object)"Should not reach here.");
        }

        @Override
        public <T> T getOrCreateRuntimeData(Object sourceVM, Supplier<T> constructor) {
            if (!(sourceVM instanceof VMObject)) {
                return null;
            }
            PolyglotEngineImpl engine = EngineImpl.getEngine(sourceVM);
            if (engine.runtimeData == null) {
                engine.runtimeData = constructor.get();
            }
            return (T)engine.runtimeData;
        }

        @Override
        public boolean isDefaultFileSystem(FileSystem fs) {
            return FileSystems.getDefaultFileSystem() == fs;
        }

        @Override
        public void addToHostClassPath(Object vmObject, TruffleFile entry) {
            HostLanguage.HostContext hostContext = ((PolyglotLanguageContext)vmObject).context.getHostContextImpl();
            hostContext.addToHostClasspath(entry);
        }

        @Override
        public String getLanguageHome(Object engineObject) {
            return ((PolyglotLanguage)engineObject).cache.getLanguageHome();
        }

        @Override
        public boolean isInstrumentExceptionsAreThrown(Object vmObject) {
            return EngineImpl.getEngine((Object)vmObject).engineOptionValues.get(PolyglotEngineOptions.InstrumentExceptionsAreThrown);
        }

        @Override
        public Handler getLogHandler() {
            return PolyglotLogHandler.INSTANCE;
        }

        @Override
        public LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
            return PolyglotLogHandler.createLogRecord(level, loggerName, message, className, methodName, parameters, thrown);
        }

        @Override
        public Object getCurrentOuterContext() {
            return PolyglotLogHandler.getCurrentOuterContext();
        }

        @Override
        public Map<String, Level> getLogLevels(Object context) {
            if (!(context instanceof PolyglotContextImpl)) {
                throw new AssertionError();
            }
            return ((PolyglotContextImpl)context).config.logLevels;
        }

        @Override
        public Set<String> getValidMimeTypes(String language) {
            if (language == null) {
                return LanguageCache.languageMimes().keySet();
            }
            LanguageCache lang = LanguageCache.languages().get(language);
            if (lang != null) {
                return lang.getMimeTypes();
            }
            return Collections.emptySet();
        }

        @Override
        public boolean isCharacterBasedSource(String language, String mimeType) {
            LanguageCache cache = LanguageCache.languages().get(language);
            if (cache == null) {
                return true;
            }
            String useMimeType = mimeType;
            if (useMimeType == null) {
                useMimeType = cache.getDefaultMimeType();
            }
            if (useMimeType == null || !cache.getMimeTypes().contains(useMimeType)) {
                return true;
            }
            return cache.isCharacterMimeType(useMimeType);
        }

        @Override
        public Object asHostObject(Object obj) {
            assert (this.isHostObject(obj));
            HostObject javaObject = (HostObject)obj;
            return javaObject.obj;
        }

        @Override
        public boolean isHostFunction(Object obj) {
            if (TruffleOptions.AOT) {
                return false;
            }
            return HostFunction.isInstance(obj);
        }

        @Override
        public boolean isHostObject(Object obj) {
            return HostObject.isInstance(obj);
        }

        @Override
        public boolean isHostSymbol(Object obj) {
            return HostObject.isStaticClass(obj);
        }
    }

    private static class EngineException
    extends RuntimeException {
        final RuntimeException e;

        EngineException(RuntimeException e) {
            this.e = e;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        default public PolyglotImpl getImpl() {
            return this.getEngine().impl;
        }

        default public AbstractPolyglotImpl.APIAccess getAPIAccess() {
            return this.getEngine().impl.getAPIAccess();
        }
    }
}

