/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.VMAccessor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Language;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLanguage
extends AbstractPolyglotImpl.AbstractLanguageImpl
implements PolyglotImpl.VMObject {
    final PolyglotEngineImpl engine;
    final LanguageCache cache;
    final LanguageInfo info;
    Language api;
    final int index;
    private final boolean host;
    final RuntimeException initError;
    private volatile OptionDescriptors options;
    private volatile OptionValuesImpl optionValues;
    private volatile boolean initialized;
    private volatile PolyglotLanguageInstance initLanguage;
    private final LinkedList<PolyglotLanguageInstance> instancePool = new LinkedList();
    final ContextProfile profile;

    PolyglotLanguage(PolyglotEngineImpl engine, LanguageCache cache, int index, boolean host, RuntimeException initError) {
        super((AbstractPolyglotImpl)engine.impl);
        this.engine = engine;
        this.cache = cache;
        this.initError = initError;
        this.index = index;
        this.host = host;
        this.profile = new ContextProfile(this);
        this.info = VMAccessor.NODES.createLanguage(this, cache.getId(), cache.getName(), cache.getVersion(), cache.getDefaultMimeType(), cache.getMimeTypes(), cache.isInternal(), cache.isInteractive());
    }

    PolyglotLanguageContext getCurrentLanguageContext() {
        return PolyglotContextImpl.requireContext().contexts[this.index];
    }

    boolean dependsOn(PolyglotLanguage otherLanguage) {
        Set<String> dependentLanguages = this.cache.getDependentLanguages();
        if (dependentLanguages.contains(otherLanguage.getId())) {
            return true;
        }
        for (String dependentLanguage : dependentLanguages) {
            PolyglotLanguage dependentLanguageObj = this.engine.idToLanguage.get(dependentLanguage);
            if (dependentLanguageObj == null || !this.dependsOn(dependentLanguageObj)) continue;
            return true;
        }
        return false;
    }

    boolean isHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OptionDescriptors getOptions() {
        this.engine.checkState();
        if (!this.initialized) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (!this.initialized) {
                    try {
                        this.initLanguage = this.ensureInitialized(new PolyglotLanguageInstance(this));
                    }
                    catch (Throwable e) {
                        return OptionDescriptors.EMPTY;
                    }
                    this.initialized = true;
                }
            }
        }
        return this.options;
    }

    private PolyglotLanguageInstance createInstance() {
        assert (Thread.holdsLock(this.engine));
        PolyglotLanguageInstance instance = null;
        if (this.initLanguage != null) {
            instance = this.initLanguage;
            this.initLanguage = null;
        }
        if (instance == null) {
            instance = this.ensureInitialized(new PolyglotLanguageInstance(this));
        }
        return instance;
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageInstance ensureInitialized(PolyglotLanguageInstance instance) {
        if (!this.initialized) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (!this.initialized) {
                    try {
                        this.options = VMAccessor.LANGUAGE.describeOptions(instance.spi, this.cache.getId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", this.cache.getId(), this.cache.getClassName()), e);
                    }
                    this.initialized = true;
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PolyglotLanguageInstance allocateInstance(OptionValuesImpl newOptions) {
        PolyglotLanguageInstance instance;
        PolyglotEngineImpl polyglotEngineImpl = this.engine;
        synchronized (polyglotEngineImpl) {
            switch (this.cache.getPolicy()) {
                case EXCLUSIVE: {
                    instance = this.createInstance();
                    break;
                }
                case REUSE: {
                    instance = this.fetchFromPool(newOptions, false);
                    break;
                }
                case SHARED: {
                    instance = this.fetchFromPool(newOptions, true);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Unknown context cardinality.");
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolyglotLanguageInstance fetchFromPool(OptionValuesImpl newOptions, boolean shared) {
        PolyglotEngineImpl polyglotEngineImpl = this.engine;
        synchronized (polyglotEngineImpl) {
            PolyglotLanguageInstance foundInstance = null;
            Iterator iterator = this.instancePool.iterator();
            while (iterator.hasNext()) {
                PolyglotLanguageInstance instance = (PolyglotLanguageInstance)iterator.next();
                if (!instance.areOptionsCompatible(newOptions)) continue;
                if (!shared) {
                    iterator.remove();
                }
                foundInstance = instance;
                break;
            }
            if (foundInstance == null) {
                foundInstance = this.createInstance();
                foundInstance.claim(newOptions);
                if (shared) {
                    this.instancePool.addFirst(foundInstance);
                }
            }
            return foundInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeInstance(PolyglotLanguageInstance instance) {
        switch (this.cache.getPolicy()) {
            case EXCLUSIVE: {
                break;
            }
            case REUSE: {
                PolyglotEngineImpl polyglotEngineImpl = this.engine;
                synchronized (polyglotEngineImpl) {
                    this.profile.notifyLanguageFreed();
                    this.instancePool.addFirst(instance);
                    break;
                }
            }
            case SHARED: {
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown context cardinality.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OptionValuesImpl getOptionValues() {
        if (this.optionValues == null) {
            PolyglotEngineImpl polyglotEngineImpl = this.engine;
            synchronized (polyglotEngineImpl) {
                if (this.optionValues == null) {
                    this.optionValues = new OptionValuesImpl(this.engine, this.getOptions());
                }
            }
        }
        return this.optionValues;
    }

    public String getDefaultMimeType() {
        return this.cache.getDefaultMimeType();
    }

    void clearOptionValues() {
        this.optionValues = null;
    }

    public String getName() {
        return this.cache.getName();
    }

    public String getImplementationName() {
        return this.cache.getImplementationName();
    }

    public boolean isInteractive() {
        return this.cache.isInteractive();
    }

    public Set<String> getMimeTypes() {
        return this.cache.getMimeTypes();
    }

    public String getVersion() {
        String version = this.cache.getVersion();
        if (version.equals("inherit")) {
            return this.engine.getVersion();
        }
        return version;
    }

    public String getId() {
        return this.cache.getId();
    }

    public String toString() {
        return "PolyglotLanguage [id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.isHost() + "]";
    }

    static final class ContextProfile {
        private static final Object UNSET_CONTEXT = new Object();
        private final PolyglotLanguage language;
        private final Assumption singleContext = Truffle.getRuntime().createAssumption("Language single context.");
        @CompilerDirectives.CompilationFinal
        private volatile Object cachedSingleContext = UNSET_CONTEXT;

        ContextProfile(PolyglotLanguage language) {
            this.language = language;
            if (!language.engine.boundEngine) {
                this.singleContext.invalidate();
            }
        }

        Object get() {
            Object cachedSingle;
            assert (this.assertCorrectEngine());
            if (this.singleContext.isValid() && (cachedSingle = this.cachedSingleContext) != UNSET_CONTEXT) {
                assert (this.assertGet(cachedSingle));
                return cachedSingle;
            }
            return this.lookupLanguageContext(PolyglotContextImpl.requireContext());
        }

        private boolean assertCorrectEngine() {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            PolyglotLanguageContext languageContext = context.getContext(this.language);
            if (languageContext.isInitialized() && languageContext.language.engine != this.language.engine) {
                throw new AssertionError((Object)String.format("Context reference was used from an Engine that is currently not entered. ContextReference of engine %s was used but engine %s is currently entered. ContextReference must not be shared between multiple Engine instances.", languageContext.language.engine.creatorApi, this.language.engine.creatorApi));
            }
            return true;
        }

        private boolean assertGet(Object cachedSingle) {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            if (!this.singleContext.isValid()) {
                return true;
            }
            Object verifyContext = this.lookupLanguageContext(context);
            if (cachedSingle != verifyContext) {
                throw new AssertionError((Object)String.format("Expected %s but got %s.", cachedSingle, verifyContext));
            }
            return true;
        }

        private Object lookupLanguageContext(PolyglotContextImpl context) {
            TruffleLanguage.Env env = context.getContext((PolyglotLanguage)this.language).env;
            if (env == null) {
                CompilerDirectives.transferToInterpreter();
                throw new IllegalStateException("The language context is not yet initialized or already disposed.");
            }
            return VMAccessor.LANGUAGE.getContext(env);
        }

        void notifyContextCreate(TruffleLanguage.Env env) {
            if (this.singleContext.isValid()) {
                Object cachedSingle = this.cachedSingleContext;
                assert (cachedSingle != VMAccessor.LANGUAGE.getContext(env) || cachedSingle == null) : "Non-null context objects should be distinct";
                if (cachedSingle == UNSET_CONTEXT) {
                    if (this.singleContext.isValid()) {
                        this.cachedSingleContext = VMAccessor.LANGUAGE.getContext(env);
                    }
                } else {
                    this.singleContext.invalidate();
                    this.cachedSingleContext = UNSET_CONTEXT;
                }
            }
        }

        void notifyLanguageFreed() {
            if (this.singleContext.isValid()) {
                this.cachedSingleContext = UNSET_CONTEXT;
            }
        }
    }
}

