/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.DefaultScope;
import com.oracle.truffle.polyglot.PolyglotBindings;
import java.util.ArrayList;
import java.util.HashSet;

final class PolyglotLanguageBindings
implements TruffleObject {
    final TruffleObject[] scopes;

    PolyglotLanguageBindings(Iterable<Scope> scopes) {
        ArrayList<TruffleObject> collectScopes = new ArrayList<TruffleObject>();
        Node hasKeysNode = Message.HAS_KEYS.createNode();
        for (Scope scope : scopes) {
            Object vars = scope.getVariables();
            if (!(vars instanceof TruffleObject)) {
                throw new AssertionError((Object)"Returned scope variables object must be a TruffleObject.");
            }
            if (!ForeignAccess.sendHasKeys(hasKeysNode, (TruffleObject)vars)) {
                throw new AssertionError((Object)"Returned scope variables object must return true for HAS_KEYS.");
            }
            collectScopes.add((TruffleObject)vars);
        }
        this.scopes = collectScopes.toArray(new TruffleObject[0]);
    }

    @Override
    public ForeignAccess getForeignAccess() {
        return LanguageBindingsFactory.INSTANCE;
    }

    private static final class LanguageBindingsFactory
    implements ForeignAccess.StandardFactory {
        private static final ForeignAccess INSTANCE = ForeignAccess.create(PolyglotBindings.class, new LanguageBindingsFactory());

        private LanguageBindingsFactory() {
        }

        @Override
        public CallTarget accessWrite() {
            return Truffle.getRuntime().createCallTarget(new WriteNode());
        }

        @Override
        public CallTarget accessIsBoxed() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(Boolean.FALSE));
        }

        @Override
        public CallTarget accessUnbox() {
            return null;
        }

        @Override
        public CallTarget accessRead() {
            return Truffle.getRuntime().createCallTarget(new ReadNode());
        }

        @Override
        public CallTarget accessRemove() {
            return Truffle.getRuntime().createCallTarget(new RemoveNode());
        }

        @Override
        public CallTarget accessIsInstantiable() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(Boolean.FALSE));
        }

        @Override
        public CallTarget accessNew(int argumentsLength) {
            return null;
        }

        @Override
        public CallTarget accessHasKeys() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(Boolean.TRUE));
        }

        @Override
        public CallTarget accessKeys() {
            return Truffle.getRuntime().createCallTarget(new KeysNode());
        }

        @Override
        public CallTarget accessKeyInfo() {
            return Truffle.getRuntime().createCallTarget(new KeyInfoNode());
        }

        @Override
        public CallTarget accessIsNull() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessIsExecutable() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessInvoke(int argumentsLength) {
            return null;
        }

        @Override
        public CallTarget accessHasSize() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessGetSize() {
            return null;
        }

        @Override
        public CallTarget accessExecute(int argumentsLength) {
            return null;
        }

        @Override
        public CallTarget accessIsPointer() {
            return Truffle.getRuntime().createCallTarget(RootNode.createConstantNode(false));
        }

        @Override
        public CallTarget accessAsPointer() {
            return null;
        }

        @Override
        public CallTarget accessToNative() {
            return null;
        }

        @Override
        public CallTarget accessMessage(Message unknown) {
            return null;
        }

        private static class KeysNode
        extends BaseNode {
            @Node.Child
            private Node keysNode = Message.KEYS.createNode();
            @Node.Child
            private Node readNode = Message.READ.createNode();
            @Node.Child
            private Node getSizeNode = Message.GET_SIZE.createNode();

            private KeysNode() {
            }

            @Override
            Object execute(TruffleObject[] scopes, int length, Object[] arguments, int offset) throws InteropException {
                if (length == 0) {
                    return DefaultScope.VariableNamesObject.EMPTY;
                }
                if (length == 1) {
                    return ForeignAccess.sendKeys(this.keysNode, scopes[0]);
                }
                return this.collectKeys(scopes);
            }

            @CompilerDirectives.TruffleBoundary
            private Object collectKeys(TruffleObject[] scopes) throws UnsupportedMessageException {
                HashSet<String> keySet = new HashSet<String>();
                for (TruffleObject scope : scopes) {
                    TruffleObject keys = ForeignAccess.sendKeys(this.keysNode, scope);
                    int size = ((Number)ForeignAccess.sendGetSize(this.getSizeNode, keys)).intValue();
                    for (int i = 0; i < size; ++i) {
                        try {
                            keySet.add((String)ForeignAccess.sendRead(this.readNode, keys, i));
                            continue;
                        }
                        catch (UnknownIdentifierException unknownIdentifierException) {
                            // empty catch block
                        }
                    }
                }
                return new DefaultScope.VariableNamesObject(keySet);
            }
        }

        private static class KeyInfoNode
        extends BaseNode {
            @Node.Child
            private Node keyInfoNode = Message.KEY_INFO.createNode();

            private KeyInfoNode() {
            }

            @Override
            Object execute(TruffleObject[] scopes, int length, Object[] arguments, int offset) throws InteropException {
                String identifier = KeyInfoNode.expectIdentifier(arguments, offset, Message.KEY_INFO);
                int keyInfo = 0;
                for (int i = 0; i < length; ++i) {
                    TruffleObject scopeObject = scopes[i];
                    int currentInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, scopeObject, identifier);
                    if (KeyInfo.isExisting(currentInfo)) {
                        keyInfo = currentInfo;
                        break;
                    }
                    if (!KeyInfo.isInsertable(currentInfo)) continue;
                    keyInfo = currentInfo;
                }
                return keyInfo;
            }
        }

        private static class RemoveNode
        extends BaseNode {
            @Node.Child
            private Node removeNode = Message.REMOVE.createNode();
            @Node.Child
            private Node keyInfoNode = Message.KEY_INFO.createNode();

            private RemoveNode() {
            }

            @Override
            Object execute(TruffleObject[] scopes, int length, Object[] arguments, int offset) throws InteropException {
                String identifier = RemoveNode.expectIdentifier(arguments, offset, Message.REMOVE);
                if (this.isConstantSingleLength()) {
                    return ForeignAccess.sendRemove(this.removeNode, scopes[0], identifier);
                }
                if (length > 0) {
                    for (int i = 0; i < length; ++i) {
                        TruffleObject scopeObject = scopes[i];
                        int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, scopeObject, identifier);
                        if (KeyInfo.isRemovable(keyInfo)) {
                            return ForeignAccess.sendRemove(this.removeNode, scopeObject, identifier);
                        }
                        if (!KeyInfo.isExisting(keyInfo)) continue;
                        CompilerDirectives.transferToInterpreter();
                        throw UnsupportedMessageException.raise(Message.REMOVE);
                    }
                }
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(identifier);
            }
        }

        private static class WriteNode
        extends BaseNode {
            @Node.Child
            Node writeNode = Message.WRITE.createNode();
            @Node.Child
            Node keyInfoNode = Message.KEY_INFO.createNode();

            private WriteNode() {
            }

            @Override
            Object execute(TruffleObject[] scopes, int length, Object[] arguments, int offset) throws InteropException {
                String identifier = WriteNode.expectIdentifier(arguments, offset, Message.WRITE);
                Object value = arguments[offset + 1];
                if (this.isConstantSingleLength()) {
                    return ForeignAccess.sendWrite(this.writeNode, scopes[0], identifier, value);
                }
                if (length > 0) {
                    for (int i = 0; i < length; ++i) {
                        TruffleObject scopeObject = scopes[i];
                        if (!KeyInfo.isWritable(ForeignAccess.sendKeyInfo(this.keyInfoNode, scopeObject, identifier))) continue;
                        return ForeignAccess.sendWrite(this.writeNode, scopeObject, identifier, value);
                    }
                }
                throw UnsupportedMessageException.raise(Message.WRITE);
            }
        }

        private static class ReadNode
        extends BaseNode {
            @Node.Child
            Node readNode = Message.READ.createNode();
            @Node.Child
            Node keyInfoNode = Message.KEY_INFO.createNode();

            private ReadNode() {
            }

            @Override
            Object execute(TruffleObject[] scopes, int length, Object[] arguments, int offset) throws UnknownIdentifierException, UnsupportedMessageException {
                String identifier = ReadNode.expectIdentifier(arguments, offset, Message.READ);
                if (this.isConstantSingleLength()) {
                    return ForeignAccess.sendRead(this.readNode, scopes[0], identifier);
                }
                if (length > 0) {
                    for (int i = 0; i < length; ++i) {
                        TruffleObject scopeObject = scopes[i];
                        if (!KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfoNode, scopeObject, identifier))) continue;
                        return ForeignAccess.sendRead(this.readNode, scopeObject, identifier);
                    }
                }
                throw UnknownIdentifierException.raise(identifier);
            }
        }

        private static abstract class BaseNode
        extends RootNode {
            @CompilerDirectives.CompilationFinal
            boolean seenException = false;
            @CompilerDirectives.CompilationFinal
            int scopesLength = -1;

            protected BaseNode() {
                super(null);
            }

            @Override
            public final Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                PolyglotLanguageBindings bindings = (PolyglotLanguageBindings)arguments[0];
                TruffleObject[] scopes = bindings.scopes;
                int length = this.profileLength(scopes.length);
                try {
                    return this.execute(scopes, length, arguments, 1);
                }
                catch (InteropException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw e.raise();
                }
            }

            private int profileLength(int length) {
                if (this.scopesLength != -2) {
                    if (this.scopesLength == length) {
                        return this.scopesLength;
                    }
                    if (this.scopesLength == -1) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.scopesLength = length;
                    }
                }
                return length;
            }

            protected static final String expectIdentifier(Object[] arguments, int offset, Message message) {
                Object key = arguments[offset];
                if (!(key instanceof String)) {
                    CompilerDirectives.transferToInterpreter();
                    throw UnsupportedMessageException.raise(message);
                }
                return (String)key;
            }

            protected final boolean isConstantSingleLength() {
                return this.scopesLength == 1;
            }

            abstract Object execute(TruffleObject[] var1, int var2, Object[] var3, int var4) throws InteropException;
        }
    }
}

