/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotFunction;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotIllegalStateException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageBindings;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMap;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.PolyglotValue;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.proxy.Proxy;

final class PolyglotLanguageContext
implements PolyglotImpl.VMObject {
    private static final TruffleLogger LOG = TruffleLogger.getLogger("engine", PolyglotLanguageContext.class);
    final PolyglotContextImpl context;
    final PolyglotLanguage language;
    final boolean eventsEnabled;
    private volatile boolean creating;
    private volatile boolean initialized;
    volatile boolean finalized;
    @CompilerDirectives.CompilationFinal
    private volatile Value hostBindings;
    @CompilerDirectives.CompilationFinal
    private volatile Lazy lazy;
    @CompilerDirectives.CompilationFinal
    volatile TruffleLanguage.Env env;

    PolyglotLanguageContext(PolyglotContextImpl context, PolyglotLanguage language) {
        this.context = context;
        this.language = language;
        this.eventsEnabled = !language.isHost();
    }

    Thread.UncaughtExceptionHandler getPolyglotExceptionHandler() {
        assert (this.env != null);
        return this.lazy.uncaughtExceptionHandler;
    }

    Map<Class<?>, PolyglotValue> getValueCache() {
        assert (this.env != null);
        return this.lazy.valueCache;
    }

    PolyglotValue getDefaultValueCache() {
        assert (this.env != null);
        return this.lazy.defaultValueCache;
    }

    PolyglotLanguageInstance getLanguageInstance() {
        assert (this.env != null);
        return this.lazy.languageInstance;
    }

    private void checkThreadAccess(TruffleLanguage.Env localEnv) {
        assert (Thread.holdsLock(this.context));
        boolean singleThreaded = this.context.isSingleThreaded();
        Thread firstFailingThread = null;
        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
            if (VMAccessor.LANGUAGE.isThreadAccessAllowed(localEnv, threadInfo.thread, singleThreaded)) continue;
            firstFailingThread = threadInfo.thread;
            break;
        }
        if (firstFailingThread != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(firstFailingThread, singleThreaded, Arrays.asList(this.language));
        }
    }

    Object getContextImpl() {
        if (this.env != null) {
            return VMAccessor.LANGUAGE.getContext(this.env);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Value getHostBindings() {
        assert (this.initialized);
        if (this.hostBindings == null) {
            PolyglotLanguageContext polyglotLanguageContext = this;
            synchronized (polyglotLanguageContext) {
                if (this.hostBindings == null) {
                    Object prev = this.context.enterIfNeeded();
                    try {
                        Iterable<Scope> scopes = VMAccessor.LANGUAGE.findTopScopes(this.env);
                        this.hostBindings = this.asValue(new PolyglotLanguageBindings(scopes));
                    }
                    catch (Throwable t) {
                        throw PolyglotImpl.wrapGuestException(this, t);
                    }
                    finally {
                        this.context.leaveIfNeeded(prev);
                    }
                }
            }
        }
        return this.hostBindings;
    }

    Object getPolyglotGuestBindings() {
        assert (this.isInitialized());
        return this.lazy.polyglotGuestBindings;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    CallTarget parseCached(PolyglotLanguage accessingLanguage, Source source, String[] argumentNames) throws AssertionError {
        this.ensureInitialized(accessingLanguage);
        PolyglotSourceCache cache = this.lazy.sourceCache;
        assert (cache != null);
        return cache.parseCached(this, source, argumentNames);
    }

    TruffleLanguage.Env requireEnv() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv == null) {
            CompilerDirectives.transferToInterpreter();
            throw new AssertionError((Object)"No language context is active on this thread.");
        }
        return localEnv;
    }

    boolean finalizeContext() {
        if (!this.finalized) {
            this.finalized = true;
            VMAccessor.LANGUAGE.finalizeContext(this.env);
            if (this.eventsEnabled) {
                VMAccessor.INSTRUMENT.notifyLanguageContextFinalized(this.context.engine, this.context.truffleContext, this.language.info);
            }
            return true;
        }
        return false;
    }

    boolean dispose() {
        assert (Thread.holdsLock(this.context));
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv != null) {
            if (!this.lazy.activePolyglotThreads.isEmpty()) {
                throw new AssertionError((Object)("The language did not complete all polyglot threads but should have: " + this.lazy.activePolyglotThreads));
            }
            for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                assert (threadInfo.thread != null);
                if (threadInfo.isPolyglotThread(this.context)) continue;
                VMAccessor.LANGUAGE.disposeThread(localEnv, threadInfo.thread);
            }
            VMAccessor.LANGUAGE.dispose(localEnv);
            this.language.freeInstance(this.lazy.languageInstance);
            return true;
        }
        return false;
    }

    void notifyDisposed() {
        if (this.eventsEnabled) {
            VMAccessor.INSTRUMENT.notifyLanguageContextDisposed(this.context.engine, this.context.truffleContext, this.language.info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object enterThread(PolyglotThread thread) {
        assert (this.isInitialized());
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.lazy.activePolyglotThreads.add(thread);
            return this.context.enter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveThread(Object prev, PolyglotThread thread) {
        assert (this.isInitialized());
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            Map<Thread, PolyglotThreadInfo> seenThreads = this.context.getSeenThreads();
            PolyglotThreadInfo info = seenThreads.get(thread);
            if (info == null) {
                return;
            }
            for (PolyglotLanguageContext languageContext : this.context.contexts) {
                if (!languageContext.isInitialized()) continue;
                VMAccessor.LANGUAGE.disposeThread(languageContext.env, thread);
            }
            this.lazy.activePolyglotThreads.remove(thread);
            this.context.leave(prev);
            seenThreads.remove(thread);
        }
        VMAccessor.INSTRUMENT.notifyThreadFinished(this.context.engine, this.context.truffleContext, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCreated(PolyglotLanguage accessingLanguage) {
        if (this.creating) {
            throw new PolyglotIllegalStateException(String.format("Cyclic access to language context for language %s. The context is currently being created.", this.language.getId()));
        }
        if (this.lazy == null) {
            this.checkAccess(accessingLanguage);
            Map<String, Object> creatorConfig = this.context.creator == this.language ? this.context.creatorArguments : Collections.emptyMap();
            PolyglotContextConfig envConfig = this.context.config;
            PolyglotLanguageInstance lang = this.language.allocateInstance(envConfig.getOptionValues(this.language));
            try {
                PolyglotContextImpl polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    if (this.lazy == null) {
                        TruffleLanguage.Env localEnv = VMAccessor.LANGUAGE.createEnv(this, lang.spi, envConfig.out, envConfig.err, envConfig.in, creatorConfig, envConfig.getOptionValues(this.language), envConfig.getApplicationArguments(this.language), envConfig.fileSystem);
                        Lazy localLazy = new Lazy(lang);
                        PolyglotValue.createDefaultValueCaches(this, localLazy.valueCache);
                        this.checkThreadAccess(localEnv);
                        this.creating = true;
                        this.env = localEnv;
                        this.lazy = localLazy;
                        assert (VMAccessor.LANGUAGE.getLanguage(this.env) != null);
                        try {
                            VMAccessor.LANGUAGE.createEnvContext(localEnv);
                            lang.language.profile.notifyContextCreate(localEnv);
                            if (this.eventsEnabled) {
                                VMAccessor.INSTRUMENT.notifyLanguageContextCreated(this.context.engine, this.context.truffleContext, this.language.info);
                            }
                            lang = null;
                        }
                        catch (Throwable e) {
                            this.env = null;
                            this.lazy = null;
                            throw e;
                        }
                        finally {
                            this.creating = false;
                        }
                    }
                }
            }
            finally {
                if (lang != null) {
                    this.language.freeInstance(lang);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureInitialized(PolyglotLanguage accessingLanguage) {
        this.ensureCreated(accessingLanguage);
        boolean wasInitialized = false;
        if (!this.initialized) {
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                if (!this.initialized) {
                    this.initialized = true;
                    try {
                        if (!this.context.inContextPreInitialization) {
                            VMAccessor.LANGUAGE.initializeThread(this.env, Thread.currentThread());
                        }
                        VMAccessor.LANGUAGE.postInitEnv(this.env);
                        if (!this.context.isSingleThreaded()) {
                            VMAccessor.LANGUAGE.initializeMultiThreading(this.env);
                        }
                        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                            if (threadInfo.thread == Thread.currentThread()) continue;
                            VMAccessor.LANGUAGE.initializeThread(this.env, threadInfo.thread);
                        }
                        wasInitialized = true;
                    }
                    catch (Throwable e) {
                        this.initialized = false;
                        throw e;
                    }
                }
            }
        }
        if (wasInitialized && this.eventsEnabled) {
            VMAccessor.INSTRUMENT.notifyLanguageContextInitialized(this.context.engine, this.context.truffleContext, this.language.info);
        }
        return wasInitialized;
    }

    void checkAccess(PolyglotLanguage accessingLanguage) {
        boolean accessPermitted;
        this.context.engine.checkState();
        if (this.context.closed) {
            throw new PolyglotIllegalStateException("The Context is already closed.");
        }
        boolean bl = accessPermitted = this.language.isHost() || this.language.cache.isInternal() || this.context.config.allowedPublicLanguages.contains(this.language.info.getId()) || accessingLanguage != null && accessingLanguage.dependsOn(this.language);
        if (!accessPermitted) {
            throw new PolyglotIllegalArgumentException(String.format("Access to language '%s' is not permitted. ", this.language.getId()));
        }
        RuntimeException initError = this.language.initError;
        if (initError != null) {
            throw new PolyglotIllegalStateException(String.format("Initialization error: %s", initError.getMessage()), initError);
        }
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.context.getEngine();
    }

    void preInitialize() {
        this.ensureInitialized(null);
        LOG.log(Level.FINE, "Pre-initialized context for language: {0}", this.language.getId());
    }

    boolean patch(PolyglotContextConfig newConfig) {
        if (this.isInitialized()) {
            try {
                TruffleLanguage.Env newEnv = VMAccessor.LANGUAGE.patchEnvContext(this.env, newConfig.out, newConfig.err, newConfig.in, Collections.emptyMap(), newConfig.getOptionValues(this.language), newConfig.getApplicationArguments(this.language), newConfig.fileSystem);
                if (newEnv != null) {
                    this.env = newEnv;
                    LOG.log(Level.FINE, "Successfully patched context of language: {0}", this.language.getId());
                    return true;
                }
                LOG.log(Level.FINE, "Failed to patch context of language: {0}", this.language.getId());
                return false;
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw t;
                }
                LOG.log(Level.FINE, "Exception during patching context of language: {0}", this.language.getId());
                throw PolyglotImpl.wrapGuestException(this, t);
            }
        }
        return true;
    }

    static ToGuestValueNode createToGuestValue() {
        return new ToGuestValueNode();
    }

    @CompilerDirectives.TruffleBoundary
    Value asValue(Object guestValue) {
        assert (this.lazy != null);
        assert (guestValue != null);
        assert (!(guestValue instanceof Value));
        assert (!(guestValue instanceof Proxy));
        Object receiver = guestValue;
        PolyglotValue cache = this.lazy.valueCache.get(receiver.getClass());
        if (cache == null) {
            cache = this.lookupValueCache(guestValue);
        }
        return this.getAPIAccess().newValue(receiver, (AbstractPolyglotImpl.AbstractValueImpl)cache);
    }

    synchronized PolyglotValue lookupValueCache(final Object guestValue) {
        assert (this.toGuestValue(guestValue) == guestValue) : "Not a valid guest value: " + guestValue + ". Only interop values are allowed to be exported.";
        PolyglotValue cache = this.lazy.valueCache.computeIfAbsent(guestValue.getClass(), new Function<Class<?>, PolyglotValue>(){

            @Override
            public PolyglotValue apply(Class<?> t) {
                return PolyglotValue.createInteropValueCache(PolyglotLanguageContext.this, (TruffleObject)guestValue, guestValue.getClass());
            }
        });
        return cache;
    }

    ToHostValueNode createToHostValue() {
        return new ToHostValueNode();
    }

    Object toGuestValue(Class<?> receiver) {
        return HostObject.forClass(receiver, this);
    }

    Object toGuestValue(Object receiver) {
        if (receiver instanceof Value) {
            Value receiverValue = (Value)receiver;
            PolyglotValue valueImpl = (PolyglotValue)this.getAPIAccess().getImpl(receiverValue);
            if (valueImpl.languageContext.context != this.context) {
                CompilerDirectives.transferToInterpreter();
                throw PolyglotImpl.engineError(new IllegalArgumentException(String.format("Values cannot be passed from one context to another. The current value originates from context 0x%s and the argument originates from context 0x%s.", Integer.toHexString(this.context.hashCode()), Integer.toHexString(valueImpl.languageContext.context.hashCode()))));
            }
            return this.getAPIAccess().getReceiver(receiverValue);
        }
        if (PolyglotImpl.isGuestPrimitive(receiver)) {
            return receiver;
        }
        if (receiver instanceof Proxy) {
            return PolyglotProxy.toProxyGuestObject(this, (Proxy)receiver);
        }
        if (receiver instanceof TruffleObject) {
            return receiver;
        }
        if (receiver instanceof Class) {
            return HostObject.forClass((Class)receiver, this);
        }
        if (receiver == null) {
            return HostObject.NULL;
        }
        if (receiver.getClass().isArray()) {
            return HostObject.forObject(receiver, this);
        }
        if (receiver instanceof PolyglotList) {
            return ((PolyglotList)receiver).guestObject;
        }
        if (receiver instanceof PolyglotMap) {
            return ((PolyglotMap)receiver).guestObject;
        }
        if (receiver instanceof PolyglotFunction) {
            return ((PolyglotFunction)receiver).guestObject;
        }
        if (TruffleOptions.AOT) {
            return HostObject.forObject(receiver, this);
        }
        return HostInteropReflect.asTruffleViaReflection(receiver, this);
    }

    @CompilerDirectives.TruffleBoundary
    Value[] toHostValues(Object[] values, int startIndex) {
        Value[] args = new Value[values.length - startIndex];
        for (int i = startIndex; i < values.length; ++i) {
            args[i - startIndex] = this.asValue(values[i]);
        }
        return args;
    }

    @CompilerDirectives.TruffleBoundary
    Value[] toHostValues(Object[] values) {
        Value[] args = new Value[values.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.asValue(values[i]);
        }
        return args;
    }

    public String toString() {
        return "PolyglotLanguageContext [language=" + this.language + ", initialized=" + (this.env != null) + "]";
    }

    private class PolyglotUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private PolyglotUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            TruffleLanguage.Env currentEnv = PolyglotLanguageContext.this.env;
            if (currentEnv != null) {
                try {
                    e.printStackTrace(new PrintStream(currentEnv.err()));
                }
                catch (Throwable exc) {
                    e.printStackTrace();
                }
            } else {
                e.printStackTrace();
            }
        }
    }

    final class ToHostValueNode {
        final AbstractPolyglotImpl.APIAccess apiAccess;
        @CompilerDirectives.CompilationFinal
        volatile Class<?> cachedClass;
        @CompilerDirectives.CompilationFinal
        volatile PolyglotValue cachedValue;

        private ToHostValueNode() {
            this.apiAccess = PolyglotLanguageContext.this.context.engine.impl.getAPIAccess();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Value execute(Object value) {
            Object receiver = value;
            Class<?> cachedClassLocal = this.cachedClass;
            if (cachedClassLocal == Generic.class) return PolyglotLanguageContext.this.asValue(value);
            if (cachedClassLocal == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedClass = receiver.getClass();
                PolyglotValue cache = ((PolyglotLanguageContext)PolyglotLanguageContext.this).lazy.valueCache.get(receiver.getClass());
                if (cache == null) {
                    cache = PolyglotLanguageContext.this.lookupValueCache(receiver);
                }
                this.cachedValue = cache;
                return this.apiAccess.newValue(receiver, (AbstractPolyglotImpl.AbstractValueImpl)cache);
            }
            if (value.getClass() == cachedClassLocal) {
                receiver = CompilerDirectives.inInterpreter() ? receiver : CompilerDirectives.castExact(receiver, cachedClassLocal);
                PolyglotValue cache = this.cachedValue;
                if (cache != null) return this.apiAccess.newValue(receiver, (AbstractPolyglotImpl.AbstractValueImpl)cache);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return PolyglotLanguageContext.this.asValue(value);
            } else {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.cachedClass = Generic.class;
                this.cachedValue = null;
            }
            return PolyglotLanguageContext.this.asValue(value);
        }
    }

    static final class ToGuestValueNode {
        @CompilerDirectives.CompilationFinal
        private volatile Class<?> cachedClass;

        private ToGuestValueNode() {
        }

        public Object apply(PolyglotLanguageContext languageContext, Object receiver) {
            Class<Object> cachedClassLocal = this.cachedClass;
            if (cachedClassLocal == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (receiver == null) {
                    cachedClassLocal = Generic.class;
                    this.cachedClass = Generic.class;
                } else {
                    cachedClassLocal = receiver.getClass();
                    this.cachedClass = cachedClassLocal;
                }
            }
            if (cachedClassLocal != Generic.class) {
                assert (cachedClassLocal != null);
                if (receiver != null && cachedClassLocal == receiver.getClass()) {
                    return languageContext.toGuestValue(cachedClassLocal.cast(receiver));
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                cachedClassLocal = Generic.class;
                this.cachedClass = Generic.class;
            }
            return ToGuestValueNode.slowPath(languageContext, receiver);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object slowPath(PolyglotLanguageContext languageContext, Object receiver) {
            return languageContext.toGuestValue(receiver);
        }

        public static ToGuestValueNode create() {
            return new ToGuestValueNode();
        }
    }

    static final class Generic {
        private Generic() {
            throw new AssertionError((Object)"no instances");
        }
    }

    static final class ToGuestValuesNode {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private volatile ToGuestValueNode[] toGuestValue;
        @CompilerDirectives.CompilationFinal
        private volatile boolean needsCopy = false;
        @CompilerDirectives.CompilationFinal
        private volatile boolean generic = false;

        private ToGuestValuesNode() {
        }

        public Object[] apply(PolyglotLanguageContext languageContext, Object[] args) {
            ToGuestValueNode[] nodes = this.toGuestValue;
            if (nodes == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                nodes = new ToGuestValueNode[args.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodes[i] = PolyglotLanguageContext.createToGuestValue();
                }
                this.toGuestValue = nodes;
            }
            if (args.length == nodes.length) {
                if (nodes.length == 0) {
                    return args;
                }
                Object[] newArgs = this.fastToGuestValuesUnroll(nodes, languageContext, args);
                return newArgs;
            }
            if (!this.generic || nodes.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                nodes = Arrays.copyOf(nodes, 1);
                if (nodes[0] == null) {
                    nodes[0] = PolyglotLanguageContext.createToGuestValue();
                }
                this.toGuestValue = nodes;
                this.generic = true;
            }
            if (args.length == 0) {
                return args;
            }
            return this.fastToGuestValues(nodes[0], languageContext, args);
        }

        @ExplodeLoop
        private Object[] fastToGuestValuesUnroll(ToGuestValueNode[] nodes, PolyglotLanguageContext languageContext, Object[] args) {
            Object[] newArgs = this.needsCopy ? new Object[nodes.length] : args;
            for (int i = 0; i < nodes.length; ++i) {
                Object arg = args[i];
                Object newArg = nodes[i].apply(languageContext, arg);
                if (this.needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                newArgs = new Object[nodes.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
                this.needsCopy = true;
            }
            return newArgs;
        }

        private Object[] fastToGuestValues(ToGuestValueNode node, PolyglotLanguageContext languageContext, Object[] args) {
            assert (this.toGuestValue[0] != null);
            Object[] newArgs = this.needsCopy ? new Object[args.length] : args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object newArg = node.apply(languageContext, arg);
                if (this.needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                CompilerDirectives.transferToInterpreterAndInvalidate();
                newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
                this.needsCopy = true;
            }
            return newArgs;
        }

        public static ToGuestValuesNode create() {
            return new ToGuestValuesNode();
        }
    }

    final class Lazy {
        final PolyglotSourceCache sourceCache;
        final Map<Class<?>, PolyglotValue> valueCache = new ConcurrentHashMap();
        final PolyglotValue defaultValueCache;
        final Set<PolyglotThread> activePolyglotThreads;
        final Object polyglotGuestBindings;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        final PolyglotLanguageInstance languageInstance;

        Lazy(PolyglotLanguageInstance languageInstance) {
            this.languageInstance = languageInstance;
            this.sourceCache = languageInstance.getSourceCache();
            this.activePolyglotThreads = new HashSet<PolyglotThread>();
            this.defaultValueCache = new PolyglotValue.Default(PolyglotLanguageContext.this);
            this.polyglotGuestBindings = new PolyglotBindings(PolyglotLanguageContext.this, PolyglotLanguageContext.this.context.polyglotBindings);
            this.uncaughtExceptionHandler = new PolyglotUncaughtExceptionHandler();
        }
    }
}

