/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.VMAccessor;

final class PolyglotLanguageInstance {
    final PolyglotLanguage language;
    final TruffleLanguage<?> spi;
    private final PolyglotSourceCache sourceCache;
    private volatile OptionValuesImpl firstOptionValues;

    PolyglotLanguageInstance(PolyglotLanguage language) {
        this.language = language;
        try {
            this.spi = language.cache.loadLanguage();
            VMAccessor.LANGUAGE.initializeLanguage(this.spi, language.info, language);
            if (!language.engine.singleContext.isValid()) {
                this.initializeMultiContext();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Error initializing language '%s' using class '%s'.", language.cache.getId(), language.cache.getClassName()), e);
        }
        this.sourceCache = new PolyglotSourceCache();
    }

    boolean areOptionsCompatible(OptionValuesImpl newOptionValues) {
        OptionValuesImpl firstOptions = this.firstOptionValues;
        if (this.firstOptionValues == null) {
            return true;
        }
        return VMAccessor.LANGUAGE.areOptionsCompatible(this.spi, firstOptions, newOptionValues);
    }

    void claim(OptionValuesImpl optionValues) {
        assert (Thread.holdsLock(this.language.engine));
        if (this.firstOptionValues == null) {
            this.firstOptionValues = optionValues;
        }
    }

    void initializeMultiContext() {
        assert (!this.language.engine.singleContext.isValid());
        if (this.language.cache.getPolicy() != TruffleLanguage.ContextPolicy.EXCLUSIVE) {
            VMAccessor.LANGUAGE.initializeMultiContext(this.spi);
        }
    }

    PolyglotSourceCache getSourceCache() {
        return this.sourceCache;
    }
}

