/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.polyglot.HostEntryRootNode;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotListAndFunction;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;

class PolyglotList<T>
extends AbstractList<T> {
    final TruffleObject guestObject;
    final PolyglotLanguageContext languageContext;
    final Cache cache;

    PolyglotList(Class<T> elementClass, Type elementType, TruffleObject array, PolyglotLanguageContext languageContext) {
        this.guestObject = array;
        this.languageContext = languageContext;
        this.cache = Cache.lookup(languageContext, array.getClass(), elementClass, elementType);
    }

    @CompilerDirectives.TruffleBoundary
    public static <T> List<T> create(PolyglotLanguageContext languageContext, TruffleObject array, boolean implementFunction, Class<T> elementClass, Type elementType) {
        if (implementFunction) {
            return new PolyglotListAndFunction<T>(elementClass, elementType, array, languageContext);
        }
        return new PolyglotList<T>(elementClass, elementType, array, languageContext);
    }

    @Override
    public T get(int index) {
        return (T)this.cache.get.call(this.languageContext, this.guestObject, index);
    }

    @Override
    public T set(int index, T element) {
        T prev = this.get(index);
        this.cache.set.call(this.languageContext, this.guestObject, index, element);
        return prev;
    }

    @Override
    public T remove(int index) {
        return (T)this.cache.remove.call(this.languageContext, this.guestObject, index);
    }

    @Override
    public int size() {
        return (Integer)this.cache.size.call(this.languageContext, this.guestObject);
    }

    @Override
    public int hashCode() {
        return this.guestObject.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PolyglotList) {
            return this.languageContext.context == ((PolyglotList)o).languageContext.context && this.guestObject.equals(((PolyglotList)o).guestObject);
        }
        return false;
    }

    @Override
    public String toString() {
        try {
            return this.languageContext.asValue(this.guestObject).toString();
        }
        catch (UnsupportedOperationException e) {
            return super.toString();
        }
    }

    static final class Cache {
        final Class<?> receiverClass;
        final Class<?> valueClass;
        final Type valueType;
        final CallTarget get;
        final CallTarget set;
        final CallTarget remove;
        final CallTarget size;
        final CallTarget apply;

        Cache(Class<?> receiverClass, Class<?> valueClass, Type valueType) {
            this.receiverClass = receiverClass;
            this.valueClass = valueClass;
            this.valueType = valueType;
            this.get = Cache.initializeCall(new Get(this));
            this.size = Cache.initializeCall(new Size(this));
            this.set = Cache.initializeCall(new Set(this));
            this.remove = Cache.initializeCall(new Remove(this));
            this.apply = Cache.initializeCall(new Apply(this));
        }

        private static CallTarget initializeCall(PolyglotListNode node) {
            return HostEntryRootNode.createTarget(node);
        }

        static Cache lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> valueClass, Type valueType) {
            Key cacheKey = new Key(receiverClass, valueClass, valueType);
            Cache cache = HostEntryRootNode.lookupHostCodeCache(languageContext, cacheKey, Cache.class);
            if (cache == null) {
                cache = HostEntryRootNode.installHostCodeCache(languageContext, cacheKey, new Cache(receiverClass, valueClass, valueType), Cache.class);
            }
            assert (cache.receiverClass == receiverClass);
            assert (cache.valueClass == valueClass);
            assert (cache.valueType == valueType);
            return cache;
        }

        private static class Apply
        extends PolyglotListNode {
            @Node.Child
            private PolyglotExecuteNode apply = new PolyglotExecuteNode();

            Apply(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "apply";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject function, Object[] args, int offset) {
                return this.apply.execute(languageContext, function, args[offset], Object.class, (Type)((Object)Object.class));
            }
        }

        private static class Remove
        extends PolyglotListNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node remove = Message.REMOVE.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();

            Remove(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                assert (key instanceof Integer);
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    if (KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                        try {
                            result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                        }
                        catch (UnknownIdentifierException unknownIdentifierException) {
                        }
                        catch (UnsupportedMessageException unsupportedMessageException) {
                            // empty catch block
                        }
                    }
                    try {
                        ForeignAccess.sendRemove(this.remove, receiver, key);
                    }
                    catch (UnknownIdentifierException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "remove");
                    }
                    return this.cache.valueClass.cast(result);
                }
                CompilerDirectives.transferToInterpreter();
                throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "remove");
            }
        }

        private static class Set
        extends PolyglotListNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node write = Message.WRITE.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();
            private final PolyglotLanguageContext.ToGuestValueNode toGuest = PolyglotLanguageContext.ToGuestValueNode.create();

            Set(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "set";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                assert (key instanceof Integer);
                Object originalValue = args[offset + 1];
                Object value = this.toGuest.apply(languageContext, originalValue);
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    if (KeyInfo.isWritable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                        try {
                            ForeignAccess.sendWrite(this.write, receiver, key, value);
                        }
                        catch (UnknownIdentifierException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
                        }
                        catch (UnsupportedTypeException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.invalidListValue(languageContext, receiver, this.cache.valueType, (Integer)key, value);
                        }
                        return this.cache.valueClass.cast(result);
                    }
                    throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
                }
                throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "set");
            }
        }

        private static class Get
        extends PolyglotListNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();

            Get(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "get";
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                assert (key instanceof Integer);
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    if (KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                        try {
                            return this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                        }
                        catch (UnknownIdentifierException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "get()");
                        }
                    }
                    CompilerDirectives.transferToInterpreter();
                    throw HostInteropErrors.invalidListIndex(languageContext, receiver, this.cache.valueType, (Integer)key);
                }
                CompilerDirectives.transferToInterpreter();
                throw HostInteropErrors.listUnsupported(languageContext, receiver, this.cache.valueType, "get()");
            }
        }

        private static class Size
        extends PolyglotListNode {
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node hasSize = Message.HAS_SIZE.createNode();

            Size(Cache cache) {
                super(cache);
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                int size = 0;
                if (ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    try {
                        size = ((Number)ForeignAccess.sendGetSize(this.getSize, receiver)).intValue();
                    }
                    catch (UnsupportedMessageException e) {
                        size = 0;
                    }
                }
                return size;
            }

            @Override
            protected String getOperationName() {
                return "size";
            }
        }

        private static abstract class PolyglotListNode
        extends HostEntryRootNode<TruffleObject> {
            final Cache cache;

            PolyglotListNode(Cache cache) {
                this.cache = cache;
            }

            @Override
            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String getName() {
                return "PolyglotList<" + this.cache.receiverClass + ", " + this.cache.valueType + ">." + this.getOperationName();
            }

            protected abstract String getOperationName();
        }

        private static final class Key {
            final Class<?> receiverClass;
            final Class<?> valueClass;
            final Type valueType;

            Key(Class<?> receiverClass, Class<?> valueClass, Type valueType) {
                assert (receiverClass != null);
                this.receiverClass = receiverClass;
                this.valueClass = valueClass;
                this.valueType = valueType;
            }

            public int hashCode() {
                return 31 * (31 * (this.valueType == null ? 0 : this.valueType.hashCode()) + this.receiverClass.hashCode()) + this.valueClass.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.valueType == other.valueType && this.valueClass == other.valueClass && this.receiverClass == other.receiverClass;
            }
        }
    }
}

