/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.VMAccessor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;

final class PolyglotLogHandler
extends Handler {
    static final Handler INSTANCE = new PolyglotLogHandler();

    private PolyglotLogHandler() {
    }

    @Override
    public void publish(LogRecord record) {
        Handler handler = PolyglotLogHandler.findDelegate();
        if (handler != null) {
            handler.publish(record);
        }
    }

    @Override
    public void flush() {
        Handler handler = PolyglotLogHandler.findDelegate();
        if (handler != null) {
            handler.flush();
        }
    }

    @Override
    public void close() throws SecurityException {
        Handler handler = PolyglotLogHandler.findDelegate();
        if (handler != null) {
            handler.close();
        }
    }

    private static Handler findDelegate() {
        PolyglotContextImpl currentContext = PolyglotLogHandler.getCurrentOuterContext();
        return currentContext != null ? currentContext.config.logHandler : null;
    }

    static PolyglotContextImpl getCurrentOuterContext() {
        PolyglotContextImpl currentContext = PolyglotContextImpl.current();
        if (currentContext != null) {
            while (currentContext.parent != null) {
                currentContext = currentContext.parent;
            }
        }
        return currentContext;
    }

    static LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
        return new ImmutableLogRecord(level, loggerName, message, className, methodName, parameters, thrown);
    }

    static Handler createStreamHandler(OutputStream out, boolean closeStream, boolean flushOnPublish) {
        return new PolyglotStreamHandler(out, closeStream, flushOnPublish);
    }

    private static final class PolyglotStreamHandler
    extends StreamHandler {
        private final boolean closeStream;
        private final boolean flushOnPublish;

        PolyglotStreamHandler(OutputStream out, boolean closeStream, boolean flushOnPublish) {
            super(out, FormatterImpl.INSTANCE);
            this.setLevel(Level.ALL);
            this.closeStream = closeStream;
            this.flushOnPublish = flushOnPublish;
        }

        @Override
        public synchronized void publish(LogRecord record) {
            super.publish(record);
            if (this.flushOnPublish) {
                this.flush();
            }
        }

        @Override
        public void close() {
            if (this.closeStream) {
                super.close();
            } else {
                this.flush();
            }
        }

        private static final class FormatterImpl
        extends Formatter {
            private static final String FORMAT = "[%1$s] %2$s: %3$s%4$s%n";
            static final Formatter INSTANCE = new FormatterImpl();

            private FormatterImpl() {
            }

            @Override
            public String format(LogRecord record) {
                String loggerName = FormatterImpl.formatLoggerName(record.getLoggerName());
                String message = this.formatMessage(record);
                String stackTrace = "";
                Throwable exception = record.getThrown();
                if (exception != null) {
                    StringWriter str = new StringWriter();
                    try (PrintWriter out = new PrintWriter(str);){
                        out.println();
                        exception.printStackTrace(out);
                    }
                    stackTrace = str.toString();
                }
                return String.format(FORMAT, loggerName, record.getLevel().getName(), message, stackTrace);
            }

            private static String formatLoggerName(String loggerName) {
                String name;
                String id;
                int index = loggerName.indexOf(46);
                if (index < 0) {
                    id = loggerName;
                    name = "";
                } else {
                    id = loggerName.substring(0, index);
                    name = loggerName.substring(index + 1);
                }
                if (name.isEmpty()) {
                    return id;
                }
                StringBuilder sb = new StringBuilder(id);
                sb.append("::");
                sb.append(FormatterImpl.possibleSimpleName(name));
                return sb.toString();
            }

            private static String possibleSimpleName(String loggerName) {
                int index = -1;
                int i = 0;
                while (i >= 0) {
                    if (i + 1 < loggerName.length() && Character.isUpperCase(loggerName.charAt(i + 1))) {
                        index = i + 1;
                        break;
                    }
                    i = loggerName.indexOf(46, i + 1);
                }
                return index < 0 ? loggerName : loggerName.substring(index);
            }
        }
    }

    private static final class ImmutableLogRecord
    extends LogRecord {
        private static final long serialVersionUID = 1L;

        private ImmutableLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
            super(level, message);
            super.setLoggerName(loggerName);
            if (className != null) {
                super.setSourceClassName(className);
            }
            if (methodName != null) {
                super.setSourceMethodName(methodName);
            }
            Object[] copy = parameters;
            if (parameters != null && parameters.length > 0) {
                copy = new Object[parameters.length];
                PolyglotContextImpl context = PolyglotContextImpl.current();
                for (int i = 0; i < parameters.length; ++i) {
                    copy[i] = ImmutableLogRecord.safeValue(parameters[i], context);
                }
            }
            super.setParameters(copy);
            super.setThrown(thrown);
        }

        @Override
        public void setLevel(Level level) {
            throw new UnsupportedOperationException("Setting Level is not supported.");
        }

        @Override
        public void setLoggerName(String name) {
            throw new UnsupportedOperationException("Setting Logger Name is not supported.");
        }

        @Override
        public void setMessage(String message) {
            throw new UnsupportedOperationException("Setting Messag is not supported.");
        }

        @Override
        public void setMillis(long millis) {
            throw new UnsupportedOperationException("Setting Millis is not supported.");
        }

        @Override
        public void setParameters(Object[] parameters) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setResourceBundle(ResourceBundle bundle) {
            throw new UnsupportedOperationException("Setting Resource Bundle is not supported.");
        }

        @Override
        public void setResourceBundleName(String name) {
            throw new UnsupportedOperationException("Setting Resource Bundle Name is not supported.");
        }

        @Override
        public void setSequenceNumber(long seq) {
            throw new UnsupportedOperationException("Setting Sequence Number is not supported.");
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            throw new UnsupportedOperationException("Setting Parameters is not supported.");
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            throw new UnsupportedOperationException("Setting Source Method Name is not supported.");
        }

        @Override
        public void setThreadID(int threadID) {
            throw new UnsupportedOperationException("Setting Thread ID is not supported.");
        }

        @Override
        public void setThrown(Throwable thrown) {
            throw new UnsupportedOperationException("Setting Throwable is not supported.");
        }

        private static Object safeValue(Object param, PolyglotContextImpl context) {
            if (param == null || PolyglotImpl.EngineImpl.isPrimitive(param)) {
                return param;
            }
            if (param instanceof TruffleObject) {
                PolyglotLanguage resolvedLanguage = PolyglotImpl.EngineImpl.findObjectLanguage(context, null, param);
                PolyglotLanguageContext displayLanguageContext = resolvedLanguage != null ? context.contexts[resolvedLanguage.index] : context.getHostContext();
                return VMAccessor.LANGUAGE.toStringIfVisible(displayLanguageContext.env, param, false);
            }
            return param.toString();
        }
    }
}

