/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostEntryRootNode;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.PolyglotExecuteNode;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotList;
import com.oracle.truffle.polyglot.PolyglotMapAndFunction;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

class PolyglotMap<K, V>
extends AbstractMap<K, V> {
    final PolyglotLanguageContext languageContext;
    final TruffleObject guestObject;
    final Cache cache;

    PolyglotMap(PolyglotLanguageContext languageContext, TruffleObject obj, Class<K> keyClass, Class<V> valueClass, Type valueType) {
        this.guestObject = obj;
        this.languageContext = languageContext;
        this.cache = Cache.lookup(languageContext, obj.getClass(), keyClass, valueClass, valueType);
    }

    static <K, V> Map<K, V> create(PolyglotLanguageContext languageContext, TruffleObject foreignObject, boolean implementsFunction, Class<K> keyClass, Class<V> valueClass, Type valueType) {
        if (implementsFunction) {
            return new PolyglotMapAndFunction<K, V>(languageContext, foreignObject, keyClass, valueClass, valueType);
        }
        return new PolyglotMap<K, V>(languageContext, foreignObject, keyClass, valueClass, valueType);
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)this.cache.containsKey.call(this.languageContext, this.guestObject, key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return (Set)this.cache.entrySet.call(this.languageContext, this.guestObject, this);
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.get.call(this.languageContext, this.guestObject, key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.cache.put.call(this.languageContext, this.guestObject, key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.cache.remove.call(this.languageContext, this.guestObject, key);
    }

    @Override
    public String toString() {
        try {
            return this.languageContext.asValue(this.guestObject).toString();
        }
        catch (UnsupportedOperationException e) {
            return super.toString();
        }
    }

    @Override
    public int hashCode() {
        return this.guestObject.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PolyglotMap) {
            return this.languageContext.context == ((PolyglotMap)o).languageContext.context && this.guestObject.equals(((PolyglotMap)o).guestObject);
        }
        return false;
    }

    static final class Cache {
        final Class<?> receiverClass;
        final Class<?> keyClass;
        final Class<?> valueClass;
        final Type valueType;
        final boolean memberKey;
        final boolean numberKey;
        final CallTarget entrySet;
        final CallTarget get;
        final CallTarget put;
        final CallTarget remove;
        final CallTarget removeBoolean;
        final CallTarget containsKey;
        final CallTarget apply;

        Cache(Class<?> receiverClass, Class<?> keyClass, Class<?> valueClass, Type valueType) {
            this.receiverClass = receiverClass;
            this.keyClass = keyClass;
            this.valueClass = valueClass;
            this.valueType = valueType;
            this.memberKey = keyClass == Object.class || keyClass == String.class || keyClass == CharSequence.class;
            this.numberKey = keyClass == Object.class || keyClass == Number.class || keyClass == Integer.class || keyClass == Long.class || keyClass == Short.class || keyClass == Byte.class;
            this.get = Cache.initializeCall(new Get(this));
            this.containsKey = Cache.initializeCall(new ContainsKey(this));
            this.entrySet = Cache.initializeCall(new EntrySet(this));
            this.put = Cache.initializeCall(new Put(this));
            this.remove = Cache.initializeCall(new Remove(this));
            this.removeBoolean = Cache.initializeCall(new RemoveBoolean(this));
            this.apply = Cache.initializeCall(new Apply(this));
        }

        private static CallTarget initializeCall(PolyglotMapNode node) {
            return HostEntryRootNode.createTarget(node);
        }

        static Cache lookup(PolyglotLanguageContext languageContext, Class<?> receiverClass, Class<?> keyClass, Class<?> valueClass, Type valueType) {
            Key cacheKey = new Key(receiverClass, keyClass, valueType);
            Cache cache = HostEntryRootNode.lookupHostCodeCache(languageContext, cacheKey, Cache.class);
            if (cache == null) {
                cache = HostEntryRootNode.installHostCodeCache(languageContext, cacheKey, new Cache(receiverClass, keyClass, valueClass, valueType), Cache.class);
            }
            assert (cache.receiverClass == receiverClass);
            assert (cache.keyClass == keyClass);
            assert (cache.valueClass == valueClass);
            assert (cache.valueType == valueType);
            return cache;
        }

        private static class Apply
        extends PolyglotMapNode {
            @Node.Child
            private PolyglotExecuteNode apply = new PolyglotExecuteNode();

            Apply(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "apply";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject function, Object[] args, int offset) {
                return this.apply.execute(languageContext, function, args[offset], Object.class, (Type)((Object)Object.class));
            }
        }

        private static class RemoveBoolean
        extends PolyglotMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node remove = Message.REMOVE.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();

            RemoveBoolean(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                if (this.isValidKey(receiver, key)) {
                    if (args.length > offset + 1) {
                        Object value = args[offset + 1];
                        Object result = null;
                        int info = ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key);
                        if (KeyInfo.isReadable(info)) {
                            try {
                                result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {
                            }
                            catch (UnsupportedMessageException unsupportedMessageException) {
                                // empty catch block
                            }
                        }
                        if (!Objects.equals(value, result)) {
                            return false;
                        }
                    }
                    try {
                        return ForeignAccess.sendRemove(this.remove, receiver, key);
                    }
                    catch (UnknownIdentifierException e) {
                        return false;
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw HostInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                    }
                }
                CompilerDirectives.transferToInterpreter();
                if (this.cache.keyClass.isInstance(key) && (key instanceof Number || key instanceof String)) {
                    throw HostInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                }
                return false;
            }
        }

        private static class Remove
        extends PolyglotMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node remove = Message.REMOVE.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();

            Remove(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "remove";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                if (this.isValidKey(receiver, key)) {
                    int info = ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key);
                    if (KeyInfo.isReadable(info)) {
                        try {
                            result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                        }
                        catch (UnknownIdentifierException unknownIdentifierException) {
                        }
                        catch (UnsupportedMessageException unsupportedMessageException) {
                            // empty catch block
                        }
                    }
                    try {
                        boolean success = ForeignAccess.sendRemove(this.remove, receiver, key);
                        if (!success) {
                            return null;
                        }
                    }
                    catch (UnknownIdentifierException e) {
                        return null;
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw HostInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                    }
                    return this.cache.valueClass.cast(result);
                }
                CompilerDirectives.transferToInterpreter();
                if (this.cache.keyClass.isInstance(key) && (key instanceof Number || key instanceof String)) {
                    throw HostInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "remove");
                }
                return null;
            }
        }

        private static class Put
        extends PolyglotMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private Node write = Message.WRITE.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();
            private final PolyglotLanguageContext.ToGuestValueNode toGuest = PolyglotLanguageContext.ToGuestValueNode.create();

            Put(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "put";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                if (this.isValidKey(receiver, key)) {
                    Object value = args[offset + 1];
                    int info = ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key);
                    if (!KeyInfo.isExisting(info) || KeyInfo.isWritable(info) && KeyInfo.isReadable(info)) {
                        if (KeyInfo.isExisting(info)) {
                            try {
                                result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                            }
                            catch (UnknownIdentifierException unknownIdentifierException) {
                            }
                            catch (UnsupportedMessageException unsupportedMessageException) {
                                // empty catch block
                            }
                        }
                        Object guestValue = this.toGuest.apply(languageContext, value);
                        try {
                            ForeignAccess.sendWrite(this.write, receiver, key, guestValue);
                        }
                        catch (UnknownIdentifierException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.invalidMapIdentifier(languageContext, receiver, this.cache.keyClass, this.cache.valueType, key);
                        }
                        catch (UnsupportedMessageException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "put");
                        }
                        catch (UnsupportedTypeException e) {
                            CompilerDirectives.transferToInterpreter();
                            throw HostInteropErrors.invalidMapValue(languageContext, receiver, this.cache.keyClass, this.cache.valueType, key, guestValue);
                        }
                        return this.cache.valueClass.cast(result);
                    }
                }
                CompilerDirectives.transferToInterpreter();
                if (this.cache.keyClass.isInstance(key) && (key instanceof Number || key instanceof String)) {
                    throw HostInteropErrors.mapUnsupported(languageContext, receiver, this.cache.keyClass, this.cache.valueType, "put");
                }
                throw HostInteropErrors.invalidMapIdentifier(languageContext, receiver, this.cache.keyClass, this.cache.valueType, key);
            }
        }

        private static class Get
        extends PolyglotMapNode {
            @Node.Child
            private Node keyInfo = Message.KEY_INFO.createNode();
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node read = Message.READ.createNode();
            @Node.Child
            private ToHostNode toHost = ToHostNode.create();

            Get(Cache cache) {
                super(cache);
            }

            @Override
            protected String getOperationName() {
                return "get";
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                Object result = null;
                if (this.isValidKey(receiver, key) && KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key))) {
                    try {
                        result = this.toHost.execute(ForeignAccess.sendRead(this.read, receiver, key), this.cache.valueClass, this.cache.valueType, languageContext);
                    }
                    catch (ClassCastException | NullPointerException e) {
                        throw e;
                    }
                    catch (UnknownIdentifierException e) {
                        return null;
                    }
                    catch (UnsupportedMessageException e) {
                        return null;
                    }
                }
                return result;
            }
        }

        private static class EntrySet
        extends PolyglotMapNode {
            @Node.Child
            private Node getSize = Message.GET_SIZE.createNode();
            @Node.Child
            private Node keysNode = Message.KEYS.createNode();

            EntrySet(Cache cache) {
                super(cache);
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                List<String> keys = null;
                int keysSize = 0;
                int elemSize = 0;
                PolyglotMap originalMap = (PolyglotMap)args[offset];
                if (this.cache.memberKey && ForeignAccess.sendHasKeys(this.hasKeys, receiver)) {
                    TruffleObject truffleKeys;
                    try {
                        truffleKeys = ForeignAccess.sendKeys(this.keysNode, receiver);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        return Collections.emptySet();
                    }
                    keys = PolyglotList.create(languageContext, truffleKeys, false, String.class, null);
                    keysSize = keys.size();
                } else if (this.cache.numberKey && ForeignAccess.sendHasSize(this.hasSize, receiver)) {
                    try {
                        elemSize = ((Number)ForeignAccess.sendGetSize(this.getSize, receiver)).intValue();
                    }
                    catch (UnsupportedMessageException e) {
                        elemSize = 0;
                    }
                }
                PolyglotMap polyglotMap = originalMap;
                polyglotMap.getClass();
                return polyglotMap.new LazyEntries(keys, keysSize, elemSize);
            }

            @Override
            protected String getOperationName() {
                return "entrySet";
            }
        }

        private class ContainsKey
        extends PolyglotMapNode {
            @Node.Child
            private Node keyInfo;
            @Node.Child
            private Node getSize;

            ContainsKey(Cache cache2) {
                super(cache2);
                this.keyInfo = Message.KEY_INFO.createNode();
                this.getSize = Message.GET_SIZE.createNode();
            }

            @Override
            protected Object executeImpl(PolyglotLanguageContext languageContext, TruffleObject receiver, Object[] args, int offset) {
                Object key = args[offset];
                if (this.isValidKey(receiver, key)) {
                    return KeyInfo.isReadable(ForeignAccess.sendKeyInfo(this.keyInfo, receiver, key));
                }
                return false;
            }

            @Override
            protected String getOperationName() {
                return "containsKey";
            }
        }

        private static abstract class PolyglotMapNode
        extends HostEntryRootNode<TruffleObject> {
            final Cache cache;
            @Node.Child
            protected Node hasSize = Message.HAS_SIZE.createNode();
            @Node.Child
            protected Node hasKeys = Message.HAS_KEYS.createNode();
            private final ConditionProfile condition = ConditionProfile.createBinaryProfile();

            PolyglotMapNode(Cache cache) {
                this.cache = cache;
            }

            @Override
            protected Class<? extends TruffleObject> getReceiverType() {
                return this.cache.receiverClass;
            }

            @Override
            public final String getName() {
                return "PolyglotMap<" + this.cache.receiverClass + ", " + this.cache.keyClass + ", " + this.cache.valueType + ">." + this.getOperationName();
            }

            protected final boolean isValidKey(TruffleObject receiver, Object key) {
                return this.cache.keyClass.isInstance(key) && (this.cache.memberKey && this.condition.profile(ForeignAccess.sendHasKeys(this.hasKeys, receiver)) ? key instanceof String : this.cache.numberKey && key instanceof Number && ForeignAccess.sendHasSize(this.hasSize, receiver));
            }

            protected abstract String getOperationName();
        }

        private static final class Key {
            final Class<?> receiverClass;
            final Class<?> keyClass;
            final Type valueType;

            Key(Class<?> receiverClass, Class<?> keyClass, Type valueType) {
                assert (receiverClass != null);
                assert (keyClass != null);
                this.receiverClass = receiverClass;
                this.keyClass = keyClass;
                this.valueType = valueType;
            }

            public int hashCode() {
                return 31 * (31 * (31 + this.keyClass.hashCode()) + (this.valueType == null ? 0 : this.valueType.hashCode())) + this.receiverClass.hashCode();
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null || this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return this.keyClass == other.keyClass && this.valueType == other.valueType && this.receiverClass == other.receiverClass;
            }
        }
    }

    private final class EntryImpl
    implements Map.Entry<K, V> {
        private final K key;

        EntryImpl(K key) {
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return PolyglotMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return PolyglotMap.this.put(this.key, value);
        }

        public String toString() {
            return "Entry[key=" + this.key + ", value=" + PolyglotMap.this.get(this.key) + "]";
        }
    }

    private final class LazyEntries
    extends AbstractSet<Map.Entry<K, V>> {
        private final List<?> props;
        private final int keysSize;
        private final int elemSize;

        LazyEntries(List<?> keys, int keysSize, int elemSize) {
            assert (keys != null || keysSize == 0);
            this.props = keys;
            this.keysSize = keysSize;
            this.elemSize = elemSize;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            if (this.keysSize > 0 && this.elemSize > 0) {
                return new CombinedIterator();
            }
            if (this.keysSize > 0) {
                return new LazyKeysIterator();
            }
            return new ElementsIterator();
        }

        @Override
        public int size() {
            return (this.props != null ? this.props.size() : this.keysSize) + this.elemSize;
        }

        @Override
        public boolean contains(Object o) {
            return PolyglotMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                return (Boolean)PolyglotMap.this.cache.removeBoolean.call(PolyglotMap.this.languageContext, PolyglotMap.this.guestObject, e.getKey(), e.getValue());
            }
            return false;
        }

        private final class CombinedIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, V>> elemIter;
            private final Iterator<Map.Entry<K, V>> keysIter;
            private boolean isElemCurrent;

            private CombinedIterator() {
                this.elemIter = new ElementsIterator();
                this.keysIter = new LazyKeysIterator();
            }

            @Override
            public boolean hasNext() {
                return this.elemIter.hasNext() || this.keysIter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.elemIter.hasNext()) {
                    this.isElemCurrent = true;
                    return this.elemIter.next();
                }
                if (this.keysIter.hasNext()) {
                    this.isElemCurrent = false;
                    return this.keysIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.isElemCurrent) {
                    this.elemIter.remove();
                } else {
                    this.keysIter.remove();
                }
            }
        }

        private final class ElementsIterator
        implements Iterator<Map.Entry<K, V>> {
            private int index = 0;
            private boolean hasCurrentEntry;

            ElementsIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < LazyEntries.this.elemSize;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hasNext()) {
                    Number key = PolyglotMap.this.cache.keyClass == Long.class ? (Number)Long.valueOf(this.index) : (Number)this.index;
                    ++this.index;
                    this.hasCurrentEntry = true;
                    return new EntryImpl(PolyglotMap.this.cache.keyClass.cast(key));
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (!this.hasCurrentEntry) {
                    throw new IllegalStateException("No current entry.");
                }
                PolyglotMap.this.cache.removeBoolean.call(PolyglotMap.this.languageContext, PolyglotMap.this.guestObject, PolyglotMap.this.cache.keyClass.cast(this.index - 1));
                this.hasCurrentEntry = false;
            }
        }

        private final class LazyKeysIterator
        implements Iterator<Map.Entry<K, V>> {
            private final int size;
            private int index;
            private int currentIndex = -1;

            LazyKeysIterator() {
                this.size = LazyEntries.this.props != null ? LazyEntries.this.props.size() : LazyEntries.this.keysSize;
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.hasNext()) {
                    this.currentIndex = this.index;
                    Object key = LazyEntries.this.props.get(this.index++);
                    return new EntryImpl(key);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.currentIndex >= 0) {
                    LazyEntries.this.props.remove(this.currentIndex);
                    this.currentIndex = -1;
                    --this.index;
                } else {
                    throw new IllegalStateException("No current entry.");
                }
            }
        }
    }
}

