/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.util.concurrent.atomic.AtomicInteger;

final class PolyglotThread
extends Thread {
    private final PolyglotLanguageContext languageContext;
    Object context;
    private static final AtomicInteger THREAD_INIT_NUMBER = new AtomicInteger(0);

    PolyglotThread(PolyglotLanguageContext languageContext, Runnable runnable) {
        super(runnable, PolyglotThread.createDefaultName(languageContext));
        this.languageContext = languageContext;
        this.setUncaughtExceptionHandler(languageContext.getPolyglotExceptionHandler());
    }

    private static String createDefaultName(PolyglotLanguageContext creator) {
        return "Polyglot-" + creator.language.getId() + "-" + THREAD_INIT_NUMBER.getAndIncrement();
    }

    boolean isOwner(PolyglotContextImpl testContext) {
        return this.languageContext.context == testContext;
    }

    @Override
    public void run() {
        Object prev = this.languageContext.enterThread(this);
        assert (prev == null);
        try {
            super.run();
        }
        finally {
            this.languageContext.leaveThread(prev, this);
        }
    }
}

