/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.HostObject;
import com.oracle.truffle.polyglot.PolyglotArrayIndexOutOfBoundsException;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotClassCastException;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotIllegalArgumentException;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageBindings;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotNullPointerException;
import com.oracle.truffle.polyglot.PolyglotProxy;
import com.oracle.truffle.polyglot.PolyglotUnsupportedException;
import com.oracle.truffle.polyglot.ToHostNode;
import com.oracle.truffle.polyglot.VMAccessor;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class PolyglotValue
extends AbstractPolyglotImpl.AbstractValueImpl {
    private static final double DOUBLE_MAX_SAFE_INTEGER = 9.007199254740991E15;
    private static final long LONG_MAX_SAFE_DOUBLE = 0x1FFFFFFFFFFFFFL;
    private static final float FLOAT_MAX_SAFE_INTEGER = 1.6777215E7f;
    private static final int INT_MAX_SAFE_FLOAT = 0xFFFFFF;
    private static final String TRUNCATION_SUFFIX = "...";
    protected final PolyglotLanguageContext languageContext;
    private static final int CHARACTER_LIMIT = 140;

    PolyglotValue(PolyglotLanguageContext languageContext) {
        super((AbstractPolyglotImpl)languageContext.getEngine().impl);
        this.languageContext = languageContext;
    }

    public Value getMetaObject(Object receiver) {
        Object prev = this.languageContext.context.enterIfNeeded();
        try {
            Object metaObject = this.findMetaObject(receiver);
            if (metaObject != null) {
                Value value = this.newValue(metaObject);
                return value;
            }
            Value value = null;
            return value;
        }
        catch (Throwable e) {
            throw PolyglotImpl.wrapGuestException(this.languageContext, e);
        }
        finally {
            this.languageContext.context.leaveIfNeeded(prev);
        }
    }

    private Object findMetaObject(Object target) {
        if (target instanceof PolyglotLanguageBindings) {
            return this.languageContext.language.getName() + " Bindings";
        }
        if (target instanceof PolyglotBindings) {
            return "Polyglot Bindings";
        }
        PolyglotLanguage resolvedLanguage = PolyglotImpl.EngineImpl.findObjectLanguage(this.languageContext.context, this.languageContext, target);
        if (resolvedLanguage == null) {
            return null;
        }
        PolyglotLanguageContext resolvedLanguageContext = this.languageContext.context.getContext(resolvedLanguage);
        assert (resolvedLanguageContext != null);
        return VMAccessor.LANGUAGE.findMetaObject(resolvedLanguageContext.env, target);
    }

    protected RuntimeException unsupported(Object receiver, String message, String useToCheck) {
        Object prev = this.languageContext.context.enterIfNeeded();
        try {
            try {
                String polyglotMessage = useToCheck != null ? String.format("Unsupported operation %s.%s for %s. You can ensure that the operation is supported using %s.%s.", Value.class.getSimpleName(), message, PolyglotValue.getValueInfo(this.languageContext, receiver), Value.class.getSimpleName(), useToCheck) : String.format("Unsupported operation %s.%s for %s.", Value.class.getSimpleName(), message, PolyglotValue.getValueInfo(this.languageContext, receiver));
                throw new PolyglotUnsupportedException(polyglotMessage);
            }
            catch (Throwable e) {
                throw PolyglotImpl.wrapGuestException(this.languageContext, e);
            }
        }
        catch (Throwable throwable) {
            this.languageContext.context.leaveIfNeeded(prev);
            throw throwable;
        }
    }

    static String getValueInfo(PolyglotLanguageContext languageContext, Object receiver) {
        String languageName;
        String valueToString;
        String metaObjectToString;
        PolyglotLanguage displayLanguage;
        block19: {
            TruffleLanguage.Env displayEnv;
            block18: {
                PolyglotLanguageContext displayContext;
                block17: {
                    if (languageContext == null) {
                        return receiver.toString();
                    }
                    if (receiver == null) {
                        assert (false) : "receiver should never be null";
                        return "null";
                    }
                    displayLanguage = languageContext.language;
                    displayContext = languageContext;
                    if (!(receiver instanceof Number || receiver instanceof String || receiver instanceof Character || receiver instanceof Boolean)) {
                        try {
                            PolyglotLanguage resolvedDisplayLanguage = PolyglotImpl.EngineImpl.findObjectLanguage(languageContext.context, languageContext, receiver);
                            if (resolvedDisplayLanguage != null) {
                                displayLanguage = resolvedDisplayLanguage;
                            }
                            displayContext = languageContext.context.getContext(displayLanguage);
                        }
                        catch (Throwable e) {
                            if ($assertionsDisabled || PolyglotValue.rethrow(e)) break block17;
                            throw new AssertionError();
                        }
                    }
                }
                displayEnv = displayContext.env;
                metaObjectToString = "Unknown";
                if (displayEnv != null) {
                    try {
                        Object metaObject = VMAccessor.LANGUAGE.findMetaObject(displayEnv, receiver);
                        if (metaObject != null) {
                            metaObjectToString = PolyglotValue.truncateString(VMAccessor.LANGUAGE.toStringIfVisible(displayEnv, metaObject, false), 140);
                        }
                    }
                    catch (Throwable e) {
                        if ($assertionsDisabled || PolyglotValue.rethrow(e)) break block18;
                        throw new AssertionError();
                    }
                }
            }
            valueToString = "Unknown";
            try {
                valueToString = PolyglotValue.truncateString(VMAccessor.LANGUAGE.toStringIfVisible(displayEnv, receiver, false), 140);
            }
            catch (Throwable e) {
                if ($assertionsDisabled || PolyglotValue.rethrow(e)) break block19;
                throw new AssertionError();
            }
        }
        boolean hideType = false;
        if (displayLanguage.isHost()) {
            languageName = "Java";
            if (metaObjectToString.equals("java.lang.Void")) {
                hideType = true;
            }
        } else {
            languageName = displayLanguage.getName();
        }
        if (hideType) {
            return String.format("'%s'(language: %s)", valueToString, languageName);
        }
        return String.format("'%s'(language: %s, type: %s)", valueToString, languageName, metaObjectToString);
    }

    private static String truncateString(String s, int i) {
        if (s.length() > i) {
            return s.substring(0, i - TRUNCATION_SUFFIX.length()) + TRUNCATION_SUFFIX;
        }
        return s;
    }

    private static <T extends RuntimeException> boolean rethrow(Throwable e) throws T {
        throw (RuntimeException)e;
    }

    protected RuntimeException nullCoercion(Object receiver, Class<?> targetType, String message, String useToCheck) {
        Object prev = this.languageContext.context.enterIfNeeded();
        try {
            try {
                String valueInfo = PolyglotValue.getValueInfo(this.languageContext, receiver);
                throw new PolyglotNullPointerException(String.format("Cannot convert null value %s to Java type '%s' using %s.%s. You can ensure that the operation is supported using %s.%s.", valueInfo, targetType, Value.class.getSimpleName(), message, Value.class.getSimpleName(), useToCheck));
            }
            catch (Throwable e) {
                throw PolyglotImpl.wrapGuestException(this.languageContext, e);
            }
        }
        catch (Throwable throwable) {
            this.languageContext.context.leaveIfNeeded(prev);
            throw throwable;
        }
    }

    protected RuntimeException cannotConvert(Object receiver, Class<?> targetType, String message, String useToCheck, String reason) {
        Object prev = this.languageContext.context.enterIfNeeded();
        try {
            try {
                String valueInfo = PolyglotValue.getValueInfo(this.languageContext, receiver);
                String targetTypeString = "";
                if (targetType != null) {
                    targetTypeString = String.format("to Java type '%s'", targetType.getTypeName());
                }
                throw new PolyglotClassCastException(String.format("Cannot convert %s %s using %s.%s: %s You can ensure that the value can be converted using %s.%s.", valueInfo, targetTypeString, Value.class.getSimpleName(), message, reason, Value.class.getSimpleName(), useToCheck));
            }
            catch (Throwable e) {
                throw PolyglotImpl.wrapGuestException(this.languageContext, e);
            }
        }
        catch (Throwable throwable) {
            this.languageContext.context.leaveIfNeeded(prev);
            throw throwable;
        }
    }

    protected static RuntimeException invalidArrayIndex(PolyglotLanguageContext context, Object receiver, long index) {
        String message = String.format("Invalid array index %s for array %s.", index, PolyglotValue.getValueInfo(context, receiver));
        throw new PolyglotArrayIndexOutOfBoundsException(message);
    }

    protected static RuntimeException invalidArrayValue(PolyglotLanguageContext context, Object receiver, long identifier, Object value) {
        throw new PolyglotClassCastException(String.format("Invalid array value %s for array %s and index %s.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), identifier));
    }

    protected static RuntimeException invalidMemberKey(PolyglotLanguageContext context, Object receiver, String identifier) {
        String message = String.format("Invalid member key '%s' for object %s.", identifier, PolyglotValue.getValueInfo(context, receiver));
        throw new PolyglotIllegalArgumentException(message);
    }

    protected static RuntimeException invalidMemberValue(PolyglotLanguageContext context, Object receiver, String identifier, Object value) {
        String message = String.format("Invalid member value %s for object %s and member key '%s'.", PolyglotValue.getValueInfo(context, value), PolyglotValue.getValueInfo(context, receiver), identifier);
        throw new PolyglotIllegalArgumentException(message);
    }

    protected static RuntimeException invalidExecuteArgumentType(PolyglotLanguageContext context, Object receiver, UnsupportedTypeException e) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, e.getSuppliedValues());
        String message = String.format("Invalid argument when executing %s with arguments %s.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw new PolyglotIllegalArgumentException(message);
    }

    protected static RuntimeException invalidInstantiateArgumentType(PolyglotLanguageContext context, Object receiver, Object[] arguments) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument when instantiating %s with arguments %s.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs));
        throw new PolyglotIllegalArgumentException(message);
    }

    protected static RuntimeException invalidInstantiateArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when instantiating %s with arguments %s. Expected %s argument(s) but got %s.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw new PolyglotIllegalArgumentException(message);
    }

    protected static RuntimeException invalidExecuteArity(PolyglotLanguageContext context, Object receiver, Object[] arguments, int expected, int actual) {
        String[] formattedArgs = PolyglotValue.formatArgs(context, arguments);
        String message = String.format("Invalid argument count when executing %s with arguments %s. Expected %s argument(s) but got %s.", PolyglotValue.getValueInfo(context, receiver), Arrays.asList(formattedArgs), expected, actual);
        throw new PolyglotIllegalArgumentException(message);
    }

    private static String[] formatArgs(PolyglotLanguageContext context, Object[] arguments) {
        String[] formattedArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            formattedArgs[i] = PolyglotValue.getValueInfo(context, arguments[i]);
        }
        return formattedArgs;
    }

    public String toString(Object receiver) {
        Object prev = this.languageContext.context.enterIfNeeded();
        try {
            if (receiver instanceof PolyglotLanguageBindings) {
                String string = this.languageContext.language.getName() + " Bindings";
                return string;
            }
            if (receiver instanceof PolyglotBindings) {
                String string = "Polyglot Bindings";
                return string;
            }
            PolyglotLanguageContext displayLanguageContext = this.languageContext;
            PolyglotLanguage resolvedLanguage = PolyglotImpl.EngineImpl.findObjectLanguage(this.languageContext.context, this.languageContext, receiver);
            if (resolvedLanguage != null) {
                displayLanguageContext = this.languageContext.context.getContext(resolvedLanguage);
            }
            String string = VMAccessor.LANGUAGE.toStringIfVisible(displayLanguageContext.env, receiver, false);
            return string;
        }
        catch (Throwable e) {
            throw PolyglotImpl.wrapGuestException(this.languageContext, e);
        }
        finally {
            this.languageContext.context.leaveIfNeeded(prev);
        }
    }

    public org.graalvm.polyglot.SourceSection getSourceLocation(Object receiver) {
        Object prev = this.languageContext.context.enterIfNeeded();
        try {
            PolyglotLanguage resolvedLanguage = PolyglotImpl.EngineImpl.findObjectLanguage(this.languageContext.context, this.languageContext, receiver);
            if (resolvedLanguage == null) {
                org.graalvm.polyglot.SourceSection sourceSection = null;
                return sourceSection;
            }
            PolyglotLanguageContext resolvedLanguageContext = this.languageContext.context.getContext(resolvedLanguage);
            SourceSection result = VMAccessor.LANGUAGE.findSourceLocation(resolvedLanguageContext.env, receiver);
            org.graalvm.polyglot.SourceSection sourceSection = result != null ? VMAccessor.engine().createSourceSection(resolvedLanguageContext, null, result) : null;
            return sourceSection;
        }
        catch (Throwable t) {
            throw PolyglotImpl.wrapGuestException(this.languageContext, t);
        }
        finally {
            this.languageContext.context.leaveIfNeeded(prev);
        }
    }

    protected final Value newValue(Object receiver) {
        return this.languageContext.asValue(receiver);
    }

    static CallTarget createTarget(PolyglotNode root) {
        RootCallTarget target = Truffle.getRuntime().createCallTarget(root);
        Class<?>[] types = root.getArgumentTypes();
        if (types != null) {
            VMAccessor.SPI.initializeProfile(target, types);
        }
        return target;
    }

    static PolyglotValue createInteropValueCache(PolyglotLanguageContext languageContext, TruffleObject receiver, Class<?> receiverType) {
        return new Interop(languageContext, receiver, receiverType);
    }

    static void createDefaultValueCaches(PolyglotLanguageContext context, Map<Class<?>, PolyglotValue> valueCache) {
        valueCache.put(Boolean.class, new BooleanValueCache(context));
        valueCache.put(Byte.class, new ByteValueCache(context));
        valueCache.put(Short.class, new ShortValueCache(context));
        valueCache.put(Integer.class, new IntValueCache(context));
        valueCache.put(Long.class, new LongValueCache(context));
        valueCache.put(Float.class, new FloatValueCache(context));
        valueCache.put(Double.class, new DoubleValueCache(context));
        valueCache.put(String.class, new StringValueCache(context));
        valueCache.put(Character.class, new CharacterValueCache(context));
    }

    private static boolean inSafeIntegerRange(double d) {
        return d >= -9.007199254740991E15 && d <= 9.007199254740991E15;
    }

    private static boolean inSafeDoubleRange(long l) {
        return l >= -9007199254740991L && l <= 0x1FFFFFFFFFFFFFL;
    }

    private static boolean inSafeIntegerRange(float f) {
        return f >= -1.6777215E7f && f <= 1.6777215E7f;
    }

    private static boolean inSafeFloatRange(int i) {
        return i >= -16777215 && i <= 0xFFFFFF;
    }

    private static boolean inSafeFloatRange(long l) {
        return l >= -16777215L && l <= 0xFFFFFFL;
    }

    private static boolean isNegativeZero(double d) {
        return d == 0.0 && Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(-0.0);
    }

    private static boolean isNegativeZero(float f) {
        return f == 0.0f && Float.floatToRawIntBits(f) == Float.floatToRawIntBits(-0.0f);
    }

    private static final class Interop
    extends BaseCache {
        final Node keysNode = Message.KEYS.createNode();
        final Node keyInfoNode = Message.KEY_INFO.createNode();
        final Node keysSizeNode = Message.GET_SIZE.createNode();
        final Node keysReadNode = Message.READ.createNode();
        final CallTarget isNativePointer;
        final CallTarget asNativePointer;
        final CallTarget hasArrayElements;
        final CallTarget getArrayElement;
        final CallTarget setArrayElement;
        final CallTarget removeArrayElement;
        final CallTarget getArraySize;
        final CallTarget hasMembers;
        final CallTarget hasMember;
        final CallTarget getMember;
        final CallTarget putMember;
        final CallTarget removeMember;
        final CallTarget isNull;
        final CallTarget canExecute;
        final CallTarget execute;
        final CallTarget canInstantiate;
        final CallTarget newInstance;
        final CallTarget executeNoArgs;
        final CallTarget executeVoid;
        final CallTarget executeVoidNoArgs;
        final CallTarget asPrimitive;
        final boolean isProxy;
        final boolean isHost;

        Interop(PolyglotLanguageContext context, TruffleObject receiver, Class<?> receiverType) {
            super(context, receiverType);
            Objects.requireNonNull(receiverType);
            this.isNativePointer = Interop.createTarget(new IsNativePointerNode(this));
            this.asNativePointer = Interop.createTarget(new AsNativePointerNode(this));
            this.hasArrayElements = Interop.createTarget(new HasArrayElementsNode(this));
            this.getArrayElement = Interop.createTarget(new GetArrayElementNode(this));
            this.setArrayElement = Interop.createTarget(new SetArrayElementNode(this));
            this.removeArrayElement = Interop.createTarget(new RemoveArrayElementNode(this));
            this.getArraySize = Interop.createTarget(new GetArraySizeNode(this));
            this.hasMember = Interop.createTarget(new HasMemberNode(this));
            this.getMember = Interop.createTarget(new GetMemberNode(this));
            this.putMember = Interop.createTarget(new PutMemberNode(this));
            this.removeMember = Interop.createTarget(new RemoveMemberNode(this));
            this.isNull = Interop.createTarget(new IsNullNode(this));
            this.execute = Interop.createTarget(new ExecuteNode(this));
            this.executeNoArgs = Interop.createTarget(new ExecuteNoArgsNode(this));
            this.executeVoid = Interop.createTarget(new ExecuteVoidNode(this));
            this.executeVoidNoArgs = Interop.createTarget(new ExecuteVoidNoArgsNode(this));
            this.newInstance = Interop.createTarget(new NewInstanceNode(this));
            this.canInstantiate = Interop.createTarget(new CanInstantiateNode(this));
            this.canExecute = Interop.createTarget(new CanExecuteNode(this));
            this.hasMembers = Interop.createTarget(new HasMembersNode(this));
            this.asPrimitive = Interop.createTarget(new AsPrimitiveNode(this));
            this.isProxy = PolyglotProxy.isProxyGuestObject(receiver);
            this.isHost = HostObject.isInstance(receiver);
        }

        public boolean isNativePointer(Object receiver) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.isNativePointer, receiver);
        }

        public boolean hasArrayElements(Object receiver) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.hasArrayElements, receiver);
        }

        public Value getArrayElement(Object receiver, long index) {
            return (Value)VMAccessor.SPI.callProfiled(this.getArrayElement, receiver, index);
        }

        public void setArrayElement(Object receiver, long index, Object value) {
            VMAccessor.SPI.callProfiled(this.setArrayElement, receiver, index, value);
        }

        public boolean removeArrayElement(Object receiver, long index) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.removeArrayElement, receiver, index);
        }

        public long getArraySize(Object receiver) {
            return (Long)VMAccessor.SPI.callProfiled(this.getArraySize, receiver);
        }

        public boolean hasMembers(Object receiver) {
            return (Boolean)this.hasMembers.call(receiver);
        }

        public Value getMember(Object receiver, String key) {
            return (Value)VMAccessor.SPI.callProfiled(this.getMember, receiver, key);
        }

        public boolean hasMember(Object receiver, String key) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.hasMember, receiver, key);
        }

        public void putMember(Object receiver, String key, Object member) {
            VMAccessor.SPI.callProfiled(this.putMember, receiver, key, member);
        }

        public boolean removeMember(Object receiver, String key) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.removeMember, receiver, key);
        }

        public Set<String> getMemberKeys(Object receiver) {
            Object prev = this.languageContext.context.enterIfNeeded();
            try {
                TruffleObject keys = ForeignAccess.sendKeys(this.keysNode, (TruffleObject)receiver, false);
                if (!(keys instanceof TruffleObject)) {
                    Set<String> set = Collections.emptySet();
                    return set;
                }
                MemberSet memberSet = new MemberSet((TruffleObject)receiver, keys);
                return memberSet;
            }
            catch (UnsupportedMessageException e) {
                Set<String> set = Collections.emptySet();
                return set;
            }
            catch (Throwable e) {
                throw PolyglotImpl.wrapGuestException(this.languageContext, e);
            }
            finally {
                this.languageContext.context.leaveIfNeeded(prev);
            }
        }

        public long asNativePointer(Object receiver) {
            return (Long)VMAccessor.SPI.callProfiled(this.asNativePointer, receiver);
        }

        public boolean isHostObject(Object receiver) {
            return this.isHost;
        }

        public boolean isProxyObject(Object receiver) {
            return this.isProxy;
        }

        public Object asProxyObject(Object receiver) {
            if (this.isProxy) {
                return PolyglotProxy.toProxyHostObject((TruffleObject)receiver);
            }
            return super.asProxyObject(receiver);
        }

        public Object asHostObject(Object receiver) {
            if (this.isHost) {
                return ((HostObject)receiver).obj;
            }
            return super.asHostObject(receiver);
        }

        public boolean isNull(Object receiver) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.isNull, receiver);
        }

        public boolean canExecute(Object receiver) {
            return (Boolean)VMAccessor.SPI.callProfiled(this.canExecute, receiver);
        }

        public void executeVoid(Object receiver, Object[] arguments) {
            VMAccessor.SPI.callProfiled(this.executeVoid, receiver, arguments);
        }

        public void executeVoid(Object receiver) {
            VMAccessor.SPI.callProfiled(this.executeVoidNoArgs, receiver);
        }

        public Value execute(Object receiver, Object[] arguments) {
            return (Value)VMAccessor.SPI.callProfiled(this.execute, receiver, arguments);
        }

        public Value execute(Object receiver) {
            return (Value)VMAccessor.SPI.callProfiled(this.executeNoArgs, receiver);
        }

        public boolean canInstantiate(Object receiver) {
            return (Boolean)this.canInstantiate.call(receiver);
        }

        public Value newInstance(Object receiver, Object[] arguments) {
            return (Value)this.newInstance.call(receiver, arguments);
        }

        private Object asPrimitive(Object receiver) {
            return VMAccessor.SPI.callProfiled(this.asPrimitive, receiver);
        }

        private PolyglotValue getPrimitiveCache(Object primitive) {
            assert (primitive != null);
            PolyglotValue cache = this.languageContext.getValueCache().get(primitive.getClass());
            if (cache == null) {
                cache = this.languageContext.getDefaultValueCache();
            }
            return cache;
        }

        public boolean isNumber(Object receiver) {
            return this.asPrimitive(receiver) instanceof Number;
        }

        public boolean fitsInByte(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.fitsInByte(receiver);
            }
            return this.getPrimitiveCache(primitive).fitsInByte(primitive);
        }

        public byte asByte(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asByte(receiver);
            }
            return this.getPrimitiveCache(primitive).asByte(primitive);
        }

        public boolean isString(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.isString(receiver);
            }
            return this.getPrimitiveCache(primitive).isString(primitive);
        }

        public String asString(Object receiver) {
            if (this.isNull(receiver)) {
                return null;
            }
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asString(receiver);
            }
            return this.getPrimitiveCache(primitive).asString(primitive);
        }

        public boolean fitsInInt(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.fitsInInt(receiver);
            }
            return this.getPrimitiveCache(primitive).fitsInInt(primitive);
        }

        public int asInt(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asInt(receiver);
            }
            return this.getPrimitiveCache(primitive).asInt(primitive);
        }

        public boolean isBoolean(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.isBoolean(receiver);
            }
            return this.getPrimitiveCache(primitive).isBoolean(primitive);
        }

        public boolean asBoolean(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asBoolean(receiver);
            }
            return this.getPrimitiveCache(primitive).asBoolean(primitive);
        }

        public boolean fitsInFloat(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.fitsInFloat(receiver);
            }
            return this.getPrimitiveCache(primitive).fitsInFloat(primitive);
        }

        public float asFloat(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asFloat(receiver);
            }
            return this.getPrimitiveCache(primitive).asFloat(primitive);
        }

        public boolean fitsInDouble(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.fitsInDouble(receiver);
            }
            return this.getPrimitiveCache(primitive).fitsInDouble(primitive);
        }

        public double asDouble(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asDouble(receiver);
            }
            return this.getPrimitiveCache(primitive).asDouble(primitive);
        }

        public boolean fitsInLong(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.fitsInLong(receiver);
            }
            return this.getPrimitiveCache(primitive).fitsInLong(primitive);
        }

        public long asLong(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asLong(receiver);
            }
            return this.getPrimitiveCache(primitive).asLong(primitive);
        }

        public boolean fitsInShort(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.fitsInShort(receiver);
            }
            return this.getPrimitiveCache(primitive).fitsInShort(primitive);
        }

        public short asShort(Object receiver) {
            Object primitive = this.asPrimitive(receiver);
            if (primitive == null) {
                return super.asShort(receiver);
            }
            return this.getPrimitiveCache(primitive).asShort(primitive);
        }

        private final class MemberSet
        extends AbstractSet<String> {
            private final TruffleObject receiver;
            private final TruffleObject keys;
            private int cachedSize = -1;

            MemberSet(TruffleObject receiver, TruffleObject keys) {
                this.receiver = receiver;
                this.keys = keys;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof String)) {
                    return false;
                }
                Object prev = Interop.this.languageContext.context.enterIfNeeded();
                try {
                    int keyInfo = ForeignAccess.sendKeyInfo(Interop.this.keyInfoNode, this.receiver, o);
                    boolean bl = KeyInfo.isExisting(keyInfo);
                    return bl;
                }
                catch (Throwable e) {
                    throw PolyglotImpl.wrapGuestException(Interop.this.languageContext, e);
                }
                finally {
                    Interop.this.languageContext.context.leaveIfNeeded(prev);
                }
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MemberSet.this.size();
                    }

                    @Override
                    public String next() {
                        if (this.index >= MemberSet.this.size()) {
                            throw new NoSuchElementException();
                        }
                        Object prev = Interop.this.languageContext.context.enterIfNeeded();
                        try {
                            Object result = ForeignAccess.sendRead(Interop.this.keysReadNode, MemberSet.this.keys, this.index);
                            if (!(result instanceof String) && !(result instanceof Character)) {
                                throw PolyglotImpl.wrapHostException(Interop.this.languageContext, new ClassCastException("Cannot cast " + result + " to String."));
                            }
                            ++this.index;
                            String string = result.toString();
                            return string;
                        }
                        catch (UnknownIdentifierException | UnsupportedMessageException e) {
                            try {
                                throw new AssertionError((Object)"Implementation error: Language must support read messages for keys objects.");
                            }
                            catch (Throwable e2) {
                                throw PolyglotImpl.wrapGuestException(Interop.this.languageContext, e2);
                            }
                        }
                        finally {
                            Interop.this.languageContext.context.leaveIfNeeded(prev);
                        }
                    }
                };
            }

            @Override
            public int size() {
                if (this.cachedSize != -1) {
                    return this.cachedSize;
                }
                Object prev = Interop.this.languageContext.context.enterIfNeeded();
                try {
                    try {
                        this.cachedSize = ((Number)ForeignAccess.sendGetSize(Interop.this.keysSizeNode, this.keys)).intValue();
                    }
                    catch (UnsupportedMessageException e) {
                        int n = 0;
                        Interop.this.languageContext.context.leaveIfNeeded(prev);
                        return n;
                    }
                    int e = this.cachedSize;
                    return e;
                }
                catch (Throwable e) {
                    throw PolyglotImpl.wrapGuestException(Interop.this.languageContext, e);
                }
                finally {
                    Interop.this.languageContext.context.leaveIfNeeded(prev);
                }
            }
        }

        private static class NewInstanceNode
        extends PolyglotNode {
            @Node.Child
            private Node newInstanceNode = Message.NEW.createNode();
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected NewInstanceNode(Interop interop) {
                super(interop);
                this.toHostValue = this.polyglot.languageContext.createToHostValue();
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                Object[] instantiateArguments = this.toGuestValues.apply(this.polyglot.languageContext, (Object[])args[1]);
                try {
                    return this.toHostValue.execute(ForeignAccess.sendNew(this.newInstanceNode, (TruffleObject)receiver, instantiateArguments));
                }
                catch (UnsupportedTypeException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidInstantiateArgumentType(this.polyglot.languageContext, receiver, args);
                }
                catch (ArityException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidInstantiateArity(this.polyglot.languageContext, receiver, args, e.getExpectedArity(), e.getActualArity());
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    return this.polyglot.newInstanceUnsupported(receiver);
                }
            }

            @Override
            protected String getOperationName() {
                return "newInstance";
            }
        }

        private static class ExecuteNoArgsNode
        extends AbstractExecuteNode {
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected ExecuteNoArgsNode(Interop interop) {
                super(interop);
                this.toHostValue = this.polyglot.languageContext.createToHostValue();
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return this.toHostValue.execute(this.executeShared(receiver, ExecuteVoidNoArgsNode.NO_ARGS));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        private static class ExecuteNode
        extends AbstractExecuteNode {
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected ExecuteNode(Interop interop) {
                super(interop);
                this.toHostValue = this.polyglot.languageContext.createToHostValue();
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return this.toHostValue.execute(this.executeShared(receiver, (Object[])args[1]));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        private static class ExecuteVoidNoArgsNode
        extends AbstractExecuteNode {
            private static final Object[] NO_ARGS = new Object[0];

            protected ExecuteVoidNoArgsNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                this.executeShared(receiver, NO_ARGS);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        private static class ExecuteVoidNode
        extends AbstractExecuteNode {
            protected ExecuteVoidNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Object[].class};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                this.executeShared(receiver, (Object[])args[1]);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        private static abstract class AbstractExecuteNode
        extends PolyglotNode {
            @Node.Child
            private Node executeNode = Message.EXECUTE.createNode();
            private final PolyglotLanguageContext.ToGuestValuesNode toGuestValues = PolyglotLanguageContext.ToGuestValuesNode.create();

            protected AbstractExecuteNode(Interop interop) {
                super(interop);
            }

            protected final Object executeShared(Object receiver, Object[] args) {
                Object[] guestArguments = this.toGuestValues.apply(this.polyglot.languageContext, args);
                try {
                    return ForeignAccess.sendExecute(this.executeNode, (TruffleObject)receiver, guestArguments);
                }
                catch (UnsupportedTypeException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidExecuteArgumentType(this.polyglot.languageContext, receiver, e);
                }
                catch (ArityException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidExecuteArity(this.polyglot.languageContext, receiver, guestArguments, e.getExpectedArity(), e.getActualArity());
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    return this.polyglot.executeUnsupported(receiver);
                }
            }
        }

        private static class AsPrimitiveNode
        extends PolyglotNode {
            @Node.Child
            private Node isBoxedNode = Message.IS_BOXED.createNode();
            @Node.Child
            private Node unboxNode = Message.UNBOX.createNode();

            protected AsPrimitiveNode(Interop interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "asPrimitive";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                if (ForeignAccess.sendIsBoxed(this.isBoxedNode, (TruffleObject)receiver)) {
                    try {
                        return ForeignAccess.sendUnbox(this.unboxNode, (TruffleObject)receiver);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                        throw new AssertionError((Object)"isBoxed returned true but unbox threw unsupported error.");
                    }
                }
                return null;
            }
        }

        private static class CanInstantiateNode
        extends PolyglotNode {
            @Node.Child
            private Node isInstantiableNode = Message.IS_INSTANTIABLE.createNode();

            protected CanInstantiateNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "canInstantiate";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return ForeignAccess.sendIsInstantiable(this.isInstantiableNode, (TruffleObject)receiver);
            }
        }

        private static class CanExecuteNode
        extends PolyglotNode {
            @Node.Child
            private Node isExecutableNode = Message.IS_EXECUTABLE.createNode();

            protected CanExecuteNode(Interop interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canExecute";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return ForeignAccess.sendIsExecutable(this.isExecutableNode, (TruffleObject)receiver);
            }
        }

        private static class HasMemberNode
        extends PolyglotNode {
            final Node keyInfoNode = Message.KEY_INFO.createNode();

            protected HasMemberNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "hasMember";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                String key = (String)args[1];
                int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, (TruffleObject)receiver, key);
                return KeyInfo.isExisting(keyInfo);
            }
        }

        private static class HasMembersNode
        extends PolyglotNode {
            @Node.Child
            private Node hasKeysNode = Message.HAS_KEYS.createNode();

            protected HasMembersNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasMembers";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return ForeignAccess.sendHasKeys(this.hasKeysNode, (TruffleObject)receiver);
            }
        }

        private static class IsNullNode
        extends PolyglotNode {
            @Node.Child
            private Node isNullNode = Message.IS_NULL.createNode();

            protected IsNullNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNull";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return ForeignAccess.sendIsNull(this.isNullNode, (TruffleObject)receiver);
            }
        }

        private static class RemoveMemberNode
        extends PolyglotNode {
            @Node.Child
            private Node removeMemberNode = Message.REMOVE.createNode();
            @Node.Child
            private Node keyInfoNode = Message.KEY_INFO.createNode();
            @Node.Child
            private Node hasKeysNode = Message.HAS_KEYS.createNode();
            @CompilerDirectives.CompilationFinal
            private boolean optimistic = true;

            protected RemoveMemberNode(Interop interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "removeMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, String.class};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                block7: {
                    String key = (String)args[1];
                    TruffleObject truffleReceiver = (TruffleObject)receiver;
                    try {
                        if (this.optimistic) {
                            return ForeignAccess.sendRemove(this.removeMemberNode, truffleReceiver, key);
                        }
                        int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, truffleReceiver, key);
                        if (KeyInfo.isRemovable(keyInfo)) {
                            return ForeignAccess.sendRemove(this.removeMemberNode, truffleReceiver, key);
                        }
                        if (KeyInfo.isExisting(keyInfo) || !ForeignAccess.sendHasKeys(this.hasKeysNode, truffleReceiver)) {
                            CompilerDirectives.transferToInterpreter();
                            return this.polyglot.getMemberUnsupported(receiver, key);
                        }
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException e) {
                        if (this.optimistic) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.optimistic = false;
                        } else {
                            CompilerDirectives.transferToInterpreter();
                        }
                        int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, truffleReceiver, key);
                        if (!KeyInfo.isExisting(keyInfo) && ForeignAccess.sendHasKeys(this.hasKeysNode, truffleReceiver)) break block7;
                        this.polyglot.removeMemberUnsupported(receiver);
                    }
                }
                return false;
            }
        }

        private static class PutMemberNode
        extends PolyglotNode {
            @Node.Child
            private Node writeMemberNode = Message.WRITE.createNode();
            private final PolyglotLanguageContext.ToGuestValueNode toGuestValue = PolyglotLanguageContext.ToGuestValueNode.create();

            protected PutMemberNode(Interop interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "putMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, String.class, null};
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                String key = (String)args[1];
                Object originalValue = args[2];
                Object value = this.toGuestValue.apply(this.polyglot.languageContext, originalValue);
                try {
                    ForeignAccess.sendWrite(this.writeMemberNode, (TruffleObject)receiver, key, value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    this.polyglot.putMemberUnsupported(receiver);
                }
                catch (UnknownIdentifierException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidMemberKey(this.polyglot.languageContext, receiver, key);
                }
                catch (UnsupportedTypeException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidMemberValue(this.polyglot.languageContext, receiver, key, value);
                }
                return null;
            }
        }

        private static class GetMemberNode
        extends PolyglotNode {
            @Node.Child
            private Node readMemberNode = Message.READ.createNode();
            @Node.Child
            private Node keyInfoNode = Message.KEY_INFO.createNode();
            @Node.Child
            private Node hasKeysNode = Message.HAS_KEYS.createNode();
            @CompilerDirectives.CompilationFinal
            private boolean optimistic = true;
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected GetMemberNode(Interop interop) {
                super(interop);
                this.toHostValue = this.polyglot.languageContext.createToHostValue();
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "getMember";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                Value value;
                String key = (String)args[1];
                TruffleObject truffleReceiver = (TruffleObject)receiver;
                try {
                    if (this.optimistic) {
                        value = this.toHostValue.execute(ForeignAccess.sendRead(this.readMemberNode, truffleReceiver, key));
                    } else {
                        int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, truffleReceiver, key);
                        if (KeyInfo.isReadable(keyInfo)) {
                            value = this.toHostValue.execute(ForeignAccess.sendRead(this.readMemberNode, truffleReceiver, key));
                        } else {
                            if (KeyInfo.isExisting(keyInfo) || !ForeignAccess.sendHasKeys(this.hasKeysNode, truffleReceiver)) {
                                CompilerDirectives.transferToInterpreter();
                                return this.polyglot.getMemberUnsupported(receiver, key);
                            }
                            value = null;
                        }
                    }
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    if (this.optimistic) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.optimistic = false;
                    } else {
                        CompilerDirectives.transferToInterpreter();
                    }
                    int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, truffleReceiver, key);
                    if (KeyInfo.isExisting(keyInfo) || !ForeignAccess.sendHasKeys(this.hasKeysNode, truffleReceiver)) {
                        return this.polyglot.getMemberUnsupported(receiver, key);
                    }
                    value = null;
                }
                return value;
            }
        }

        private static class GetArraySizeNode
        extends PolyglotNode {
            @Node.Child
            private Node getSizeNode = Message.GET_SIZE.createNode();

            protected GetArraySizeNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getArraySize";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                try {
                    return ((Number)ForeignAccess.sendGetSize(this.getSizeNode, (TruffleObject)receiver)).longValue();
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    return this.polyglot.getArraySizeUnsupported(receiver);
                }
            }
        }

        private static class RemoveArrayElementNode
        extends PolyglotNode {
            @Node.Child
            private Node removeArrayNode = Message.REMOVE.createNode();
            @Node.Child
            private Node keyInfoNode = Message.KEY_INFO.createNode();
            @Node.Child
            private Node hasSizeNode = Message.HAS_SIZE.createNode();
            @CompilerDirectives.CompilationFinal
            private boolean optimistic = true;

            protected RemoveArrayElementNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "removeArrayElement";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                long index;
                block7: {
                    index = (Long)args[1];
                    TruffleObject truffleReceiver = (TruffleObject)receiver;
                    try {
                        if (this.optimistic) {
                            return ForeignAccess.sendRemove(this.removeArrayNode, (TruffleObject)receiver, index);
                        }
                        int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, truffleReceiver, index);
                        if (KeyInfo.isRemovable(keyInfo)) {
                            return ForeignAccess.sendRemove(this.removeArrayNode, (TruffleObject)receiver, index);
                        }
                        if (KeyInfo.isExisting(keyInfo) || !ForeignAccess.sendHasSize(this.hasSizeNode, truffleReceiver)) {
                            CompilerDirectives.transferToInterpreter();
                            this.polyglot.removeArrayElementUnsupported(receiver);
                        }
                    }
                    catch (UnknownIdentifierException | UnsupportedMessageException e) {
                        if (this.optimistic) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.optimistic = false;
                        } else {
                            CompilerDirectives.transferToInterpreter();
                        }
                        int keyInfo = ForeignAccess.sendKeyInfo(this.keyInfoNode, truffleReceiver, index);
                        if (!KeyInfo.isExisting(keyInfo) && ForeignAccess.sendHasSize(this.hasSizeNode, truffleReceiver)) break block7;
                        this.polyglot.removeArrayElementUnsupported(receiver);
                    }
                }
                CompilerDirectives.transferToInterpreter();
                throw PolyglotValue.invalidArrayIndex(this.polyglot.languageContext, receiver, index);
            }
        }

        private static class SetArrayElementNode
        extends PolyglotNode {
            @Node.Child
            private Node writeArrayNode = Message.WRITE.createNode();
            private final PolyglotLanguageContext.ToGuestValueNode toGuestValue = PolyglotLanguageContext.ToGuestValueNode.create();

            protected SetArrayElementNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Long.class, null};
            }

            @Override
            protected String getOperationName() {
                return "setArrayElement";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                long index = (Long)args[1];
                Object value = this.toGuestValue.apply(this.polyglot.languageContext, args[2]);
                try {
                    ForeignAccess.sendWrite(this.writeArrayNode, (TruffleObject)receiver, index, value);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    this.polyglot.setArrayElementUnsupported(receiver);
                }
                catch (UnknownIdentifierException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidArrayIndex(this.polyglot.languageContext, receiver, index);
                }
                catch (UnsupportedTypeException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidArrayValue(this.polyglot.languageContext, receiver, index, value);
                }
                return null;
            }
        }

        private static class GetArrayElementNode
        extends PolyglotNode {
            @Node.Child
            private Node readArrayNode = Message.READ.createNode();
            private final PolyglotLanguageContext.ToHostValueNode toHostValue;

            protected GetArrayElementNode(Interop interop) {
                super(interop);
                this.toHostValue = this.polyglot.languageContext.createToHostValue();
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "getArrayElement";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                long index = (Long)args[1];
                try {
                    return this.toHostValue.execute(ForeignAccess.sendRead(this.readArrayNode, (TruffleObject)receiver, index));
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    return this.polyglot.getArrayElementUnsupported(receiver);
                }
                catch (UnknownIdentifierException e) {
                    CompilerDirectives.transferToInterpreter();
                    throw PolyglotValue.invalidArrayIndex(this.polyglot.languageContext, receiver, index);
                }
            }
        }

        private static class HasArrayElementsNode
        extends PolyglotNode {
            @Node.Child
            private Node hasSizeNode = Message.HAS_SIZE.createNode();

            protected HasArrayElementsNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasArrayElements";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return ForeignAccess.sendHasSize(this.hasSizeNode, (TruffleObject)receiver);
            }
        }

        private static class AsNativePointerNode
        extends PolyglotNode {
            @Node.Child
            private Node asPointerNode = Message.AS_POINTER.createNode();

            protected AsNativePointerNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asNativePointer";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                try {
                    return ForeignAccess.sendAsPointer(this.asPointerNode, (TruffleObject)receiver);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreter();
                    return this.polyglot.asNativePointerUnsupported(receiver);
                }
            }
        }

        private static class IsNativePointerNode
        extends PolyglotNode {
            @Node.Child
            private Node isPointerNode = Message.IS_POINTER.createNode();

            protected IsNativePointerNode(Interop interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNativePointer";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return ForeignAccess.sendIsPointer(this.isPointerNode, (TruffleObject)receiver);
            }
        }
    }

    static final class Default
    extends BaseCache {
        Default(PolyglotLanguageContext context) {
            super(context, Object.class);
        }
    }

    private static final class IntValueCache
    extends BaseCache {
        IntValueCache(PolyglotLanguageContext context) {
            super(context, Integer.class);
        }

        public boolean isNumber(Object receiver) {
            return true;
        }

        public boolean fitsInInt(Object receiver) {
            return true;
        }

        public int asInt(Object receiver) {
            return (Integer)receiver;
        }

        public boolean fitsInLong(Object receiver) {
            return true;
        }

        public long asLong(Object receiver) {
            return ((Integer)receiver).intValue();
        }

        public boolean fitsInDouble(Object receiver) {
            return true;
        }

        public double asDouble(Object receiver) {
            return ((Integer)receiver).intValue();
        }

        public boolean fitsInByte(Object receiver) {
            byte castValue;
            int intReceiver = (Integer)receiver;
            return intReceiver == (castValue = (byte)intReceiver);
        }

        public byte asByte(Object receiver) {
            byte castValue;
            int intReceiver = (Integer)receiver;
            if (intReceiver == (castValue = (byte)intReceiver)) {
                return castValue;
            }
            return super.asByte(receiver);
        }

        public boolean fitsInFloat(Object receiver) {
            int intReceiver = (Integer)receiver;
            return PolyglotValue.inSafeFloatRange(intReceiver);
        }

        public float asFloat(Object receiver) {
            int intReceiver = (Integer)receiver;
            float castValue = intReceiver;
            if (PolyglotValue.inSafeFloatRange(intReceiver)) {
                return castValue;
            }
            return super.asFloat(receiver);
        }

        public boolean fitsInShort(Object receiver) {
            short castValue;
            int intReceiver = (Integer)receiver;
            return intReceiver == (castValue = (short)intReceiver);
        }

        public short asShort(Object receiver) {
            short castValue;
            int intReceiver = (Integer)receiver;
            if (intReceiver == (castValue = (short)intReceiver)) {
                return castValue;
            }
            return super.asShort(receiver);
        }
    }

    private static final class DoubleValueCache
    extends BaseCache {
        DoubleValueCache(PolyglotLanguageContext context) {
            super(context, Double.class);
        }

        public boolean isNumber(Object receiver) {
            return true;
        }

        public boolean fitsInByte(Object receiver) {
            byte castValue;
            double originalReceiver = (Double)receiver;
            return originalReceiver == (double)(castValue = (byte)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver);
        }

        public byte asByte(Object receiver) {
            byte castValue;
            double originalReceiver = (Double)receiver;
            if (originalReceiver == (double)(castValue = (byte)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver)) {
                return castValue;
            }
            return super.asByte(receiver);
        }

        public boolean fitsInInt(Object receiver) {
            int castValue;
            double originalReceiver = (Double)receiver;
            return originalReceiver == (double)(castValue = (int)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver);
        }

        public int asInt(Object receiver) {
            int castValue;
            double originalReceiver = (Double)receiver;
            if (originalReceiver == (double)(castValue = (int)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver)) {
                return castValue;
            }
            return super.asInt(receiver);
        }

        public boolean fitsInLong(Object receiver) {
            double originalReceiver = (Double)receiver;
            long castValue = (long)originalReceiver;
            return PolyglotValue.inSafeIntegerRange(originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver) && originalReceiver == (double)castValue;
        }

        public long asLong(Object receiver) {
            double originalReceiver = (Double)receiver;
            long castValue = (long)originalReceiver;
            if (PolyglotValue.inSafeIntegerRange(originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver) && originalReceiver == (double)castValue) {
                return castValue;
            }
            return super.asLong(receiver);
        }

        public boolean fitsInFloat(Object receiver) {
            double originalReceiver = (Double)receiver;
            float castValue = (float)originalReceiver;
            return !Double.isFinite(originalReceiver) || (double)castValue == originalReceiver;
        }

        public float asFloat(Object receiver) {
            double originalReceiver = (Double)receiver;
            float castValue = (float)originalReceiver;
            if (!Double.isFinite(originalReceiver) || (double)castValue == originalReceiver) {
                return castValue;
            }
            return super.asFloat(receiver);
        }

        public boolean fitsInDouble(Object receiver) {
            return true;
        }

        public double asDouble(Object receiver) {
            return (Double)receiver;
        }

        public boolean fitsInShort(Object receiver) {
            short castValue;
            double originalReceiver = (Double)receiver;
            return originalReceiver == (double)(castValue = (short)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver);
        }

        public short asShort(Object receiver) {
            short castValue;
            double originalReceiver = (Double)receiver;
            if (originalReceiver == (double)(castValue = (short)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver)) {
                return castValue;
            }
            return super.asShort(receiver);
        }
    }

    private static final class FloatValueCache
    extends BaseCache {
        FloatValueCache(PolyglotLanguageContext context) {
            super(context, Float.class);
        }

        public boolean isNumber(Object receiver) {
            return true;
        }

        public boolean fitsInByte(Object receiver) {
            byte castValue;
            float originalReceiver = ((Float)receiver).floatValue();
            return originalReceiver == (float)(castValue = (byte)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver);
        }

        public byte asByte(Object receiver) {
            byte castValue;
            float originalReceiver = ((Float)receiver).floatValue();
            if (originalReceiver == (float)(castValue = (byte)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver)) {
                return castValue;
            }
            return super.asByte(receiver);
        }

        public boolean fitsInInt(Object receiver) {
            float originalReceiver = ((Float)receiver).floatValue();
            int castValue = (int)originalReceiver;
            return PolyglotValue.inSafeIntegerRange(originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver) && originalReceiver == (float)castValue;
        }

        public int asInt(Object receiver) {
            float originalReceiver = ((Float)receiver).floatValue();
            int castValue = (int)originalReceiver;
            if (PolyglotValue.inSafeIntegerRange(originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver) && originalReceiver == (float)castValue) {
                return castValue;
            }
            return super.asInt(receiver);
        }

        public boolean fitsInLong(Object receiver) {
            float originalReceiver = ((Float)receiver).floatValue();
            long castValue = (long)originalReceiver;
            return PolyglotValue.inSafeIntegerRange(originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver) && originalReceiver == (float)castValue;
        }

        public long asLong(Object receiver) {
            float originalReceiver = ((Float)receiver).floatValue();
            long castValue = (long)originalReceiver;
            if (PolyglotValue.inSafeIntegerRange(originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver) && originalReceiver == (float)castValue) {
                return castValue;
            }
            return super.asLong(receiver);
        }

        public boolean fitsInFloat(Object receiver) {
            return true;
        }

        public float asFloat(Object receiver) {
            return ((Float)receiver).floatValue();
        }

        public boolean fitsInDouble(Object receiver) {
            float originalReceiver = ((Float)receiver).floatValue();
            double castValue = originalReceiver;
            return !Float.isFinite(originalReceiver) || castValue == (double)originalReceiver;
        }

        public double asDouble(Object receiver) {
            float originalReceiver = ((Float)receiver).floatValue();
            double castValue = originalReceiver;
            if (!Float.isFinite(originalReceiver) || castValue == (double)originalReceiver) {
                return castValue;
            }
            return super.asLong(receiver);
        }

        public boolean fitsInShort(Object receiver) {
            short castValue;
            float originalReceiver = ((Float)receiver).floatValue();
            return originalReceiver == (float)(castValue = (short)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver);
        }

        public short asShort(Object receiver) {
            short castValue;
            float originalReceiver = ((Float)receiver).floatValue();
            if (originalReceiver == (float)(castValue = (short)originalReceiver) && !PolyglotValue.isNegativeZero(originalReceiver)) {
                return castValue;
            }
            return super.asShort(receiver);
        }
    }

    private static final class LongValueCache
    extends BaseCache {
        LongValueCache(PolyglotLanguageContext context) {
            super(context, Long.class);
        }

        public boolean isNumber(Object receiver) {
            return true;
        }

        public boolean fitsInByte(Object receiver) {
            byte castValue;
            long originalReceiver = (Long)receiver;
            return originalReceiver == (long)(castValue = (byte)originalReceiver);
        }

        public byte asByte(Object receiver) {
            byte castValue;
            long originalReceiver = (Long)receiver;
            if (originalReceiver == (long)(castValue = (byte)originalReceiver)) {
                return castValue;
            }
            return super.asByte(receiver);
        }

        public boolean fitsInInt(Object receiver) {
            int castValue;
            long originalReceiver = (Long)receiver;
            return originalReceiver == (long)(castValue = (int)originalReceiver);
        }

        public int asInt(Object receiver) {
            int castValue;
            long originalReceiver = (Long)receiver;
            if (originalReceiver == (long)(castValue = (int)originalReceiver)) {
                return castValue;
            }
            return super.asInt(receiver);
        }

        public boolean fitsInLong(Object receiver) {
            return true;
        }

        public long asLong(Object receiver) {
            return (Long)receiver;
        }

        public boolean fitsInFloat(Object receiver) {
            long originalReceiver = (Long)receiver;
            return PolyglotValue.inSafeFloatRange(originalReceiver);
        }

        public float asFloat(Object receiver) {
            long originalReceiver = (Long)receiver;
            float castValue = originalReceiver;
            if (PolyglotValue.inSafeFloatRange(originalReceiver)) {
                return castValue;
            }
            return super.asFloat(receiver);
        }

        public boolean fitsInDouble(Object receiver) {
            long originalReceiver = (Long)receiver;
            return PolyglotValue.inSafeDoubleRange(originalReceiver);
        }

        public double asDouble(Object receiver) {
            long originalReceiver = (Long)receiver;
            double castValue = originalReceiver;
            if (PolyglotValue.inSafeDoubleRange(originalReceiver)) {
                return castValue;
            }
            return super.asDouble(receiver);
        }

        public boolean fitsInShort(Object receiver) {
            short castValue;
            long originalReceiver = (Long)receiver;
            return originalReceiver == (long)(castValue = (short)originalReceiver);
        }

        public short asShort(Object receiver) {
            short castValue;
            long originalReceiver = (Long)receiver;
            if (originalReceiver == (long)(castValue = (short)originalReceiver)) {
                return castValue;
            }
            return super.asShort(receiver);
        }
    }

    private static final class CharacterValueCache
    extends BaseCache {
        CharacterValueCache(PolyglotLanguageContext context) {
            super(context, Character.class);
        }

        public boolean isString(Object receiver) {
            return true;
        }

        public String asString(Object receiver) {
            return String.valueOf(((Character)receiver).charValue());
        }
    }

    private static final class ShortValueCache
    extends BaseCache {
        ShortValueCache(PolyglotLanguageContext context) {
            super(context, Short.class);
        }

        public boolean isNumber(Object receiver) {
            return true;
        }

        public boolean fitsInByte(Object receiver) {
            byte castValue;
            short originalReceiver = (Short)receiver;
            return originalReceiver == (castValue = (byte)originalReceiver);
        }

        public byte asByte(Object receiver) {
            byte castValue;
            short originalReceiver = (Short)receiver;
            if (originalReceiver == (castValue = (byte)originalReceiver)) {
                return castValue;
            }
            return super.asByte(receiver);
        }

        public boolean fitsInShort(Object receiver) {
            return true;
        }

        public short asShort(Object receiver) {
            return (Short)receiver;
        }

        public boolean fitsInInt(Object receiver) {
            return true;
        }

        public int asInt(Object receiver) {
            return ((Short)receiver).shortValue();
        }

        public boolean fitsInLong(Object receiver) {
            return true;
        }

        public long asLong(Object receiver) {
            return ((Short)receiver).shortValue();
        }

        public boolean fitsInFloat(Object receiver) {
            return true;
        }

        public float asFloat(Object receiver) {
            return ((Short)receiver).shortValue();
        }

        public boolean fitsInDouble(Object receiver) {
            return true;
        }

        public double asDouble(Object receiver) {
            return ((Short)receiver).shortValue();
        }
    }

    private static final class ByteValueCache
    extends BaseCache {
        ByteValueCache(PolyglotLanguageContext context) {
            super(context, Byte.class);
        }

        public boolean isNumber(Object receiver) {
            return true;
        }

        public boolean fitsInByte(Object receiver) {
            return true;
        }

        public byte asByte(Object receiver) {
            return (Byte)receiver;
        }

        public boolean fitsInShort(Object receiver) {
            return true;
        }

        public short asShort(Object receiver) {
            return ((Byte)receiver).byteValue();
        }

        public boolean fitsInInt(Object receiver) {
            return true;
        }

        public int asInt(Object receiver) {
            return ((Byte)receiver).byteValue();
        }

        public boolean fitsInLong(Object receiver) {
            return true;
        }

        public long asLong(Object receiver) {
            return ((Byte)receiver).byteValue();
        }

        public boolean fitsInFloat(Object receiver) {
            return true;
        }

        public float asFloat(Object receiver) {
            return ((Byte)receiver).byteValue();
        }

        public boolean fitsInDouble(Object receiver) {
            return true;
        }

        public double asDouble(Object receiver) {
            return ((Byte)receiver).byteValue();
        }
    }

    private static final class BooleanValueCache
    extends BaseCache {
        BooleanValueCache(PolyglotLanguageContext context) {
            super(context, Boolean.class);
        }

        public boolean isBoolean(Object receiver) {
            return true;
        }

        public boolean asBoolean(Object receiver) {
            return (Boolean)receiver;
        }
    }

    private static final class StringValueCache
    extends BaseCache {
        StringValueCache(PolyglotLanguageContext context) {
            super(context, String.class);
        }

        public boolean isString(Object receiver) {
            return true;
        }

        public String asString(Object receiver) {
            return (String)receiver;
        }
    }

    private static abstract class PolyglotNode
    extends RootNode {
        protected final BaseCache polyglot;
        @CompilerDirectives.CompilationFinal
        private boolean seenEnter;
        @CompilerDirectives.CompilationFinal
        private boolean seenNonEnter;

        protected abstract String getOperationName();

        protected PolyglotNode(BaseCache polyglot) {
            super(null);
            this.polyglot = polyglot;
        }

        protected abstract Class<?>[] getArgumentTypes();

        @Override
        public final Object execute(VirtualFrame frame) {
            Object prev;
            Object[] args = frame.getArguments();
            Object receiver = this.polyglot.receiverType.cast(args[0]);
            PolyglotContextImpl context = this.polyglot.languageContext.context;
            boolean needsEnter = context.needsEnter();
            if (needsEnter) {
                if (!this.seenEnter) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenEnter = true;
                }
                prev = context.enter();
            } else {
                if (!this.seenNonEnter) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenNonEnter = true;
                }
                prev = null;
            }
            try {
                Object object = this.executeImpl(receiver, args);
                return object;
            }
            catch (Throwable e) {
                CompilerDirectives.transferToInterpreter();
                throw PolyglotImpl.wrapGuestException(this.polyglot.languageContext, e);
            }
            finally {
                if (needsEnter) {
                    context.leave(prev);
                }
            }
        }

        protected abstract Object executeImpl(Object var1, Object[] var2);

        @Override
        public final String getName() {
            return "org.graalvm.polyglot.Value<" + this.polyglot.receiverType.getSimpleName() + ">." + this.getOperationName();
        }

        @Override
        public final String toString() {
            return this.getName();
        }
    }

    static abstract class BaseCache
    extends PolyglotValue {
        final CallTarget asClassLiteral;
        final CallTarget asTypeLiteral;
        final Class<?> receiverType;

        BaseCache(PolyglotLanguageContext context, Class<?> receiverType) {
            super(context);
            this.receiverType = receiverType;
            this.asClassLiteral = BaseCache.createTarget(new AsClassLiteralNode(this));
            this.asTypeLiteral = BaseCache.createTarget(new AsTypeLiteralNode(this));
        }

        public final <T> T as(Object receiver, Class<T> targetType) {
            return (T)VMAccessor.SPI.callProfiled(this.asClassLiteral, receiver, targetType);
        }

        public final <T> T as(Object receiver, TypeLiteral<T> targetType) {
            return (T)VMAccessor.SPI.callProfiled(this.asTypeLiteral, receiver, targetType);
        }

        private static class AsTypeLiteralNode
        extends PolyglotNode {
            @Node.Child
            ToHostNode toHost = ToHostNode.create();

            protected AsTypeLiteralNode(BaseCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, TypeLiteral.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                TypeLiteral typeLiteral = (TypeLiteral)args[1];
                return this.toHost.execute(args[0], typeLiteral.getRawType(), typeLiteral.getType(), this.polyglot.languageContext);
            }
        }

        private static class AsClassLiteralNode
        extends PolyglotNode {
            @Node.Child
            ToHostNode toHost = ToHostNode.create();

            protected AsClassLiteralNode(BaseCache interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{this.polyglot.receiverType, Class.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Override
            protected Object executeImpl(Object receiver, Object[] args) {
                return this.toHost.execute(args[0], (Class)args[1], null, this.polyglot.languageContext);
            }
        }
    }
}

