/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.KeyInfo;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.polyglot.HostInteropErrors;
import com.oracle.truffle.polyglot.HostInteropReflect;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.ToHostNode;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@ImportStatic(value={Message.class, HostInteropReflect.class})
abstract class ProxyInvokeNode
extends Node {
    protected static final int LIMIT = Integer.MAX_VALUE;
    @CompilerDirectives.CompilationFinal
    private boolean invokeFailed;

    ProxyInvokeNode() {
    }

    public abstract Object execute(PolyglotLanguageContext var1, TruffleObject var2, Method var3, Object[] var4);

    @Specialization(guards={"cachedMethod.equals(method)"}, limit="LIMIT")
    protected Object doCachedMethod(PolyglotLanguageContext languageContext, TruffleObject receiver, Method method, Object[] arguments, @Cached(value="method") Method cachedMethod, @Cached(value="method.getName()") String name, @Cached(value="getMethodReturnType(method)") Class<?> returnClass, @Cached(value="getMethodGenericReturnType(method)") Type returnType, @Cached(value="INVOKE.createNode()") Node invokeNode, @Cached(value="KEY_INFO.createNode()") Node keyInfoNode, @Cached(value="READ.createNode()") Node readNode, @Cached(value="IS_EXECUTABLE.createNode()") Node isExecutableNode, @Cached(value="EXECUTE.createNode()") Node executeNode, @Cached(value="createBinaryProfile()") ConditionProfile branchProfile, @Cached(value="create()") ToHostNode toJava) {
        Object result = this.invokeOrExecute(languageContext, receiver, arguments, name, invokeNode, keyInfoNode, readNode, isExecutableNode, executeNode, branchProfile);
        return toJava.execute(result, returnClass, returnType, languageContext);
    }

    @CompilerDirectives.TruffleBoundary
    private static boolean guardReturnType(Method method, Type returnType) {
        return method.getGenericReturnType().equals(returnType);
    }

    private Object invokeOrExecute(PolyglotLanguageContext polyglotContext, TruffleObject receiver, Object[] arguments, String name, Node invokeNode, Node keyInfoNode, Node readNode, Node isExecutableNode, Node executeNode, ConditionProfile invokeOrReadAndExecuteProfile) {
        try {
            if (!this.invokeFailed) {
                try {
                    return ForeignAccess.sendInvoke(invokeNode, receiver, name, arguments);
                }
                catch (UnknownIdentifierException | UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.invokeFailed = true;
                }
            }
            if (this.invokeFailed) {
                int keyInfo = ForeignAccess.sendKeyInfo(keyInfoNode, receiver, name);
                if (invokeOrReadAndExecuteProfile.profile(KeyInfo.isInvocable(keyInfo))) {
                    try {
                        return ForeignAccess.sendInvoke(invokeNode, receiver, name, arguments);
                    }
                    catch (UnsupportedMessageException e) {
                        CompilerDirectives.transferToInterpreter();
                    }
                } else if (KeyInfo.isReadable(keyInfo)) {
                    TruffleObject truffleReadValue;
                    Object readValue = ForeignAccess.sendRead(readNode, receiver, name);
                    if (readValue instanceof TruffleObject && ForeignAccess.sendIsExecutable(isExecutableNode, truffleReadValue = (TruffleObject)readValue)) {
                        return ForeignAccess.sendExecute(executeNode, truffleReadValue, arguments);
                    }
                    if (arguments.length == 0) {
                        return readValue;
                    }
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw HostInteropErrors.invokeUnsupported(polyglotContext, receiver, name);
        }
        catch (UnknownIdentifierException e) {
            CompilerDirectives.transferToInterpreter();
            throw HostInteropErrors.invokeUnsupported(polyglotContext, receiver, name);
        }
        catch (UnsupportedTypeException e) {
            CompilerDirectives.transferToInterpreter();
            throw HostInteropErrors.invalidExecuteArgumentType(polyglotContext, receiver, e.getSuppliedValues());
        }
        catch (ArityException e) {
            CompilerDirectives.transferToInterpreter();
            throw HostInteropErrors.invalidExecuteArity(polyglotContext, receiver, arguments, e.getExpectedArity(), e.getActualArity());
        }
        catch (UnsupportedMessageException e) {
            CompilerDirectives.transferToInterpreter();
            throw HostInteropErrors.invokeUnsupported(polyglotContext, receiver, name);
        }
    }
}

