/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.bean;

import com.orangesignal.csv.bean.CsvValueConverter;
import com.orangesignal.csv.bean.FormatUtils;
import com.orangesignal.csv.bean.SimpleCsvValueConverter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCsvBeanTemplate<T, O extends AbstractCsvBeanTemplate<T, O>> {
    private Class<T> type;
    private Map<String, Format> valueParserMapping = new HashMap<String, Format>();
    private Map<Object, Format> valueFormatterMapping = new HashMap<Object, Format>();
    private CsvValueConverter valueConverter = new SimpleCsvValueConverter();

    protected AbstractCsvBeanTemplate(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void setValueParserMapping(Map<String, Format> valueParserMapping) {
        if (valueParserMapping == null) {
            throw new IllegalArgumentException("CSV value parser mapping must not be null");
        }
        this.valueParserMapping = valueParserMapping;
    }

    public O valueParserMapping(Map<String, Format> valueParserMapping) {
        this.setValueParserMapping(valueParserMapping);
        return (O)this;
    }

    public void setValueFormatterMapping(Map<Object, Format> valueFormatterMapping) {
        if (valueFormatterMapping == null) {
            throw new IllegalArgumentException("CSV value formatter mapping must not be null");
        }
        this.valueFormatterMapping = valueFormatterMapping;
    }

    public O valueFormatterMapping(Map<Object, Format> valueFormatterMapping) {
        this.setValueFormatterMapping(valueFormatterMapping);
        return (O)this;
    }

    public void setValueConverter(CsvValueConverter valueConverter) {
        if (valueConverter == null) {
            throw new IllegalArgumentException("CsvValueConverter must not be null");
        }
        this.valueConverter = valueConverter;
    }

    public O valueConverter(CsvValueConverter valueConverter) {
        this.setValueConverter(valueConverter);
        return (O)this;
    }

    public O format(String name, Format format) {
        this.setValueParser(name, format);
        this.setValueFormatter(name, format);
        return (O)this;
    }

    public void setValueParser(String field, Format parser) {
        Format src = this.valueParserMapping.get(field);
        if (src != null) {
            this.valueParserMapping.put(field, FormatUtils.mergeFormatPattern(src, parser));
        } else {
            this.valueParserMapping.put(field, parser);
        }
    }

    public void setValueFormatter(Object column, Format formatter) {
        this.valueFormatterMapping.put(column, formatter);
    }

    public T createBean() throws IOException {
        try {
            return this.type.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot create " + this.type.getName() + ": " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot create " + this.type.getName() + ": " + e.getMessage(), e);
        }
    }

    public Map<String, Object[]> createFieldAndColumnsMap(Map<?, String> map) {
        HashMap<String, Object[]> results = new HashMap<String, Object[]>();
        for (Field f : this.type.getDeclaredFields()) {
            String fieldName = f.getName();
            ArrayList list = new ArrayList();
            for (Map.Entry<?, String> e : map.entrySet()) {
                if (!fieldName.equals(e.getValue())) continue;
                list.add(e.getKey());
            }
            if (list.size() <= 0) continue;
            results.put(fieldName, list.toArray());
        }
        return results;
    }

    public Object stringToObject(Field field, String value) {
        Format format = this.valueParserMapping.get(field.getName());
        if (format != null) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return format.parseObject(value);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse the %s: %s", field.getName(), value), e);
            }
        }
        Class<?> type = field.getType();
        return this.valueConverter.convert(value, type.isArray() ? type.getComponentType() : type);
    }

    public String objectToString(Object column, Object obj) {
        Format format = this.valueFormatterMapping.get(column);
        if (format != null) {
            if (obj == null) {
                return null;
            }
            return format.format(obj);
        }
        return this.valueConverter.convert(obj);
    }
}

