/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.bean;

import com.orangesignal.csv.bean.AbstractCsvBeanTemplate;
import com.orangesignal.csv.bean.CsvColumnPositionMappingBeanOperation;
import com.orangesignal.csv.filters.CsvValueFilter;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class CsvColumnPositionMappingBeanTemplate<T>
extends AbstractCsvBeanTemplate<T, CsvColumnPositionMappingBeanTemplate<T>>
implements CsvColumnPositionMappingBeanOperation<CsvColumnPositionMappingBeanTemplate<T>> {
    private SortedMap<Integer, String> columnMapping = new TreeMap<Integer, String>();
    private CsvValueFilter filter;

    public static <T> CsvColumnPositionMappingBeanTemplate<T> newInstance(Class<T> type) {
        return new CsvColumnPositionMappingBeanTemplate<T>(type);
    }

    public CsvColumnPositionMappingBeanTemplate(Class<T> type) {
        super(type);
    }

    @Override
    public CsvColumnPositionMappingBeanTemplate<T> column(String field) {
        return this.column(field, null);
    }

    @Override
    public CsvColumnPositionMappingBeanTemplate<T> column(String field, Format format) {
        return this.column(this.getMaxColumnPosition() + 1, field, format);
    }

    @Override
    public CsvColumnPositionMappingBeanTemplate<T> column(int position, String field) {
        return this.column(position, field, null);
    }

    @Override
    public CsvColumnPositionMappingBeanTemplate<T> column(int position, String field, Format format) {
        this.columnMapping.put(position, field);
        if (format != null) {
            this.setValueParser(field, format);
            this.setValueFormatter(position, format);
        }
        return this;
    }

    @Override
    public void setColumnMapping(Map<Integer, String> columnMapping) {
        if (columnMapping == null) {
            throw new IllegalArgumentException("Column mapping must not be null");
        }
        this.columnMapping = new TreeMap<Integer, String>(columnMapping);
    }

    @Override
    public CsvColumnPositionMappingBeanTemplate<T> columnMapping(Map<Integer, String> columnMapping) {
        this.setColumnMapping(columnMapping);
        return this;
    }

    @Override
    public CsvColumnPositionMappingBeanTemplate<T> filter(CsvValueFilter filter) {
        this.filter = filter;
        return this;
    }

    public int getMaxColumnPosition() {
        if (this.columnMapping.size() > 0) {
            return this.columnMapping.lastKey();
        }
        return -1;
    }

    public List<String> createColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.columnMapping.size());
        for (Map.Entry<Integer, String> e : this.columnMapping.entrySet()) {
            columnNames.add(e.getValue());
        }
        return columnNames;
    }

    public boolean isAccept(List<String> values) {
        return this.filter != null && !this.filter.accept(values);
    }

    public Map<String, Object[]> createFieldAndColumnsMap() {
        return super.createFieldAndColumnsMap(this.columnMapping);
    }

    public Set<Map.Entry<Integer, String>> columnMappingEntrySet() {
        return this.columnMapping.entrySet();
    }
}

