/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.filters;

import com.orangesignal.csv.filters.ColumnNameExpression;
import com.orangesignal.csv.filters.CsvExpressionUtils;
import java.util.List;

public class ColumnNameBetweenExpression
extends ColumnNameExpression {
    private String low;
    private String high;

    protected ColumnNameBetweenExpression(String name, String low, String high) {
        super(name);
        if (low == null || high == null) {
            throw new IllegalArgumentException("Low or High must not be null");
        }
        this.low = low;
        this.high = high;
    }

    @Override
    public boolean accept(List<String> header, List<String> values) {
        int position = header.indexOf(this.name);
        if (position == -1) {
            throw new IllegalArgumentException(String.format("Invalid column name %s", this.name));
        }
        return CsvExpressionUtils.between(values, position, this.low, this.high);
    }
}

