/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.filters;

import com.orangesignal.csv.filters.CsvExpressions;
import com.orangesignal.csv.filters.CsvValueAndExpression;
import com.orangesignal.csv.filters.CsvValueFilter;
import com.orangesignal.csv.filters.CsvValueLogicalExpression;
import java.util.List;
import java.util.regex.Pattern;

public class SimpleCsvValueFilter
implements CsvValueFilter {
    private CsvValueLogicalExpression expr;

    public SimpleCsvValueFilter() {
        this(new CsvValueAndExpression());
    }

    public SimpleCsvValueFilter(CsvValueLogicalExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("%s must not be null", CsvValueLogicalExpression.class.getSimpleName()));
        }
        this.expr = expr;
    }

    public SimpleCsvValueFilter add(CsvValueFilter filter) {
        this.expr.add(filter);
        return this;
    }

    public SimpleCsvValueFilter isNull(int position) {
        this.expr.add(CsvExpressions.isNull(position));
        return this;
    }

    public SimpleCsvValueFilter isNotNull(int position) {
        this.expr.add(CsvExpressions.isNotNull(position));
        return this;
    }

    public SimpleCsvValueFilter isEmpty(int position) {
        this.expr.add(CsvExpressions.isEmpty(position));
        return this;
    }

    public SimpleCsvValueFilter isNotEmpty(int position) {
        this.expr.add(CsvExpressions.isNotEmpty(position));
        return this;
    }

    public SimpleCsvValueFilter eq(int position, String criteria) {
        this.expr.add(CsvExpressions.eq(position, criteria));
        return this;
    }

    public SimpleCsvValueFilter eq(int position, String criteria, boolean ignoreCase) {
        this.expr.add(CsvExpressions.eq(position, criteria, ignoreCase));
        return this;
    }

    public SimpleCsvValueFilter ne(int position, String criteria) {
        this.expr.add(CsvExpressions.ne(position, criteria));
        return this;
    }

    public SimpleCsvValueFilter ne(int position, String criteria, boolean ignoreCase) {
        this.expr.add(CsvExpressions.ne(position, criteria, ignoreCase));
        return this;
    }

    public SimpleCsvValueFilter in(int position, String ... criterias) {
        this.expr.add(CsvExpressions.in(position, criterias));
        return this;
    }

    public SimpleCsvValueFilter in(int position, String[] criterias, boolean ignoreCase) {
        this.expr.add(CsvExpressions.in(position, criterias, ignoreCase));
        return this;
    }

    public SimpleCsvValueFilter notIn(int position, String ... criterias) {
        this.expr.add(CsvExpressions.notIn(position, criterias));
        return this;
    }

    public SimpleCsvValueFilter notIn(int position, String[] criterias, boolean ignoreCase) {
        this.expr.add(CsvExpressions.notIn(position, criterias, ignoreCase));
        return this;
    }

    public SimpleCsvValueFilter regex(int position, String pattern) {
        this.expr.add(CsvExpressions.regex(position, pattern));
        return this;
    }

    public SimpleCsvValueFilter regex(int position, String pattern, boolean ignoreCase) {
        this.expr.add(CsvExpressions.regex(position, pattern, ignoreCase));
        return this;
    }

    public SimpleCsvValueFilter regex(int position, String pattern, int flags) {
        this.expr.add(CsvExpressions.regex(position, pattern, flags));
        return this;
    }

    public SimpleCsvValueFilter regex(int position, Pattern pattern) {
        this.expr.add(CsvExpressions.regex(position, pattern));
        return this;
    }

    public SimpleCsvValueFilter gt(int position, String criteria) {
        this.expr.add(CsvExpressions.gt(position, criteria));
        return this;
    }

    public SimpleCsvValueFilter lt(int position, String criteria) {
        this.expr.add(CsvExpressions.lt(position, criteria));
        return this;
    }

    public SimpleCsvValueFilter ge(int position, String criteria) {
        this.expr.add(CsvExpressions.ge(position, criteria));
        return this;
    }

    public SimpleCsvValueFilter le(int position, String criteria) {
        this.expr.add(CsvExpressions.le(position, criteria));
        return this;
    }

    public SimpleCsvValueFilter between(int position, String low, String high) {
        this.expr.add(CsvExpressions.between(position, low, high));
        return this;
    }

    public SimpleCsvValueFilter not(CsvValueFilter filter) {
        this.expr.add(CsvExpressions.not(filter));
        return this;
    }

    @Override
    public boolean accept(List<String> values) {
        return this.expr.accept(values);
    }

    public String toString() {
        String name = this.getClass().getName();
        int period = name.lastIndexOf(46);
        return period > 0 ? name.substring(period + 1) : name;
    }
}

