/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.CsvWriter;
import com.orangesignal.csv.annotation.CsvEntity;
import com.orangesignal.csv.bean.CsvEntityOperation;
import com.orangesignal.csv.bean.CsvEntityTemplate;
import com.orangesignal.csv.filters.CsvNamedValueFilter;
import com.orangesignal.csv.handlers.AbstractBeanListHandler;
import com.orangesignal.csv.io.CsvEntityReader;
import com.orangesignal.csv.io.CsvEntityWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CsvEntityListHandler<T>
extends AbstractBeanListHandler<T, CsvEntityTemplate<T>, CsvEntityListHandler<T>>
implements CsvEntityOperation<CsvEntityListHandler<T>> {
    private boolean disableWriteHeader;

    public CsvEntityListHandler(Class<T> entityClass) {
        super(CsvEntityTemplate.newInstance(entityClass));
    }

    public CsvEntityListHandler<T> disableWriteHeader(boolean disableWriteHeader) {
        this.setDisableWriteHeader(disableWriteHeader);
        return this;
    }

    public void setDisableWriteHeader(boolean disableWriteHeader) {
        this.disableWriteHeader = disableWriteHeader;
    }

    @Override
    public CsvEntityListHandler<T> filter(CsvNamedValueFilter filter) {
        ((CsvEntityTemplate)this.template).filter(filter);
        return this;
    }

    @Override
    public List<T> load(CsvReader reader, boolean ignoreScalar) throws IOException {
        List<String> values;
        CsvEntityReader r = new CsvEntityReader(reader, (CsvEntityTemplate)this.template);
        ArrayList results = new ArrayList();
        boolean order = ignoreScalar || this.orders != null && !this.orders.isEmpty();
        int offset = 0;
        while ((values = r.readValues()) != null && (order || this.limit <= 0 || results.size() < this.limit)) {
            if (this.beanFilter == null && !order && offset < this.offset) {
                ++offset;
                continue;
            }
            Object entity = r.toEntity(values);
            if (this.beanFilter != null) {
                if (!this.beanFilter.accept(entity)) continue;
                if (!order && offset < this.offset) {
                    ++offset;
                    continue;
                }
            }
            results.add(entity);
        }
        if (ignoreScalar || !order) {
            return results;
        }
        return this.processScalar(results);
    }

    @Override
    public void save(List<T> entities, CsvWriter writer) throws IOException {
        if (entities == null) {
            throw new IllegalArgumentException("CsvEntities must not be null");
        }
        CsvEntityWriter<T> w = new CsvEntityWriter<T>(writer, (CsvEntityTemplate)this.template, this.disableWriteHeader);
        for (T entity : entities) {
            if (entity == null || entity.getClass().getAnnotation(CsvEntity.class) == null) {
                w.write(null);
                continue;
            }
            if (this.beanFilter != null && !this.beanFilter.accept(entity)) continue;
            w.write(entity);
        }
    }
}

