/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.handlers;

import com.orangesignal.csv.CsvHandler;
import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.CsvResultSet;
import com.orangesignal.csv.CsvWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class ResultSetHandler
implements CsvHandler<ResultSet> {
    private boolean header = true;

    public ResultSetHandler header(boolean header) {
        this.header = header;
        return this;
    }

    @Override
    public ResultSet load(CsvReader reader) throws IOException {
        return new CsvResultSet(reader);
    }

    @Override
    public void save(ResultSet rs, CsvWriter writer) throws IOException {
        try {
            int count = this.writeHeader(rs.getMetaData(), writer);
            while (rs.next()) {
                ArrayList<String> list = new ArrayList<String>(count);
                for (int i = 1; i <= count; ++i) {
                    Object o = rs.getObject(i);
                    if (rs.wasNull()) {
                        list.add(null);
                        continue;
                    }
                    list.add(o.toString());
                }
                writer.writeValues(list);
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private int writeHeader(ResultSetMetaData meta, CsvWriter writer) throws IOException {
        try {
            int count = meta.getColumnCount();
            ArrayList<String> list = new ArrayList<String>(count);
            for (int i = 1; i <= count; ++i) {
                list.add(meta.getColumnLabel(i));
            }
            if (this.header) {
                writer.writeValues(list);
            }
            return count;
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

