/*
 * Decompiled with CFR 0.152.
 */
package com.orangesignal.csv.io;

import com.orangesignal.csv.CsvReader;
import com.orangesignal.csv.bean.CsvBeanTemplate;
import com.orangesignal.csv.bean.FieldUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;

public class CsvBeanReader<T>
implements Closeable {
    private CsvReader reader;
    private final CsvBeanTemplate<T> template;
    private List<String> columnNames;

    public static <T> CsvBeanReader<T> newInstance(CsvReader reader, Class<T> type) {
        return new CsvBeanReader<T>(reader, type);
    }

    public static <T> CsvBeanReader<T> newInstance(CsvReader reader, CsvBeanTemplate<T> template) {
        return new CsvBeanReader<T>(reader, template);
    }

    public CsvBeanReader(CsvReader reader, Class<T> type) {
        this(reader, new CsvBeanTemplate<T>(type));
    }

    public CsvBeanReader(CsvReader reader, CsvBeanTemplate<T> template) {
        if (reader == null) {
            throw new IllegalArgumentException("CsvReader must not be null");
        }
        if (template == null) {
            throw new IllegalArgumentException("CsvBeanTemplate must not be null");
        }
        this.reader = reader;
        this.template = template;
    }

    private void ensureOpen() throws IOException {
        if (this.reader == null) {
            throw new IOException("CsvReader closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureHeader() throws IOException {
        CsvBeanReader csvBeanReader = this;
        synchronized (csvBeanReader) {
            if (this.columnNames == null) {
                this.columnNames = Collections.unmodifiableList(this.reader.readValues());
                if (this.columnNames == null) {
                    throw new IOException("No header is available");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CsvBeanReader csvBeanReader = this;
        synchronized (csvBeanReader) {
            this.ensureOpen();
            this.reader.close();
            this.reader = null;
            this.columnNames = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHeader() throws IOException {
        CsvBeanReader csvBeanReader = this;
        synchronized (csvBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.columnNames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws IOException {
        CsvBeanReader csvBeanReader = this;
        synchronized (csvBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            List<String> values = this.nextValues();
            if (values == null) {
                return null;
            }
            return this.convert(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readValues() throws IOException {
        CsvBeanReader csvBeanReader = this;
        synchronized (csvBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.nextValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T toBean(List<String> values) throws IOException {
        CsvBeanReader csvBeanReader = this;
        synchronized (csvBeanReader) {
            this.ensureOpen();
            this.ensureHeader();
            return this.convert(values);
        }
    }

    private List<String> nextValues() throws IOException {
        List<String> values;
        while ((values = this.reader.readValues()) != null) {
            if (this.template.isAccept(this.columnNames, values)) continue;
            return values;
        }
        return null;
    }

    private T convert(List<String> values) throws IOException {
        Object bean = this.template.createBean();
        int len = Math.min(this.columnNames.size(), values.size());
        for (int pos = 0; pos < len; ++pos) {
            Field f;
            Object o;
            String name = this.columnNames.get(pos);
            if (!this.template.isTargetName(name) || (o = this.template.stringToObject(f = FieldUtils.getField(this.template.getType(), name), values.get(pos))) == null) continue;
            FieldUtils.setFieldValue(bean, f, o);
        }
        return bean;
    }

    public CsvBeanTemplate<T> getTemplate() {
        return this.template;
    }
}

